/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.smpp.load.smppp;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.log4j.Logger;
import org.mobicents.protocols.smpp.load.smppp.GlobalFSM;
import org.mobicents.protocols.smpp.load.smppp.RemoteControl;
import org.mobicents.protocols.smpp.load.smppp.SMPPInitializer;
import org.mobicents.protocols.smpp.load.smppp.Scenario;
import org.mobicents.protocols.smpp.load.smppp.ScenarioContext;
import org.mobicents.protocols.smpp.load.smppp.StackInitializer;
import org.mobicents.protocols.smpp.load.smppp.SteppedScenario;
import org.squirrelframework.foundation.component.SquirrelSingletonProvider;

public class GlobalContext {
    private Map<String, AtomicLong> counters = new TreeMap<String, AtomicLong>();
    private int threadCounter = 0;
    final ScheduledExecutorService executor;
    ScheduledFuture<?> csvFuture;
    ScheduledFuture<?> trafficFuture;
    final List<StackInitializer> initializersList = new ArrayList<StackInitializer>();
    final GlobalFSM fsm;
    SteppedScenario scenarioXml;
    RemoteControl remoteControl;
    Scenario scenario;
    final Logger logger = Logger.getLogger((String)"smppp.msglog");
    private final Properties props;
    final Map<String, Object> data = new HashMap<String, Object>();
    Map<String, ScenarioContext> scenariosMap;

    public GlobalContext(Properties props) {
        this.props = props;
        this.executor = Executors.newScheduledThreadPool(this.getIntegerProp("smppp.threadPoolSize"), new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, "SMPPpPool-" + GlobalContext.this.threadCounter++);
            }
        });
        SquirrelSingletonProvider.getInstance().register(ExecutorService.class, (Object)this.executor);
        SquirrelSingletonProvider.getInstance().register(ScheduledExecutorService.class, (Object)this.executor);
        this.initializersList.add(new SMPPInitializer());
        this.fsm = GlobalFSM.createNewInstance(this);
    }

    Integer getIntegerProp(String pName) {
        return Integer.valueOf(this.props.getProperty(pName).trim());
    }

    String getProperty(String pName) {
        String p = this.props.getProperty(pName);
        if (p == null) {
            this.logger.warn((Object)("Property Name was null:" + pName));
        } else {
            if (this.logger != null) {
                this.logger.info((Object)("Proper name(" + pName + ")=" + p));
            }
            p = p.trim();
        }
        return p;
    }

    void setProperty(String pName, String value) {
        this.props.setProperty(pName, value);
    }

    synchronized long incrementCounter(String counterName) {
        AtomicLong prevCounter;
        AtomicLong counter = this.counters.get(counterName);
        if (counter == null && (prevCounter = this.counters.put(counterName, counter = new AtomicLong(0L))) != null) {
            counter = prevCounter;
        }
        return counter.incrementAndGet();
    }

    synchronized long incrementResponseTimeCounter(String counterIndex, long newResTime) {
        AtomicLong prevCounter;
        this.incrementCounter("ResponseTimeSamples" + counterIndex);
        String avgCounterId = "ResponseTimeSum" + counterIndex;
        AtomicLong avgCounter = this.counters.get(avgCounterId);
        if (avgCounter == null && (prevCounter = this.counters.put(avgCounterId, avgCounter = new AtomicLong(0L))) != null) {
            avgCounter = prevCounter;
        }
        return avgCounter.addAndGet(newResTime);
    }

    public Properties getProps() {
        return this.props;
    }

    public Map<String, Object> getData() {
        return this.data;
    }

    AtomicLong getCurrentCounter(String counterName) {
        AtomicLong counter = this.counters.get(counterName);
        if (counter == null) {
            counter = new AtomicLong(0L);
            this.counters.put(counterName, counter);
        }
        return counter;
    }

    public synchronized Map<String, AtomicLong> retrieveAndResetCurrentCounters() {
        Map<String, AtomicLong> currentCounters = this.counters;
        this.counters = new HashMap<String, AtomicLong>();
        return currentCounters;
    }
}

