/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.smpp.load.smppp;

import com.cloudhopper.smpp.type.Address;
import java.io.File;
import java.io.FileInputStream;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.apache.commons.beanutils.ConvertUtilsBean;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.beanutils.PropertyUtilsBean;
import org.apache.log4j.Appender;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.PropertyConfigurator;
import org.apache.log4j.SimpleLayout;
import org.mobicents.protocols.smpp.load.smppp.AddressConverter;
import org.mobicents.protocols.smpp.load.smppp.GlobalContext;
import org.mobicents.protocols.smpp.load.smppp.GlobalEvent;
import org.mobicents.protocols.smpp.load.smppp.ReleaseOnShutdown;

public class SMPPp {
    final GlobalContext ctx;
    private static final int ERROR_STATUS = 64;

    public SMPPp(Properties props) {
        this.initLog4J(props);
        this.ctx = new GlobalContext(props);
        ConvertUtilsBean cub = new ConvertUtilsBean();
        cub.register((Converter)new AddressConverter(this.ctx), Address.class);
        BeanUtilsBean.setInstance((BeanUtilsBean)new BeanUtilsBean(cub, new PropertyUtilsBean()));
        Runtime.getRuntime().addShutdownHook(new ReleaseOnShutdown(this.ctx));
        this.ctx.fsm.fire((Object)GlobalEvent.START, this.ctx);
    }

    private void initLog4J(Properties props) {
        try {
            String log4jProps = props.getProperty("smppp.log4jPropsFilePath");
            if (log4jProps != null) {
                FileInputStream inStreamLog4j = new FileInputStream(new File(log4jProps));
                Properties propertiesLog4j = new Properties();
                propertiesLog4j.load(inStreamLog4j);
                PropertyConfigurator.configure((Properties)propertiesLog4j);
            } else {
                BasicConfigurator.configure();
            }
            String lf = props.getProperty("smppp.logFilePath");
            if (lf != null) {
                this.ctx.logger.addAppender((Appender)new FileAppender((Layout)new SimpleLayout(), lf));
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static void main(String[] args) {
        SMPPp smppp = null;
        int status = 0;
        try {
            Properties props = new Properties();
            FileInputStream iStream = new FileInputStream(new File(args[0]));
            props.load(iStream);
            smppp = new SMPPp(props);
            smppp.waitForTrafficToComplete();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            status = 64;
        }
        System.exit(status);
    }

    public void waitForTrafficToComplete() throws InterruptedException {
        this.ctx.executor.awaitTermination(this.ctx.getIntegerProp("smppp.awaitTermination").intValue(), TimeUnit.SECONDS);
        this.ctx.fsm.fire((Object)GlobalEvent.STOP, this.ctx);
        this.ctx.executor.awaitTermination(this.ctx.getIntegerProp("smppp.trafficGrantPeriod").intValue(), TimeUnit.SECONDS);
    }
}

