/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.smpp.load.smppp;

import java.io.Closeable;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.Map;
import org.mobicents.protocols.smpp.load.smppp.GlobalContext;
import org.mobicents.protocols.smpp.load.smppp.GlobalEvent;
import org.mobicents.protocols.smpp.load.smppp.GlobalState;

public class RemoteControl
extends Thread
implements Closeable {
    private static final String COMMAND_SEPARATOR = " ";
    private static final String SUCCESS = "200";
    private static final String NOT_FOUND = "404";
    private final DatagramSocket socket;
    private final GlobalContext ctx;
    private final Map<String, RemoteCmd> commandMap = new HashMap<String, RemoteCmd>();

    public RemoteControl(GlobalContext ctx) throws IOException {
        super("RemoteControlTH");
        this.ctx = ctx;
        this.socket = new DatagramSocket(ctx.getIntegerProp("smppp.remoteControlPort"));
        this.commandMap.put("stop", new StopCmd());
        this.commandMap.put("setRate", new SetRateCmd());
    }

    @Override
    public void close() throws IOException {
        if (this.socket != null) {
            this.socket.close();
        }
    }

    private String executeCommand(String remoteCommand) {
        this.ctx.logger.info((Object)("Received remote command:" + remoteCommand));
        String response = NOT_FOUND;
        String[] cmdSplit = remoteCommand.split(COMMAND_SEPARATOR);
        if (cmdSplit != null && cmdSplit.length > 0 && this.commandMap.containsKey(cmdSplit[0])) {
            RemoteCmd cmd = this.commandMap.get(cmdSplit[0]);
            this.ctx.logger.info((Object)("Command recognized:" + cmd.getClass().getSimpleName()));
            response = cmd.execute(cmdSplit);
        } else {
            this.ctx.logger.info((Object)"Command not recognized.");
        }
        this.ctx.logger.info((Object)("Remote command result:" + response));
        return response;
    }

    @Override
    public void run() {
        while (!((GlobalState)((Object)this.ctx.fsm.getCurrentState())).equals((Object)GlobalState.STOPPED)) {
            try {
                byte[] buf = new byte[256];
                DatagramPacket packet = new DatagramPacket(buf, buf.length);
                this.socket.receive(packet);
                String remoteCommand = new String(buf, "UTF-8");
                String dString = this.executeCommand(remoteCommand);
                buf = dString.getBytes();
                InetAddress address = packet.getAddress();
                int port = packet.getPort();
                packet = new DatagramPacket(buf, buf.length, address, port);
                this.socket.send(packet);
            }
            catch (IOException e) {
                this.ctx.logger.error((Object)"while processing remote command", (Throwable)e);
            }
        }
    }

    class SetRateCmd
    implements RemoteCmd {
        SetRateCmd() {
        }

        @Override
        public String execute(String[] cmdSplit) {
            RemoteControl.this.ctx.setProperty("smppp.caps", cmdSplit[1]);
            ((RemoteControl)RemoteControl.this).ctx.fsm.fire((Object)GlobalEvent.RATE_CHANGED, RemoteControl.this.ctx);
            return RemoteControl.SUCCESS;
        }
    }

    class StopCmd
    implements RemoteCmd {
        StopCmd() {
        }

        @Override
        public String execute(String[] cmdSplit) {
            ((RemoteControl)RemoteControl.this).ctx.fsm.fire((Object)GlobalEvent.STOP, RemoteControl.this.ctx);
            return RemoteControl.SUCCESS;
        }
    }

    static interface RemoteCmd {
        public String execute(String[] var1);
    }
}

