/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.smpp.load.smppp;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.concurrent.TimeUnit;
import javax.xml.bind.JAXBContext;
import org.mobicents.protocols.smpp.load.smppp.GlobalContext;
import org.mobicents.protocols.smpp.load.smppp.GlobalEvent;
import org.mobicents.protocols.smpp.load.smppp.GlobalFSM;
import org.mobicents.protocols.smpp.load.smppp.GlobalState;
import org.mobicents.protocols.smpp.load.smppp.RemoteControl;
import org.mobicents.protocols.smpp.load.smppp.Scenario;
import org.mobicents.protocols.smpp.load.smppp.StatsPrinter;
import org.mobicents.protocols.smpp.load.smppp.SteppedEngine;
import org.mobicents.protocols.smpp.load.smppp.SteppedScenario;
import org.squirrelframework.foundation.fsm.Action;

public class StartAction
implements Action<GlobalFSM, GlobalState, GlobalEvent, GlobalContext> {
    public void execute(GlobalState s, GlobalState s1, GlobalEvent e, GlobalContext ctx, GlobalFSM t) {
        try {
            this.initScenario(ctx);
            for (int i = 0; i < ctx.initializersList.size(); ++i) {
                ctx.initializersList.get(i).init(ctx);
            }
            ctx.remoteControl = new RemoteControl(ctx);
            ctx.remoteControl.start();
            ctx.csvFuture = ctx.executor.scheduleAtFixedRate(new StatsPrinter(ctx), ctx.getIntegerProp("smppp.csvFrequency").intValue(), ctx.getIntegerProp("smppp.csvFrequency").intValue(), TimeUnit.SECONDS);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private void initScenario(GlobalContext ctx) throws Exception {
        String scenarioXML = ctx.getProperty("smppp.scenarioXMLPath");
        if (scenarioXML != null) {
            SteppedScenario targetSet;
            FileInputStream resourceAsStream = new FileInputStream(new File(scenarioXML));
            JAXBContext targetsContext = JAXBContext.newInstance((Class[])new Class[]{SteppedScenario.class});
            ctx.scenarioXml = targetSet = (SteppedScenario)targetsContext.createUnmarshaller().unmarshal((InputStream)resourceAsStream);
            ctx.scenario = new SteppedEngine();
            ctx.scenario.init(ctx);
        } else {
            String scenarioClassName = ctx.getProperty("smppp.scenarioClassName");
            Class<?> scenarioClass = this.getClass().getClassLoader().loadClass(scenarioClassName);
            ctx.scenario = (Scenario)scenarioClass.newInstance();
        }
        ctx.scenario.init(ctx);
    }

    public String name() {
        return "StartAction";
    }

    public int weight() {
        return 0;
    }

    public boolean isAsync() {
        return false;
    }

    public long timeout() {
        return 0L;
    }
}

