/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.smpp.load.smppp;

import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.mobicents.protocols.smpp.load.smppp.GlobalContext;

public class StatsPrinter
implements Runnable,
Closeable {
    private static final String[] COUNTER_HDRS = new String[]{"CreatedScenario", "FailedScenario", "CompletedScenario"};
    private static final String CSV_SEPARATOR = ";";
    GlobalContext ctx;
    PrintWriter writer;
    boolean headerPrinted = false;

    public StatsPrinter(GlobalContext ctx) throws FileNotFoundException, UnsupportedEncodingException {
        this.ctx = ctx;
        String csvFilePath = ctx.getProperty("smppp.csvFilePath");
        if (csvFilePath == null) {
            csvFilePath = "smppp-" + System.currentTimeMillis() + ".csv";
        }
        this.writer = new PrintWriter(csvFilePath, "UTF-8");
    }

    private void printHeader(Map<String, AtomicLong> retrieveAndResetCurrentCounters) {
        ArrayList<String> columns = new ArrayList<String>(COUNTER_HDRS.length);
        columns.addAll(Arrays.asList(COUNTER_HDRS));
        for (int i = 1; i < 5; ++i) {
            String rSamplesKey = "ResponseTimeSamples" + i;
            if (!retrieveAndResetCurrentCounters.containsKey(rSamplesKey)) continue;
            columns.add("ResponseTime" + i);
        }
        this.printRow(columns);
    }

    private void printRow(List columns) {
        StringBuilder csvLine = new StringBuilder();
        for (Object cAux : columns) {
            csvLine.append(cAux);
            csvLine.append(CSV_SEPARATOR);
        }
        this.writer.println(csvLine.toString());
        this.writer.flush();
    }

    @Override
    public void run() {
        ArrayList<Object> columns = new ArrayList<Object>(COUNTER_HDRS.length);
        Map<String, AtomicLong> retrieveAndResetCurrentCounters = this.ctx.retrieveAndResetCurrentCounters();
        if (!this.headerPrinted) {
            this.printHeader(retrieveAndResetCurrentCounters);
            this.headerPrinted = true;
        }
        for (String counterKey : COUNTER_HDRS) {
            AtomicLong counter = retrieveAndResetCurrentCounters.get(counterKey);
            if (counter != null) {
                columns.add(counter);
                continue;
            }
            columns.add("0");
        }
        for (int i = 1; i < 5; ++i) {
            String rSamplesKey = "ResponseTimeSamples" + i;
            if (!retrieveAndResetCurrentCounters.containsKey(rSamplesKey)) continue;
            String rSumKey = "ResponseTimeSum" + i;
            AtomicLong samples = retrieveAndResetCurrentCounters.get(rSamplesKey);
            AtomicLong sum = retrieveAndResetCurrentCounters.get(rSumKey);
            double avg = sum.get() / samples.get();
            columns.add(String.format(Locale.US, "%.2f", avg));
        }
        this.printRow(columns);
    }

    @Override
    public void close() throws IOException {
        if (this.writer != null) {
            this.writer.close();
        }
    }
}

