/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.smpp.load.smppp;

import com.cloudhopper.smpp.SmppBindType;
import com.cloudhopper.smpp.SmppSession;
import com.cloudhopper.smpp.SmppSessionConfiguration;
import com.cloudhopper.smpp.SmppSessionHandler;
import com.cloudhopper.smpp.impl.DefaultSmppClient;
import com.cloudhopper.smpp.impl.DefaultSmppSessionHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;
import org.mobicents.protocols.smpp.load.smppp.CyclicCounter;
import org.mobicents.protocols.smpp.load.smppp.GlobalContext;
import org.mobicents.protocols.smpp.load.smppp.GlobalEvent;
import org.mobicents.protocols.smpp.load.smppp.StackInitializer;

public class SMPPInitializer
implements StackInitializer {
    @Override
    public String getStackProtocol() {
        return "smppStack";
    }

    @Override
    public void init(GlobalContext ctx) throws Exception {
        DefaultSmppClient clientBootstrap = new DefaultSmppClient(Executors.newCachedThreadPool(), ctx.getIntegerProp("smppp.smppStack.sessionCount").intValue(), ctx.executor);
        SmppSessionConfiguration config = new SmppSessionConfiguration();
        config.setWindowSize(ctx.getIntegerProp("smppp.smppStack.windowSize").intValue());
        config.setName(ctx.getProperty("smppp.smppStack.name"));
        config.setType(SmppBindType.valueOf((String)ctx.getProperty("smppp.smppStack.type")));
        config.setHost(ctx.getProperty("smppp.smppStack.host"));
        config.setPort(ctx.getIntegerProp("smppp.smppStack.port").intValue());
        config.setConnectTimeout((long)ctx.getIntegerProp("smppp.smppStack.connectTimeout").intValue());
        config.setSystemId(ctx.getProperty("smppp.smppStack.systemId"));
        config.setPassword(ctx.getProperty("smppp.smppStack.password"));
        config.getLoggingOptions().setLogBytes(Boolean.valueOf(ctx.getProperty("smppp.smppStack.logBytes")).booleanValue());
        config.setRequestExpiryTimeout((long)ctx.getIntegerProp("smppp.smppStack.requestExpiryTimeout").intValue());
        config.setWindowMonitorInterval((long)ctx.getIntegerProp("smppp.smppStack.windowMonitorInterval").intValue());
        config.setCountersEnabled(Boolean.valueOf(ctx.getProperty("smppp.smppStack.countersEnabled")).booleanValue());
        DefaultSmppSessionHandler sessionHandler = (DefaultSmppSessionHandler)ctx.scenario;
        ArrayList<SmppSession> sessionList = new ArrayList<SmppSession>(ctx.getIntegerProp("smppp.smppStack.sessionCount"));
        for (int i = 0; i < ctx.getIntegerProp("smppp.smppStack.sessionCount"); ++i) {
            sessionList.add(clientBootstrap.bind(config, (SmppSessionHandler)sessionHandler));
        }
        ctx.data.put("SMPPSessionList", sessionList);
        CyclicCounter sessionCounter = new CyclicCounter(ctx.getIntegerProp("smppp.smppStack.sessionCount"));
        ctx.data.put("sessionCounter", sessionCounter);
        ctx.fsm.fire((Object)GlobalEvent.ASSOCIATION_UP, ctx);
    }

    @Override
    public void stop(GlobalContext ctx) throws Exception {
        List sessionList = (List)ctx.data.get("SMPPSessionList");
        for (SmppSession sAux : sessionList) {
            sAux.close();
        }
    }
}

