/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.smsc.slee.resources.smpp.server;

import com.cloudhopper.commons.util.windowing.WindowFuture;
import com.cloudhopper.smpp.PduAsyncResponse;
import com.cloudhopper.smpp.SmppSessionCounters;
import com.cloudhopper.smpp.SmppSessionHandler;
import com.cloudhopper.smpp.impl.DefaultSmppSession;
import com.cloudhopper.smpp.pdu.DataSm;
import com.cloudhopper.smpp.pdu.DataSmResp;
import com.cloudhopper.smpp.pdu.DeliverSm;
import com.cloudhopper.smpp.pdu.DeliverSmResp;
import com.cloudhopper.smpp.pdu.Pdu;
import com.cloudhopper.smpp.pdu.PduRequest;
import com.cloudhopper.smpp.pdu.PduResponse;
import com.cloudhopper.smpp.pdu.SubmitMulti;
import com.cloudhopper.smpp.pdu.SubmitMultiResp;
import com.cloudhopper.smpp.pdu.SubmitSm;
import com.cloudhopper.smpp.pdu.SubmitSmResp;
import com.cloudhopper.smpp.type.Address;
import com.cloudhopper.smpp.type.RecoverablePduException;
import com.cloudhopper.smpp.type.SmppChannelException;
import com.cloudhopper.smpp.type.SmppTimeoutException;
import com.cloudhopper.smpp.type.UnrecoverablePduException;
import javax.slee.SLEEException;
import javax.slee.facilities.Tracer;
import javax.slee.resource.ActivityAlreadyExistsException;
import javax.slee.resource.StartActivityException;
import org.mobicents.smsc.slee.resources.smpp.server.SmppServerResourceAdaptor;
import org.mobicents.smsc.slee.resources.smpp.server.SmppSessions;
import org.mobicents.smsc.slee.resources.smpp.server.SmppTransaction;
import org.mobicents.smsc.slee.resources.smpp.server.SmppTransactionHandle;
import org.mobicents.smsc.slee.resources.smpp.server.SmppTransactionImpl;
import org.mobicents.smsc.slee.resources.smpp.server.SmppTransactionType;
import org.mobicents.smsc.slee.resources.smpp.server.events.PduRequestTimeout;
import org.mobicents.smsc.smpp.Esme;
import org.mobicents.smsc.smpp.SmppSessionHandlerInterface;

public class SmppSessionsImpl
implements SmppSessions {
    private static Tracer tracer;
    private SmppServerResourceAdaptor smppServerResourceAdaptor = null;
    protected SmppSessionHandlerInterfaceImpl smppSessionHandlerInterfaceImpl = null;

    public SmppSessionsImpl(SmppServerResourceAdaptor smppServerResourceAdaptor) {
        this.smppServerResourceAdaptor = smppServerResourceAdaptor;
        if (tracer == null) {
            tracer = this.smppServerResourceAdaptor.getRAContext().getTracer(SmppSessionHandlerInterfaceImpl.class.getSimpleName());
        }
        this.smppSessionHandlerInterfaceImpl = new SmppSessionHandlerInterfaceImpl();
    }

    protected SmppSessionHandlerInterface getSmppSessionHandlerInterface() {
        return this.smppSessionHandlerInterfaceImpl;
    }

    public SmppTransaction sendRequestPdu(Esme esme, PduRequest request, long timeoutMillis) throws RecoverablePduException, UnrecoverablePduException, SmppTimeoutException, SmppChannelException, InterruptedException, ActivityAlreadyExistsException, NullPointerException, IllegalStateException, SLEEException, StartActivityException {
        DefaultSmppSession defaultSmppSession = esme.getSmppSession();
        if (defaultSmppSession == null) {
            throw new NullPointerException("Underlying SmppSession is Null!");
        }
        if (!request.hasSequenceNumberAssigned()) {
            request.setSequenceNumber(defaultSmppSession.getSequenceNumber().next());
        }
        SmppTransactionHandle smppServerTransactionHandle = new SmppTransactionHandle(esme.getName(), request.getSequenceNumber(), SmppTransactionType.OUTGOING);
        SmppTransactionImpl smppServerTransaction = new SmppTransactionImpl(request, esme, smppServerTransactionHandle, this.smppServerResourceAdaptor);
        this.smppServerResourceAdaptor.startNewSmppTransactionSuspendedActivity(smppServerTransaction);
        try {
            WindowFuture windowFuture = defaultSmppSession.sendRequestPdu(request, timeoutMillis, false);
        }
        catch (RecoverablePduException e) {
            this.smppServerResourceAdaptor.endActivity(smppServerTransaction);
            throw e;
        }
        catch (UnrecoverablePduException e) {
            this.smppServerResourceAdaptor.endActivity(smppServerTransaction);
            throw e;
        }
        catch (SmppTimeoutException e) {
            this.smppServerResourceAdaptor.endActivity(smppServerTransaction);
            throw e;
        }
        catch (SmppChannelException e) {
            this.smppServerResourceAdaptor.endActivity(smppServerTransaction);
            throw e;
        }
        catch (InterruptedException e) {
            this.smppServerResourceAdaptor.endActivity(smppServerTransaction);
            throw e;
        }
        return smppServerTransaction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendResponsePdu(Esme esme, PduRequest request, PduResponse response) throws RecoverablePduException, UnrecoverablePduException, SmppChannelException, InterruptedException {
        SmppTransactionImpl smppServerTransactionImpl = (SmppTransactionImpl)request.getReferenceObject();
        try {
            DefaultSmppSession defaultSmppSession = esme.getSmppSession();
            if (defaultSmppSession == null) {
                throw new NullPointerException("Underlying SmppSession is Null!");
            }
            if (request.getSequenceNumber() != response.getSequenceNumber()) {
                throw new UnrecoverablePduException("Sequence number of response is not same as request");
            }
            defaultSmppSession.sendResponsePdu(response);
        }
        catch (Throwable throwable) {
            SmppSessionCounters smppSessionCounters = esme.getSmppSession().getCounters();
            SmppTransactionImpl smppTransactionImpl = (SmppTransactionImpl)request.getReferenceObject();
            long responseTime = System.currentTimeMillis() - smppTransactionImpl.getStartTime();
            this.countSendResponsePdu(smppSessionCounters, response, responseTime, responseTime);
            if (smppServerTransactionImpl == null) {
                tracer.severe(String.format("SmppTransactionImpl Activity is null while trying to send PduResponse=%s", response));
            } else {
                this.smppServerResourceAdaptor.endActivity(smppServerTransactionImpl);
            }
            throw throwable;
        }
        SmppSessionCounters smppSessionCounters = esme.getSmppSession().getCounters();
        SmppTransactionImpl smppTransactionImpl = (SmppTransactionImpl)request.getReferenceObject();
        long responseTime = System.currentTimeMillis() - smppTransactionImpl.getStartTime();
        this.countSendResponsePdu(smppSessionCounters, response, responseTime, responseTime);
        if (smppServerTransactionImpl == null) {
            tracer.severe(String.format("SmppTransactionImpl Activity is null while trying to send PduResponse=%s", response));
        } else {
            this.smppServerResourceAdaptor.endActivity(smppServerTransactionImpl);
        }
    }

    private void countSendResponsePdu(SmppSessionCounters counters, PduResponse pdu, long responseTime, long estimatedProcessingTime) {
        if (pdu.isResponse()) {
            switch (pdu.getCommandId()) {
                case -2147483644: {
                    counters.getRxSubmitSM().incrementResponseAndGet();
                    counters.getRxSubmitSM().addRequestResponseTimeAndGet(responseTime);
                    counters.getRxSubmitSM().addRequestEstimatedProcessingTimeAndGet(estimatedProcessingTime);
                    counters.getRxSubmitSM().getResponseCommandStatusCounter().incrementAndGet(pdu.getCommandStatus());
                    break;
                }
                case -2147483643: {
                    counters.getRxDeliverSM().incrementResponseAndGet();
                    counters.getRxDeliverSM().addRequestResponseTimeAndGet(responseTime);
                    counters.getRxDeliverSM().addRequestEstimatedProcessingTimeAndGet(estimatedProcessingTime);
                    counters.getRxDeliverSM().getResponseCommandStatusCounter().incrementAndGet(pdu.getCommandStatus());
                    break;
                }
                case -2147483389: {
                    counters.getRxDataSM().incrementResponseAndGet();
                    counters.getRxDataSM().addRequestResponseTimeAndGet(responseTime);
                    counters.getRxDataSM().addRequestEstimatedProcessingTimeAndGet(estimatedProcessingTime);
                    counters.getRxDataSM().getResponseCommandStatusCounter().incrementAndGet(pdu.getCommandStatus());
                    break;
                }
                case -2147483627: {
                    counters.getRxEnquireLink().incrementResponseAndGet();
                    counters.getRxEnquireLink().addRequestResponseTimeAndGet(responseTime);
                    counters.getRxEnquireLink().addRequestEstimatedProcessingTimeAndGet(estimatedProcessingTime);
                    counters.getRxEnquireLink().getResponseCommandStatusCounter().incrementAndGet(pdu.getCommandStatus());
                }
            }
        }
    }

    protected class SmppSessionHandlerImpl
    implements SmppSessionHandler {
        private Esme esme;

        public SmppSessionHandlerImpl(Esme esme) {
            this.esme = esme;
        }

        public PduResponse firePduRequestReceived(PduRequest pduRequest) {
            PduResponse response = pduRequest.createResponse();
            try {
                SmppTransactionImpl smppServerTransaction = null;
                SmppTransactionHandle smppServerTransactionHandle = null;
                Address sourceAddress = null;
                switch (pduRequest.getCommandId()) {
                    case 21: {
                        break;
                    }
                    case 6: {
                        break;
                    }
                    case 4: {
                        SubmitSm submitSm = (SubmitSm)pduRequest;
                        sourceAddress = submitSm.getSourceAddress();
                        if (!this.esme.isSourceAddressMatching(sourceAddress)) {
                            tracer.warning(String.format("Incoming SUBMIT_SM's sequence_number=%d source_addr_ton=%d source_addr_npi=%d source_addr=%s doesn't match with configured ESME name=%s source_addr_ton=%d source_addr_npi=%d source_addr=%s", submitSm.getSequenceNumber(), sourceAddress.getTon(), sourceAddress.getNpi(), sourceAddress.getAddress(), this.esme.getName(), this.esme.getSourceTon(), this.esme.getSourceNpi(), this.esme.getSourceAddressRange()));
                            response.setCommandStatus(10);
                            return response;
                        }
                        smppServerTransactionHandle = new SmppTransactionHandle(this.esme.getName(), pduRequest.getSequenceNumber(), SmppTransactionType.INCOMING);
                        smppServerTransaction = new SmppTransactionImpl(pduRequest, this.esme, smppServerTransactionHandle, SmppSessionsImpl.this.smppServerResourceAdaptor);
                        SmppSessionsImpl.this.smppServerResourceAdaptor.startNewSmppServerTransactionActivity(smppServerTransaction);
                        SmppSessionsImpl.this.smppServerResourceAdaptor.fireEvent("org.mobicents.resources.smpp.server.SUBMIT_SM", smppServerTransaction.getActivityHandle(), submitSm);
                        return null;
                    }
                    case 259: {
                        DataSm dataSm = (DataSm)pduRequest;
                        sourceAddress = dataSm.getSourceAddress();
                        if (!this.esme.isSourceAddressMatching(sourceAddress)) {
                            tracer.warning(String.format("Incoming DATA_SM's sequence_number=%d source_addr_ton=%d source_addr_npi=%d source_addr=%s doesn't match with configured ESME name=%s source_addr_ton=%d source_addr_npi=%d source_addr=%s", dataSm.getSequenceNumber(), sourceAddress.getTon(), sourceAddress.getNpi(), sourceAddress.getAddress(), this.esme.getName(), this.esme.getSourceTon(), this.esme.getSourceNpi(), this.esme.getSourceAddressRange()));
                            response.setCommandStatus(10);
                            return response;
                        }
                        smppServerTransactionHandle = new SmppTransactionHandle(this.esme.getName(), pduRequest.getSequenceNumber(), SmppTransactionType.INCOMING);
                        smppServerTransaction = new SmppTransactionImpl(pduRequest, this.esme, smppServerTransactionHandle, SmppSessionsImpl.this.smppServerResourceAdaptor);
                        SmppSessionsImpl.this.smppServerResourceAdaptor.startNewSmppServerTransactionActivity(smppServerTransaction);
                        SmppSessionsImpl.this.smppServerResourceAdaptor.fireEvent("org.mobicents.resources.smpp.server.DATA_SM", smppServerTransaction.getActivityHandle(), (DataSm)pduRequest);
                        return null;
                    }
                    case 5: {
                        DeliverSm deliverSm = (DeliverSm)pduRequest;
                        sourceAddress = deliverSm.getSourceAddress();
                        if (!this.esme.isSourceAddressMatching(sourceAddress)) {
                            tracer.warning(String.format("Incoming DELIVER_SM's sequence_number=%d source_addr_ton=%d source_addr_npi=%d source_addr=%s doesn't match with configured ESME name=%s source_addr_ton=%d source_addr_npi=%d source_addr=%s", deliverSm.getSequenceNumber(), sourceAddress.getTon(), sourceAddress.getNpi(), sourceAddress.getAddress(), this.esme.getName(), this.esme.getSourceTon(), this.esme.getSourceNpi(), this.esme.getSourceAddressRange()));
                            response.setCommandStatus(10);
                            return response;
                        }
                        smppServerTransactionHandle = new SmppTransactionHandle(this.esme.getName(), pduRequest.getSequenceNumber(), SmppTransactionType.INCOMING);
                        smppServerTransaction = new SmppTransactionImpl(pduRequest, this.esme, smppServerTransactionHandle, SmppSessionsImpl.this.smppServerResourceAdaptor);
                        SmppSessionsImpl.this.smppServerResourceAdaptor.startNewSmppServerTransactionActivity(smppServerTransaction);
                        SmppSessionsImpl.this.smppServerResourceAdaptor.fireEvent("org.mobicents.resources.smpp.server.DELIVER_SM", smppServerTransaction.getActivityHandle(), (DeliverSm)pduRequest);
                        return null;
                    }
                    case 33: {
                        SubmitMulti submitMulti = (SubmitMulti)pduRequest;
                        sourceAddress = submitMulti.getSourceAddress();
                        if (!this.esme.isSourceAddressMatching(sourceAddress)) {
                            tracer.warning(String.format("Incoming SUBMIT_MULTI's sequence_number=%d source_addr_ton=%d source_addr_npi=%d source_addr=%s doesn't match with configured ESME name=%s source_addr_ton=%d source_addr_npi=%d source_addr=%s", submitMulti.getSequenceNumber(), sourceAddress.getTon(), sourceAddress.getNpi(), sourceAddress.getAddress(), this.esme.getName(), this.esme.getSourceTon(), this.esme.getSourceNpi(), this.esme.getSourceAddressRange()));
                            response.setCommandStatus(10);
                            return response;
                        }
                        smppServerTransactionHandle = new SmppTransactionHandle(this.esme.getName(), pduRequest.getSequenceNumber(), SmppTransactionType.INCOMING);
                        smppServerTransaction = new SmppTransactionImpl(pduRequest, this.esme, smppServerTransactionHandle, SmppSessionsImpl.this.smppServerResourceAdaptor);
                        SmppSessionsImpl.this.smppServerResourceAdaptor.startNewSmppServerTransactionActivity(smppServerTransaction);
                        SmppSessionsImpl.this.smppServerResourceAdaptor.fireEvent("org.mobicents.resources.smpp.server.SUBMIT_MULTI", smppServerTransaction.getActivityHandle(), submitMulti);
                        return null;
                    }
                    default: {
                        tracer.severe(String.format("Rx : Non supported PduRequest=%s. Will not fire event", pduRequest));
                        break;
                    }
                }
            }
            catch (Exception e) {
                tracer.severe(String.format("Error while processing PduRequest=%s", pduRequest), (Throwable)e);
                response.setCommandStatus(8);
            }
            return response;
        }

        public String lookupResultMessage(int arg0) {
            return null;
        }

        public String lookupTlvTagName(short arg0) {
            return null;
        }

        public void fireChannelUnexpectedlyClosed() {
            tracer.severe(String.format("Rx : fireChannelUnexpectedlyClosed for SmppSessionImpl=%s Default handling is to discard an unexpected channel closed", this.esme.getName()));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void fireExpectedPduResponseReceived(PduAsyncResponse pduAsyncResponse) {
            PduRequest pduRequest = pduAsyncResponse.getRequest();
            PduResponse pduResponse = pduAsyncResponse.getResponse();
            SmppTransactionImpl smppServerTransaction = (SmppTransactionImpl)pduRequest.getReferenceObject();
            if (smppServerTransaction == null) {
                tracer.severe(String.format("Rx : fireExpectedPduResponseReceived for SmppSessionImpl=%s PduAsyncResponse=%s but SmppTransactionImpl is null", this.esme.getName(), pduAsyncResponse));
                return;
            }
            try {
                switch (pduResponse.getCommandId()) {
                    case -2147483643: {
                        SmppSessionsImpl.this.smppServerResourceAdaptor.fireEvent("org.mobicents.resources.smpp.server.DELIVER_SM_RESP", smppServerTransaction.getActivityHandle(), (DeliverSmResp)pduResponse);
                        return;
                    }
                    case -2147483389: {
                        SmppSessionsImpl.this.smppServerResourceAdaptor.fireEvent("org.mobicents.resources.smpp.server.DATA_SM_RESP", smppServerTransaction.getActivityHandle(), (DataSmResp)pduResponse);
                        return;
                    }
                    case -2147483644: {
                        SmppSessionsImpl.this.smppServerResourceAdaptor.fireEvent("org.mobicents.resources.smpp.server.SUBMIT_SM_RESP", smppServerTransaction.getActivityHandle(), (SubmitSmResp)pduResponse);
                        return;
                    }
                    case -2147483615: {
                        SmppSessionsImpl.this.smppServerResourceAdaptor.fireEvent("org.mobicents.resources.smpp.server.SUBMIT_MULTI_RESP", smppServerTransaction.getActivityHandle(), (SubmitMultiResp)pduResponse);
                        return;
                    }
                    default: {
                        tracer.severe(String.format("Rx : fireExpectedPduResponseReceived for SmppSessionImpl=%s PduAsyncResponse=%s but PduResponse is unidentified. Event will not be fired ", this.esme.getName(), pduAsyncResponse));
                        return;
                    }
                }
            }
            catch (Exception e) {
                tracer.severe(String.format("Error while processing PduAsyncResponse=%s", pduAsyncResponse), (Throwable)e);
                return;
            }
            finally {
                if (smppServerTransaction != null) {
                    SmppSessionsImpl.this.smppServerResourceAdaptor.endActivity(smppServerTransaction);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void firePduRequestExpired(PduRequest pduRequest) {
            tracer.warning(String.format("PduRequestExpired=%s", pduRequest));
            SmppTransactionImpl smppServerTransaction = (SmppTransactionImpl)pduRequest.getReferenceObject();
            if (smppServerTransaction == null) {
                tracer.severe(String.format("Rx : firePduRequestExpired for SmppSessionImpl=%s PduRequest=%s but SmppTransactionImpl is null", this.esme.getName(), pduRequest));
                return;
            }
            PduRequestTimeout event = new PduRequestTimeout(pduRequest, this.esme.getName());
            try {
                SmppSessionsImpl.this.smppServerResourceAdaptor.fireEvent("org.mobicents.resources.smpp.server.REQUEST_TIMEOUT", smppServerTransaction.getActivityHandle(), event);
            }
            catch (Exception e) {
                tracer.severe(String.format("Received firePduRequestExpired. Error while processing PduRequest=%s", pduRequest), (Throwable)e);
            }
            finally {
                if (smppServerTransaction != null) {
                    SmppSessionsImpl.this.smppServerResourceAdaptor.endActivity(smppServerTransaction);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fireRecoverablePduException(RecoverablePduException recoverablePduException) {
            tracer.warning("Received fireRecoverablePduException", (Throwable)recoverablePduException);
            Pdu partialPdu = recoverablePduException.getPartialPdu();
            SmppTransactionImpl smppServerTransaction = (SmppTransactionImpl)partialPdu.getReferenceObject();
            if (smppServerTransaction == null) {
                tracer.severe(String.format("Rx : fireRecoverablePduException for SmppSessionImpl=%s but SmppTransactionImpl is null", this.esme.getName()), (Throwable)recoverablePduException);
                return;
            }
            try {
                SmppSessionsImpl.this.smppServerResourceAdaptor.fireEvent("org.mobicents.resources.smpp.server.RECOVERABLE_PDU_EXCEPTION", smppServerTransaction.getActivityHandle(), recoverablePduException);
            }
            catch (Exception e) {
                tracer.severe(String.format("Received fireRecoverablePduException. Error while processing RecoverablePduException=%s", recoverablePduException), (Throwable)e);
            }
            finally {
                if (smppServerTransaction != null) {
                    SmppSessionsImpl.this.smppServerResourceAdaptor.endActivity(smppServerTransaction);
                }
            }
        }

        public void fireUnrecoverablePduException(UnrecoverablePduException unrecoverablePduException) {
            tracer.severe("Received fireUnrecoverablePduException", (Throwable)unrecoverablePduException);
        }

        public void fireUnexpectedPduResponseReceived(PduResponse pduResponse) {
            tracer.severe("Received fireUnexpectedPduResponseReceived PduResponse=" + pduResponse);
        }

        public void fireUnknownThrowable(Throwable throwable) {
            tracer.severe("Received fireUnknownThrowable", throwable);
        }
    }

    protected class SmppSessionHandlerInterfaceImpl
    implements SmppSessionHandlerInterface {
        public SmppSessionHandler createNewSmppSessionHandler(Esme esme) {
            return new SmppSessionHandlerImpl(esme);
        }
    }
}

