/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.smsc.slee.resources.smpp.server;

import java.util.concurrent.ConcurrentHashMap;
import javax.slee.EventTypeID;
import javax.slee.facilities.EventLookupFacility;
import javax.slee.facilities.Tracer;
import javax.slee.resource.FireableEventType;
import javax.slee.resource.ResourceAdaptorContext;

public class EventIDCache {
    private ConcurrentHashMap<String, FireableEventType> eventIds = new ConcurrentHashMap();
    private static final String EVENT_VENDOR = "org.mobicents";
    private static final String EVENT_VERSION = "1.0";
    private Tracer tracer;

    protected EventIDCache(ResourceAdaptorContext raContext) {
        this.tracer = raContext.getTracer(EventIDCache.class.getSimpleName());
    }

    protected FireableEventType getEventId(EventLookupFacility eventLookupFacility, String eventName) {
        FireableEventType eventType = this.eventIds.get(eventName);
        if (eventType == null) {
            try {
                eventType = eventLookupFacility.getFireableEventType(new EventTypeID(eventName, EVENT_VENDOR, EVENT_VERSION));
            }
            catch (Throwable e) {
                this.tracer.severe("Error while looking up for SMPP Server Events", e);
            }
            if (eventType != null) {
                this.eventIds.put(eventName, eventType);
            }
        }
        return eventType;
    }
}

