/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.smsc.slee.resources.smpp.server;

import javax.slee.Address;
import javax.slee.AddressPlan;
import javax.slee.SLEEException;
import javax.slee.facilities.EventLookupFacility;
import javax.slee.facilities.Tracer;
import javax.slee.resource.ActivityAlreadyExistsException;
import javax.slee.resource.ActivityHandle;
import javax.slee.resource.ActivityIsEndingException;
import javax.slee.resource.ConfigProperties;
import javax.slee.resource.FailureReason;
import javax.slee.resource.FireEventException;
import javax.slee.resource.FireableEventType;
import javax.slee.resource.IllegalEventException;
import javax.slee.resource.InvalidConfigurationException;
import javax.slee.resource.Marshaler;
import javax.slee.resource.ReceivableService;
import javax.slee.resource.ResourceAdaptor;
import javax.slee.resource.ResourceAdaptorContext;
import javax.slee.resource.SleeEndpoint;
import javax.slee.resource.StartActivityException;
import javax.slee.resource.UnrecognizedActivityHandleException;
import org.mobicents.smsc.slee.resources.smpp.server.EventIDCache;
import org.mobicents.smsc.slee.resources.smpp.server.SmppSessionsImpl;
import org.mobicents.smsc.slee.resources.smpp.server.SmppTransactionHandle;
import org.mobicents.smsc.slee.resources.smpp.server.SmppTransactionImpl;
import org.mobicents.smsc.smpp.SmppManagement;

public class SmppServerResourceAdaptor
implements ResourceAdaptor {
    private transient Tracer tracer;
    private transient ResourceAdaptorContext raContext;
    private transient SleeEndpoint sleeEndpoint = null;
    private transient EventLookupFacility eventLookup = null;
    private EventIDCache eventIdCache = null;
    private SmppSessionsImpl smppServerSession = null;
    private static final transient Address address = new Address(AddressPlan.IP, "localhost");

    public void activityEnded(ActivityHandle activityHandle) {
        if (this.tracer.isFineEnabled()) {
            this.tracer.fine("Activity with handle " + activityHandle + " ended");
        }
        SmppTransactionHandle serverTxHandle = (SmppTransactionHandle)activityHandle;
        SmppTransactionImpl serverTx = serverTxHandle.getActivity();
        serverTxHandle.setActivity(null);
        if (serverTx != null) {
            serverTx.clear();
        }
    }

    public void activityUnreferenced(ActivityHandle arg0) {
    }

    public void administrativeRemove(ActivityHandle arg0) {
    }

    public void eventProcessingFailed(ActivityHandle arg0, FireableEventType arg1, Object arg2, Address arg3, ReceivableService arg4, int arg5, FailureReason arg6) {
    }

    public void eventProcessingSuccessful(ActivityHandle arg0, FireableEventType arg1, Object arg2, Address arg3, ReceivableService arg4, int arg5) {
    }

    public void eventUnreferenced(ActivityHandle arg0, FireableEventType arg1, Object arg2, Address arg3, ReceivableService arg4, int arg5) {
    }

    public Object getActivity(ActivityHandle activityHandle) {
        SmppTransactionHandle serverTxHandle = (SmppTransactionHandle)activityHandle;
        return serverTxHandle.getActivity();
    }

    public ActivityHandle getActivityHandle(Object activity) {
        SmppTransactionImpl wrapper;
        if (activity instanceof SmppTransactionImpl && (wrapper = (SmppTransactionImpl)activity).getRa() == this) {
            return wrapper.getActivityHandle();
        }
        return null;
    }

    public Marshaler getMarshaler() {
        return null;
    }

    public Object getResourceAdaptorInterface(String arg0) {
        return this.smppServerSession;
    }

    public void queryLiveness(ActivityHandle activityHandle) {
        SmppTransactionHandle handle = (SmppTransactionHandle)activityHandle;
        SmppTransactionImpl smppServerTxActivity = handle.getActivity();
        if (smppServerTxActivity == null || smppServerTxActivity.getWrappedPduRequest() == null) {
            this.sleeEndpoint.endActivity((ActivityHandle)handle);
        }
    }

    public void raActive() {
        try {
            SmppManagement smscManagemet = SmppManagement.getInstance();
            smscManagemet.setSmppSessionHandlerInterface(this.smppServerSession.getSmppSessionHandlerInterface());
            smscManagemet.startSmppManagement();
            if (this.tracer.isInfoEnabled()) {
                this.tracer.info("Activated RA Entity " + this.raContext.getEntityName());
            }
        }
        catch (Exception e) {
            this.tracer.severe("Failed to activate SMPP Server RA ", (Throwable)e);
        }
    }

    public void raConfigurationUpdate(ConfigProperties properties) {
        this.raConfigure(properties);
    }

    public void raConfigure(ConfigProperties properties) {
        if (this.tracer.isFineEnabled()) {
            this.tracer.fine("Configuring RA Entity " + this.raContext.getEntityName());
        }
    }

    public void raInactive() {
        SmppManagement smscManagemet = SmppManagement.getInstance();
        try {
            smscManagemet.stopSmppManagement();
        }
        catch (Exception e) {
            this.tracer.severe("Error while inactivating RA Entity " + this.raContext.getEntityName(), (Throwable)e);
        }
        if (this.tracer.isInfoEnabled()) {
            this.tracer.info("Inactivated RA Entity " + this.raContext.getEntityName());
        }
    }

    public void raStopping() {
    }

    public void raUnconfigure() {
    }

    public void raVerifyConfiguration(ConfigProperties properties) throws InvalidConfigurationException {
    }

    public void serviceActive(ReceivableService arg0) {
    }

    public void serviceInactive(ReceivableService arg0) {
    }

    public void serviceStopping(ReceivableService arg0) {
    }

    public void setResourceAdaptorContext(ResourceAdaptorContext raContext) {
        this.tracer = raContext.getTracer(this.getClass().getSimpleName());
        this.raContext = raContext;
        this.sleeEndpoint = raContext.getSleeEndpoint();
        this.eventLookup = raContext.getEventLookupFacility();
        this.eventIdCache = new EventIDCache(raContext);
        this.smppServerSession = new SmppSessionsImpl(this);
    }

    public void unsetResourceAdaptorContext() {
        this.raContext = null;
        this.sleeEndpoint = null;
        this.eventLookup = null;
        this.eventIdCache = null;
        this.smppServerSession = null;
    }

    protected void startNewSmppServerTransactionActivity(SmppTransactionImpl txImpl) throws ActivityAlreadyExistsException, NullPointerException, IllegalStateException, SLEEException, StartActivityException {
        this.sleeEndpoint.startActivity((ActivityHandle)txImpl.getActivityHandle(), (Object)txImpl, 2);
    }

    protected void startNewSmppTransactionSuspendedActivity(SmppTransactionImpl txImpl) throws ActivityAlreadyExistsException, NullPointerException, IllegalStateException, SLEEException, StartActivityException {
        this.sleeEndpoint.startActivitySuspended((ActivityHandle)txImpl.getActivityHandle(), (Object)txImpl, 2);
    }

    protected void endActivity(SmppTransactionImpl txImpl) {
        try {
            this.sleeEndpoint.endActivity((ActivityHandle)txImpl.getActivityHandle());
        }
        catch (Exception e) {
            this.tracer.severe("Error while Ending Activity " + txImpl, (Throwable)e);
        }
    }

    protected ResourceAdaptorContext getRAContext() {
        return this.raContext;
    }

    protected void fireEvent(String eventName, ActivityHandle handle, Object event) {
        FireableEventType eventID = this.eventIdCache.getEventId(this.eventLookup, eventName);
        if (eventID == null) {
            this.tracer.severe("Event id for " + eventID + " is unknown, cant fire!!!");
        } else {
            try {
                this.sleeEndpoint.fireEvent(handle, eventID, event, address, null);
            }
            catch (UnrecognizedActivityHandleException e) {
                this.tracer.severe("Error while firing event", (Throwable)e);
            }
            catch (IllegalEventException e) {
                this.tracer.severe("Error while firing event", (Throwable)e);
            }
            catch (ActivityIsEndingException e) {
                this.tracer.severe("Error while firing event", (Throwable)e);
            }
            catch (NullPointerException e) {
                this.tracer.severe("Error while firing event", (Throwable)e);
            }
            catch (SLEEException e) {
                this.tracer.severe("Error while firing event", (Throwable)e);
            }
            catch (FireEventException e) {
                this.tracer.severe("Error while firing event", (Throwable)e);
            }
        }
    }
}

