/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.smsc.tools.smppsimulator;

import com.cloudhopper.smpp.PduAsyncResponse;
import com.cloudhopper.smpp.impl.DefaultSmppSessionHandler;
import com.cloudhopper.smpp.pdu.BaseSm;
import com.cloudhopper.smpp.pdu.PduRequest;
import com.cloudhopper.smpp.pdu.PduResponse;
import com.cloudhopper.smpp.tlv.Tlv;
import com.cloudhopper.smpp.type.RecoverablePduException;
import com.cloudhopper.smpp.type.UnrecoverablePduException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import org.mobicents.protocols.ss7.map.datacoding.GSMCharset;
import org.mobicents.protocols.ss7.map.datacoding.GSMCharsetDecoder;
import org.mobicents.protocols.ss7.map.datacoding.GSMCharsetDecodingData;
import org.mobicents.protocols.ss7.map.datacoding.Gsm7EncodingStyle;
import org.mobicents.protocols.ss7.map.smstpdu.DataCodingSchemeImpl;
import org.mobicents.smsc.tools.smppsimulator.SmppTestingForm;

public class ClientSmppSessionHandler
extends DefaultSmppSessionHandler {
    private SmppTestingForm testingForm;
    private static Charset utf8Charset = Charset.forName("UTF-8");
    private static Charset ucs2Charset = Charset.forName("UTF-16BE");
    private static Charset isoCharset = Charset.forName("ISO-8859-1");
    private static Charset gsm7Charset = new GSMCharset("GSM", new String[0]);

    public ClientSmppSessionHandler(SmppTestingForm testingForm) {
        this.testingForm = testingForm;
    }

    public void fireChannelUnexpectedlyClosed() {
        this.testingForm.addMessage("ChannelUnexpectedlyClosed", "SMPP channel unexpectedly closed by a peer or by TCP connection dropped");
        this.testingForm.doStop();
    }

    public PduResponse firePduRequestReceived(PduRequest pduRequest) {
        this.testingForm.addMessage("PduRequestReceived: " + pduRequest.getName(), pduRequest.toString());
        this.testingForm.messagesRcvd.incrementAndGet();
        PduResponse resp = pduRequest.createResponse();
        if (pduRequest.getCommandId() == 5 || pduRequest.getCommandId() == 259 || pduRequest.getCommandId() == 4) {
            if (pduRequest instanceof BaseSm) {
                int udhLen;
                Tlv messagePaylod;
                BaseSm dev = (BaseSm)pduRequest;
                byte[] data = dev.getShortMessage();
                if (dev.getShortMessageLength() == 0 && (messagePaylod = dev.getOptionalParameter((short)1060)) != null) {
                    data = messagePaylod.getValue();
                }
                DataCodingSchemeImpl dcs = new DataCodingSchemeImpl((int)dev.getDataCoding());
                boolean udhPresent = (dev.getEsmClass() & 0x40) != 0;
                byte[] textPart = data;
                byte[] udhData = null;
                if (udhPresent && data.length > 2 && (udhLen = (data[0] & 0xFF) + 1) <= data.length) {
                    textPart = new byte[textPart.length - udhLen];
                    udhData = new byte[udhLen];
                    System.arraycopy(data, udhLen, textPart, 0, textPart.length);
                    System.arraycopy(data, 0, udhData, 0, udhLen);
                }
                String s = null;
                switch (dcs.getCharacterSet()) {
                    case GSM7: 
                    case UCS2: {
                        if (this.testingForm.getSmppSimulatorParameters().getSmppEncoding() == 0) {
                            s = new String(textPart, utf8Charset);
                            break;
                        }
                        if (this.testingForm.getSmppSimulatorParameters().getSmppEncoding() == 1) {
                            s = new String(textPart, ucs2Charset);
                            break;
                        }
                        GSMCharsetDecoder decoder = (GSMCharsetDecoder)gsm7Charset.newDecoder();
                        decoder.setGSMCharsetDecodingData(new GSMCharsetDecodingData(Gsm7EncodingStyle.bit8_smpp_style, Integer.MAX_VALUE, 0));
                        ByteBuffer bb = ByteBuffer.wrap(textPart);
                        CharBuffer bf = null;
                        try {
                            bf = decoder.decode(bb);
                        }
                        catch (CharacterCodingException e) {
                            e.printStackTrace();
                        }
                        s = bf.toString();
                        break;
                    }
                    case GSM8: {
                        s = new String(textPart, isoCharset);
                    }
                }
                String s2 = "";
                if (udhData != null) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("[");
                    boolean i2 = false;
                    for (byte b : udhData) {
                        int i1 = b & 0xFF;
                        if (!i2) {
                            i2 = true;
                        } else {
                            sb.append(", ");
                        }
                        sb.append(i1);
                    }
                    sb.append("] ");
                    s2 = sb.toString();
                }
                this.testingForm.addMessage("TextReceived: ", s2 + s);
            }
            if (this.testingForm.getSmppSimulatorParameters().isRejectIncomingDeliveryMessage()) {
                resp.setCommandStatus(1);
            }
            this.testingForm.addMessage("PduResponseSent: " + resp.getName(), resp.toString());
        }
        return resp;
    }

    public void firePduRequestExpired(PduRequest pduRequest) {
        this.testingForm.addMessage("PduRequestExpired: " + pduRequest.getName(), pduRequest.toString());
    }

    public void fireExpectedPduResponseReceived(PduAsyncResponse pduAsyncResponse) {
        this.testingForm.responsesRcvd.incrementAndGet();
        if (this.testingForm.timer == null) {
            this.testingForm.addMessage("Response=" + pduAsyncResponse.getResponse().getName(), "Req: " + pduAsyncResponse.getRequest().toString() + "\nResp: " + pduAsyncResponse.getResponse().toString());
        }
    }

    public void fireUnexpectedPduResponseReceived(PduResponse pduResponse) {
        this.testingForm.addMessage("UnexpectedPduResponseReceived: " + pduResponse.getName(), pduResponse.toString());
    }

    public void fireUnrecoverablePduException(UnrecoverablePduException e) {
        this.testingForm.addMessage("UnrecoverablePduException", e.toString());
        this.testingForm.doStop();
    }

    public void fireRecoverablePduException(RecoverablePduException e) {
        this.testingForm.addMessage("RecoverablePduException", e.toString());
    }

    public void fireUnknownThrowable(Throwable t) {
        if (t instanceof ClosedChannelException) {
            this.testingForm.addMessage("UnknownThrowable", "Unknown throwable received, but it was a ClosedChannelException, calling fireChannelUnexpectedlyClosed instead");
            this.fireChannelUnexpectedlyClosed();
        } else {
            this.testingForm.addMessage("UnknownThrowable", t.toString());
            this.testingForm.doStop();
        }
    }
}

