/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.smsc.tools.smppsimulator;

import com.cloudhopper.smpp.pdu.BaseSm;
import com.cloudhopper.smpp.pdu.DataSm;
import com.cloudhopper.smpp.pdu.DeliverSm;
import com.cloudhopper.smpp.pdu.Pdu;
import com.cloudhopper.smpp.pdu.SubmitSm;
import com.cloudhopper.smpp.transcoder.DefaultPduTranscoder;
import com.cloudhopper.smpp.transcoder.DefaultPduTranscoderContext;
import com.cloudhopper.smpp.transcoder.PduTranscoderContext;
import java.io.FileInputStream;
import java.io.IOException;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.mobicents.smsc.tools.smppsimulator.SmppAccepter;

public class SmppPcapParser {
    private SmppAccepter smppAccepter;
    private String fileName;
    private int port;
    private DefaultPduTranscoderContext context;
    private DefaultPduTranscoder dpt;

    public SmppPcapParser(SmppAccepter smppAccepter, String fileName, int port) {
        this.smppAccepter = smppAccepter;
        this.fileName = fileName;
        this.port = port;
        this.context = new DefaultPduTranscoderContext();
        this.dpt = new DefaultPduTranscoder((PduTranscoderContext)this.context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse() throws Exception {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(this.fileName);
            byte[] globHeader = new byte[24];
            if (fis.read(globHeader) < 24) {
                throw new Exception("Not enouph data for a global header");
            }
            int network = ((globHeader[20] & 0xFF) << 0) + ((globHeader[21] & 0xFF) << 8) + ((globHeader[22] & 0xFF) << 16) + ((globHeader[23] & 0xFF) << 24);
            int recCnt = 0;
            while (fis.available() > 0) {
                if (!this.smppAccepter.needContinue()) {
                    return;
                }
                byte[] packetHeader = new byte[16];
                if (fis.read(packetHeader) < 16) {
                    throw new Exception("Not enouph data for a packet header");
                }
                int ts_sec = (packetHeader[0] & 0xFF) + ((packetHeader[1] & 0xFF) << 8) + ((packetHeader[2] & 0xFF) << 16) + ((packetHeader[3] & 0xFF) << 24);
                int ts_usec = (packetHeader[4] & 0xFF) + ((packetHeader[5] & 0xFF) << 8) + ((packetHeader[6] & 0xFF) << 16) + ((packetHeader[7] & 0xFF) << 24);
                int incl_len = (packetHeader[8] & 0xFF) + ((packetHeader[9] & 0xFF) << 8) + ((packetHeader[10] & 0xFF) << 16) + ((packetHeader[11] & 0xFF) << 24);
                int orig_len = (packetHeader[12] & 0xFF) + ((packetHeader[13] & 0xFF) << 8) + ((packetHeader[14] & 0xFF) << 16) + ((packetHeader[15] & 0xFF) << 24);
                byte[] data = new byte[incl_len];
                if (fis.read(data) < incl_len) {
                    throw new Exception("Not enouph data for a packet data");
                }
                ++recCnt;
                this.parsePacket(data, network);
            }
        }
        finally {
            try {
                fis.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        boolean finished = false;
    }

    private void parsePacket(byte[] data, int network) throws Exception {
        switch (network) {
            case 1: {
                if (data == null || data.length < 34) {
                    return;
                }
                if (data[12] != 8 || data[13] != 0) {
                    return;
                }
                byte[] ipData = new byte[data.length - 14];
                System.arraycopy(data, 14, ipData, 0, data.length - 14);
                this.parseIpV4Packet(ipData);
            }
        }
    }

    private void parseIpV4Packet(byte[] data) throws Exception {
        int version = (data[0] & 0xF0) >> 4;
        int ipHeaderLen = (data[0] & 0xF) * 4;
        if (version != 4) {
            return;
        }
        int ipProtocolId = data[9] & 0xFF;
        if (ipProtocolId != 6) {
            return;
        }
        int startTcpBlock = ipHeaderLen;
        int sourcePort = ((data[startTcpBlock + 0] & 0xFF) << 8) + (data[startTcpBlock + 1] & 0xFF);
        int destPort = ((data[startTcpBlock + 2] & 0xFF) << 8) + (data[startTcpBlock + 3] & 0xFF);
        if (sourcePort != this.port && destPort != this.port) {
            return;
        }
        int tcpHeaderLen = ((data[startTcpBlock + 12] & 0xF0) >> 4) * 4;
        byte[] tcpData = new byte[data.length - ipHeaderLen - tcpHeaderLen];
        System.arraycopy(data, ipHeaderLen + tcpHeaderLen, tcpData, 0, tcpData.length);
        if (tcpData.length >= 16) {
            while (true) {
                int len;
                if (tcpData.length < (len = ((tcpData[0] & 0xFF) << 24) + ((tcpData[1] & 0xFF) << 16) + ((tcpData[2] & 0xFF) << 8) + (tcpData[3] & 0xFF))) {
                    return;
                }
                byte[] smppPacket = new byte[len];
                System.arraycopy(tcpData, 0, smppPacket, 0, len);
                this.parseSmppPacket(smppPacket);
                if (tcpData.length - len < 16) {
                    return;
                }
                byte[] newTcpData = new byte[tcpData.length - len];
                System.arraycopy(tcpData, len, newTcpData, 0, newTcpData.length);
                tcpData = newTcpData;
            }
        }
    }

    private void parseSmppPacket(byte[] data) throws Exception {
        ChannelBuffer buffer = ChannelBuffers.wrappedBuffer((byte[])data);
        try {
            Pdu pdu = this.dpt.decode(buffer);
            if (pdu instanceof SubmitSm) {
                SubmitSm submitPdu = (SubmitSm)pdu;
                this.smppAccepter.onNewSmppRequest((BaseSm)submitPdu);
            } else if (pdu instanceof DataSm) {
                DataSm dataPdu = (DataSm)pdu;
                this.smppAccepter.onNewSmppRequest((BaseSm)dataPdu);
            } else if (pdu instanceof DeliverSm) {
                DeliverSm deliverPdu = (DeliverSm)pdu;
                this.smppAccepter.onNewSmppRequest((BaseSm)deliverPdu);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

