/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.smsc.tools.smppsimulator;

import com.cloudhopper.smpp.SmppBindType;
import com.cloudhopper.smpp.SmppSession;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.mobicents.smsc.tools.smppsimulator.SmppSimulatorParameters;

public class SmppParametersForm
extends JDialog {
    private static final long serialVersionUID = -8945615083883278369L;
    private SmppSimulatorParameters data;
    private JTextField tbWindowSize;
    private JComboBox<SmppBindType> cbBindType;
    private JComboBox<SmppSession.Type> cbSmppSessionType;
    private JTextField tbHost;
    private JTextField tbPort;
    private JTextField tbConnectTimeout;
    private JTextField tbSystemId;
    private JTextField tbPassword;
    private JTextField tbRequestExpiryTimeout;
    private JTextField tbWindowMonitorInterval;
    private JCheckBox cbRejectIncomingDeliveryMessage;
    private JTextField tbAddressRange;

    public SmppParametersForm(JFrame owner) {
        super((Frame)owner, true);
        this.setTitle("SMPP general parameters");
        this.setResizable(false);
        this.setDefaultCloseOperation(2);
        this.setBounds(100, 100, 620, 451);
        JPanel panel = new JPanel();
        this.getContentPane().add((Component)panel, "Center");
        panel.setLayout(null);
        JLabel lblSmppWindowSize = new JLabel("<html>SMPP window size. The maximum number of requests \r\n<br>permitted to be outstanding (unacknowledged) at a given time\r\n</html>");
        lblSmppWindowSize.setBounds(10, 225, 401, 33);
        panel.add(lblSmppWindowSize);
        this.tbWindowSize = new JTextField();
        this.tbWindowSize.setBounds(424, 224, 86, 20);
        panel.add(this.tbWindowSize);
        this.tbWindowSize.setColumns(10);
        JButton btCancel = new JButton("Cancel");
        btCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SmppParametersForm.this.doCancel();
            }
        });
        btCancel.setBounds(466, 382, 136, 23);
        panel.add(btCancel);
        JButton btOK = new JButton("OK");
        btOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SmppParametersForm.this.doOK();
            }
        });
        btOK.setBounds(325, 382, 136, 23);
        panel.add(btOK);
        JLabel lblSmppBindType = new JLabel("SMPP bind type");
        lblSmppBindType.setBounds(10, 129, 401, 14);
        panel.add(lblSmppBindType);
        this.cbBindType = new JComboBox();
        this.cbBindType.setBounds(424, 126, 180, 20);
        panel.add(this.cbBindType);
        JLabel lblSmscHost = new JLabel("SMSC host");
        lblSmscHost.setBounds(10, 70, 401, 14);
        panel.add(lblSmscHost);
        JLabel lblSmscPort = new JLabel("SMSC port (for client mode), local port (for server mode)");
        lblSmscPort.setBounds(10, 101, 401, 14);
        panel.add(lblSmscPort);
        this.tbHost = new JTextField();
        this.tbHost.setColumns(10);
        this.tbHost.setBounds(424, 67, 180, 20);
        panel.add(this.tbHost);
        this.tbPort = new JTextField();
        this.tbPort.setColumns(10);
        this.tbPort.setBounds(424, 98, 86, 20);
        panel.add(this.tbPort);
        JLabel lblConnecttimeoutmilliseconds = new JLabel("ConnectTimeout (milliseconds)");
        lblConnecttimeoutmilliseconds.setBounds(10, 265, 401, 14);
        panel.add(lblConnecttimeoutmilliseconds);
        this.tbConnectTimeout = new JTextField();
        this.tbConnectTimeout.setColumns(10);
        this.tbConnectTimeout.setBounds(424, 262, 86, 20);
        panel.add(this.tbConnectTimeout);
        JLabel lblSystemid = new JLabel("SystemId");
        lblSystemid.setBounds(10, 14, 401, 14);
        panel.add(lblSystemid);
        this.tbSystemId = new JTextField();
        this.tbSystemId.setColumns(10);
        this.tbSystemId.setBounds(424, 11, 180, 20);
        panel.add(this.tbSystemId);
        JLabel lblPassword = new JLabel("Password");
        lblPassword.setBounds(10, 42, 401, 14);
        panel.add(lblPassword);
        this.tbPassword = new JTextField();
        this.tbPassword.setColumns(10);
        this.tbPassword.setBounds(424, 39, 180, 20);
        panel.add(this.tbPassword);
        JLabel lblRequestexpirytimeoutmilliseconds = new JLabel("RequestExpiryTimeout (milliseconds)");
        lblRequestexpirytimeoutmilliseconds.setBounds(10, 293, 401, 14);
        panel.add(lblRequestexpirytimeoutmilliseconds);
        this.tbRequestExpiryTimeout = new JTextField();
        this.tbRequestExpiryTimeout.setColumns(10);
        this.tbRequestExpiryTimeout.setBounds(424, 290, 86, 20);
        panel.add(this.tbRequestExpiryTimeout);
        JLabel lblWindowmonitorintervalmilliseconds = new JLabel("WindowMonitorInterval (milliseconds)");
        lblWindowmonitorintervalmilliseconds.setBounds(10, 321, 401, 14);
        panel.add(lblWindowmonitorintervalmilliseconds);
        this.tbWindowMonitorInterval = new JTextField();
        this.tbWindowMonitorInterval.setColumns(10);
        this.tbWindowMonitorInterval.setBounds(424, 318, 86, 20);
        panel.add(this.tbWindowMonitorInterval);
        this.cbRejectIncomingDeliveryMessage = new JCheckBox("Rejecting of incoming SMPP delivery messages");
        this.cbRejectIncomingDeliveryMessage.setBounds(10, 344, 524, 25);
        panel.add(this.cbRejectIncomingDeliveryMessage);
        JLabel lblSmppRole = new JLabel("Smpp session type");
        lblSmppRole.setBounds(10, 155, 401, 14);
        panel.add(lblSmppRole);
        this.cbSmppSessionType = new JComboBox();
        this.cbSmppSessionType.setBounds(424, 152, 180, 20);
        panel.add(this.cbSmppSessionType);
        JLabel lblEsmeaddressrangeField = new JLabel("Esme \"address_range\" field");
        lblEsmeaddressrangeField.setBounds(10, 181, 401, 14);
        panel.add(lblEsmeaddressrangeField);
        this.tbAddressRange = new JTextField();
        this.tbAddressRange.setColumns(10);
        this.tbAddressRange.setBounds(424, 178, 180, 20);
        panel.add(this.tbAddressRange);
    }

    public void setData(SmppSimulatorParameters data) {
        this.data = data;
        this.tbWindowSize.setText(Integer.valueOf(data.getWindowSize()).toString());
        this.tbHost.setText(data.getHost());
        this.tbPort.setText(Integer.valueOf(data.getPort()).toString());
        this.tbSystemId.setText(data.getSystemId());
        this.tbPassword.setText(data.getPassword());
        this.tbConnectTimeout.setText(Long.valueOf(data.getConnectTimeout()).toString());
        this.tbRequestExpiryTimeout.setText(Long.valueOf(data.getRequestExpiryTimeout()).toString());
        this.tbWindowMonitorInterval.setText(Long.valueOf(data.getWindowMonitorInterval()).toString());
        this.tbAddressRange.setText(data.getAddressRange());
        this.cbBindType.removeAllItems();
        SmppBindType[] vall = SmppBindType.values();
        SmppBindType dv = null;
        for (SmppBindType v : vall) {
            this.cbBindType.addItem(v);
            if (v != data.getBindType()) continue;
            dv = v;
        }
        if (dv != null) {
            this.cbBindType.setSelectedItem(dv);
        }
        this.cbSmppSessionType.removeAllItems();
        SmppSession.Type[] vall2 = SmppSession.Type.values();
        SmppSession.Type dv2 = null;
        for (SmppSession.Type v : vall2) {
            this.cbSmppSessionType.addItem(v);
            if (v != data.getSmppSessionType()) continue;
            dv2 = v;
        }
        if (dv2 != null) {
            this.cbSmppSessionType.setSelectedItem(dv2);
        }
        this.cbRejectIncomingDeliveryMessage.setSelected(this.data.isRejectIncomingDeliveryMessage());
    }

    public SmppSimulatorParameters getData() {
        return this.data;
    }

    private void doOK() {
        this.data.setHost(this.tbHost.getText());
        this.data.setSystemId(this.tbSystemId.getText());
        this.data.setPassword(this.tbPassword.getText());
        int intVal = 0;
        try {
            intVal = Integer.parseInt(this.tbWindowSize.getText());
            this.data.setWindowSize(intVal);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Exception when parsing WindowSize value: " + e.toString());
            return;
        }
        try {
            intVal = Integer.parseInt(this.tbPort.getText());
            this.data.setPort(intVal);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Exception when parsing Port value: " + e.toString());
            return;
        }
        long longVal = 0L;
        try {
            longVal = Long.parseLong(this.tbConnectTimeout.getText());
            this.data.setConnectTimeout(longVal);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Exception when parsing ConnectTimeout value: " + e.toString());
            return;
        }
        try {
            longVal = Long.parseLong(this.tbRequestExpiryTimeout.getText());
            this.data.setRequestExpiryTimeout(longVal);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Exception when parsing RequestExpiryTimeout value: " + e.toString());
            return;
        }
        try {
            longVal = Long.parseLong(this.tbWindowMonitorInterval.getText());
            this.data.setWindowMonitorInterval(longVal);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Exception when parsing WindowMonitorInterval value: " + e.toString());
            return;
        }
        this.data.setBindType((SmppBindType)this.cbBindType.getSelectedItem());
        this.data.setSmppSessionType((SmppSession.Type)this.cbSmppSessionType.getSelectedItem());
        this.data.setRejectIncomingDeliveryMessage(this.cbRejectIncomingDeliveryMessage.isSelected());
        this.data.setAddressRange(this.tbAddressRange.getText());
        this.dispose();
    }

    private void doCancel() {
        this.data = null;
        this.dispose();
    }
}

