/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.smsc.tools.smppsimulator;

import com.cloudhopper.smpp.SmppServerHandler;
import com.cloudhopper.smpp.SmppServerSession;
import com.cloudhopper.smpp.SmppSession;
import com.cloudhopper.smpp.SmppSessionConfiguration;
import com.cloudhopper.smpp.SmppSessionHandler;
import com.cloudhopper.smpp.pdu.BaseBind;
import com.cloudhopper.smpp.pdu.BaseBindResp;
import com.cloudhopper.smpp.type.SmppProcessingException;
import org.mobicents.smsc.tools.smppsimulator.ClientSmppSessionHandler;
import org.mobicents.smsc.tools.smppsimulator.SmppTestingForm;

public class DefaultSmppServerHandler
implements SmppServerHandler {
    SmppTestingForm frm;

    public DefaultSmppServerHandler(SmppTestingForm frm) {
        this.frm = frm;
    }

    public void sessionBindRequested(Long sessionId, SmppSessionConfiguration sessionConfiguration, BaseBind bindRequest) throws SmppProcessingException {
        if (this.frm.getSmppSession() != null) {
            throw new SmppProcessingException(4);
        }
        sessionConfiguration.setName("Test SMPP session");
    }

    public void sessionCreated(Long sessionId, SmppServerSession session, BaseBindResp preparedBindResponse) throws SmppProcessingException {
        if (this.frm.getSmppSession() != null) {
            throw new SmppProcessingException(4);
        }
        this.frm.addMessage("Session created", session.getConfiguration().getSystemId());
        this.frm.setSmppSession((SmppSession)session);
        session.serverReady((SmppSessionHandler)new ClientSmppSessionHandler(this.frm));
    }

    public void sessionDestroyed(Long sessionId, SmppServerSession session) {
        this.frm.addMessage("Session destroyed", session.getConfiguration().getSystemId());
        this.frm.setSmppSession(null);
        session.destroy();
    }
}

