/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.smsc.tools.smppsimulator.testsmpp;

import com.cloudhopper.commons.util.windowing.DuplicateKeyException;
import com.cloudhopper.commons.util.windowing.OfferTimeoutException;
import com.cloudhopper.commons.util.windowing.WindowFuture;
import com.cloudhopper.smpp.SmppSession;
import com.cloudhopper.smpp.SmppSessionConfiguration;
import com.cloudhopper.smpp.SmppSessionHandler;
import com.cloudhopper.smpp.SmppSessionListener;
import com.cloudhopper.smpp.impl.DefaultSmppSession;
import com.cloudhopper.smpp.pdu.Pdu;
import com.cloudhopper.smpp.pdu.PduRequest;
import com.cloudhopper.smpp.pdu.PduResponse;
import com.cloudhopper.smpp.pdu.SubmitSm;
import com.cloudhopper.smpp.pdu.SubmitSmResp;
import com.cloudhopper.smpp.transcoder.PduTranscoder;
import com.cloudhopper.smpp.type.RecoverablePduException;
import com.cloudhopper.smpp.type.SmppChannelException;
import com.cloudhopper.smpp.type.SmppTimeoutException;
import com.cloudhopper.smpp.type.UnrecoverablePduException;
import java.util.concurrent.ScheduledExecutorService;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFuture;
import org.mobicents.smsc.tools.smppsimulator.testsmpp.TestPduTranscoder;

public class TestSmppSession
extends DefaultSmppSession {
    SmppSessionHandler sessionHandler;
    TestPduTranscoder testPduTranscoder = new TestPduTranscoder();
    boolean malformedPacket = false;

    public TestSmppSession(SmppSession.Type localType, SmppSessionConfiguration configuration, Channel channel, SmppSessionHandler sessionHandler, ScheduledExecutorService monitorExecutor) {
        super(localType, configuration, channel, sessionHandler, monitorExecutor);
        this.sessionHandler = sessionHandler;
    }

    public void setMalformedPacket() {
        this.malformedPacket = true;
    }

    protected PduTranscoder getTranscoder() {
        return super.getTranscoder();
    }

    public SubmitSmResp submit(SubmitSm request, long timeoutMillis) throws RecoverablePduException, UnrecoverablePduException, SmppTimeoutException, SmppChannelException, InterruptedException {
        return super.submit(request, timeoutMillis);
    }

    public WindowFuture<Integer, PduRequest, PduResponse> sendRequestPdu(PduRequest pdu, long timeoutMillis, boolean synchronous) throws RecoverablePduException, UnrecoverablePduException, SmppTimeoutException, SmppChannelException, InterruptedException {
        ChannelFuture channelFuture;
        ChannelBuffer buffer;
        if (!pdu.hasSequenceNumberAssigned()) {
            pdu.setSequenceNumber(this.getSequenceNumber().next());
        }
        if (this.malformedPacket) {
            this.malformedPacket = false;
            buffer = this.testPduTranscoder.encode((Pdu)pdu);
        } else {
            buffer = this.getTranscoder().encode((Pdu)pdu);
        }
        WindowFuture future = null;
        try {
            future = this.getSendWindow().offer((Object)pdu.getSequenceNumber(), (Object)pdu, timeoutMillis, this.getConfiguration().getRequestExpiryTimeout(), synchronous);
        }
        catch (DuplicateKeyException e) {
            throw new UnrecoverablePduException(e.getMessage(), (Throwable)e);
        }
        catch (OfferTimeoutException e) {
            throw new SmppTimeoutException(e.getMessage(), (Throwable)e);
        }
        if (this.sessionHandler instanceof SmppSessionListener && !((SmppSessionListener)this.sessionHandler).firePduDispatch((Pdu)pdu)) {
            future.cancel();
            return future;
        }
        if (!this.getConfiguration().getLoggingOptions().isLogPduEnabled() || synchronous) {
            // empty if block
        }
        if (!(channelFuture = this.getChannel().write((Object)buffer).await()).isSuccess()) {
            throw new SmppChannelException(channelFuture.getCause().getMessage(), channelFuture.getCause());
        }
        return future;
    }
}

