/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.smsc.tools.smppsimulator;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.apache.log4j.BasicConfigurator;
import org.mobicents.smsc.tools.smppsimulator.SmppParametersForm;
import org.mobicents.smsc.tools.smppsimulator.SmppSimulatorParameters;
import org.mobicents.smsc.tools.smppsimulator.SmppTestingForm;

public class SmppSimulatorForm {
    protected JFrame frmSmppSimulator;
    private static SmppSimulatorParameters initPar = null;
    private SmppSimulatorParameters par;
    private SmppTestingForm testingForm;
    private JButton btnConfigure;
    private JButton btnRun;

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    SmppSimulatorForm window = new SmppSimulatorForm();
                    window.frmSmppSimulator.setVisible(true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private static void setupLog4j() {
        BasicConfigurator.configure();
    }

    public SmppSimulatorForm() {
        this.initialize();
        SmppSimulatorForm.setupLog4j();
        Object par = null;
        try {
            BufferedInputStream bis = new BufferedInputStream(new FileInputStream("SmppSimulatorParameters.xml"));
            XMLDecoder d = new XMLDecoder(bis);
            initPar = (SmppSimulatorParameters)d.readObject();
            d.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (par == null) {
            this.par = new SmppSimulatorParameters();
        }
    }

    private void initialize() {
        this.frmSmppSimulator = new JFrame();
        this.frmSmppSimulator.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent arg0) {
                if (SmppSimulatorForm.this.frmSmppSimulator.getDefaultCloseOperation() == 0) {
                    JOptionPane.showMessageDialog(SmppSimulatorForm.this.getJFrame(), "Before exiting you must close a test window form");
                }
            }
        });
        this.frmSmppSimulator.setResizable(false);
        this.frmSmppSimulator.setTitle("SMPP Simulator");
        this.frmSmppSimulator.setBounds(100, 100, 510, 299);
        this.frmSmppSimulator.setDefaultCloseOperation(3);
        JPanel panel = new JPanel();
        this.frmSmppSimulator.getContentPane().add((Component)panel, "Center");
        panel.setLayout(null);
        this.btnConfigure = new JButton("Configure");
        this.btnConfigure.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                SmppParametersForm frame = new SmppParametersForm(SmppSimulatorForm.this.getJFrame());
                frame.setData(SmppSimulatorForm.this.par);
                frame.setVisible(true);
                SmppSimulatorParameters newPar = frame.getData();
                if (newPar != null) {
                    SmppSimulatorForm.this.par = newPar;
                    try {
                        BufferedOutputStream bis = new BufferedOutputStream(new FileOutputStream("SmppSimulatorParameters.xml"));
                        XMLEncoder d = new XMLEncoder(bis);
                        d.writeObject(newPar);
                        d.close();
                    }
                    catch (Exception ee) {
                        ee.printStackTrace();
                        JOptionPane.showMessageDialog(null, "Failed when saving the parameter file SmppSimulatorParameters.xml: " + ee.getMessage());
                    }
                }
            }
        });
        this.btnConfigure.setBounds(10, 25, 183, 23);
        panel.add(this.btnConfigure);
        this.btnRun = new JButton("Run test");
        this.btnRun.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                SmppSimulatorForm.this.runTest();
            }
        });
        this.btnRun.setBounds(10, 59, 183, 23);
        panel.add(this.btnRun);
    }

    public JFrame getJFrame() {
        return this.frmSmppSimulator;
    }

    private void enableButtons(boolean enable) {
        this.btnConfigure.setEnabled(enable);
        this.btnRun.setEnabled(enable);
    }

    private void runTest() {
        SmppTestingForm dlg = new SmppTestingForm(this.getJFrame());
        this.enableButtons(false);
        this.frmSmppSimulator.setDefaultCloseOperation(0);
        this.testingForm = dlg;
        dlg.setData(this, this.par);
        dlg.setVisible(true);
    }

    public void testingFormClose() {
        this.testingForm = null;
        this.enableButtons(true);
        this.frmSmppSimulator.setDefaultCloseOperation(3);
    }
}

