/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.smsc.tools.smppsimulator.testsmpp;

import com.cloudhopper.smpp.SmppSession;
import com.cloudhopper.smpp.SmppSessionConfiguration;
import com.cloudhopper.smpp.SmppSessionHandler;
import com.cloudhopper.smpp.channel.SmppSessionLogger;
import com.cloudhopper.smpp.channel.SmppSessionPduDecoder;
import com.cloudhopper.smpp.channel.SmppSessionThreadRenamer;
import com.cloudhopper.smpp.channel.SmppSessionWrapper;
import com.cloudhopper.smpp.impl.DefaultSmppClient;
import com.cloudhopper.smpp.impl.DefaultSmppSession;
import com.cloudhopper.smpp.impl.SmppSessionChannelListener;
import com.cloudhopper.smpp.ssl.SslConfiguration;
import com.cloudhopper.smpp.ssl.SslContextFactory;
import com.cloudhopper.smpp.type.SmppChannelConnectException;
import com.cloudhopper.smpp.type.SmppChannelException;
import com.cloudhopper.smpp.type.SmppTimeoutException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLEngine;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.handler.ssl.SslHandler;
import org.jboss.netty.handler.timeout.WriteTimeoutHandler;
import org.jboss.netty.util.HashedWheelTimer;
import org.jboss.netty.util.Timer;
import org.mobicents.smsc.tools.smppsimulator.testsmpp.TestSmppSession;

public class TestSmppClient
extends DefaultSmppClient {
    ScheduledExecutorService monitorExecutor;

    public TestSmppClient(ExecutorService executors, int expectedSessions, ScheduledExecutorService monitorExecutor) {
        super(executors, expectedSessions, monitorExecutor);
        this.monitorExecutor = monitorExecutor;
    }

    protected DefaultSmppSession createSession(Channel channel, SmppSessionConfiguration config, SmppSessionHandler sessionHandler) throws SmppTimeoutException, SmppChannelException, InterruptedException {
        TestSmppSession session = new TestSmppSession(SmppSession.Type.CLIENT, config, channel, sessionHandler, this.monitorExecutor);
        if (config.isUseSsl()) {
            SslConfiguration sslConfig = config.getSslConfiguration();
            if (sslConfig == null) {
                throw new IllegalStateException("sslConfiguration must be set");
            }
            try {
                SslContextFactory factory = new SslContextFactory(sslConfig);
                SSLEngine sslEngine = factory.newSslEngine();
                sslEngine.setUseClientMode(true);
                channel.getPipeline().addLast("smppSessionSSL", (ChannelHandler)new SslHandler(sslEngine));
            }
            catch (Exception e) {
                throw new SmppChannelConnectException("Unable to create SSL session]: " + e.getMessage(), (Throwable)e);
            }
        }
        if (config.getName() != null) {
            channel.getPipeline().addLast("smppSessionThreadRenamer", (ChannelHandler)new SmppSessionThreadRenamer(config.getName()));
        }
        SmppSessionLogger loggingHandler = new SmppSessionLogger(DefaultSmppSession.class.getCanonicalName(), config.getLoggingOptions());
        channel.getPipeline().addLast("smppSessionLogger", (ChannelHandler)loggingHandler);
        if (config.getWriteTimeout() > 0L) {
            WriteTimeoutHandler writeTimeoutHandler = new WriteTimeoutHandler((Timer)new HashedWheelTimer(), config.getWriteTimeout(), TimeUnit.MILLISECONDS);
            channel.getPipeline().addLast("smppSessionWriteTimeout", (ChannelHandler)writeTimeoutHandler);
        }
        channel.getPipeline().addLast("smppSessionPduDecoder", (ChannelHandler)new SmppSessionPduDecoder(session.getTranscoder()));
        channel.getPipeline().addLast("smppSessionWrapper", (ChannelHandler)new SmppSessionWrapper((SmppSessionChannelListener)session));
        return session;
    }
}

