/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.smsc.tools.smppsimulator;

import com.cloudhopper.commons.util.ByteArrayUtil;
import com.cloudhopper.smpp.tlv.Tlv;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.mobicents.smsc.tools.smppsimulator.SmppSimulatorParameters;
import org.restcomm.smpp.parameter.TlvSet;

public class SmppMessageParamForm
extends JDialog {
    private static final long serialVersionUID = -7694148495845105185L;
    private SmppSimulatorParameters data;
    private JTextArea tbMessage;
    private JComboBox<SmppSimulatorParameters.EncodingType> cbEncodingType;
    private JComboBox<SmppSimulatorParameters.SplittingType> cbSplittingType;
    private JComboBox<SmppSimulatorParameters.TON> cbSrcTON;
    private JComboBox<SmppSimulatorParameters.NPI> cbSrcNPI;
    private JTextField tbSourceAddress;
    private JTextField tbDestAddress;
    private JComboBox<SmppSimulatorParameters.TON> cbDestTON;
    private JComboBox<SmppSimulatorParameters.NPI> cbDestNPI;
    private JComboBox<SmppSimulatorParameters.ValidityType> cbValidityType;
    private JTextField tbBulkDestAddressRangeStart;
    private JTextField tbBulkDestAddressRangeEnd;
    private JTextField tbBulkMessagePerSecond;
    private JComboBox<SmppSimulatorParameters.SendingMessageType> cbSendingMessageType;
    private JComboBox<SmppSimulatorParameters.MCDeliveryReceipt> cbMcDeliveryReceipt;
    private JRadioButton rbUtf8;
    private JRadioButton rbUnicode;
    private JRadioButton rbGsm7;
    private JRadioButton rbClass0;
    private JRadioButton rbClass1;
    private JRadioButton rbClass2;
    private JRadioButton rbClass3;
    private JRadioButton rbClassNo;
    private JComboBox<SmppSimulatorParameters.MessagingMode> cbMessagingMode;
    private final ButtonGroup buttonGroup = new ButtonGroup();
    private JTextField tbSubmitMultiMessageCnt;
    private JTextField tbSegmentLength;
    private final ButtonGroup buttonGroup_1 = new ButtonGroup();
    private JCheckBox cbRejectIncomingDeliveryMessage;
    private JRadioButton rbDR_No;
    private JRadioButton rbDR_Success;
    private JRadioButton rbDR_Error8;
    private JCheckBox cbDRAfter2Min;
    private JCheckBox cbIdResponseTlv;
    private JCheckBox cbIdResponseTlvMessageState;
    private JCheckBox cbWrongMessageIdInDlr;
    private JCheckBox cbAddMessageIdIntoDeliverySmResp;
    private final ButtonGroup buttonGroup_2 = new ButtonGroup();
    private JCheckBox cbSendOptionalParameter;
    private TlvSet tlvSet;
    private JTextField tbTlvTagValue;
    private JTextField tbTlvValue;

    public SmppMessageParamForm(JDialog owner) {
        super((Dialog)owner, true);
        this.setTitle("SMPP message parameters");
        this.setResizable(false);
        this.setDefaultCloseOperation(2);
        this.setBounds(100, 100, 677, 727);
        JPanel panel = new JPanel();
        this.getContentPane().add((Component)panel, "Center");
        panel.setLayout(null);
        JButton button = new JButton("OK");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                SmppMessageParamForm.this.doOK();
            }
        });
        button.setBounds(385, 661, 136, 23);
        panel.add(button);
        JButton button_1 = new JButton("Cancel");
        button_1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SmppMessageParamForm.this.doCancel();
            }
        });
        button_1.setBounds(526, 661, 136, 23);
        panel.add(button_1);
        JTabbedPane tabbedPane = new JTabbedPane(1);
        tabbedPane.setBounds(10, 0, 652, 650);
        panel.add(tabbedPane);
        JPanel panel_main = new JPanel();
        tabbedPane.addTab("General", null, panel_main, null);
        panel_main.setLayout(null);
        JLabel lblMessageText = new JLabel("Message text");
        lblMessageText.setBounds(10, 11, 401, 14);
        panel_main.add(lblMessageText);
        this.tbMessage = new JTextArea();
        this.tbMessage.setBounds(10, 39, 594, 56);
        JScrollPane scrollPane = new JScrollPane(this.tbMessage);
        scrollPane.setBounds(10, 33, 604, 58);
        panel_main.add(scrollPane);
        JLabel lblTextEncodingType = new JLabel("Data coding scheme (DCS)");
        lblTextEncodingType.setBounds(10, 105, 329, 14);
        panel_main.add(lblTextEncodingType);
        this.cbEncodingType = new JComboBox();
        this.cbEncodingType.setBounds(349, 102, 255, 20);
        panel_main.add(this.cbEncodingType);
        JLabel lblMessageSplittingType = new JLabel("Message splitting type");
        lblMessageSplittingType.setBounds(10, 198, 283, 14);
        panel_main.add(lblMessageSplittingType);
        JLabel lblTypeOfNumber = new JLabel("Source address: Type of number");
        lblTypeOfNumber.setBounds(10, 257, 329, 14);
        panel_main.add(lblTypeOfNumber);
        JLabel lblNumberingPlanIndicator = new JLabel("Source address: Numbering plan indicator");
        lblNumberingPlanIndicator.setBounds(10, 285, 329, 14);
        panel_main.add(lblNumberingPlanIndicator);
        JLabel lblDestinationAddressType = new JLabel("Destination address: Type of number");
        lblDestinationAddressType.setBounds(10, 315, 329, 14);
        panel_main.add(lblDestinationAddressType);
        JLabel lblDestinationAddressNumbering = new JLabel("Destination address: Numbering plan indicator");
        lblDestinationAddressNumbering.setBounds(10, 343, 329, 14);
        panel_main.add(lblDestinationAddressNumbering);
        this.cbDestNPI = new JComboBox();
        this.cbDestNPI.setBounds(349, 340, 255, 20);
        panel_main.add(this.cbDestNPI);
        this.cbDestTON = new JComboBox();
        this.cbDestTON.setBounds(349, 312, 255, 20);
        panel_main.add(this.cbDestTON);
        this.cbSrcNPI = new JComboBox();
        this.cbSrcNPI.setBounds(349, 282, 255, 20);
        panel_main.add(this.cbSrcNPI);
        this.cbSrcTON = new JComboBox();
        this.cbSrcTON.setBounds(349, 254, 255, 20);
        panel_main.add(this.cbSrcTON);
        this.cbSplittingType = new JComboBox();
        this.cbSplittingType.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                SmppSimulatorParameters.SplittingType st = (SmppSimulatorParameters.SplittingType)((Object)SmppMessageParamForm.this.cbSplittingType.getSelectedItem());
                if (st == SmppSimulatorParameters.SplittingType.SplitWithParameters_SpecifiedSegmentLength || st == SmppSimulatorParameters.SplittingType.SplitWithUdh_SpecifiedSegmentLength) {
                    SmppMessageParamForm.this.tbSegmentLength.setEnabled(true);
                } else {
                    SmppMessageParamForm.this.tbSegmentLength.setEnabled(false);
                }
            }
        });
        this.cbSplittingType.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                SmppSimulatorParameters.SplittingType st = (SmppSimulatorParameters.SplittingType)((Object)SmppMessageParamForm.this.cbSplittingType.getSelectedItem());
                if (st == SmppSimulatorParameters.SplittingType.SplitWithParameters_SpecifiedSegmentLength || st == SmppSimulatorParameters.SplittingType.SplitWithUdh_SpecifiedSegmentLength) {
                    SmppMessageParamForm.this.tbSegmentLength.setEnabled(true);
                } else {
                    SmppMessageParamForm.this.tbSegmentLength.setEnabled(false);
                }
            }
        });
        this.cbSplittingType.setBounds(304, 195, 300, 20);
        panel_main.add(this.cbSplittingType);
        JLabel lblEncodingTypeAt = new JLabel("Encoding type at SMPP part for (GSM7/UCS2)");
        lblEncodingTypeAt.setBounds(10, 164, 329, 14);
        panel_main.add(lblEncodingTypeAt);
        this.rbUtf8 = new JRadioButton("Utf8");
        this.buttonGroup.add(this.rbUtf8);
        this.rbUtf8.setBounds(349, 159, 73, 25);
        panel_main.add(this.rbUtf8);
        this.rbUnicode = new JRadioButton("Unicode");
        this.buttonGroup.add(this.rbUnicode);
        this.rbUnicode.setBounds(449, 159, 86, 25);
        panel_main.add(this.rbUnicode);
        this.tbSourceAddress = new JTextField();
        this.tbSourceAddress.setBounds(349, 371, 255, 20);
        panel_main.add(this.tbSourceAddress);
        this.tbSourceAddress.setColumns(10);
        this.tbDestAddress = new JTextField();
        this.tbDestAddress.setBounds(349, 401, 255, 20);
        panel_main.add(this.tbDestAddress);
        this.tbDestAddress.setColumns(10);
        JLabel lblSourceAddress = new JLabel("Source address");
        lblSourceAddress.setBounds(10, 374, 329, 14);
        panel_main.add(lblSourceAddress);
        JLabel lblDestinationAddress = new JLabel("Destination address");
        lblDestinationAddress.setBounds(10, 404, 329, 14);
        panel_main.add(lblDestinationAddress);
        JLabel lblValidityPeriod = new JLabel("Validity period / schedule delivery time");
        lblValidityPeriod.setBounds(10, 436, 329, 14);
        panel_main.add(lblValidityPeriod);
        this.cbValidityType = new JComboBox();
        this.cbValidityType.setBounds(349, 433, 255, 20);
        panel_main.add(this.cbValidityType);
        this.cbSendingMessageType = new JComboBox();
        this.cbSendingMessageType.setBounds(349, 463, 255, 20);
        panel_main.add(this.cbSendingMessageType);
        JLabel lblSendingMessageType = new JLabel("Sending message type");
        lblSendingMessageType.setBounds(10, 466, 329, 14);
        panel_main.add(lblSendingMessageType);
        JLabel lblSubmitmultimessagecnt = new JLabel("Message count for SubmitMulti message (addresses are for 0, 1, 2,... more then a \"Dest.address\")");
        lblSubmitmultimessagecnt.setBounds(10, 494, 498, 14);
        panel_main.add(lblSubmitmultimessagecnt);
        this.tbSubmitMultiMessageCnt = new JTextField();
        this.tbSubmitMultiMessageCnt.setBounds(518, 491, 86, 20);
        panel_main.add(this.tbSubmitMultiMessageCnt);
        this.tbSubmitMultiMessageCnt.setColumns(10);
        JLabel lblMcdeliveryreceiptRequestin = new JLabel("MCDeliveryReceipt request (in registered_delivery)");
        lblMcdeliveryreceiptRequestin.setBounds(10, 522, 329, 14);
        panel_main.add(lblMcdeliveryreceiptRequestin);
        this.cbMcDeliveryReceipt = new JComboBox();
        this.cbMcDeliveryReceipt.setBounds(349, 519, 255, 20);
        panel_main.add(this.cbMcDeliveryReceipt);
        this.cbMessagingMode = new JComboBox();
        this.cbMessagingMode.setBounds(349, 547, 255, 20);
        panel_main.add(this.cbMessagingMode);
        JLabel lblMessagingMode = new JLabel("Messaging mode");
        lblMessagingMode.setBounds(10, 550, 329, 14);
        panel_main.add(lblMessagingMode);
        this.tbSegmentLength = new JTextField();
        this.tbSegmentLength.setColumns(10);
        this.tbSegmentLength.setBounds(349, 223, 86, 20);
        panel_main.add(this.tbSegmentLength);
        JLabel lblSpecifiedSegmentLength = new JLabel("Specified segment length :");
        lblSpecifiedSegmentLength.setBounds(10, 223, 329, 14);
        panel_main.add(lblSpecifiedSegmentLength);
        this.rbGsm7 = new JRadioButton("Gsm7");
        this.buttonGroup.add(this.rbGsm7);
        this.rbGsm7.setBounds(537, 159, 86, 25);
        panel_main.add(this.rbGsm7);
        this.rbClass0 = new JRadioButton("Cl 0 Display");
        this.buttonGroup_1.add(this.rbClass0);
        this.rbClass0.setBounds(154, 129, 104, 23);
        panel_main.add(this.rbClass0);
        this.rbClass1 = new JRadioButton("Cl 1 Equipment");
        this.buttonGroup_1.add(this.rbClass1);
        this.rbClass1.setBounds(260, 129, 121, 23);
        panel_main.add(this.rbClass1);
        this.rbClass2 = new JRadioButton("Cl 2 SIM");
        this.buttonGroup_1.add(this.rbClass2);
        this.rbClass2.setBounds(383, 129, 86, 23);
        panel_main.add(this.rbClass2);
        this.rbClass3 = new JRadioButton("Cl 3 External Unit 1 ");
        this.buttonGroup_1.add(this.rbClass3);
        this.rbClass3.setBounds(471, 129, 143, 23);
        panel_main.add(this.rbClass3);
        JLabel lblMessageClass = new JLabel("Message class");
        lblMessageClass.setBounds(10, 134, 91, 14);
        panel_main.add(lblMessageClass);
        this.rbClassNo = new JRadioButton("No");
        this.buttonGroup_1.add(this.rbClassNo);
        this.rbClassNo.setBounds(104, 129, 45, 23);
        panel_main.add(this.rbClassNo);
        this.cbSendingMessageType.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent arg0) {
                if (SmppMessageParamForm.this.cbSendingMessageType.getSelectedItem().toString().equals(SmppSimulatorParameters.SendingMessageType.SubmitMulti.toString())) {
                    SmppMessageParamForm.this.tbSubmitMultiMessageCnt.setEnabled(true);
                } else {
                    SmppMessageParamForm.this.tbSubmitMultiMessageCnt.setEnabled(false);
                }
            }
        });
        JPanel panel_resp = new JPanel();
        tabbedPane.addTab("Response", null, panel_resp, null);
        panel_resp.setLayout(null);
        this.cbRejectIncomingDeliveryMessage = new JCheckBox("Rejecting of incoming SMPP delivery messages");
        this.cbRejectIncomingDeliveryMessage.setBounds(6, 7, 400, 23);
        panel_resp.add(this.cbRejectIncomingDeliveryMessage);
        this.rbDR_Success = new JRadioButton("Success receipt");
        this.buttonGroup_2.add(this.rbDR_Success);
        this.rbDR_Success.setBounds(119, 65, 126, 23);
        panel_resp.add(this.rbDR_Success);
        this.rbDR_Error8 = new JRadioButton("Receipt with error 8");
        this.buttonGroup_2.add(this.rbDR_Error8);
        this.rbDR_Error8.setBounds(253, 65, 146, 23);
        panel_resp.add(this.rbDR_Error8);
        JLabel lblGeneratingOfDelivery = new JLabel("Generating of delivery receipts");
        lblGeneratingOfDelivery.setBounds(6, 44, 247, 14);
        panel_resp.add(lblGeneratingOfDelivery);
        this.rbDR_No = new JRadioButton("Disabled");
        this.buttonGroup_2.add(this.rbDR_No);
        this.rbDR_No.setBounds(6, 65, 114, 23);
        panel_resp.add(this.rbDR_No);
        this.cbDRAfter2Min = new JCheckBox("Delivery receipt after 2 min");
        this.cbDRAfter2Min.setBounds(6, 99, 364, 23);
        panel_resp.add(this.cbDRAfter2Min);
        this.cbIdResponseTlv = new JCheckBox("Tlv fields usage in delivery receipt");
        this.cbIdResponseTlv.setBounds(6, 125, 364, 23);
        panel_resp.add(this.cbIdResponseTlv);
        this.cbIdResponseTlvMessageState = new JCheckBox("Tlv \"Message State\" in delivery receipt");
        this.cbIdResponseTlvMessageState.setBounds(6, 151, 364, 23);
        panel_resp.add(this.cbIdResponseTlvMessageState);
        this.cbWrongMessageIdInDlr = new JCheckBox("Wrong messageId in delivery receipt");
        this.cbWrongMessageIdInDlr.setBounds(6, 177, 364, 23);
        panel_resp.add(this.cbWrongMessageIdInDlr);
        this.cbAddMessageIdIntoDeliverySmResp = new JCheckBox("Addinng of MessageId into DeliverySmResp");
        this.cbAddMessageIdIntoDeliverySmResp.setBounds(6, 203, 364, 23);
        panel_resp.add(this.cbAddMessageIdIntoDeliverySmResp);
        JPanel panel_bulk = new JPanel();
        tabbedPane.addTab("Bulk", null, panel_bulk, null);
        panel_bulk.setLayout(null);
        JLabel lblBulkMessageSending = new JLabel("Bulk message sending options");
        lblBulkMessageSending.setBounds(10, 11, 329, 14);
        panel_bulk.add(lblBulkMessageSending);
        JLabel lblDestinationAddressRange = new JLabel("Destination address range start");
        lblDestinationAddressRange.setBounds(10, 41, 329, 14);
        panel_bulk.add(lblDestinationAddressRange);
        JLabel lblDestinationAddressRange_1 = new JLabel("Destination address range end");
        lblDestinationAddressRange_1.setBounds(10, 71, 329, 14);
        panel_bulk.add(lblDestinationAddressRange_1);
        JLabel lblBulkMessagesPer = new JLabel("Bulk messages per second");
        lblBulkMessagesPer.setBounds(10, 102, 329, 14);
        panel_bulk.add(lblBulkMessagesPer);
        this.tbBulkMessagePerSecond = new JTextField();
        this.tbBulkMessagePerSecond.setBounds(349, 99, 229, 20);
        panel_bulk.add(this.tbBulkMessagePerSecond);
        this.tbBulkMessagePerSecond.setColumns(10);
        this.tbBulkDestAddressRangeEnd = new JTextField();
        this.tbBulkDestAddressRangeEnd.setBounds(349, 68, 229, 20);
        panel_bulk.add(this.tbBulkDestAddressRangeEnd);
        this.tbBulkDestAddressRangeEnd.setColumns(10);
        this.tbBulkDestAddressRangeStart = new JTextField();
        this.tbBulkDestAddressRangeStart.setBounds(349, 38, 229, 20);
        panel_bulk.add(this.tbBulkDestAddressRangeStart);
        this.tbBulkDestAddressRangeStart.setColumns(10);
        JPanel panel_tlv = new JPanel();
        tabbedPane.addTab("Optional Parameters", null, panel_tlv, null);
        panel_tlv.setLayout(null);
        this.cbSendOptionalParameter = new JCheckBox("Sending Tlv (integer value)");
        this.cbSendOptionalParameter.setBounds(6, 7, 320, 23);
        panel_tlv.add(this.cbSendOptionalParameter);
        JLabel lblTlvTagValue = new JLabel("Tlv tag");
        lblTlvTagValue.setBounds(10, 41, 329, 14);
        panel_tlv.add(lblTlvTagValue);
        JLabel lblTlvValue = new JLabel("Tlv value");
        lblTlvValue.setBounds(10, 71, 329, 14);
        panel_tlv.add(lblTlvValue);
        this.tbTlvTagValue = new JTextField();
        this.tbTlvTagValue.setBounds(349, 38, 229, 20);
        panel_tlv.add(this.tbTlvTagValue);
        this.tbTlvTagValue.setColumns(10);
        this.tbTlvValue = new JTextField();
        this.tbTlvValue.setBounds(349, 69, 229, 20);
        panel_tlv.add(this.tbTlvValue);
        this.tbTlvValue.setColumns(10);
    }

    public void setData(SmppSimulatorParameters data) {
        this.data = data;
        this.tbMessage.setText(data.getMessageText());
        this.tbSourceAddress.setText(data.getSourceAddress());
        this.tbDestAddress.setText(data.getDestAddress());
        this.tbBulkDestAddressRangeStart.setText(Integer.valueOf(data.getBulkDestAddressRangeStart()).toString());
        this.tbBulkDestAddressRangeEnd.setText(Integer.valueOf(data.getBulkDestAddressRangeEnd()).toString());
        this.tbBulkMessagePerSecond.setText(Integer.valueOf(data.getBulkMessagePerSecond()).toString());
        this.tbSubmitMultiMessageCnt.setText(Integer.valueOf(data.getSubmitMultiMessageCnt()).toString());
        this.cbEncodingType.removeAllItems();
        SmppSimulatorParameters.EncodingType[] vallET = SmppSimulatorParameters.EncodingType.values();
        SmppSimulatorParameters.EncodingType dv = null;
        for (SmppSimulatorParameters.EncodingType v : vallET) {
            this.cbEncodingType.addItem(v);
            if (v != data.getEncodingType()) continue;
            dv = v;
        }
        if (dv != null) {
            this.cbEncodingType.setSelectedItem((Object)dv);
        }
        this.cbSplittingType.removeAllItems();
        SmppSimulatorParameters.SplittingType[] vallST = SmppSimulatorParameters.SplittingType.values();
        SmppSimulatorParameters.SplittingType dvST = null;
        for (SmppSimulatorParameters.SplittingType v : vallST) {
            this.cbSplittingType.addItem(v);
            if (v != data.getSplittingType()) continue;
            dvST = v;
        }
        if (dvST != null) {
            this.cbSplittingType.setSelectedItem((Object)dvST);
        }
        this.tbSegmentLength.setText(Integer.valueOf(data.getSpecifiedSegmentLength()).toString());
        this.cbSrcTON.removeAllItems();
        SmppSimulatorParameters.TON[] vallTON = SmppSimulatorParameters.TON.values();
        SmppSimulatorParameters.TON dvTON = null;
        for (SmppSimulatorParameters.TON v : vallTON) {
            this.cbSrcTON.addItem(v);
            if (v != data.getSourceTON()) continue;
            dvTON = v;
        }
        if (dvTON != null) {
            this.cbSrcTON.setSelectedItem((Object)dvTON);
        }
        this.cbDestTON.removeAllItems();
        vallTON = SmppSimulatorParameters.TON.values();
        dvTON = null;
        for (SmppSimulatorParameters.TON v : vallTON) {
            this.cbDestTON.addItem(v);
            if (v != data.getDestTON()) continue;
            dvTON = v;
        }
        if (dvTON != null) {
            this.cbDestTON.setSelectedItem((Object)dvTON);
        }
        this.cbSrcNPI.removeAllItems();
        SmppSimulatorParameters.NPI[] vallNPI = SmppSimulatorParameters.NPI.values();
        SmppSimulatorParameters.NPI dvNPI = null;
        for (SmppSimulatorParameters.NPI v : vallNPI) {
            this.cbSrcNPI.addItem(v);
            if (v != data.getSourceNPI()) continue;
            dvNPI = v;
        }
        if (dvNPI != null) {
            this.cbSrcNPI.setSelectedItem((Object)dvNPI);
        }
        this.cbDestNPI.removeAllItems();
        vallNPI = SmppSimulatorParameters.NPI.values();
        dvNPI = null;
        for (SmppSimulatorParameters.NPI v : vallNPI) {
            this.cbDestNPI.addItem(v);
            if (v != data.getDestNPI()) continue;
            dvNPI = v;
        }
        if (dvNPI != null) {
            this.cbDestNPI.setSelectedItem((Object)dvNPI);
        }
        this.cbValidityType.removeAllItems();
        SmppSimulatorParameters.ValidityType[] vallValType = SmppSimulatorParameters.ValidityType.values();
        SmppSimulatorParameters.ValidityType dvValType = null;
        for (SmppSimulatorParameters.ValidityType v : vallValType) {
            this.cbValidityType.addItem(v);
            if (v != data.getValidityType()) continue;
            dvValType = v;
        }
        if (dvValType != null) {
            this.cbValidityType.setSelectedItem((Object)dvValType);
        }
        this.cbSendingMessageType.removeAllItems();
        SmppSimulatorParameters.SendingMessageType[] vallSendingMessageType = SmppSimulatorParameters.SendingMessageType.values();
        SmppSimulatorParameters.SendingMessageType dvSendingMessageType = null;
        for (SmppSimulatorParameters.SendingMessageType v : vallSendingMessageType) {
            this.cbSendingMessageType.addItem(v);
            if (v != data.getSendingMessageType()) continue;
            dvSendingMessageType = v;
        }
        if (dvSendingMessageType != null) {
            this.cbSendingMessageType.setSelectedItem((Object)dvSendingMessageType);
        }
        this.cbMessagingMode.removeAllItems();
        SmppSimulatorParameters.MessagingMode[] vallMessagingMode = SmppSimulatorParameters.MessagingMode.values();
        SmppSimulatorParameters.MessagingMode dvMessagingMode = null;
        for (SmppSimulatorParameters.MessagingMode v : vallMessagingMode) {
            this.cbMessagingMode.addItem(v);
            if (v != data.getMessagingMode()) continue;
            dvMessagingMode = v;
        }
        if (dvMessagingMode != null) {
            this.cbMessagingMode.setSelectedItem((Object)dvMessagingMode);
        }
        this.cbMcDeliveryReceipt.removeAllItems();
        SmppSimulatorParameters.MCDeliveryReceipt[] vallMcDeliveryReceipt = SmppSimulatorParameters.MCDeliveryReceipt.values();
        SmppSimulatorParameters.MCDeliveryReceipt dvMcDeliveryReceipt = null;
        for (SmppSimulatorParameters.MCDeliveryReceipt v : vallMcDeliveryReceipt) {
            this.cbMcDeliveryReceipt.addItem(v);
            if (v != data.getMcDeliveryReceipt()) continue;
            dvMcDeliveryReceipt = v;
        }
        if (dvMcDeliveryReceipt != null) {
            this.cbMcDeliveryReceipt.setSelectedItem((Object)dvMcDeliveryReceipt);
        }
        switch (data.betMessageClass()) {
            case 0: {
                this.rbClassNo.setSelected(true);
                break;
            }
            case 1: {
                this.rbClass0.setSelected(true);
                break;
            }
            case 2: {
                this.rbClass1.setSelected(true);
                break;
            }
            case 3: {
                this.rbClass2.setSelected(true);
                break;
            }
            case 4: {
                this.rbClass3.setSelected(true);
            }
        }
        if (data.getSmppEncoding() == 0) {
            this.rbUtf8.setSelected(true);
        } else if (data.getSmppEncoding() == 1) {
            this.rbUnicode.setSelected(true);
        } else {
            this.rbGsm7.setSelected(true);
        }
        this.cbRejectIncomingDeliveryMessage.setSelected(this.data.isRejectIncomingDeliveryMessage());
        this.cbDRAfter2Min.setSelected(this.data.isDeliveryResponseAfter2Min());
        this.cbIdResponseTlv.setSelected(this.data.isIdResponseTlv());
        this.cbIdResponseTlvMessageState.setSelected(this.data.isIdResponseTlvMessageState());
        this.cbWrongMessageIdInDlr.setSelected(this.data.isWrongMessageIdInDlr());
        this.cbAddMessageIdIntoDeliverySmResp.setSelected(this.data.isAddMessageIdIntoDeliverySmResp());
        switch (this.data.getDeliveryResponseGenerating()) {
            case No: {
                this.rbDR_No.setSelected(true);
                break;
            }
            case Success: {
                this.rbDR_Success.setSelected(true);
                break;
            }
            case Error8: {
                this.rbDR_Error8.setSelected(true);
            }
        }
        this.cbSendOptionalParameter.setSelected(this.data.isSendOptionalParameter());
        if (this.data.isSendOptionalParameter()) {
            TlvSet tlvSet = this.data.getTlvSet();
            try {
                for (Tlv tlv : tlvSet.getOptionalParameters()) {
                    this.tbTlvTagValue.setText(new Short(tlv.getTag()).toString());
                    this.tbTlvValue.setText(new Integer(tlv.getValueAsInt()).toString());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public SmppSimulatorParameters getData() {
        return this.data;
    }

    private void doOK() {
        int val;
        this.data.setMessageText(this.tbMessage.getText());
        this.data.setSourceAddress(this.tbSourceAddress.getText());
        this.data.setDestAddress(this.tbDestAddress.getText());
        try {
            val = Integer.parseInt(this.tbBulkDestAddressRangeStart.getText());
            if (val < 0) {
                throw new NumberFormatException();
            }
            this.data.setBulkDestAddressRangeStart(val);
        }
        catch (NumberFormatException e) {
            JOptionPane.showMessageDialog(this, "Error in BulkDestAddressRangeStart field - it must be digital and positive");
            return;
        }
        try {
            val = Integer.parseInt(this.tbBulkDestAddressRangeEnd.getText());
            if (val < 0) {
                throw new NumberFormatException();
            }
            this.data.setBulkDestAddressRangeEnd(val);
        }
        catch (NumberFormatException e) {
            JOptionPane.showMessageDialog(this, "Error in BulkDestAddressRangeEnd field - it must be digital and positive");
            return;
        }
        try {
            val = Integer.parseInt(this.tbBulkMessagePerSecond.getText());
            if (val < 0) {
                throw new NumberFormatException();
            }
            this.data.setBulkMessagePerSecond(val);
        }
        catch (NumberFormatException e) {
            JOptionPane.showMessageDialog(this, "Error in BulkMessagePerSecond field - it must be digital and positive");
            return;
        }
        try {
            val = Integer.parseInt(this.tbSubmitMultiMessageCnt.getText());
            if (val < 0 || val > 255) {
                throw new NumberFormatException();
            }
            this.data.setSubmitMultiMessageCnt(val);
        }
        catch (NumberFormatException e) {
            JOptionPane.showMessageDialog(this, "Error in SubmitMultiMessageCnt field - it must be digital, positive and less then 255");
            return;
        }
        try {
            val = Integer.parseInt(this.tbSegmentLength.getText());
            if (val < 0 || val > 255) {
                throw new NumberFormatException();
            }
            this.data.setSpecifiedSegmentLength(val);
        }
        catch (NumberFormatException e) {
            JOptionPane.showMessageDialog(this, "Error in SpecifiedSegmentLength field - it must be digital, positive and less then 255");
            return;
        }
        this.data.setEncodingType((SmppSimulatorParameters.EncodingType)((Object)this.cbEncodingType.getSelectedItem()));
        this.data.setSplittingType((SmppSimulatorParameters.SplittingType)((Object)this.cbSplittingType.getSelectedItem()));
        this.data.setSourceTON((SmppSimulatorParameters.TON)((Object)this.cbSrcTON.getSelectedItem()));
        this.data.setSourceNPI((SmppSimulatorParameters.NPI)((Object)this.cbSrcNPI.getSelectedItem()));
        this.data.setDestTON((SmppSimulatorParameters.TON)((Object)this.cbDestTON.getSelectedItem()));
        this.data.setDestNPI((SmppSimulatorParameters.NPI)((Object)this.cbDestNPI.getSelectedItem()));
        this.data.setValidityType((SmppSimulatorParameters.ValidityType)((Object)this.cbValidityType.getSelectedItem()));
        this.data.setSendingMessageType((SmppSimulatorParameters.SendingMessageType)((Object)this.cbSendingMessageType.getSelectedItem()));
        this.data.setMcDeliveryReceipt((SmppSimulatorParameters.MCDeliveryReceipt)((Object)this.cbMcDeliveryReceipt.getSelectedItem()));
        this.data.setMessagingMode((SmppSimulatorParameters.MessagingMode)((Object)this.cbMessagingMode.getSelectedItem()));
        if (this.rbClassNo.isSelected()) {
            this.data.setMessageClass(0);
        }
        if (this.rbClass0.isSelected()) {
            this.data.setMessageClass(1);
        }
        if (this.rbClass1.isSelected()) {
            this.data.setMessageClass(2);
        }
        if (this.rbClass2.isSelected()) {
            this.data.setMessageClass(3);
        }
        if (this.rbClass3.isSelected()) {
            this.data.setMessageClass(4);
        }
        if (this.rbUtf8.isSelected()) {
            this.data.setSmppEncoding(0);
        } else if (this.rbUnicode.isSelected()) {
            this.data.setSmppEncoding(1);
        } else {
            this.data.setSmppEncoding(2);
        }
        this.data.setRejectIncomingDeliveryMessage(this.cbRejectIncomingDeliveryMessage.isSelected());
        this.data.setDeliveryResponseAfter2Min(this.cbDRAfter2Min.isSelected());
        this.data.setIdResponseTlv(this.cbIdResponseTlv.isSelected());
        this.data.setIdResponseTlvMessageState(this.cbIdResponseTlvMessageState.isSelected());
        this.data.setWrongMessageIdInDlr(this.cbWrongMessageIdInDlr.isSelected());
        this.data.setAddMessageIdIntoDeliverySmResp(this.cbAddMessageIdIntoDeliverySmResp.isSelected());
        if (this.rbDR_No.isSelected()) {
            this.data.setDeliveryResponseGenerating(SmppSimulatorParameters.DeliveryResponseGenerating.No);
        }
        if (this.rbDR_Success.isSelected()) {
            this.data.setDeliveryResponseGenerating(SmppSimulatorParameters.DeliveryResponseGenerating.Success);
        }
        if (this.rbDR_Error8.isSelected()) {
            this.data.setDeliveryResponseGenerating(SmppSimulatorParameters.DeliveryResponseGenerating.Error8);
        }
        this.data.setSendOptionalParameter(this.cbSendOptionalParameter.isSelected());
        if (this.cbSendOptionalParameter.isSelected()) {
            this.tlvSet = new TlvSet();
            short tag = -1;
            try {
                tag = Short.parseShort(this.tbTlvTagValue.getText());
                if (tag < 0) {
                    throw new NumberFormatException();
                }
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this, "Tlv tag - it must be digital and positive");
                return;
            }
            int tlvValue = -1;
            try {
                tlvValue = Integer.parseInt(this.tbTlvValue.getText());
                if (tlvValue < 0) {
                    throw new NumberFormatException();
                }
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this, "Tlv value - it must be digital and positive");
                return;
            }
            if (tag > 0 && tlvValue > 0) {
                Tlv tlv = new Tlv(tag, ByteArrayUtil.toByteArray((int)tlvValue));
                this.tlvSet.addOptionalParameter(tlv);
            }
            this.data.setTlvSet(this.tlvSet);
        }
        this.dispose();
    }

    private void doCancel() {
        this.data = null;
        this.dispose();
    }
}

