/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.smsc.tools.smppsimulator;

import com.cloudhopper.commons.util.windowing.WindowFuture;
import com.cloudhopper.smpp.SmppServerConfiguration;
import com.cloudhopper.smpp.SmppServerHandler;
import com.cloudhopper.smpp.SmppSession;
import com.cloudhopper.smpp.SmppSessionConfiguration;
import com.cloudhopper.smpp.SmppSessionHandler;
import com.cloudhopper.smpp.impl.DefaultSmppServer;
import com.cloudhopper.smpp.pdu.BaseSm;
import com.cloudhopper.smpp.pdu.DataSm;
import com.cloudhopper.smpp.pdu.DeliverSm;
import com.cloudhopper.smpp.pdu.PduRequest;
import com.cloudhopper.smpp.pdu.SubmitMulti;
import com.cloudhopper.smpp.pdu.SubmitSm;
import com.cloudhopper.smpp.tlv.Tlv;
import com.cloudhopper.smpp.type.Address;
import com.cloudhopper.smpp.type.SmppChannelException;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.XMLEncoder;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Date;
import java.util.Random;
import java.util.TimerTask;
import java.util.Vector;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.Timer;
import javax.swing.border.LineBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.DefaultTableModel;
import org.mobicents.protocols.ss7.map.api.smstpdu.DataCodingScheme;
import org.mobicents.protocols.ss7.map.datacoding.GSMCharset;
import org.mobicents.protocols.ss7.map.datacoding.GSMCharsetEncoder;
import org.mobicents.protocols.ss7.map.datacoding.GSMCharsetEncodingData;
import org.mobicents.protocols.ss7.map.datacoding.Gsm7EncodingStyle;
import org.mobicents.protocols.ss7.map.smstpdu.DataCodingSchemeImpl;
import org.mobicents.smsc.library.MessageUtil;
import org.mobicents.smsc.tools.smppsimulator.ClientSmppSessionHandler;
import org.mobicents.smsc.tools.smppsimulator.DefaultSmppServerHandler;
import org.mobicents.smsc.tools.smppsimulator.EventForm;
import org.mobicents.smsc.tools.smppsimulator.SmppAccepter;
import org.mobicents.smsc.tools.smppsimulator.SmppMessageParamForm;
import org.mobicents.smsc.tools.smppsimulator.SmppPcapParser;
import org.mobicents.smsc.tools.smppsimulator.SmppSimulatorForm;
import org.mobicents.smsc.tools.smppsimulator.SmppSimulatorParameters;
import org.mobicents.smsc.tools.smppsimulator.TraceFileFilter;
import org.mobicents.smsc.tools.smppsimulator.testsmpp.TestSmppClient;
import org.mobicents.smsc.tools.smppsimulator.testsmpp.TestSmppSession;

public class SmppTestingForm
extends JDialog
implements SmppAccepter {
    private static final long serialVersionUID = 4969830723671541575L;
    private DefaultTableModel model = new DefaultTableModel();
    private EventForm eventForm;
    private SmppSimulatorForm mainForm;
    private SmppSimulatorParameters param;
    private JTable tNotif;
    private JButton btStart;
    private JButton btStop;
    private JButton btStartBulk;
    private JButton btStopBulk;
    private Timer tm;
    private JLabel lbState;
    private JRadioButton rbRandomBulkMessages;
    private JRadioButton rbBulkMessagesFrom;
    private JButton btPcapFileName;
    private ThreadPoolExecutor executor;
    private ScheduledThreadPoolExecutor monitorExecutor;
    private TestSmppClient clientBootstrap;
    private SmppSession session0;
    private DefaultSmppServer defaultSmppServer;
    protected java.util.Timer[] timer;
    protected AtomicInteger messagesSent = new AtomicInteger();
    protected AtomicInteger segmentsSent = new AtomicInteger();
    protected AtomicInteger responsesRcvd = new AtomicInteger();
    protected AtomicInteger messagesRcvd = new AtomicInteger();
    private static Charset utf8Charset = Charset.forName("UTF-8");
    private static Charset ucs2Charset = Charset.forName("UTF-16BE");
    private static Charset isoCharset = Charset.forName("ISO-8859-1");
    private static Charset gsm7Charset = new GSMCharset("GSM", new String[0]);
    private AtomicLong msgIdGenerator;
    private int msgRef = 0;
    private int threadCount = 10;
    private String bigMessage = "01234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789";
    private JTextField tbPcapFileName;
    private final ButtonGroup buttonGroup = new ButtonGroup();
    private JTextField tbPcapPort;
    private AtomicInteger messagesNum = new AtomicInteger();

    public SmppTestingForm(JFrame owner) {
        super((Frame)owner, true);
        this.setModal(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (SmppTestingForm.this.getDefaultCloseOperation() == 0) {
                    JOptionPane.showMessageDialog(SmppTestingForm.this.getJDialog(), "Before exiting you must Stop the testing process");
                } else {
                    SmppTestingForm.this.closingWindow();
                }
            }
        });
        this.setBounds(100, 100, 772, 677);
        JPanel panel = new JPanel();
        this.getContentPane().add((Component)panel, "Center");
        panel.setLayout(new GridLayout(0, 1, 0, 0));
        JPanel panel_1 = new JPanel();
        panel.add(panel_1);
        panel_1.setLayout(new GridLayout(1, 0, 0, 0));
        JScrollPane scrollPane = new JScrollPane(null);
        panel_1.add(scrollPane);
        this.tNotif = new JTable();
        this.tNotif.setFillsViewportHeight(true);
        this.tNotif.setBorder(new LineBorder(new Color(0, 0, 0)));
        this.tNotif.setSelectionMode(0);
        this.tNotif.setModel(new DefaultTableModel(new Object[0][], new String[]{"TimeStamp", "Message", "UserData"}){
            Class[] columnTypes;
            boolean[] columnEditables;
            {
                this.columnTypes = new Class[]{String.class, String.class, String.class};
                this.columnEditables = new boolean[]{false, false, false};
            }

            public Class getColumnClass(int columnIndex) {
                return this.columnTypes[columnIndex];
            }

            @Override
            public boolean isCellEditable(int row, int column) {
                return this.columnEditables[column];
            }
        });
        this.tNotif.getColumnModel().getColumn(0).setPreferredWidth(46);
        this.tNotif.getColumnModel().getColumn(1).setPreferredWidth(221);
        this.tNotif.getColumnModel().getColumn(2).setPreferredWidth(254);
        scrollPane.setViewportView(this.tNotif);
        this.model = (DefaultTableModel)this.tNotif.getModel();
        this.tNotif.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                if (SmppTestingForm.this.eventForm == null) {
                    return;
                }
                SmppTestingForm.this.setEventMsg();
            }
        });
        JPanel panel_2 = new JPanel();
        panel.add(panel_2);
        panel_2.setLayout(null);
        this.btStart = new JButton("Start a session");
        this.btStart.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SmppTestingForm.this.start();
            }
        });
        this.btStart.setBounds(10, 11, 141, 23);
        panel_2.add(this.btStart);
        this.btStop = new JButton("Stop a session");
        this.btStop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SmppTestingForm.this.stop();
            }
        });
        this.btStop.setEnabled(false);
        this.btStop.setBounds(158, 11, 122, 23);
        panel_2.add(this.btStop);
        JButton btRefreshState = new JButton("Refresh state");
        btRefreshState.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SmppTestingForm.this.refreshState();
            }
        });
        btRefreshState.setBounds(286, 11, 148, 23);
        panel_2.add(btRefreshState);
        JButton btOpeEventWindow = new JButton("Open event window");
        btOpeEventWindow.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SmppTestingForm.this.openEventWindow();
            }
        });
        btOpeEventWindow.setBounds(439, 11, 159, 23);
        panel_2.add(btOpeEventWindow);
        JButton btConfigSubmitData = new JButton("Configure data for a message submitting");
        btConfigSubmitData.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SmppMessageParamForm frame = new SmppMessageParamForm(SmppTestingForm.this.getJDialog());
                frame.setData(SmppTestingForm.this.param);
                frame.setVisible(true);
                SmppSimulatorParameters newPar = frame.getData();
                if (newPar != null) {
                    SmppTestingForm.this.param = newPar;
                    try {
                        BufferedOutputStream bis = new BufferedOutputStream(new FileOutputStream("SmppSimulatorParameters.xml"));
                        XMLEncoder d = new XMLEncoder(bis);
                        d.writeObject(newPar);
                        d.close();
                    }
                    catch (Exception ee) {
                        ee.printStackTrace();
                        JOptionPane.showMessageDialog(null, "Failed when saving the parameter file SmppSimulatorParameters.xml: " + ee.getMessage());
                    }
                }
            }
        });
        btConfigSubmitData.setBounds(11, 46, 341, 23);
        panel_2.add(btConfigSubmitData);
        JButton btSendMessage = new JButton("Submit a message");
        btSendMessage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SmppTestingForm.this.submitMessage(SmppTestingForm.this.param.getEncodingType(), SmppTestingForm.this.param.betMessageClass(), SmppTestingForm.this.param.getMessageText(), SmppTestingForm.this.param.getSplittingType(), SmppTestingForm.this.param.getValidityType(), SmppTestingForm.this.param.getDestAddress(), SmppTestingForm.this.param.getMessagingMode(), SmppTestingForm.this.param.getSpecifiedSegmentLength());
            }
        });
        btSendMessage.setBounds(11, 80, 341, 23);
        panel_2.add(btSendMessage);
        this.btStartBulk = new JButton("Start bulk sending");
        this.btStartBulk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                SmppTestingForm.this.startBulkSending();
            }
        });
        this.btStartBulk.setBounds(10, 172, 201, 23);
        panel_2.add(this.btStartBulk);
        this.btStopBulk = new JButton("Stop bulk sending");
        this.btStopBulk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SmppTestingForm.this.stopBulkSending();
            }
        });
        this.btStopBulk.setEnabled(false);
        this.btStopBulk.setBounds(223, 172, 211, 23);
        panel_2.add(this.btStopBulk);
        this.lbState = new JLabel("-");
        this.lbState.setBounds(14, 206, 732, 16);
        panel_2.add(this.lbState);
        this.rbRandomBulkMessages = new JRadioButton("Random bulk messages");
        this.rbRandomBulkMessages.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                SmppTestingForm.this.tbPcapFileName.setEnabled(false);
                SmppTestingForm.this.btPcapFileName.setEnabled(false);
                SmppTestingForm.this.tbPcapPort.setEnabled(false);
            }
        });
        this.buttonGroup.add(this.rbRandomBulkMessages);
        this.rbRandomBulkMessages.setSelected(true);
        this.rbRandomBulkMessages.setBounds(10, 127, 197, 23);
        panel_2.add(this.rbRandomBulkMessages);
        this.rbBulkMessagesFrom = new JRadioButton("Bulk messages from pcap file");
        this.rbBulkMessagesFrom.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                SmppTestingForm.this.tbPcapFileName.setEnabled(true);
                SmppTestingForm.this.btPcapFileName.setEnabled(true);
                SmppTestingForm.this.tbPcapPort.setEnabled(true);
            }
        });
        this.buttonGroup.add(this.rbBulkMessagesFrom);
        this.rbBulkMessagesFrom.setBounds(10, 149, 204, 23);
        panel_2.add(this.rbBulkMessagesFrom);
        this.tbPcapFileName = new JTextField();
        this.tbPcapFileName.setEnabled(false);
        this.tbPcapFileName.setBounds(251, 128, 439, 20);
        panel_2.add(this.tbPcapFileName);
        this.tbPcapFileName.setColumns(10);
        this.btPcapFileName = new JButton(". . .");
        this.btPcapFileName.setEnabled(false);
        this.btPcapFileName.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                JFileChooser chooser = new JFileChooser();
                String filterName = null;
                filterName = "Pcap";
                TraceFileFilter filter = new TraceFileFilter(filterName);
                chooser.setFileFilter(filter);
                chooser.addChoosableFileFilter(filter);
                File f = new File(SmppTestingForm.this.tbPcapFileName.getText());
                chooser.setSelectedFile(f);
                chooser.setFileSelectionMode(0);
                int returnVal = chooser.showOpenDialog(SmppTestingForm.this.getJDialog());
                if (returnVal == 0) {
                    File f2 = chooser.getSelectedFile();
                    if (f2 != null && f2.exists()) {
                        SmppTestingForm.this.tbPcapFileName.setText(f2.getPath());
                    } else {
                        JOptionPane.showMessageDialog(null, "File does not exists - try again");
                    }
                }
            }
        });
        this.btPcapFileName.setBounds(693, 127, 53, 23);
        panel_2.add(this.btPcapFileName);
        JLabel lblTcpPortFor = new JLabel("TCP Port for pcap parsing");
        lblTcpPortFor.setBounds(251, 154, 240, 14);
        panel_2.add(lblTcpPortFor);
        this.tbPcapPort = new JTextField();
        this.tbPcapPort.setText("2775");
        this.tbPcapPort.setEnabled(false);
        this.tbPcapPort.setBounds(501, 150, 86, 20);
        panel_2.add(this.tbPcapPort);
        this.tbPcapPort.setColumns(10);
        JButton btSendBadPacket = new JButton("Send Bad packet");
        btSendBadPacket.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SmppTestingForm.this.doSendBadPacket();
            }
        });
        btSendBadPacket.setBounds(509, 45, 129, 23);
        panel_2.add(btSendBadPacket);
        this.tm = new Timer(5000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SmppTestingForm.this.refreshState();
            }
        });
        this.tm.start();
        Random rn = new Random();
        this.msgIdGenerator = new AtomicLong(rn.nextInt(100000000));
    }

    public ScheduledThreadPoolExecutor getExecutor() {
        return this.monitorExecutor;
    }

    public SmppSession getSession() {
        return this.session0;
    }

    public AtomicLong getMsgIdGenerator() {
        return this.msgIdGenerator;
    }

    private void doSendBadPacket() {
        SubmitSm submitSm = new SubmitSm();
        try {
            ((TestSmppSession)this.session0).setMalformedPacket();
            this.session0.submit(submitSm, 1000L);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public SmppSimulatorParameters getSmppSimulatorParameters() {
        return this.param;
    }

    public void setSmppSession(SmppSession smppSession) {
        this.session0 = smppSession;
    }

    public SmppSession getSmppSession() {
        return this.session0;
    }

    private int getNextMsgRef() {
        ++this.msgRef;
        if (this.msgRef > 255) {
            this.msgRef = 1;
        }
        return this.msgRef;
    }

    private byte[] encodeSegment(String msg, SmppSimulatorParameters.EncodingType encodingType) {
        if (encodingType == SmppSimulatorParameters.EncodingType.GSM8_DCS_4) {
            return msg.getBytes(isoCharset);
        }
        if (this.param.getSmppEncoding() == 0) {
            return msg.getBytes(utf8Charset);
        }
        if (this.param.getSmppEncoding() == 1) {
            return msg.getBytes(ucs2Charset);
        }
        GSMCharsetEncoder encoder = (GSMCharsetEncoder)gsm7Charset.newEncoder();
        encoder.setGSMCharsetEncodingData(new GSMCharsetEncodingData(Gsm7EncodingStyle.bit8_smpp_style, null));
        ByteBuffer bb = null;
        try {
            bb = encoder.encode(CharBuffer.wrap(msg));
        }
        catch (CharacterCodingException e) {
            e.printStackTrace();
        }
        byte[] data = new byte[bb.limit()];
        bb.get(data);
        return data;
    }

    private void submitMessage(SmppSimulatorParameters.EncodingType encodingType, int messageClass, String messageText, SmppSimulatorParameters.SplittingType splittingType, SmppSimulatorParameters.ValidityType validityType, String destAddr, SmppSimulatorParameters.MessagingMode messagingMode, int specifiedSegmentLength) {
        if (this.session0 == null) {
            return;
        }
        try {
            int dcs = 0;
            ArrayList<byte[]> msgLst = new ArrayList<byte[]>();
            int msgRef = 0;
            switch (encodingType) {
                case GSM7_DCS_0: {
                    dcs = 0;
                    break;
                }
                case GSM8_DCS_4: {
                    dcs = 4;
                    break;
                }
                case UCS2_DCS_8: {
                    dcs = 8;
                }
            }
            int messageClassVal = 0;
            if (messageClass > 0) {
                messageClassVal = messageClass;
            }
            DataCodingSchemeImpl dataCodingScheme = new DataCodingSchemeImpl(dcs);
            int maxLen = MessageUtil.getMaxSolidMessageCharsLength((DataCodingScheme)dataCodingScheme);
            int maxSplLen = MessageUtil.getMaxSegmentedMessageCharsLength((DataCodingScheme)dataCodingScheme);
            if (splittingType == SmppSimulatorParameters.SplittingType.SplitWithParameters_SpecifiedSegmentLength || splittingType == SmppSimulatorParameters.SplittingType.SplitWithUdh_SpecifiedSegmentLength) {
                maxLen = specifiedSegmentLength;
                maxSplLen = specifiedSegmentLength;
            }
            int segmCnt = 0;
            int esmClass = 0;
            boolean addSegmTlv = false;
            if (messageText.length() > maxLen) {
                SmppSimulatorParameters.SplittingType st = splittingType;
                switch (st) {
                    case DoNotSplit: {
                        byte[] buf2;
                        byte[] buf1 = this.encodeSegment(messageText, encodingType);
                        if (encodingType == SmppSimulatorParameters.EncodingType.GSM8_DCS_4) {
                            byte[] bf3 = new byte[]{6, 5, 4, 62, -108, 0, 0};
                            buf2 = new byte[bf3.length + buf1.length];
                            System.arraycopy(bf3, 0, buf2, 0, bf3.length);
                            System.arraycopy(buf1, 0, buf2, bf3.length, buf1.length);
                            esmClass = 64;
                        } else {
                            buf2 = buf1;
                        }
                        msgLst.add(buf2);
                        ArrayList<String> r1 = this.splitStr(messageText, maxSplLen);
                        segmCnt = r1.size();
                        break;
                    }
                    case SplitWithParameters_DefaultSegmentLength: 
                    case SplitWithParameters_SpecifiedSegmentLength: {
                        msgRef = this.getNextMsgRef();
                        ArrayList<String> r1 = this.splitStr(messageText, maxSplLen);
                        for (String bf : r1) {
                            msgLst.add(this.encodeSegment(bf, encodingType));
                        }
                        segmCnt = msgLst.size();
                        addSegmTlv = true;
                        break;
                    }
                    case SplitWithUdh_DefaultSegmentLength: 
                    case SplitWithUdh_SpecifiedSegmentLength: {
                        msgRef = this.getNextMsgRef();
                        ArrayList<String> r1 = this.splitStr(messageText, maxSplLen);
                        byte[] bf1 = new byte[6];
                        bf1[0] = 5;
                        bf1[1] = 0;
                        bf1[2] = 3;
                        bf1[3] = (byte)msgRef;
                        bf1[4] = (byte)r1.size();
                        int i1 = 0;
                        for (String bfStr : r1) {
                            byte[] bf = this.encodeSegment(bfStr, encodingType);
                            bf1[5] = (byte)(++i1);
                            byte[] bf2 = new byte[bf1.length + bf.length];
                            System.arraycopy(bf1, 0, bf2, 0, bf1.length);
                            System.arraycopy(bf, 0, bf2, bf1.length, bf.length);
                            msgLst.add(bf2);
                        }
                        segmCnt = msgLst.size();
                        esmClass = 64;
                    }
                }
            } else {
                byte[] buf = this.encodeSegment(messageText, encodingType);
                if (encodingType == SmppSimulatorParameters.EncodingType.GSM8_DCS_4) {
                    byte[] bf1 = new byte[]{6, 5, 4, 62, -108, 0, 0};
                    byte[] bf2 = new byte[bf1.length + buf.length];
                    System.arraycopy(bf1, 0, bf2, 0, bf1.length);
                    System.arraycopy(buf, 0, bf2, bf1.length, buf.length);
                    msgLst.add(bf2);
                    esmClass = 64;
                } else {
                    msgLst.add(buf);
                }
                segmCnt = 1;
            }
            this.doSubmitMessage(dcs, msgLst, msgRef, addSegmTlv, esmClass |= messagingMode.getCode(), validityType, segmCnt, destAddr, messageClassVal);
        }
        catch (Exception e) {
            this.addMessage("Failure to submit message", e.toString());
            return;
        }
    }

    private ArrayList<String> splitStr(String buf, int maxLen) {
        ArrayList<String> res = new ArrayList<String>();
        String prevBuf = buf;
        while (true) {
            if (prevBuf.length() <= maxLen) break;
            String segm = prevBuf.substring(0, maxLen);
            String newBuf = prevBuf.substring(maxLen, prevBuf.length());
            res.add(segm);
            prevBuf = newBuf;
        }
        res.add(prevBuf);
        return res;
    }

    private void doSubmitMessage(int dcs, ArrayList<byte[]> msgLst, int msgRef, boolean addSegmTlv, int esmClass, SmppSimulatorParameters.ValidityType validityType, int segmentCnt, String destAddr, int messageClassVal) throws Exception {
        int i1 = 0;
        for (byte[] buf : msgLst) {
            Tlv tlv3;
            SubmitSm pdu;
            ++i1;
            switch (this.param.getSendingMessageType()) {
                case SubmitSm: {
                    SubmitSm submitPdu;
                    pdu = submitPdu = new SubmitSm();
                    break;
                }
                case DataSm: {
                    DataSm dataPdu = new DataSm();
                    pdu = dataPdu;
                    break;
                }
                case DeliverSm: {
                    DeliverSm deliverPdu = new DeliverSm();
                    pdu = deliverPdu;
                    break;
                }
                case SubmitMulti: {
                    SubmitMulti submitMulti = new SubmitMulti();
                    pdu = submitMulti;
                    break;
                }
                default: {
                    return;
                }
            }
            pdu.setSourceAddress(new Address((byte)this.param.getSourceTON().getCode(), (byte)this.param.getSourceNPI().getCode(), this.param.getSourceAddress()));
            if (this.param.getSendingMessageType() == SmppSimulatorParameters.SendingMessageType.SubmitMulti) {
                long daOrig = 1L;
                try {
                    daOrig = Long.parseLong(destAddr);
                }
                catch (Exception deliverPdu) {
                    // empty catch block
                }
                for (int i2 = 0; i2 < this.param.getSubmitMultiMessageCnt(); ++i2) {
                    ((SubmitMulti)pdu).addDestAddresses(new Address((byte)this.param.getDestTON().getCode(), (byte)this.param.getDestNPI().getCode(), String.valueOf(daOrig + (long)i2)));
                }
            } else {
                pdu.setDestAddress(new Address((byte)this.param.getDestTON().getCode(), (byte)this.param.getDestNPI().getCode(), destAddr));
            }
            pdu.setEsmClass((byte)esmClass);
            switch (validityType) {
                case ValidityPeriod_5min: {
                    pdu.setValidityPeriod(MessageUtil.printSmppRelativeDate((int)0, (int)0, (int)0, (int)0, (int)5, (int)0));
                    break;
                }
                case ValidityPeriod_2hours: {
                    pdu.setValidityPeriod(MessageUtil.printSmppRelativeDate((int)0, (int)0, (int)0, (int)2, (int)0, (int)0));
                    break;
                }
                case ScheduleDeliveryTime_5min: {
                    pdu.setScheduleDeliveryTime(MessageUtil.printSmppRelativeDate((int)0, (int)0, (int)0, (int)0, (int)5, (int)0));
                }
            }
            pdu.setDataCoding((byte)dcs);
            pdu.setRegisteredDelivery((byte)this.param.getMcDeliveryReceipt().getCode());
            if (buf.length < 250 && this.param.getSendingMessageType() != SmppSimulatorParameters.SendingMessageType.DataSm) {
                pdu.setShortMessage(buf);
            } else {
                Tlv tlv2 = new Tlv(1060, buf);
                pdu.addOptionalParameter(tlv2);
            }
            if (addSegmTlv) {
                byte[] buf1 = new byte[]{0, (byte)msgRef};
                tlv3 = new Tlv(524, buf1);
                pdu.addOptionalParameter(tlv3);
                buf1 = new byte[]{(byte)msgLst.size()};
                tlv3 = new Tlv(526, buf1);
                pdu.addOptionalParameter(tlv3);
                buf1 = new byte[]{(byte)i1};
                tlv3 = new Tlv(527, buf1);
                pdu.addOptionalParameter(tlv3);
            }
            if (messageClassVal > 0) {
                byte[] buf1 = new byte[]{(byte)messageClassVal};
                tlv3 = new Tlv(5, buf1);
                pdu.addOptionalParameter(tlv3);
            }
            if (this.param.isSendOptionalParameter()) {
                for (Tlv tlv3 : this.param.getTlvSet().getOptionalParameters()) {
                    pdu.addOptionalParameter(tlv3);
                }
            }
            WindowFuture future0 = this.session0.sendRequestPdu((PduRequest)pdu, 10000L, false);
            this.messagesSent.incrementAndGet();
            if (this.timer != null) continue;
            this.addMessage("Request=" + pdu.getName(), pdu.toString());
        }
        this.segmentsSent.addAndGet(segmentCnt);
    }

    private void setEventMsg() {
        ListSelectionModel l = this.tNotif.getSelectionModel();
        if (!l.isSelectionEmpty()) {
            int index = l.getMinSelectionIndex();
            String s1 = (String)this.model.getValueAt(index, 0);
            String s2 = (String)this.model.getValueAt(index, 1);
            String s3 = (String)this.model.getValueAt(index, 2);
            this.eventForm.setData(s1, s2, s3);
        }
    }

    private void start() {
        this.messagesSent = new AtomicInteger();
        this.segmentsSent = new AtomicInteger();
        this.responsesRcvd = new AtomicInteger();
        this.messagesRcvd = new AtomicInteger();
        this.addMessage("Trying to start a new " + this.param.getSmppSessionType() + " session", "");
        this.executor = (ThreadPoolExecutor)Executors.newCachedThreadPool();
        this.monitorExecutor = (ScheduledThreadPoolExecutor)Executors.newScheduledThreadPool(1, new ThreadFactory(){
            private AtomicInteger sequence = new AtomicInteger(0);

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r);
                t.setName("SmppClientSessionWindowMonitorPool-" + this.sequence.getAndIncrement());
                return t;
            }
        });
        if (this.param.getSmppSessionType() == SmppSession.Type.CLIENT) {
            this.clientBootstrap = new TestSmppClient(Executors.newCachedThreadPool(), 1, this.monitorExecutor);
            ClientSmppSessionHandler sessionHandler = new ClientSmppSessionHandler(this);
            SmppSessionConfiguration config0 = new SmppSessionConfiguration();
            config0.setWindowSize(this.param.getWindowSize());
            config0.setName("Tester.Session.0");
            config0.setType(this.param.getBindType());
            config0.setHost(this.param.getHost());
            config0.setPort(this.param.getPort());
            config0.setConnectTimeout(this.param.getConnectTimeout());
            config0.setSystemId(this.param.getSystemId());
            config0.setPassword(this.param.getPassword());
            config0.setAddressRange(new Address(1, 1, this.param.getAddressRange()));
            config0.getLoggingOptions().setLogBytes(true);
            config0.setRequestExpiryTimeout(this.param.getRequestExpiryTimeout());
            config0.setWindowMonitorInterval(this.param.getWindowMonitorInterval());
            config0.setCountersEnabled(true);
            try {
                this.session0 = this.clientBootstrap.bind(config0, (SmppSessionHandler)sessionHandler);
            }
            catch (Exception e) {
                this.addMessage("Failure to start a new session", e.toString());
                return;
            }
            this.enableStart(false);
            this.setDefaultCloseOperation(0);
            this.addMessage("Session has been successfully started", "");
        } else {
            SmppServerConfiguration configuration = new SmppServerConfiguration();
            configuration.setName("Test SMPP server");
            configuration.setPort(this.param.getPort());
            configuration.setBindTimeout(5000L);
            configuration.setSystemId(this.param.getSystemId());
            configuration.setAutoNegotiateInterfaceVersion(true);
            configuration.setInterfaceVersion((byte)52);
            configuration.setMaxConnectionSize(100);
            configuration.setNonBlockingSocketsEnabled(true);
            configuration.setDefaultRequestExpiryTimeout(-1L);
            configuration.setDefaultWindowMonitorInterval(-1L);
            configuration.setDefaultWindowSize(1);
            configuration.setDefaultWindowWaitTimeout(60000L);
            configuration.setDefaultSessionCountersEnabled(true);
            configuration.setJmxEnabled(false);
            this.defaultSmppServer = new DefaultSmppServer(configuration, (SmppServerHandler)new DefaultSmppServerHandler(this), (ExecutorService)this.executor, (ScheduledExecutorService)this.monitorExecutor);
            try {
                this.defaultSmppServer.start();
            }
            catch (SmppChannelException e1) {
                this.addMessage("Failure to start a defaultSmppServer", e1.toString());
                return;
            }
            this.enableStart(false);
            this.setDefaultCloseOperation(0);
            this.addMessage("SMPP Server has been successfully started", "");
        }
    }

    public void stop() {
        this.addMessage("Trying to stop a session", "");
        this.doStop();
    }

    public void doStop() {
        if (this.session0 != null) {
            this.session0.unbind(5000L);
            this.session0.destroy();
            this.session0 = null;
        }
        if (this.defaultSmppServer != null) {
            this.defaultSmppServer.stop();
            this.defaultSmppServer.destroy();
            this.defaultSmppServer = null;
        }
        if (this.clientBootstrap != null) {
            try {
                this.clientBootstrap.destroy();
                this.executor.shutdownNow();
                this.monitorExecutor.shutdownNow();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.clientBootstrap = null;
            this.executor = null;
            this.monitorExecutor = null;
        }
        this.enableStart(true);
        this.setDefaultCloseOperation(2);
        this.addMessage("Session has been stopped", "");
    }

    public void enableStart(boolean enabled) {
        this.btStart.setEnabled(enabled);
        this.btStop.setEnabled(!enabled);
    }

    private void refreshState() {
        this.lbState.setText("messageSegmentsSent=" + this.segmentsSent.get() + ", submitMessagesSent=" + this.messagesSent.get() + ", submitResponsesRcvd=" + this.responsesRcvd.get() + ", messagesRcvd=" + this.messagesRcvd.get());
    }

    public void setData(SmppSimulatorForm mainForm, SmppSimulatorParameters param) {
        this.param = param;
        this.mainForm = mainForm;
    }

    private JDialog getJDialog() {
        return this;
    }

    private void closingWindow() {
        this.mainForm.testingFormClose();
    }

    public void eventFormClose() {
        this.eventForm = null;
    }

    private void openEventWindow() {
        if (this.eventForm != null) {
            return;
        }
        this.eventForm = new EventForm(this);
        this.eventForm.setVisible(true);
        this.setEventMsg();
    }

    private void doStopTimer() {
        if (this.timer != null) {
            for (java.util.Timer tm : this.timer) {
                tm.cancel();
            }
            this.timer = null;
        }
    }

    private void startBulkSending() {
        if (this.rbRandomBulkMessages.isSelected()) {
            this.doStopTimer();
            this.timer = new java.util.Timer[this.threadCount];
            for (int i1 = 0; i1 < this.threadCount; ++i1) {
                this.timer[i1] = new java.util.Timer();
                this.timer[i1].scheduleAtFixedRate(new TimerTask(){

                    @Override
                    public void run() {
                        SmppTestingForm.this.doSendSmppMessages();
                    }
                }, 1000L, 1000L);
            }
            this.btStartBulk.setEnabled(false);
            this.btStopBulk.setEnabled(true);
        } else {
            this.doStopTimer();
            this.btStartBulk.setEnabled(false);
            this.btStopBulk.setEnabled(true);
            Thread t = new Thread(new Runnable(){

                @Override
                public void run() {
                    SmppTestingForm.this.doParsePcapFile();
                }
            });
            t.start();
        }
    }

    private void stopBulkSending() {
        this.doStopTimer();
        this.btStartBulk.setEnabled(true);
        this.btStopBulk.setEnabled(false);
    }

    private void doSendSmppMessages() {
        Random rand = new Random();
        for (int i1 = 0; i1 < this.param.getBulkMessagePerSecond() / this.threadCount; ++i1) {
            SmppSimulatorParameters.SplittingType splittingType;
            int n = this.param.getBulkDestAddressRangeEnd() - this.param.getBulkDestAddressRangeStart() + 1;
            if (n < 1) {
                n = 1;
            }
            int j1 = rand.nextInt(n);
            Integer destAddr = this.param.getBulkDestAddressRangeStart() + j1;
            String destAddrS = destAddr.toString();
            int j2 = rand.nextInt(2);
            int j3 = rand.nextInt(3);
            SmppSimulatorParameters.EncodingType encodingType = j2 == 0 ? SmppSimulatorParameters.EncodingType.GSM7_DCS_0 : SmppSimulatorParameters.EncodingType.UCS2_DCS_8;
            switch (j3) {
                case 0: {
                    splittingType = SmppSimulatorParameters.SplittingType.DoNotSplit;
                    break;
                }
                case 1: {
                    splittingType = SmppSimulatorParameters.SplittingType.SplitWithParameters_DefaultSegmentLength;
                    break;
                }
                default: {
                    splittingType = SmppSimulatorParameters.SplittingType.SplitWithUdh_DefaultSegmentLength;
                }
            }
            int j4 = rand.nextInt(5);
            String msg = this.param.getMessageText();
            if (j4 == 0) {
                msg = this.bigMessage;
            }
            msg = msg + " " + Integer.valueOf(this.messagesNum.incrementAndGet()).toString();
            this.submitMessage(encodingType, 0, msg, splittingType, this.param.getValidityType(), destAddrS, this.param.getMessagingMode(), this.param.getSpecifiedSegmentLength());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doParsePcapFile() {
        try {
            int port = Integer.parseInt(this.tbPcapPort.getText());
            SmppPcapParser smppPcapParser = new SmppPcapParser(this, this.tbPcapFileName.getText(), port);
            smppPcapParser.parse();
        }
        catch (Throwable e) {
            JOptionPane.showMessageDialog(this.getJDialog(), "General exception when pcap parsing: " + e.toString());
            e.printStackTrace();
        }
        finally {
            this.btStartBulk.setEnabled(true);
            this.btStopBulk.setEnabled(false);
        }
    }

    @Override
    public void onNewSmppRequest(BaseSm pdu) throws Exception {
        if (this.session0 != null) {
            WindowFuture future0 = this.session0.sendRequestPdu((PduRequest)pdu, 10000L, false);
            this.messagesSent.incrementAndGet();
        }
    }

    @Override
    public boolean needContinue() {
        return !this.btStartBulk.isEnabled();
    }

    public synchronized void addMessage(String msg, String info) {
        Date d1 = new Date();
        String s1 = d1.toLocaleString();
        Vector<String> newRow = new Vector<String>();
        newRow.add(s1);
        newRow.add(msg);
        newRow.add(info);
        this.model.getDataVector().add(0, newRow);
        this.model.newRowsAdded(new TableModelEvent(this.model));
    }
}

