/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.smsc.tools.stresstool;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.log4j.Logger;
import org.mobicents.smsc.cassandra.PersistenceException;
import org.mobicents.smsc.library.Sms;
import org.mobicents.smsc.library.SmsSet;
import org.mobicents.smsc.library.TargetAddress;
import org.mobicents.smsc.tools.stresstool.ProcessTask;
import org.mobicents.smsc.tools.stresstool.TT_DBOperationsProxy;

public class StressTool {
    private String host = "localhost";
    private int port = 9042;
    private String keyspace = "RestCommSMSC";
    private int smsSetRange = 100000;
    private int recordCount = 10000000;
    private int threadCountW = 0;
    private int threadCountR = 3;
    private CTask task = CTask.Live_Sms_Cycle;
    private static final Logger logger = Logger.getLogger(StressTool.class);
    private String persistFile = "stresstool.xml";
    private static final String TAB_INDENT = "\t";
    private TT_DBOperationsProxy dbOperations;
    private Queue<SmsSet> queue = new ConcurrentLinkedQueue<SmsSet>();

    public static void main(final String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    StressTool tool = new StressTool();
                    tool.start(args);
                }
                catch (Exception e) {
                    logger.error((Object)("General exception: " + e.toString()), (Throwable)e);
                    e.printStackTrace();
                }
            }
        });
    }

    public void start(String[] args) throws Exception {
        this.parseParameters(args);
        this.logInfo("Stress tool starting ...");
        this.logInfo("host        : " + this.host);
        this.logInfo("port        : " + this.port);
        this.logInfo("keyspace    : " + this.keyspace);
        this.logInfo("smsSetRange : " + this.smsSetRange);
        this.logInfo("recordCount : " + this.recordCount);
        this.logInfo("threadCountW : " + this.threadCountW);
        this.logInfo("threadCountR : " + this.threadCountR);
        this.logInfo("task        : " + (Object)((Object)this.task));
        this.dbOperations = new TT_DBOperationsProxy();
        this.dbOperations.start(this.host, this.port, this.keyspace);
        Runnable ta = null;
        if (this.task == CTask.Live_Sms_Filling) {
            ta = new TA();
        } else if (this.task == CTask.Live_Sms_Deleting) {
            ta = new TB();
        } else if (this.task == CTask.Live_Sms_Cycle) {
            ta = new TX();
        }
        if (ta != null) {
            while (!ta.isReady()) {
                this.logInfo(ta.getResults());
                Thread.sleep(10000L);
            }
        }
        this.dbOperations.stop();
    }

    private void logInfo(String s) {
        logger.info((Object)s);
        System.out.print("\n");
        System.out.print(s);
    }

    private void parseParameters(String[] args) {
        for (String s : args) {
            if (s.length() <= 2) continue;
            String s1 = s.substring(0, 2);
            String s2 = s.substring(2);
            if (s1.equals("-h")) {
                this.host = s2;
                continue;
            }
            if (s1.equals("-p")) {
                this.port = Integer.parseInt(s2);
                continue;
            }
            if (s1.equals("-k")) {
                this.keyspace = s2;
                continue;
            }
            if (s1.equals("-s")) {
                this.smsSetRange = Integer.parseInt(s2);
                continue;
            }
            if (s1.equals("-c")) {
                this.recordCount = Integer.parseInt(s2);
                continue;
            }
            if (s1.equals("-t")) {
                this.threadCountW = Integer.parseInt(s2);
                continue;
            }
            if (s1.equals("-T")) {
                this.threadCountR = Integer.parseInt(s2);
                continue;
            }
            if (!s1.equals("-d")) continue;
            if (s2.equals("a")) {
                this.task = CTask.Live_Sms_Filling;
                continue;
            }
            if (!s2.equals("b")) continue;
            this.task = CTask.Live_Sms_Deleting;
        }
    }

    private String generateAddr() {
        Integer res = ThreadLocalRandom.current().nextInt(this.smsSetRange) + 1000000000;
        return res.toString();
    }

    class TX3
    implements ProcessTask,
    Runnable {
        @Override
        public boolean isReady() {
            return true;
        }

        @Override
        public String getResults() {
            return "";
        }

        @Override
        public void run() {
            while (true) {
                SmsSet smsSet;
                if ((smsSet = (SmsSet)StressTool.this.queue.poll()) != null) {
                    try {
                        StressTool.this.dbOperations.fetchSchedulableSms(smsSet, false);
                        long ii = smsSet.getSmsCount();
                        int i1 = 0;
                        while ((long)i1 < ii) {
                            Sms sms = smsSet.getSms((long)i1);
                            StressTool.this.dbOperations.archiveDeliveredSms(sms, new Date());
                            ++i1;
                        }
                        StressTool.this.dbOperations.deleteSmsSet(smsSet);
                    }
                    catch (PersistenceException e) {
                        logger.error((Object)("Exception in task X1: " + e.toString()), (Throwable)e);
                    }
                    continue;
                }
                try {
                    Thread.sleep(100L);
                    continue;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        }

        @Override
        public void terminate() {
        }
    }

    class TX2
    implements ProcessTask,
    Runnable {
        private int startNum;
        private int endNum;
        private int curNum;
        private boolean ready;

        public TX2(int startNum, int endNum) {
            this.startNum = startNum;
            this.endNum = endNum;
            this.curNum = startNum;
        }

        @Override
        public boolean isReady() {
            return this.ready;
        }

        @Override
        public String getResults() {
            return "";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                block7: while (true) {
                    try {
                        int cnt = 1000;
                        List lst = StressTool.this.dbOperations.fetchSchedulableSmsSets(cnt, null);
                        this.curNum += cnt;
                        for (SmsSet smsSet : lst) {
                            boolean b1 = StressTool.this.dbOperations.checkSmsSetExists(new TargetAddress(smsSet));
                            if (b1) {
                                StressTool.this.dbOperations.setDeliveryStart(smsSet, new Date());
                            }
                            StressTool.this.queue.add(smsSet);
                        }
                    }
                    catch (PersistenceException e) {
                        logger.error((Object)("Exception in task X2: " + e.toString()), (Throwable)e);
                    }
                    if (this.curNum >= this.endNum) {
                        break;
                    }
                    while (true) {
                        if (StressTool.this.queue.size() <= 10000) continue block7;
                        Thread.sleep(100L);
                    }
                    break;
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            finally {
                this.ready = true;
            }
        }

        @Override
        public void terminate() {
        }
    }

    class TX1
    implements ProcessTask,
    Runnable {
        private int startNum;
        private int endNum;
        private int curNum;
        private boolean ready;

        public TX1(int startNum, int endNum) {
            this.startNum = startNum;
            this.endNum = endNum;
            this.curNum = startNum;
        }

        @Override
        public boolean isReady() {
            return this.ready;
        }

        @Override
        public String getResults() {
            return "";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                do {
                    Integer ii1 = this.curNum;
                    String s1 = ii1.toString();
                    TargetAddress ta = new TargetAddress(1, 1, s1, 0);
                    try {
                        SmsSet smsSet = StressTool.this.dbOperations.obtainSmsSet(ta);
                        StressTool.this.dbOperations.setNewMessageScheduled(smsSet, new Date());
                        ArrayList<byte[]> bb = new ArrayList<byte[]>();
                        byte[] bf1 = new byte[10];
                        byte[] bf2 = new byte[20];
                        byte[] bf3 = new byte[30];
                        bf1[0] = 10;
                        bf2[1] = 20;
                        bf3[3] = 30;
                        bb.add(bf1);
                        bb.add(bf2);
                        bb.add(bf3);
                        for (int i1 = 0; i1 < 3; ++i1) {
                            Sms sms = new Sms();
                            sms.setSmsSet(smsSet);
                            sms.setMessageId((long)this.curNum);
                            sms.setDbId(UUID.randomUUID());
                            sms.setShortMessage((byte[])bb.get(i1));
                            StressTool.this.dbOperations.createLiveSms(sms);
                        }
                    }
                    catch (PersistenceException e) {
                        logger.error((Object)("Exception in task X1: " + e.toString()), (Throwable)e);
                    }
                    ++this.curNum;
                } while (this.curNum < this.endNum);
            }
            finally {
                this.ready = true;
            }
        }

        @Override
        public void terminate() {
        }
    }

    class TX
    implements ProcessTask,
    Runnable {
        private ArrayList<TX1> tx1 = new ArrayList();
        private TX2 tx2;
        private ArrayList<TX3> tx3 = new ArrayList();

        public TX() {
            if (StressTool.this.threadCountW > 0) {
                int num = 1000000;
                int step = StressTool.this.recordCount / StressTool.this.threadCountW;
                for (int i1 = 0; i1 < StressTool.this.threadCountW; ++i1) {
                    TX1 ta = new TX1(num, num + step);
                    num += step;
                    this.tx1.add(ta);
                    Thread t = new Thread(ta);
                    t.start();
                }
            }
            this.tx2 = new TX2(0, StressTool.this.recordCount);
            Thread t = new Thread(this.tx2);
            t.start();
            for (int i1 = 0; i1 < StressTool.this.threadCountR; ++i1) {
                TX3 ta = new TX3();
                this.tx3.add(ta);
                t = new Thread(ta);
                t.start();
            }
        }

        @Override
        public boolean isReady() {
            for (TX1 el : this.tx1) {
                if (el.isReady()) continue;
                return false;
            }
            return this.tx2.isReady();
        }

        @Override
        public String getResults() {
            int i1 = 0;
            for (TX1 el : this.tx1) {
                i1 += el.curNum - el.startNum;
            }
            int i2 = StressTool.this.recordCount;
            String s1 = "Processed TX1 " + i1 + " out of " + i2 + ", processed TX2 " + this.tx2.curNum + " out of " + (this.tx2.endNum - this.tx2.startNum) + ", queue=" + StressTool.this.queue.size();
            return s1;
        }

        @Override
        public void run() {
        }

        @Override
        public void terminate() {
        }
    }

    class TB
    implements ProcessTask,
    Runnable {
        private ArrayList<TB> threads = new ArrayList();
        private int startNum;
        private int endNum;
        private int curNum;
        private boolean ready;
        private boolean isMaster = false;

        public TB() {
            this.isMaster = true;
            int num = 1000000;
            int step = StressTool.this.recordCount / StressTool.this.threadCountW;
            for (int i1 = 0; i1 < StressTool.this.threadCountW; ++i1) {
                TB ta = new TB(num, num + step);
                num += step;
                this.threads.add(ta);
                Thread t = new Thread(ta);
                t.start();
            }
        }

        public TB(int startNum, int endNum) {
            this.startNum = startNum;
            this.endNum = endNum;
            this.curNum = startNum;
        }

        @Override
        public boolean isReady() {
            if (this.isMaster) {
                for (TB el : this.threads) {
                    if (el.isReady()) continue;
                    return false;
                }
                return true;
            }
            return this.ready;
        }

        @Override
        public String getResults() {
            int i1 = 0;
            for (TB el : this.threads) {
                i1 += el.curNum - el.startNum;
            }
            int i2 = StressTool.this.recordCount;
            return "Processed " + i1 + " out of " + i2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                do {
                    Session sess = StressTool.this.dbOperations.getSession();
                    PreparedStatement obtainSmsSet = sess.prepare("SELECT * FROM \"LIVE_SMS\" LIMIT 100;");
                    BoundStatement boundStatement = new BoundStatement(obtainSmsSet);
                    ResultSet res = sess.execute((Statement)boundStatement);
                    Row row = res.one();
                    UUID id = row.getUUID("ID");
                    PreparedStatement deleteLiveSms = sess.prepare("delete from \"LIVE_SMS\" where \"ID\"=?;");
                    boundStatement = new BoundStatement(deleteLiveSms);
                    boundStatement.bind(new Object[]{id});
                    ResultSet rs = sess.execute((Statement)boundStatement);
                    ++this.curNum;
                } while (this.curNum < this.endNum);
            }
            finally {
                this.ready = true;
            }
        }

        @Override
        public void terminate() {
        }
    }

    class TA
    implements ProcessTask,
    Runnable {
        private ArrayList<TA> threads = new ArrayList();
        private int startNum;
        private int endNum;
        private int curNum;
        private boolean ready;
        private boolean isMaster = false;

        public TA() {
            this.isMaster = true;
            int num = 1000000;
            int step = StressTool.this.recordCount / StressTool.this.threadCountW;
            for (int i1 = 0; i1 < StressTool.this.threadCountW; ++i1) {
                TA ta = new TA(num, num + step);
                num += step;
                this.threads.add(ta);
                Thread t = new Thread(ta);
                t.start();
            }
        }

        public TA(int startNum, int endNum) {
            this.startNum = startNum;
            this.endNum = endNum;
            this.curNum = startNum;
        }

        @Override
        public boolean isReady() {
            if (this.isMaster) {
                for (TA el : this.threads) {
                    if (el.isReady()) continue;
                    return false;
                }
                return true;
            }
            return this.ready;
        }

        @Override
        public String getResults() {
            int i1 = 0;
            for (TA el : this.threads) {
                i1 += el.curNum - el.startNum;
            }
            int i2 = StressTool.this.recordCount;
            return "Processed " + i1 + " out of " + i2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                do {
                    SmsSet smsSet = new SmsSet();
                    Integer ii1 = this.curNum;
                    String s1 = ii1.toString();
                    smsSet.setDestAddr(s1);
                    smsSet.setDestAddrNpi(1);
                    smsSet.setDestAddrTon(1);
                    Sms sms = new Sms();
                    sms.setSmsSet(smsSet);
                    sms.setMessageId((long)this.curNum);
                    sms.setDbId(UUID.randomUUID());
                    sms.setShortMessage(new byte[10]);
                    try {
                        StressTool.this.dbOperations.createLiveSms(sms);
                    }
                    catch (PersistenceException e) {
                        logger.error((Object)("Exception in task A: " + e.toString()), (Throwable)e);
                    }
                    ++this.curNum;
                } while (this.curNum < this.endNum);
            }
            finally {
                this.ready = true;
            }
        }

        @Override
        public void terminate() {
        }
    }

    static enum CTask {
        Live_Sms_Filling,
        Live_Sms_Deleting,
        Live_Sms_Cycle;

    }
}

