/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.smsc.tools.stresstool;

import com.cloudhopper.smpp.tlv.Tlv;
import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.Date;
import java.util.Queue;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.log4j.Logger;
import org.mobicents.protocols.ss7.map.api.primitives.AddressNature;
import org.mobicents.protocols.ss7.map.api.primitives.ISDNAddressString;
import org.mobicents.protocols.ss7.map.api.primitives.NumberingPlan;
import org.mobicents.protocols.ss7.map.api.service.sms.LocationInfoWithLMSI;
import org.mobicents.protocols.ss7.map.primitives.ISDNAddressStringImpl;
import org.mobicents.protocols.ss7.map.service.sms.LocationInfoWithLMSIImpl;
import org.mobicents.smsc.cassandra.PersistenceException;
import org.mobicents.smsc.cassandra.PreparedStatementCollection;
import org.mobicents.smsc.library.ErrorCode;
import org.mobicents.smsc.library.SmType;
import org.mobicents.smsc.library.Sms;
import org.mobicents.smsc.library.SmsSet;
import org.mobicents.smsc.library.SmsSetCache;
import org.mobicents.smsc.library.TargetAddress;
import org.mobicents.smsc.tools.stresstool.ProcessTask;
import org.mobicents.smsc.tools.stresstool.TT_DBOperationsProxy3;

public class StressTool3 {
    private String host = "localhost";
    private int port = 9042;
    private String keyspace = "saturn";
    private int dataTableDaysTimeArea = 10;
    private int smsSetRange = 10;
    private int recordCount = 500000;
    private int threadCountW = 8;
    private int threadCountR = 10;
    private int threadCountA = 10;
    private CTask task = CTask.Live_Sms_Cycle;
    private static final Logger logger = Logger.getLogger(StressTool3.class);
    private String persistFile = "stresstool.xml";
    private static final String TAB_INDENT = "\t";
    private TT_DBOperationsProxy3 dbOperations;
    private Queue<SmsSet> queue = new ConcurrentLinkedQueue<SmsSet>();

    public static void main(final String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    StressTool3 tool = new StressTool3();
                    tool.start(args);
                }
                catch (Exception e) {
                    logger.error((Object)("General exception: " + e.toString()), (Throwable)e);
                    e.printStackTrace();
                }
            }
        });
    }

    public void start(String[] args) throws Exception {
        this.parseParameters(args);
        this.logInfo("Stress tool starting ...");
        this.logInfo("host        : " + this.host);
        this.logInfo("port        : " + this.port);
        this.logInfo("keyspace    : " + this.keyspace);
        this.logInfo("dataTableDaysTimeArea : " + this.dataTableDaysTimeArea);
        this.logInfo("smsSetRange  : " + this.smsSetRange);
        this.logInfo("recordCount  : " + this.recordCount);
        this.logInfo("threadCountW : " + this.threadCountW);
        this.logInfo("threadCountR : " + this.threadCountR);
        this.logInfo("task         : " + (Object)((Object)this.task));
        this.dbOperations = new TT_DBOperationsProxy3();
        this.dbOperations.start(this.host, this.port, this.keyspace, 60, 60, 600);
        ProcessTask ta = null;
        if (this.task == CTask.Live_Sms_Cycle) {
            ta = new TX();
        }
        if (ta != null) {
            while (!ta.isReady()) {
                this.logInfo(ta.getResults());
                Thread.sleep(10000L);
            }
            ta.terminate();
        }
        this.dbOperations.stop();
    }

    private void logInfo(String s) {
        logger.info((Object)s);
        System.out.print("\n");
        System.out.print(s);
    }

    private void parseParameters(String[] args) {
        for (String s : args) {
            if (s.length() <= 2) continue;
            String s1 = s.substring(0, 2);
            String s2 = s.substring(2);
            if (s1.equals("-h")) {
                this.host = s2;
                continue;
            }
            if (s1.equals("-p")) {
                this.port = Integer.parseInt(s2);
                continue;
            }
            if (s1.equals("-k")) {
                this.keyspace = s2;
                continue;
            }
            if (s1.equals("-s")) {
                this.smsSetRange = Integer.parseInt(s2);
                continue;
            }
            if (s1.equals("-c")) {
                this.recordCount = Integer.parseInt(s2);
                continue;
            }
            if (s1.equals("-t")) {
                this.threadCountW = Integer.parseInt(s2);
                continue;
            }
            if (s1.equals("-T")) {
                this.threadCountR = Integer.parseInt(s2);
                continue;
            }
            if (!s1.equals("-m")) continue;
            this.dataTableDaysTimeArea = Integer.parseInt(s2);
        }
    }

    class TX4
    implements ProcessTask,
    Runnable {
        @Override
        public boolean isReady() {
            return true;
        }

        @Override
        public String getResults() {
            return "";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            int j1 = 0;
            while (true) {
                SmsSet smsSet;
                if ((smsSet = (SmsSet)StressTool3.this.queue.poll()) != null) {
                    ++j1;
                    try {
                        TargetAddress lock = SmsSetCache.getInstance().addSmsSet(new TargetAddress(smsSet));
                        try {
                            TargetAddress targetAddress = lock;
                            synchronized (targetAddress) {
                                int j2 = j1 % 3;
                                long ii = smsSet.getSmsCount();
                                if (j2 == 0) {
                                    Date dt = new Date(new Date().getTime() + 600000L);
                                    int i1 = 0;
                                    while ((long)i1 < ii) {
                                        Sms sms = smsSet.getSms((long)i1);
                                        sms.setDeliveryDate(new Date());
                                        StressTool3.this.dbOperations.c2_updateInSystem(sms, 2, false);
                                        sms.setDueSlot(StressTool3.this.dbOperations.c2_getDueSlotForTime(dt));
                                        StressTool3.this.dbOperations.c2_createRecordCurrent(sms);
                                        ++i1;
                                    }
                                } else {
                                    smsSet.setType(SmType.SMS_FOR_SS7);
                                    if (j1 % 3 == 1) {
                                        smsSet.setStatus(ErrorCode.ABSENT_SUBSCRIBER);
                                    } else {
                                        smsSet.setStatus(ErrorCode.SUCCESS);
                                        smsSet.setImsi("123456789012324");
                                        ISDNAddressStringImpl networkNodeNumber = new ISDNAddressStringImpl(AddressNature.international_number, NumberingPlan.ISDN, "1231223123");
                                        LocationInfoWithLMSIImpl locationInfoWithLMSI = new LocationInfoWithLMSIImpl((ISDNAddressString)networkNodeNumber, null, null, false, null);
                                        smsSet.setLocationInfoWithLMSI((LocationInfoWithLMSI)locationInfoWithLMSI);
                                    }
                                    int i1 = 0;
                                    while ((long)i1 < ii) {
                                        Sms sms = smsSet.getSms((long)i1);
                                        sms.setDeliveryDate(new Date());
                                        StressTool3.this.dbOperations.c2_updateInSystem(sms, 2, false);
                                        StressTool3.this.dbOperations.c2_createRecordArchive(sms);
                                        ++i1;
                                    }
                                }
                                SmsSetCache.getInstance().removeProcessingSmsSet(smsSet.getTargetId());
                            }
                        }
                        finally {
                            SmsSetCache.getInstance().removeSmsSet(lock);
                        }
                    }
                    catch (PersistenceException e) {
                        logger.error((Object)("Exception in task X3: " + e.toString()), (Throwable)e);
                    }
                    continue;
                }
                try {
                    Thread.sleep(100L);
                    continue;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        }

        @Override
        public void terminate() {
        }
    }

    class TX3
    implements ProcessTask,
    Runnable {
        private int startNum;
        private int endNum;
        private int curNum;
        private boolean ready;
        private boolean toTernminate;

        public TX3(int startNum, int endNum) {
            this.startNum = startNum;
            this.endNum = endNum;
            this.curNum = startNum;
        }

        @Override
        public boolean isReady() {
            return this.ready;
        }

        @Override
        public String getResults() {
            return "";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                while (!this.toTernminate) {
                    try {
                        long processedDueSlot = StressTool3.this.dbOperations.c2_getCurrentDueSlot();
                        long possibleDueSlot = StressTool3.this.dbOperations.c2_getIntimeDueSlot();
                        if (processedDueSlot >= possibleDueSlot || StressTool3.this.queue.size() > 10000) {
                            Thread.sleep(10L);
                        } else {
                            if (!StressTool3.this.dbOperations.c2_checkDueSlotNotWriting(++processedDueSlot)) {
                                Thread.sleep(10L);
                                continue;
                            }
                            ArrayList lstS = StressTool3.this.dbOperations.c2_getRecordList(processedDueSlot);
                            ArrayList lst = StressTool3.this.dbOperations.c2_sortRecordList(lstS);
                            this.curNum += lstS.size();
                            for (SmsSet ti : lst) {
                                if (ti.isProcessingStarted()) continue;
                                ti.setProcessingStarted();
                                StressTool3.this.queue.add(ti);
                            }
                            StressTool3.this.dbOperations.c2_setCurrentDueSlot(processedDueSlot);
                        }
                    }
                    catch (Throwable e) {
                        logger.error((Object)("Exception in task X3: " + e.toString()), e);
                    }
                    if (this.curNum < this.endNum) continue;
                    break;
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            finally {
                this.ready = true;
            }
        }

        @Override
        public void terminate() {
            this.toTernminate = true;
        }
    }

    class TX2
    implements ProcessTask,
    Runnable {
        private int startNum;
        private int endNum;
        private int numProcessed;
        private boolean toTernminate;
        private Random rnd = new Random();

        public TX2(int startNum, int endNum) {
            this.startNum = startNum;
            this.endNum = endNum;
        }

        @Override
        public boolean isReady() {
            return true;
        }

        @Override
        public String getResults() {
            return "";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                while (!this.toTernminate) {
                    int num = this.rnd.nextInt(this.endNum - this.startNum) + this.startNum;
                    try {
                        PreparedStatementCollection psc = StressTool3.this.dbOperations.getStatementCollection(new Date());
                        Integer ii1 = num;
                        String s1 = ii1.toString();
                        SmsSet smsSet0 = new SmsSet();
                        smsSet0.setDestAddr(s1);
                        smsSet0.setDestAddrNpi(1);
                        smsSet0.setDestAddrTon(1);
                        TargetAddress lock = SmsSetCache.getInstance().addSmsSet(new TargetAddress(smsSet0));
                        try {
                            TargetAddress targetAddress = lock;
                            synchronized (targetAddress) {
                                long dueSlot = StressTool3.this.dbOperations.c2_getDueSlotForTargetId(psc, smsSet0.getTargetId());
                                if (dueSlot != 0L && dueSlot > StressTool3.this.dbOperations.c2_getCurrentDueSlot()) {
                                    StressTool3.this.dbOperations.c2_registerDueSlotWriting(dueSlot);
                                    try {
                                        SmsSet smsSet;
                                        if (dueSlot != 0L && dueSlot > StressTool3.this.dbOperations.c2_getCurrentDueSlot() && (smsSet = StressTool3.this.dbOperations.c2_getRecordListForTargeId(dueSlot, smsSet0.getTargetId())) != null) {
                                            ArrayList<SmsSet> lstS = new ArrayList<SmsSet>();
                                            lstS.add(smsSet);
                                            ArrayList lst = StressTool3.this.dbOperations.c2_sortRecordList(lstS);
                                            int i1 = 0;
                                            while ((long)i1 < smsSet.getSmsCount()) {
                                                Sms sms = smsSet.getSms((long)i1);
                                                StressTool3.this.dbOperations.c2_updateInSystem(sms, 1, false);
                                                ++i1;
                                            }
                                            this.numProcessed = (int)((long)this.numProcessed + smsSet.getSmsCount());
                                            for (SmsSet t1 : lst) {
                                                if (t1.isProcessingStarted()) continue;
                                                t1.setProcessingStarted();
                                                StressTool3.this.queue.add(t1);
                                            }
                                        }
                                    }
                                    finally {
                                        StressTool3.this.dbOperations.c2_unregisterDueSlotWriting(dueSlot);
                                    }
                                }
                            }
                        }
                        finally {
                            SmsSetCache.getInstance().removeSmsSet(lock);
                        }
                    }
                    catch (PersistenceException e) {
                        logger.error((Object)("Exception in task X2: " + e.toString()), (Throwable)e);
                    }
                    Thread.sleep(10L);
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }

        @Override
        public void terminate() {
            this.toTernminate = true;
        }
    }

    class TX1
    implements ProcessTask,
    Runnable {
        private int startNum;
        private int endNum;
        private int curNum;
        private boolean ready;
        private boolean toTernminate;

        public TX1(int startNum, int endNum) {
            this.startNum = startNum;
            this.endNum = endNum;
            this.curNum = startNum;
        }

        @Override
        public boolean isReady() {
            return this.ready;
        }

        @Override
        public String getResults() {
            return "";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                while (!this.toTernminate) {
                    Integer ii1 = this.curNum;
                    String s1 = ii1.toString();
                    int messageId = 0;
                    int cnt = 3;
                    try {
                        PreparedStatementCollection psc = StressTool3.this.dbOperations.getStatementCollection(new Date());
                        SmsSet smsSet = new SmsSet();
                        smsSet.setDestAddr(s1);
                        smsSet.setDestAddrNpi(1);
                        smsSet.setDestAddrTon(1);
                        ArrayList<byte[]> bb = new ArrayList<byte[]>();
                        byte[] bf1 = new byte[10];
                        byte[] bf2 = new byte[20];
                        byte[] bf3 = new byte[30];
                        bf1[0] = 10;
                        bf2[1] = 20;
                        bf3[3] = 30;
                        bb.add(bf1);
                        bb.add(bf2);
                        bb.add(bf3);
                        for (int i1 = 0; i1 < cnt; ++i1) {
                            long dueSlot;
                            Sms sms = new Sms();
                            sms.setSmsSet(smsSet);
                            sms.setMessageId((long)this.curNum);
                            sms.setDbId(UUID.randomUUID());
                            sms.setShortMessage((byte[])bb.get(i1));
                            sms.setDataCoding(0);
                            sms.setEsmClass(20);
                            sms.setMessageId((long)(++messageId));
                            sms.setMoMessageRef(13);
                            sms.setOrigEsmeName("A1");
                            sms.setOrigSystemId("E1");
                            sms.setPriority(3);
                            sms.setProtocolId(14);
                            sms.setRegisteredDelivery(15);
                            if (i1 == 0) {
                                sms.setScheduleDeliveryTime(new Date());
                            }
                            Integer I2 = messageId + 20000;
                            sms.setSourceAddr(I2.toString());
                            sms.setSourceAddrNpi(4);
                            sms.setSourceAddrTon(1);
                            sms.setSubmitDate(new Date());
                            sms.setValidityPeriod(new Date(new Date().getTime() + 86400000L));
                            if (i1 == 0) {
                                Tlv tlv = new Tlv(0, bf3);
                                sms.getTlvSet().addOptionalParameter(tlv);
                            }
                            TargetAddress lock = SmsSetCache.getInstance().addSmsSet(new TargetAddress(smsSet));
                            try {
                                TargetAddress targetAddress = lock;
                                synchronized (targetAddress) {
                                    dueSlot = StressTool3.this.dbOperations.c2_getDueSlotForTargetId(psc, sms.getSmsSet().getTargetId());
                                    if (dueSlot == 0L || dueSlot <= StressTool3.this.dbOperations.c2_getCurrentDueSlot()) {
                                        dueSlot = StressTool3.this.dbOperations.c2_getDueSlotForNewSms();
                                        StressTool3.this.dbOperations.c2_updateDueSlotForTargetId(sms.getSmsSet().getTargetId(), dueSlot);
                                    }
                                    sms.setDueSlot(dueSlot);
                                }
                            }
                            finally {
                                SmsSetCache.getInstance().removeSmsSet(lock);
                            }
                            StressTool3.this.dbOperations.c2_registerDueSlotWriting(dueSlot);
                            try {
                                StressTool3.this.dbOperations.c2_createRecordCurrent(sms);
                                continue;
                            }
                            finally {
                                StressTool3.this.dbOperations.c2_unregisterDueSlotWriting(dueSlot);
                            }
                        }
                    }
                    catch (PersistenceException e) {
                        logger.error((Object)("Exception in task X1: " + e.toString()), (Throwable)e);
                    }
                    this.curNum += cnt;
                    if (this.curNum < this.endNum) continue;
                    break;
                }
            }
            finally {
                this.ready = true;
            }
        }

        @Override
        public void terminate() {
            this.toTernminate = true;
        }
    }

    class TX
    implements ProcessTask,
    Runnable {
        private ArrayList<TX1> tx1 = new ArrayList();
        private ArrayList<TX2> tx2 = new ArrayList();
        private TX3 tx3;
        private ArrayList<TX4> tx4 = new ArrayList();

        public TX() {
            int num;
            if (StressTool3.this.threadCountW > 0) {
                num = 1000000;
                int step = StressTool3.this.recordCount / StressTool3.this.threadCountW;
                for (int i1 = 0; i1 < StressTool3.this.threadCountW; ++i1) {
                    TX1 ta = new TX1(num, num + step);
                    num += step;
                    this.tx1.add(ta);
                    Thread t = new Thread(ta);
                    t.start();
                }
            }
            if (StressTool3.this.threadCountR > 0) {
                this.tx3 = new TX3(0, StressTool3.this.recordCount);
                Thread t = new Thread(this.tx3);
                t.start();
            }
            if (StressTool3.this.threadCountA > 0) {
                num = 1000000;
                for (int i1 = 0; i1 < StressTool3.this.threadCountA; ++i1) {
                    TX2 ta = new TX2(num, num + StressTool3.this.recordCount);
                    this.tx2.add(ta);
                    Thread t = new Thread(ta);
                    t.start();
                }
            }
            for (int i1 = 0; i1 < StressTool3.this.threadCountR; ++i1) {
                TX4 ta = new TX4();
                this.tx4.add(ta);
                Thread t = new Thread(ta);
                t.start();
            }
        }

        @Override
        public boolean isReady() {
            for (TX1 el : this.tx1) {
                if (el.isReady()) continue;
                return false;
            }
            return this.tx3 == null || this.tx3.isReady();
        }

        @Override
        public String getResults() {
            int i1 = 0;
            for (TX1 el : this.tx1) {
                i1 += el.curNum - el.startNum;
            }
            int i2 = StressTool3.this.recordCount;
            int i3 = 0;
            for (TX2 el : this.tx2) {
                i3 += el.numProcessed;
            }
            String s1 = "Processed TX1 " + i1 + " out of " + i2 + ", processed TX3 " + (this.tx3 != null ? Integer.valueOf(this.tx3.curNum) : "") + " out of " + (this.tx3 != null ? Integer.valueOf(this.tx3.endNum - this.tx3.startNum) : "") + ", queue=" + StressTool3.this.queue.size() + ", T2-numProcessed=" + i3;
            return s1;
        }

        @Override
        public void run() {
        }

        @Override
        public void terminate() {
            for (ProcessTask processTask : this.tx1) {
                processTask.terminate();
            }
            if (this.tx3 != null) {
                this.tx3.terminate();
            }
        }
    }

    static enum CTask {
        Live_Sms_Cycle;

    }
}

