/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.smsc.tools.stresstool;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.Metadata;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.exceptions.InvalidQueryException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import javolution.util.FastMap;
import javolution.xml.XMLObjectReader;
import javolution.xml.XMLObjectWriter;
import javolution.xml.stream.XMLStreamException;
import org.apache.log4j.Logger;
import org.mobicents.smsc.cassandra.DBOperations;
import org.mobicents.smsc.cassandra.PersistenceException;
import org.mobicents.smsc.library.Sms;
import org.mobicents.smsc.library.SmsSet;
import org.mobicents.smsc.smpp.TlvSet;
import org.mobicents.smsc.tools.stresstool.NN_LoadedTargetId;

public class NN_DBOper {
    private static final Logger logger = Logger.getLogger(NN_DBOper.class);
    public static final String TLV_SET = "tlvSet";
    protected Cluster cluster;
    protected Session session;
    protected int dataTableDaysTimeArea;
    private FastMap<String, PreparedStatementCollection2> dataTableRead = new FastMap();
    private static final NN_DBOper instance = new NN_DBOper();
    private PreparedStatement selectCurrentSlotTable;
    private PreparedStatement updateCurrentSlotTable;
    private volatile boolean started = false;
    protected Date slotOrigDate = new Date(100, 1, 1);
    private long millisecInDueSlot = 500L;
    private long currentDueSlot = 0L;
    protected int slotSecondsTimeArea;
    private long nextDueSlotTime = 0L;
    private long dueSlotsInTable = 5000000L;
    private FastMap<String, PreparedStatementCollection4> dataTableRead4 = new FastMap();
    private FastMap<String, PreparedStatementCollection3> dataTableRead3 = new FastMap();

    protected NN_DBOper() {
    }

    public static NN_DBOper getInstance() {
        return instance;
    }

    public boolean isStarted() {
        return this.started;
    }

    protected Session getSession() {
        return this.session;
    }

    public void start(String ip, int port, String keyspace, int dataTableDaysTimeArea, int slotSecondsTimeArea) throws Exception {
        if (this.started) {
            throw new Exception("DBOperations already started");
        }
        this.dataTableDaysTimeArea = dataTableDaysTimeArea;
        this.slotSecondsTimeArea = slotSecondsTimeArea;
        Cluster.Builder builder = Cluster.builder();
        builder.withPort(port);
        builder.addContactPoint(ip);
        this.cluster = builder.build();
        Metadata metadata = this.cluster.getMetadata();
        logger.info((Object)String.format("Connected to cluster: %s\n", metadata.getClusterName()));
        for (Host host : metadata.getAllHosts()) {
            logger.info((Object)String.format("Datacenter: %s; Host: %s; Rack: %s\n", host.getDatacenter(), host.getAddress(), host.getRack()));
        }
        this.session = this.cluster.connect();
        this.session.execute("USE \"" + keyspace + "\"");
        this.started = true;
    }

    public void stop() throws Exception {
        if (!this.started) {
            return;
        }
        this.cluster.close();
        Metadata metadata = this.cluster.getMetadata();
        logger.info((Object)String.format("Disconnected from cluster: %s\n", metadata.getClusterName()));
        this.started = false;
    }

    public long calculateSlot(Date dt) {
        long a2 = dt.getTime();
        long a1 = this.slotOrigDate.getTime();
        long diff = a2 - a1;
        long res = diff / (long)this.slotSecondsTimeArea / 1000L;
        return res;
    }

    public void createRecord(long dueSlot, Sms sms) throws PersistenceException {
        PreparedStatementCollection2 psc = this.getStatementCollection(sms.getSubmitDate());
        try {
            PreparedStatement ps = psc.createRecordData;
            BoundStatement boundStatement = new BoundStatement(ps);
            boundStatement.setString("ADDR_DST_DIGITS", sms.getSmsSet().getDestAddr());
            boundStatement.setInt("ADDR_DST_TON", sms.getSmsSet().getDestAddrTon());
            boundStatement.setInt("ADDR_DST_NPI", sms.getSmsSet().getDestAddrNpi());
            boundStatement.setUUID("ID", sms.getDbId());
            boundStatement.setString("TARGET_ID", sms.getSmsSet().getTargetId());
            boundStatement.setLong("DUE_SLOT", dueSlot);
            if (sms.getSourceAddr() != null) {
                boundStatement.setString("ADDR_SRC_DIGITS", sms.getSourceAddr());
            }
            boundStatement.setInt("ADDR_SRC_TON", sms.getSourceAddrTon());
            boundStatement.setInt("ADDR_SRC_NPI", sms.getSourceAddrNpi());
            boundStatement.setInt("DUE_DELAY", sms.getSmsSet().getDueDelay());
            if (sms.getSmsSet().getStatus() != null) {
                boundStatement.setInt("SM_STATUS", sms.getSmsSet().getStatus().getCode());
            }
            boundStatement.setBool("ALERTING_SUPPORTED", sms.getSmsSet().isAlertingSupported());
            boundStatement.setLong("MESSAGE_ID", sms.getMessageId());
            boundStatement.setInt("MO_MESSAGE_REF", sms.getMoMessageRef());
            if (sms.getOrigEsmeName() != null) {
                boundStatement.setString("ORIG_ESME_NAME", sms.getOrigEsmeName());
            }
            if (sms.getOrigSystemId() != null) {
                boundStatement.setString("ORIG_SYSTEM_ID", sms.getOrigSystemId());
            }
            if (sms.getSubmitDate() != null) {
                DBOperations.setBoundStatementDate((BoundStatement)boundStatement, (String)"SUBMIT_DATE", (Date)sms.getSubmitDate());
            }
            if (sms.getServiceType() != null) {
                boundStatement.setString("SERVICE_TYPE", sms.getServiceType());
            }
            boundStatement.setInt("ESM_CLASS", sms.getEsmClass());
            boundStatement.setInt("PROTOCOL_ID", sms.getProtocolId());
            boundStatement.setInt("PRIORITY", sms.getPriority());
            boundStatement.setInt("REGISTERED_DELIVERY", sms.getRegisteredDelivery());
            boundStatement.setInt("REPLACE", sms.getReplaceIfPresent());
            boundStatement.setInt("DATA_CODING", sms.getDataCoding());
            boundStatement.setInt("DEFAULT_MSG_ID", sms.getDefaultMsgId());
            if (sms.getShortMessage() != null) {
                boundStatement.setBytes("MESSAGE", ByteBuffer.wrap(sms.getShortMessage()));
            }
            if (sms.getScheduleDeliveryTime() != null) {
                DBOperations.setBoundStatementDate((BoundStatement)boundStatement, (String)"SCHEDULE_DELIVERY_TIME", (Date)sms.getScheduleDeliveryTime());
            }
            if (sms.getValidityPeriod() != null) {
                DBOperations.setBoundStatementDate((BoundStatement)boundStatement, (String)"VALIDITY_PERIOD", (Date)sms.getValidityPeriod());
            }
            boundStatement.setInt("DELIVERY_COUNT", sms.getDeliveryCount());
            if (sms.getTlvSet().getOptionalParameterCount() > 0) {
                try {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    XMLObjectWriter writer = XMLObjectWriter.newInstance((OutputStream)baos);
                    writer.setIndentation("\t");
                    writer.write((Object)sms.getTlvSet(), TLV_SET, TlvSet.class);
                    writer.close();
                    byte[] rawData = baos.toByteArray();
                    String serializedEvent = new String(rawData);
                    boundStatement.setString("OPTIONAL_PARAMETERS", serializedEvent);
                }
                catch (XMLStreamException e) {
                    String msg = "XMLStreamException when serializing optional parameters for '" + sms.getDbId() + "'!";
                    throw new PersistenceException(msg, (Throwable)e);
                }
            }
            ResultSet res = this.session.execute((Statement)boundStatement);
            ps = psc.createRecordSlots;
            boundStatement = new BoundStatement(ps);
            boundStatement.setLong("DUE_SLOT", dueSlot);
            boundStatement.setString("TARGET_ID", sms.getSmsSet().getTargetId());
            res = this.session.execute((Statement)boundStatement);
            ps = psc.createRecordDests;
            boundStatement = new BoundStatement(ps);
            boundStatement.setString("TARGET_ID", sms.getSmsSet().getTargetId());
            boundStatement.setUUID("ID", sms.getDbId());
            boundStatement.setBool("SENT", false);
            res = this.session.execute((Statement)boundStatement);
        }
        catch (Exception e1) {
            String msg = "Failed createRecord !";
            throw new PersistenceException(msg, (Throwable)e1);
        }
    }

    public List<NN_LoadedTargetId> getTargetIdListForDueSlot(Date[] dtt, long dueSlot, long newDueSlot, int maxRecordCount) throws PersistenceException {
        ArrayList<NN_LoadedTargetId> lst = new ArrayList<NN_LoadedTargetId>();
        for (Date dt : dtt) {
            PreparedStatementCollection2 psc = this.getStatementCollection(dt);
            try {
                String sa = "SELECT \"TARGET_ID\" FROM \"SLOTS" + psc.tName + "\" where \"" + "DUE_SLOT" + "\"=? limit " + maxRecordCount + " allow filtering;";
                PreparedStatement ps = this.session.prepare(sa);
                BoundStatement boundStatement = new BoundStatement(ps);
                boundStatement.bind(new Object[]{dueSlot});
                ResultSet res = this.session.execute((Statement)boundStatement);
                for (Row row : res) {
                    String s = row.getString(0);
                    lst.add(new NN_LoadedTargetId(s, dt, newDueSlot));
                }
            }
            catch (Exception e1) {
                String msg = "Failed reading a set of TARGET_ID from SLOTS for dueSlot " + dueSlot + " !";
                throw new PersistenceException(msg, (Throwable)e1);
            }
            String s1 = null;
            try {
                for (NN_LoadedTargetId ti : lst) {
                    s1 = ti.getTargetId();
                    PreparedStatement ps = psc.deleteRecordSlots;
                    BoundStatement boundStatement = new BoundStatement(ps);
                    boundStatement.bind(new Object[]{dueSlot, ti.getTargetId()});
                    ResultSet res = this.session.execute((Statement)boundStatement);
                    ps = psc.createRecordSlots;
                    boundStatement = new BoundStatement(ps);
                    boundStatement.setLong("DUE_SLOT", newDueSlot);
                    boundStatement.setString("TARGET_ID", ti.getTargetId());
                    res = this.session.execute((Statement)boundStatement);
                }
            }
            catch (Exception e1) {
                logger.error((Object)("Failed removing a TARGET_ID from SLOTS " + s1 + " !"), (Throwable)e1);
            }
            if (lst.size() > 0) break;
        }
        return lst;
    }

    public SmsSet getSmsSetForTargetId(Date[] dtt, NN_LoadedTargetId ti) throws PersistenceException {
        SmsSet smsSet = null;
        for (Date dt : dtt) {
            String msg;
            PreparedStatementCollection2 psc = this.getStatementCollection(dt);
            ArrayList<UUID> lst2 = new ArrayList<UUID>();
            try {
                PreparedStatement ps = psc.getIdListDests;
                BoundStatement boundStatement = new BoundStatement(ps);
                boundStatement.bind(new Object[]{ti.getTargetId()});
                ResultSet res = this.session.execute((Statement)boundStatement);
                for (Row row : res) {
                    UUID id = row.getUUID(0);
                    boolean sent = row.getBool(1);
                    if (sent) continue;
                    lst2.add(id);
                }
            }
            catch (Exception e1) {
                msg = "Failed reading a set of ID from DESTS for targetId " + ti.getTargetId() + " !";
                throw new PersistenceException(msg, (Throwable)e1);
            }
            try {
                for (UUID id : lst2) {
                    PreparedStatement ps = psc.getSms;
                    BoundStatement boundStatement = new BoundStatement(ps);
                    boundStatement.bind(new Object[]{ti.getTargetId(), id});
                    ResultSet res = this.session.execute((Statement)boundStatement);
                    for (Row row : res) {
                        Sms sms = this.createSms(row, smsSet);
                        smsSet = sms.getSmsSet();
                    }
                }
            }
            catch (Exception e1) {
                msg = "Failed reading SmsSet for " + ti.getTargetId() + " !";
                throw new PersistenceException(msg, (Throwable)e1);
            }
        }
        if (smsSet != null) {
            smsSet.resortSms();
        } else {
            PreparedStatementCollection2 psc = this.getStatementCollection(ti.getDtx());
            PreparedStatement ps = psc.deleteRecordSlots;
            BoundStatement boundStatement = new BoundStatement(ps);
            boundStatement.bind(new Object[]{ti.getDueSlot(), ti.getTargetId()});
            ResultSet res = this.session.execute((Statement)boundStatement);
        }
        return smsSet;
    }

    public void deleteIdFromDests(Sms sms) throws PersistenceException {
        PreparedStatementCollection2 psc = this.getStatementCollection(sms.getSubmitDate());
        PreparedStatement ps = psc.updateRecordDests;
        BoundStatement boundStatement = new BoundStatement(ps);
        boundStatement.bind(new Object[]{sms.getSmsSet().getTargetId(), sms.getDbId()});
        ResultSet res = this.session.execute((Statement)boundStatement);
    }

    public PreparedStatementCollection2 getStatementCollection(Date dt) throws PersistenceException {
        String tName = this.getTableName(dt);
        PreparedStatementCollection2 psc = (PreparedStatementCollection2)this.dataTableRead.get((Object)tName);
        if (psc != null) {
            return psc;
        }
        return this.doGetStatementCollection(dt, tName);
    }

    private synchronized PreparedStatementCollection2 doGetStatementCollection(Date dt, String tName) throws PersistenceException {
        PreparedStatementCollection2 psc = (PreparedStatementCollection2)this.dataTableRead.get((Object)tName);
        if (psc != null) {
            return psc;
        }
        try {
            try {
                String s1 = "SELECT * FROM \"DATA" + tName + "\";";
                PreparedStatement ps = this.session.prepare(s1);
            }
            catch (InvalidQueryException e) {
                StringBuilder sb = new StringBuilder();
                sb.append("CREATE TABLE \"DATA");
                sb.append(tName);
                sb.append("\" (");
                this.appendField(sb, "ADDR_DST_DIGITS", "ascii");
                this.appendField(sb, "ADDR_DST_TON", "int");
                this.appendField(sb, "ADDR_DST_NPI", "int");
                this.appendField(sb, "ID", "uuid");
                this.appendField(sb, "TARGET_ID", "ascii");
                this.appendField(sb, "DUE_SLOT", "bigint");
                this.appendField(sb, "IN_SYSTEM_SLOT", "bigint");
                this.appendField(sb, "ADDR_SRC_DIGITS", "ascii");
                this.appendField(sb, "ADDR_SRC_TON", "int");
                this.appendField(sb, "ADDR_SRC_NPI", "int");
                this.appendField(sb, "DUE_DELAY", "int");
                this.appendField(sb, "ALERTING_SUPPORTED", "boolean");
                this.appendField(sb, "MESSAGE_ID", "bigint");
                this.appendField(sb, "MO_MESSAGE_REF", "int");
                this.appendField(sb, "ORIG_ESME_NAME", "text");
                this.appendField(sb, "ORIG_SYSTEM_ID", "text");
                this.appendField(sb, "DEST_CLUSTER_NAME", "text");
                this.appendField(sb, "DEST_ESME_NAME", "text");
                this.appendField(sb, "DEST_SYSTEM_ID", "text");
                this.appendField(sb, "SUBMIT_DATE", "timestamp");
                this.appendField(sb, "DELIVERY_DATE", "timestamp");
                this.appendField(sb, "SERVICE_TYPE", "text");
                this.appendField(sb, "ESM_CLASS", "int");
                this.appendField(sb, "PROTOCOL_ID", "int");
                this.appendField(sb, "PRIORITY", "int");
                this.appendField(sb, "REGISTERED_DELIVERY", "int");
                this.appendField(sb, "REPLACE", "int");
                this.appendField(sb, "DATA_CODING", "int");
                this.appendField(sb, "DEFAULT_MSG_ID", "int");
                this.appendField(sb, "MESSAGE", "blob");
                this.appendField(sb, "OPTIONAL_PARAMETERS", "text");
                this.appendField(sb, "SCHEDULE_DELIVERY_TIME", "timestamp");
                this.appendField(sb, "VALIDITY_PERIOD", "timestamp");
                this.appendField(sb, "IMSI", "ascii");
                this.appendField(sb, "NNN_DIGITS", "ascii");
                this.appendField(sb, "NNN_AN", "int");
                this.appendField(sb, "NNN_NP", "int");
                this.appendField(sb, "SM_STATUS", "int");
                this.appendField(sb, "SM_TYPE", "int");
                this.appendField(sb, "DELIVERY_COUNT", "int");
                sb.append("PRIMARY KEY (\"");
                sb.append("TARGET_ID");
                sb.append("\", \"");
                sb.append("ID");
                sb.append("\"");
                sb.append("));");
                String s2 = sb.toString();
                PreparedStatement ps = this.session.prepare(s2);
                BoundStatement boundStatement = new BoundStatement(ps);
                ResultSet res = this.session.execute((Statement)boundStatement);
                sb = new StringBuilder();
                sb.append("CREATE TABLE \"SLOTS");
                sb.append(tName);
                sb.append("\" (");
                this.appendField(sb, "DUE_SLOT", "bigint");
                this.appendField(sb, "TARGET_ID", "ascii");
                this.appendField(sb, "PROCESSED", "boolean");
                sb.append("PRIMARY KEY (\"");
                sb.append("DUE_SLOT");
                sb.append("\", \"");
                sb.append("TARGET_ID");
                sb.append("\"");
                sb.append("));");
                s2 = sb.toString();
                ps = this.session.prepare(s2);
                boundStatement = new BoundStatement(ps);
                res = this.session.execute((Statement)boundStatement);
                sb = new StringBuilder();
                sb.append("CREATE TABLE \"DESTS");
                sb.append(tName);
                sb.append("\" (");
                this.appendField(sb, "TARGET_ID", "ascii");
                this.appendField(sb, "ID", "uuid");
                this.appendField(sb, "SENT", "boolean");
                sb.append("PRIMARY KEY (\"");
                sb.append("TARGET_ID");
                sb.append("\", \"");
                sb.append("ID");
                sb.append("\"");
                sb.append("));");
                s2 = sb.toString();
                ps = this.session.prepare(s2);
                boundStatement = new BoundStatement(ps);
                res = this.session.execute((Statement)boundStatement);
            }
        }
        catch (Exception e1) {
            String msg = "Failed to access or create table " + tName + "!";
            throw new PersistenceException(msg, (Throwable)e1);
        }
        psc = new PreparedStatementCollection2(tName);
        this.dataTableRead.putEntry((Object)tName, (Object)psc);
        return psc;
    }

    public long getDueSlotForTime(Date time) {
        long a2 = time.getTime();
        long a1 = this.slotOrigDate.getTime();
        long diff = a2 - a1;
        long res = diff / (long)this.slotSecondsTimeArea / 1000L;
        return res;
    }

    public Date getTimeForDueSlot(long dueSlot) {
        return null;
    }

    public long getProcessingDueSlot() {
        return 0L;
    }

    public void setProcessingDueSlot(long val) {
    }

    public long getStoringDueSlot() {
        return 0L;
    }

    public void registerDueSlotWriting(long dueSlot) {
    }

    public void unregisterDueSlotWriting(long dueSlot) {
    }

    protected String getTableName(long dueSlot) {
        return null;
    }

    protected String getTableName(Date dt) {
        StringBuilder sb = new StringBuilder();
        sb.append("_");
        sb.append(dt.getYear() + 1900);
        sb.append("_");
        int mn = dt.getMonth() + 1;
        if (mn >= 10) {
            sb.append(mn);
        } else {
            sb.append("0");
            sb.append(mn);
        }
        if (this.dataTableDaysTimeArea >= 1 && this.dataTableDaysTimeArea < 30) {
            int dy = dt.getDate();
            int fNum = dy / this.dataTableDaysTimeArea + 1;
            sb.append("_");
            if (fNum >= 10) {
                sb.append(fNum);
            } else {
                sb.append("0");
                sb.append(fNum);
            }
        }
        return sb.toString();
    }

    protected String getTableName4(long dueSlot) {
        long l1 = dueSlot / this.dueSlotsInTable + 1L;
        StringBuilder sb = new StringBuilder();
        sb.append("_");
        String s1 = Long.toString(l1);
        for (int i1 = 9 - s1.length(); i1 > 0; --i1) {
            sb.append("0");
        }
        sb.append(s1);
        return sb.toString();
    }

    private PreparedStatementCollection4 getStatementCollection4(long dueSlot) throws PersistenceException {
        String tName = this.getTableName4(dueSlot);
        PreparedStatementCollection4 psc = (PreparedStatementCollection4)this.dataTableRead4.get((Object)tName);
        if (psc != null) {
            return psc;
        }
        return this.doGetStatementCollection4(tName);
    }

    private PreparedStatementCollection3 getStatementCollection3(Date dt) throws PersistenceException {
        String tName = this.getTableName(dt);
        PreparedStatementCollection3 psc = (PreparedStatementCollection3)this.dataTableRead3.get((Object)tName);
        if (psc != null) {
            return psc;
        }
        return this.doGetStatementCollection3(tName);
    }

    private synchronized PreparedStatementCollection4 doGetStatementCollection4(String tName) throws PersistenceException {
        PreparedStatementCollection4 psc = (PreparedStatementCollection4)this.dataTableRead4.get((Object)tName);
        if (psc != null) {
            return psc;
        }
        try {
            try {
                String s1 = "SELECT * FROM \"DST_SLOT_TABLE" + tName + "\";";
                PreparedStatement ps = this.session.prepare(s1);
            }
            catch (InvalidQueryException e) {
                StringBuilder sb = new StringBuilder();
                sb.append("CREATE TABLE \"DST_SLOT_TABLE");
                sb.append(tName);
                sb.append("\" (");
                this.appendField(sb, "TARGET_ID", "ascii");
                this.appendField(sb, "DUE_SLOT", "bigint");
                sb.append("PRIMARY KEY (\"");
                sb.append("TARGET_ID");
                sb.append("\"");
                sb.append("));");
                String s2 = sb.toString();
                PreparedStatement ps = this.session.prepare(s2);
                BoundStatement boundStatement = new BoundStatement(ps);
                ResultSet res = this.session.execute((Statement)boundStatement);
            }
        }
        catch (Exception e1) {
            String msg = "Failed to access or create table " + tName + "!";
            throw new PersistenceException(msg, (Throwable)e1);
        }
        psc = new PreparedStatementCollection4(tName);
        this.dataTableRead4.putEntry((Object)tName, (Object)psc);
        return psc;
    }

    private synchronized PreparedStatementCollection3 doGetStatementCollection3(String tName) throws PersistenceException {
        PreparedStatementCollection3 psc = (PreparedStatementCollection3)this.dataTableRead3.get((Object)tName);
        if (psc != null) {
            return psc;
        }
        try {
            try {
                String s1 = "SELECT * FROM \"SLOT_MESSAGES_TABLE" + tName + "\";";
                PreparedStatement ps = this.session.prepare(s1);
            }
            catch (InvalidQueryException e) {
                StringBuilder sb = new StringBuilder();
                sb.append("CREATE TABLE \"SLOT_MESSAGES_TABLE");
                sb.append(tName);
                sb.append("\" (");
                this.appendField(sb, "ID", "uuid");
                this.appendField(sb, "TARGET_ID", "ascii");
                this.appendField(sb, "DUE_SLOT", "bigint");
                this.appendField(sb, "IN_SYSTEM", "bigint");
                this.appendField(sb, "ADDR_DST_DIGITS", "ascii");
                this.appendField(sb, "ADDR_DST_TON", "int");
                this.appendField(sb, "ADDR_DST_NPI", "int");
                this.appendField(sb, "ADDR_SRC_DIGITS", "ascii");
                this.appendField(sb, "ADDR_SRC_TON", "int");
                this.appendField(sb, "ADDR_SRC_NPI", "int");
                this.appendField(sb, "DUE_DELAY", "int");
                this.appendField(sb, "ALERTING_SUPPORTED", "boolean");
                this.appendField(sb, "MESSAGE_ID", "bigint");
                this.appendField(sb, "MO_MESSAGE_REF", "int");
                this.appendField(sb, "ORIG_ESME_NAME", "text");
                this.appendField(sb, "ORIG_SYSTEM_ID", "text");
                this.appendField(sb, "DEST_CLUSTER_NAME", "text");
                this.appendField(sb, "DEST_ESME_NAME", "text");
                this.appendField(sb, "DEST_SYSTEM_ID", "text");
                this.appendField(sb, "SUBMIT_DATE", "timestamp");
                this.appendField(sb, "DELIVERY_DATE", "timestamp");
                this.appendField(sb, "SERVICE_TYPE", "text");
                this.appendField(sb, "ESM_CLASS", "int");
                this.appendField(sb, "PROTOCOL_ID", "int");
                this.appendField(sb, "PRIORITY", "int");
                this.appendField(sb, "REGISTERED_DELIVERY", "int");
                this.appendField(sb, "REPLACE", "int");
                this.appendField(sb, "DATA_CODING", "int");
                this.appendField(sb, "DEFAULT_MSG_ID", "int");
                this.appendField(sb, "MESSAGE", "blob");
                this.appendField(sb, "OPTIONAL_PARAMETERS", "text");
                this.appendField(sb, "SCHEDULE_DELIVERY_TIME", "timestamp");
                this.appendField(sb, "VALIDITY_PERIOD", "timestamp");
                this.appendField(sb, "IMSI", "ascii");
                this.appendField(sb, "NNN_DIGITS", "ascii");
                this.appendField(sb, "NNN_AN", "int");
                this.appendField(sb, "NNN_NP", "int");
                this.appendField(sb, "SM_STATUS", "int");
                this.appendField(sb, "SM_TYPE", "int");
                this.appendField(sb, "DELIVERY_COUNT", "int");
                sb.append("PRIMARY KEY ((\"");
                sb.append("DUE_SLOT");
                sb.append("\"), \"");
                sb.append("TARGET_ID");
                sb.append("\", \"");
                sb.append("ID");
                sb.append("\"");
                sb.append("));");
                String s2 = sb.toString();
                PreparedStatement ps = this.session.prepare(s2);
                BoundStatement boundStatement = new BoundStatement(ps);
                ResultSet res = this.session.execute((Statement)boundStatement);
            }
        }
        catch (Exception e1) {
            String msg = "Failed to access or create table " + tName + "!";
            throw new PersistenceException(msg, (Throwable)e1);
        }
        psc = new PreparedStatementCollection3(tName);
        this.dataTableRead3.putEntry((Object)tName, (Object)psc);
        return psc;
    }

    public long getCurDueSlot() throws PersistenceException {
        if (this.nextDueSlotTime == 0L) {
            this.currentDueSlot = this.doGetCurDueSlot();
            return this.currentDueSlot;
        }
        long cur = new Date().getTime();
        if (cur > this.nextDueSlotTime) {
            long inc = this.millisecInDueSlot / (cur - this.nextDueSlotTime) + 1L;
            this.nextDueSlotTime += cur * this.millisecInDueSlot;
            this.currentDueSlot += cur;
        }
        return this.currentDueSlot;
    }

    private synchronized long doGetCurDueSlot() throws PersistenceException {
        if (this.currentDueSlot != 0L) {
            return this.currentDueSlot;
        }
        try {
            try {
                String sa = "SELECT \"NEXT_SLOT\" FROM \"CURRENT_SLOT_TABLE\" where \"ID\"=0;";
                PreparedStatement ps = this.session.prepare(sa);
            }
            catch (InvalidQueryException e) {
                StringBuilder sb = new StringBuilder();
                sb.append("CREATE TABLE \"");
                sb.append("CURRENT_SLOT_TABLE");
                sb.append("\" (");
                this.appendField(sb, "ID", "int");
                this.appendField(sb, "NEXT_SLOT", "bigint");
                sb.append("PRIMARY KEY (\"");
                sb.append("ID");
                sb.append("\"");
                sb.append("));");
                String s2 = sb.toString();
                PreparedStatement ps = this.session.prepare(s2);
                BoundStatement boundStatement = new BoundStatement(ps);
                ResultSet res = this.session.execute((Statement)boundStatement);
            }
        }
        catch (Exception e1) {
            String msg = "Failed to access or create table CURRENT_SLOT_TABLE!";
            throw new PersistenceException(msg, (Throwable)e1);
        }
        this.nextDueSlotTime = new Date().getTime() + this.millisecInDueSlot;
        return this.currentDueSlot;
    }

    private long createNextDueSlot() throws PersistenceException {
        try {
            long l = this.doSelectNewTimeSlot();
            return l;
        }
        catch (Exception e1) {
            String msg = "Failed to execute createNextDueSlot() !";
            throw new PersistenceException(msg, (Throwable)e1);
        }
    }

    private long doSelectNewTimeSlot() {
        BoundStatement boundStatement = new BoundStatement(this.selectCurrentSlotTable);
        ResultSet res = this.session.execute((Statement)boundStatement);
        long l = 0L;
        Iterator i$ = res.iterator();
        if (i$.hasNext()) {
            Row row = (Row)i$.next();
            l = row.getLong(0);
        }
        boundStatement = new BoundStatement(this.updateCurrentSlotTable);
        boundStatement.bind(new Object[]{0, ++l});
        res = this.session.execute((Statement)boundStatement);
        return l;
    }

    public long getNextDueSlotForTargetId(PreparedStatementCollection3 psc, String targetId) throws PersistenceException {
        long l = this.getDueSlotForTargetId(psc, targetId);
        if (l == 0L) {
            this.createDueSlotForTargetId(psc, targetId, l);
        }
        return l;
    }

    private long getDueSlotForTargetId(PreparedStatementCollection3 psc, String targetId) throws PersistenceException {
        try {
            PreparedStatement ps = psc.getDueSlotForTargetId;
            BoundStatement boundStatement = new BoundStatement(ps);
            boundStatement.bind(new Object[]{targetId});
            ResultSet res = this.session.execute((Statement)boundStatement);
            long l = 0L;
            Iterator i$ = res.iterator();
            if (i$.hasNext()) {
                Row row = (Row)i$.next();
                l = row.getLong(0);
            }
            return l;
        }
        catch (Exception e1) {
            String msg = "Failed to execute getDueSlotForTargetId() !";
            throw new PersistenceException(msg, (Throwable)e1);
        }
    }

    private void createDueSlotForTargetId(PreparedStatementCollection3 psc, String targetId, long newDueSlot) throws PersistenceException {
        try {
            PreparedStatement ps = psc.createDueSlotForTargetId;
            BoundStatement boundStatement = new BoundStatement(ps);
            boundStatement.bind(new Object[]{targetId, newDueSlot});
            ResultSet res = this.session.execute((Statement)boundStatement);
        }
        catch (Exception e1) {
            String msg = "Failed to execute createDueSlotForTargetId() !";
            throw new PersistenceException(msg, (Throwable)e1);
        }
    }

    public void createRecord_sch2(Sms sms) throws PersistenceException {
        PreparedStatementCollection3 psc = this.getStatementCollection3(sms.getSubmitDate());
        long dueSlot = this.getNextDueSlotForTargetId(psc, sms.getSmsSet().getTargetId());
        try {
            PreparedStatement ps = psc.createRecordData;
            BoundStatement boundStatement = new BoundStatement(ps);
            boundStatement.setString("ADDR_DST_DIGITS", sms.getSmsSet().getDestAddr());
            boundStatement.setInt("ADDR_DST_TON", sms.getSmsSet().getDestAddrTon());
            boundStatement.setInt("ADDR_DST_NPI", sms.getSmsSet().getDestAddrNpi());
            boundStatement.setUUID("ID", sms.getDbId());
            boundStatement.setString("TARGET_ID", sms.getSmsSet().getTargetId());
            boundStatement.setLong("DUE_SLOT", dueSlot);
            if (sms.getSourceAddr() != null) {
                boundStatement.setString("ADDR_SRC_DIGITS", sms.getSourceAddr());
            }
            boundStatement.setLong("IN_SYSTEM", 0L);
            boundStatement.setInt("ADDR_SRC_TON", sms.getSourceAddrTon());
            boundStatement.setInt("ADDR_SRC_NPI", sms.getSourceAddrNpi());
            boundStatement.setInt("DUE_DELAY", sms.getSmsSet().getDueDelay());
            if (sms.getSmsSet().getStatus() != null) {
                boundStatement.setInt("SM_STATUS", sms.getSmsSet().getStatus().getCode());
            }
            boundStatement.setBool("ALERTING_SUPPORTED", sms.getSmsSet().isAlertingSupported());
            boundStatement.setLong("MESSAGE_ID", sms.getMessageId());
            boundStatement.setInt("MO_MESSAGE_REF", sms.getMoMessageRef());
            if (sms.getOrigEsmeName() != null) {
                boundStatement.setString("ORIG_ESME_NAME", sms.getOrigEsmeName());
            }
            if (sms.getOrigSystemId() != null) {
                boundStatement.setString("ORIG_SYSTEM_ID", sms.getOrigSystemId());
            }
            if (sms.getSubmitDate() != null) {
                DBOperations.setBoundStatementDate((BoundStatement)boundStatement, (String)"SUBMIT_DATE", (Date)sms.getSubmitDate());
            }
            if (sms.getServiceType() != null) {
                boundStatement.setString("SERVICE_TYPE", sms.getServiceType());
            }
            boundStatement.setInt("ESM_CLASS", sms.getEsmClass());
            boundStatement.setInt("PROTOCOL_ID", sms.getProtocolId());
            boundStatement.setInt("PRIORITY", sms.getPriority());
            boundStatement.setInt("REGISTERED_DELIVERY", sms.getRegisteredDelivery());
            boundStatement.setInt("REPLACE", sms.getReplaceIfPresent());
            boundStatement.setInt("DATA_CODING", sms.getDataCoding());
            boundStatement.setInt("DEFAULT_MSG_ID", sms.getDefaultMsgId());
            if (sms.getShortMessage() != null) {
                boundStatement.setBytes("MESSAGE", ByteBuffer.wrap(sms.getShortMessage()));
            }
            if (sms.getScheduleDeliveryTime() != null) {
                DBOperations.setBoundStatementDate((BoundStatement)boundStatement, (String)"SCHEDULE_DELIVERY_TIME", (Date)sms.getScheduleDeliveryTime());
            }
            if (sms.getValidityPeriod() != null) {
                DBOperations.setBoundStatementDate((BoundStatement)boundStatement, (String)"VALIDITY_PERIOD", (Date)sms.getValidityPeriod());
            }
            boundStatement.setInt("DELIVERY_COUNT", sms.getDeliveryCount());
            if (sms.getTlvSet().getOptionalParameterCount() > 0) {
                try {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    XMLObjectWriter writer = XMLObjectWriter.newInstance((OutputStream)baos);
                    writer.setIndentation("\t");
                    writer.write((Object)sms.getTlvSet(), TLV_SET, TlvSet.class);
                    writer.close();
                    byte[] rawData = baos.toByteArray();
                    String serializedEvent = new String(rawData);
                    boundStatement.setString("OPTIONAL_PARAMETERS", serializedEvent);
                }
                catch (XMLStreamException e) {
                    String msg = "XMLStreamException when serializing optional parameters for '" + sms.getDbId() + "'!";
                    throw new PersistenceException(msg, (Throwable)e);
                }
            }
            ResultSet res = this.session.execute((Statement)boundStatement);
        }
        catch (Exception e1) {
            String msg = "Failed createRecord !";
            throw new PersistenceException(msg, (Throwable)e1);
        }
    }

    private void appendField(StringBuilder sb, String name, String type) {
        sb.append("\"");
        sb.append(name);
        sb.append("\" ");
        sb.append(type);
        sb.append(", ");
    }

    private void appendIndex(String tName, String fieldName) {
        StringBuilder sb = new StringBuilder();
        sb.append("CREATE INDEX ON \"");
        sb.append(tName);
        sb.append("\" (\"");
        sb.append(fieldName);
        sb.append("\");");
        String s2 = sb.toString();
        PreparedStatement ps = this.session.prepare(s2);
        BoundStatement boundStatement = new BoundStatement(ps);
        ResultSet res = this.session.execute((Statement)boundStatement);
    }

    protected Sms createSms(Row row, SmsSet smsSet) throws PersistenceException {
        if (row == null) {
            return null;
        }
        Sms sms = new Sms();
        sms.setDbId(row.getUUID("ID"));
        String srcAddr = null;
        int srcAddrTon = -1;
        int srcAddrNpi = -1;
        srcAddr = row.getString("ADDR_SRC_DIGITS");
        srcAddrTon = row.getInt("ADDR_SRC_TON");
        srcAddrNpi = row.getInt("ADDR_SRC_NPI");
        sms.setMessageId(row.getLong("MESSAGE_ID"));
        sms.setMoMessageRef(row.getInt("MO_MESSAGE_REF"));
        sms.setOrigEsmeName(row.getString("ORIG_ESME_NAME"));
        sms.setOrigSystemId(row.getString("ORIG_SYSTEM_ID"));
        sms.setSubmitDate(DBOperations.getRowDate((Row)row, (String)"SUBMIT_DATE"));
        sms.setSourceAddr(row.getString("ADDR_SRC_DIGITS"));
        sms.setSourceAddrTon(row.getInt("ADDR_SRC_TON"));
        sms.setSourceAddrNpi(row.getInt("ADDR_SRC_NPI"));
        sms.setServiceType(row.getString("SERVICE_TYPE"));
        sms.setEsmClass(row.getInt("ESM_CLASS"));
        sms.setProtocolId(row.getInt("PROTOCOL_ID"));
        sms.setPriority(row.getInt("PRIORITY"));
        sms.setRegisteredDelivery(row.getInt("REGISTERED_DELIVERY"));
        sms.setReplaceIfPresent(row.getInt("REPLACE"));
        sms.setDataCoding(row.getInt("DATA_CODING"));
        sms.setDefaultMsgId(row.getInt("DEFAULT_MSG_ID"));
        ByteBuffer bb = row.getBytes("MESSAGE");
        byte[] buf = new byte[bb.limit() - bb.position()];
        bb.get(buf);
        sms.setShortMessage(buf);
        sms.setScheduleDeliveryTime(DBOperations.getRowDate((Row)row, (String)"SCHEDULE_DELIVERY_TIME"));
        sms.setValidityPeriod(DBOperations.getRowDate((Row)row, (String)"VALIDITY_PERIOD"));
        sms.setDeliveryCount(row.getInt("DELIVERY_COUNT"));
        String s = row.getString("OPTIONAL_PARAMETERS");
        if (s != null) {
            try {
                ByteArrayInputStream bais = new ByteArrayInputStream(s.getBytes());
                XMLObjectReader reader = XMLObjectReader.newInstance((InputStream)bais);
                TlvSet copy = (TlvSet)reader.read(TLV_SET, TlvSet.class);
                sms.getTlvSet().clearAllOptionalParameter();
                sms.getTlvSet().addAllOptionalParameter((Collection)copy.getOptionalParameters());
            }
            catch (XMLStreamException e) {
                String msg = "XMLStreamException when deserializing optional parameters for '" + sms.getDbId() + "'!";
                throw new PersistenceException(msg, (Throwable)e);
            }
        }
        if (smsSet == null) {
            smsSet = new SmsSet();
            String destAddr = null;
            int destAddrTon = -1;
            int destAddrNpi = -1;
            destAddr = row.getString("ADDR_DST_DIGITS");
            destAddrTon = row.getInt("ADDR_DST_TON");
            destAddrNpi = row.getInt("ADDR_DST_NPI");
            if (destAddr == null || destAddrTon == -1 || destAddrNpi == -1) {
                throw new PersistenceException("destAddr or destAddrTon or destAddrNpi is absent for ID='" + sms.getDbId() + "'");
            }
            smsSet.setDestAddr(destAddr);
            smsSet.setDestAddrTon(destAddrTon);
            smsSet.setDestAddrNpi(destAddrNpi);
            smsSet.updateDueDelay(row.getInt("DUE_DELAY"));
        }
        smsSet.addSms(sms);
        return sms;
    }

    private String getFillUpdateFields() {
        StringBuilder sb = new StringBuilder();
        sb.append("\"");
        sb.append("ADDR_DST_DIGITS");
        sb.append("\", \"");
        sb.append("ADDR_DST_TON");
        sb.append("\", \"");
        sb.append("ADDR_DST_NPI");
        sb.append("\", \"");
        sb.append("ID");
        sb.append("\", \"");
        sb.append("TARGET_ID");
        sb.append("\", \"");
        sb.append("DUE_SLOT");
        sb.append("\", \"");
        sb.append("ADDR_SRC_DIGITS");
        sb.append("\", \"");
        sb.append("ADDR_SRC_TON");
        sb.append("\", \"");
        sb.append("ADDR_SRC_NPI");
        sb.append("\", \"");
        sb.append("DUE_DELAY");
        sb.append("\", \"");
        sb.append("SM_STATUS");
        sb.append("\", \"");
        sb.append("ALERTING_SUPPORTED");
        sb.append("\", \"");
        sb.append("MESSAGE_ID");
        sb.append("\", \"");
        sb.append("MO_MESSAGE_REF");
        sb.append("\", \"");
        sb.append("ORIG_ESME_NAME");
        sb.append("\", \"");
        sb.append("ORIG_SYSTEM_ID");
        sb.append("\", \"");
        sb.append("SUBMIT_DATE");
        sb.append("\", \"");
        sb.append("SERVICE_TYPE");
        sb.append("\", \"");
        sb.append("ESM_CLASS");
        sb.append("\", \"");
        sb.append("PROTOCOL_ID");
        sb.append("\", \"");
        sb.append("PRIORITY");
        sb.append("\", \"");
        sb.append("REGISTERED_DELIVERY");
        sb.append("\", \"");
        sb.append("REPLACE");
        sb.append("\", \"");
        sb.append("DATA_CODING");
        sb.append("\", \"");
        sb.append("DEFAULT_MSG_ID");
        sb.append("\", \"");
        sb.append("MESSAGE");
        sb.append("\", \"");
        sb.append("SCHEDULE_DELIVERY_TIME");
        sb.append("\", \"");
        sb.append("VALIDITY_PERIOD");
        sb.append("\", \"");
        sb.append("DELIVERY_COUNT");
        sb.append("\", \"");
        sb.append("OPTIONAL_PARAMETERS");
        sb.append("\"");
        return sb.toString();
    }

    private String getFillUpdateFields2() {
        int cnt = 30;
        StringBuilder sb = new StringBuilder();
        boolean i2 = false;
        for (int i1 = 0; i1 < cnt; ++i1) {
            if (!i2) {
                i2 = true;
            } else {
                sb.append(", ");
            }
            sb.append("?");
        }
        return sb.toString();
    }

    private class PreparedStatementCollection4 {
        private String tName;

        public PreparedStatementCollection4(String tName) {
            this.tName = tName;
        }
    }

    private class PreparedStatementCollection3 {
        private String tName;
        private PreparedStatement createDueSlotForTargetId;
        private PreparedStatement getDueSlotForTargetId;
        private PreparedStatement createRecordData;

        public PreparedStatementCollection3(String tName) {
            this.tName = tName;
            try {
                String s1 = NN_DBOper.this.getFillUpdateFields();
                String s2 = NN_DBOper.this.getFillUpdateFields2();
                String sa = "INSERT INTO \"DST_SLOT_TABLE" + tName + "\" (\"" + "TARGET_ID" + "\", \"" + "DUE_SLOT" + "\") VALUES (?, ?);";
                this.createDueSlotForTargetId = NN_DBOper.this.session.prepare(sa);
                sa = "SELECT \"DUE_SLOT\" FROM \"DST_SLOT_TABLE" + tName + "\" where \"" + "TARGET_ID" + "\"=?;";
                this.getDueSlotForTargetId = NN_DBOper.this.session.prepare(sa);
                sa = "INSERT INTO \"SLOT_MESSAGES_TABLE" + tName + "\" (\"" + "IN_SYSTEM" + "\", " + s1 + ") VALUES (?, " + s2 + ");";
                this.createRecordData = NN_DBOper.this.session.prepare(sa);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    private class PreparedStatementCollection2 {
        private String tName;
        private PreparedStatement createRecordData;
        private PreparedStatement createRecordSlots;
        private PreparedStatement createRecordDests;
        private PreparedStatement deleteRecordSlots;
        private PreparedStatement getIdListDests;
        private PreparedStatement getSms;
        private PreparedStatement updateRecordDests;

        public PreparedStatementCollection2(String tName) {
            this.tName = tName;
            try {
                String s1 = NN_DBOper.this.getFillUpdateFields();
                String s2 = NN_DBOper.this.getFillUpdateFields2();
                String sa = "INSERT INTO \"DATA" + tName + "\" (" + s1 + ") VALUES (" + s2 + ");";
                this.createRecordData = NN_DBOper.this.session.prepare(sa);
                sa = "INSERT INTO \"SLOTS" + tName + "\" (\"" + "DUE_SLOT" + "\", \"" + "TARGET_ID" + "\") VALUES (?, ?);";
                this.createRecordSlots = NN_DBOper.this.session.prepare(sa);
                sa = "INSERT INTO \"DESTS" + tName + "\" (\"" + "TARGET_ID" + "\", \"" + "ID" + "\", \"" + "SENT" + "\") VALUES (?, ?, ?);";
                this.createRecordDests = NN_DBOper.this.session.prepare(sa);
                sa = "DELETE FROM \"SLOTS" + tName + "\" where \"" + "DUE_SLOT" + "\"=? and \"" + "TARGET_ID" + "\"=?;";
                this.deleteRecordSlots = NN_DBOper.this.session.prepare(sa);
                sa = "SELECT \"ID\", \"SENT\" FROM \"DESTS" + tName + "\" where \"" + "TARGET_ID" + "\"=?;";
                this.getIdListDests = NN_DBOper.this.session.prepare(sa);
                sa = "SELECT * FROM \"DATA" + tName + "\" where \"" + "TARGET_ID" + "\"=? and \"" + "ID" + "\"=?;";
                this.getSms = NN_DBOper.this.session.prepare(sa);
                sa = "UPDATE \"DESTS" + tName + "\" SET \"" + "SENT" + "\"=true where \"" + "TARGET_ID" + "\"=? and \"" + "ID" + "\"=?;";
                this.updateRecordDests = NN_DBOper.this.session.prepare(sa);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }
}

