/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.smsc.tools.stresstool;

import com.cloudhopper.smpp.tlv.Tlv;
import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Statement;
import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.log4j.Logger;
import org.mobicents.smsc.cassandra.PersistenceException;
import org.mobicents.smsc.library.Sms;
import org.mobicents.smsc.library.SmsSet;
import org.mobicents.smsc.tools.stresstool.NN_LoadedTargetId;
import org.mobicents.smsc.tools.stresstool.ProcessTask;
import org.mobicents.smsc.tools.stresstool.TT_DBOperationsProxy2;

public class StressTool2 {
    private String host = "localhost";
    private int port = 9042;
    private String keyspace = "saturn";
    private int dataTableDaysTimeArea = 10;
    private int smsSetRange = 10;
    private int recordCount = 500000;
    private int threadCountW = 0;
    private int threadCountR = 10;
    private CTask task = CTask.Live_Sms_Special;
    private static final Logger logger = Logger.getLogger(StressTool2.class);
    private String persistFile = "stresstool.xml";
    private static final String TAB_INDENT = "\t";
    private TT_DBOperationsProxy2 dbOperations;
    private Queue<NN_LoadedTargetId> queue = new ConcurrentLinkedQueue<NN_LoadedTargetId>();

    public static void main(final String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    StressTool2 tool = new StressTool2();
                    tool.start(args);
                }
                catch (Exception e) {
                    logger.error((Object)("General exception: " + e.toString()), (Throwable)e);
                    e.printStackTrace();
                }
            }
        });
    }

    public void start(String[] args) throws Exception {
        this.parseParameters(args);
        this.logInfo("Stress tool starting ...");
        this.logInfo("host        : " + this.host);
        this.logInfo("port        : " + this.port);
        this.logInfo("keyspace    : " + this.keyspace);
        this.logInfo("dataTableDaysTimeArea : " + this.dataTableDaysTimeArea);
        this.logInfo("smsSetRange  : " + this.smsSetRange);
        this.logInfo("recordCount  : " + this.recordCount);
        this.logInfo("threadCountW : " + this.threadCountW);
        this.logInfo("threadCountR : " + this.threadCountR);
        this.logInfo("task         : " + (Object)((Object)this.task));
        this.dbOperations = new TT_DBOperationsProxy2();
        this.dbOperations.start(this.host, this.port, this.keyspace, this.dataTableDaysTimeArea, 30);
        Runnable ta = null;
        if (this.task == CTask.Live_Sms_Filling) {
            ta = new TA();
        } else if (this.task == CTask.Live_Sms_Cycle) {
            ta = new TX();
        } else if (this.task == CTask.Live_Sms_Special) {
            TY1 ty1 = new TY1();
            ta = ty1;
            Thread t = new Thread(ty1);
            t.start();
        }
        if (ta != null) {
            while (!ta.isReady()) {
                this.logInfo(ta.getResults());
                Thread.sleep(10000L);
            }
        }
        this.dbOperations.stop();
    }

    private void logInfo(String s) {
        logger.info((Object)s);
        System.out.print("\n");
        System.out.print(s);
    }

    private void parseParameters(String[] args) {
        for (String s : args) {
            if (s.length() <= 2) continue;
            String s1 = s.substring(0, 2);
            String s2 = s.substring(2);
            if (s1.equals("-h")) {
                this.host = s2;
                continue;
            }
            if (s1.equals("-p")) {
                this.port = Integer.parseInt(s2);
                continue;
            }
            if (s1.equals("-k")) {
                this.keyspace = s2;
                continue;
            }
            if (s1.equals("-s")) {
                this.smsSetRange = Integer.parseInt(s2);
                continue;
            }
            if (s1.equals("-c")) {
                this.recordCount = Integer.parseInt(s2);
                continue;
            }
            if (s1.equals("-t")) {
                this.threadCountW = Integer.parseInt(s2);
                continue;
            }
            if (s1.equals("-T")) {
                this.threadCountR = Integer.parseInt(s2);
                continue;
            }
            if (s1.equals("-m")) {
                this.dataTableDaysTimeArea = Integer.parseInt(s2);
                continue;
            }
            if (!s1.equals("-d")) continue;
            if (s2.equals("a")) {
                this.task = CTask.Live_Sms_Filling;
                continue;
            }
            if (!s2.equals("b")) continue;
            this.task = CTask.Live_Sms_Deleting;
        }
    }

    private String generateAddr() {
        Integer res = ThreadLocalRandom.current().nextInt(this.smsSetRange) + 1000000000;
        return res.toString();
    }

    class TY1
    implements ProcessTask,
    Runnable {
        private boolean ready = false;
        long a1;
        long a2;
        String step = "";
        Date startD2;

        @Override
        public boolean isReady() {
            return this.ready;
        }

        @Override
        public String getResults() {
            String s1;
            if (this.startD2 != null) {
                long tm = new Date().getTime() - this.startD2.getTime();
                s1 = "" + tm / 1000L;
            } else {
                s1 = "";
            }
            return this.step + ": " + this.a1 + " out of " + this.a2 + ", dur = " + s1;
        }

        @Override
        public void run() {
            try {
                int cnt_read;
                PreparedStatement ps2;
                String sb2;
                String sb;
                ResultSet res;
                int first_slot_cnt = 1;
                int due_slot_cnt = 1000;
                int inner_cnt = 1000;
                int sol = 2;
                int load_count = 1000;
                StressTool2.this.dbOperations.getStatementCollection(new Date());
                this.step = "Filling";
                String sa = "INSERT INTO \"SLOTS_2013_12_01\" (\"DUE_SLOT\", \"TARGET_ID\", \"PROCESSED\") VALUES (?, ?, ?) USING TTL 300;";
                String sa2 = "INSERT INTO \"SLOTS_2013_12_01\" (\"DUE_SLOT\", \"TARGET_ID\", \"PROCESSED\") VALUES (?, ?, ?);";
                PreparedStatement ps = StressTool2.this.dbOperations.getSession().prepare(sa);
                PreparedStatement psa = StressTool2.this.dbOperations.getSession().prepare(sa2);
                this.a1 = 0L;
                this.a2 = due_slot_cnt * inner_cnt;
                for (long i1 = (long)first_slot_cnt; i1 < (long)(first_slot_cnt + due_slot_cnt); ++i1) {
                    for (int i2 = 0; i2 < inner_cnt; ++i2) {
                        BoundStatement boundStatement = i1 < (long)(first_slot_cnt + due_slot_cnt - 10) ? new BoundStatement(ps) : new BoundStatement(psa);
                        Long I1 = i1 * 1000000L + 1000000000000L + (long)i2;
                        boundStatement.bind(new Object[]{i1, I1.toString(), false});
                        res = StressTool2.this.dbOperations.getSession().execute((Statement)boundStatement);
                        ++this.a1;
                    }
                }
                this.step = "Loading";
                this.startD2 = new Date();
                this.a1 = 0L;
                this.a2 = due_slot_cnt * inner_cnt;
                long i2 = first_slot_cnt;
                if (sol == 1) {
                    sb = "SELECT \"TARGET_ID\" from \"SLOTS_2013_11_03\" where \"DUE_SLOT\"=? limit " + load_count + ";";
                    ps = StressTool2.this.dbOperations.getSession().prepare(sb);
                    sb2 = "DELETE from \"SLOTS_2013_11_03\" where \"DUE_SLOT\"=? and \"TARGET_ID\"=?;";
                    ps2 = StressTool2.this.dbOperations.getSession().prepare(sb2);
                } else {
                    sb = "SELECT \"TARGET_ID\", \"PROCESSED\" from \"SLOTS_2013_11_03\" where \"DUE_SLOT\"=?;";
                    ps = StressTool2.this.dbOperations.getSession().prepare(sb);
                    sb2 = "UPDATE \"SLOTS_2013_11_03\" SET \"PROCESSED\"=true where \"DUE_SLOT\"=? and \"TARGET_ID\"=?;";
                    ps2 = StressTool2.this.dbOperations.getSession().prepare(sb2);
                }
                do {
                    String s;
                    BoundStatement boundStatement;
                    cnt_read = 0;
                    if (sol == 1) {
                        boundStatement = new BoundStatement(ps);
                        boundStatement.bind(new Object[]{i2});
                        res = StressTool2.this.dbOperations.getSession().execute((Statement)boundStatement);
                        for (Row row : res) {
                            s = row.getString(0);
                            ++cnt_read;
                            ++this.a1;
                            boundStatement = new BoundStatement(ps2);
                            boundStatement.bind(new Object[]{i2, s});
                            res = StressTool2.this.dbOperations.getSession().execute((Statement)boundStatement);
                        }
                    } else {
                        boundStatement = new BoundStatement(ps);
                        boundStatement.bind(new Object[]{i2});
                        res = StressTool2.this.dbOperations.getSession().execute((Statement)boundStatement);
                        for (Row row : res) {
                            s = row.getString(0);
                            boolean processed = row.getBool(1);
                            if (processed) continue;
                            ++this.a1;
                            ++cnt_read;
                            boundStatement = new BoundStatement(ps2);
                            boundStatement.bind(new Object[]{i2, s});
                            res = StressTool2.this.dbOperations.getSession().execute((Statement)boundStatement);
                        }
                    }
                } while (cnt_read != 0 || ++i2 < (long)(first_slot_cnt + due_slot_cnt));
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }

        @Override
        public void terminate() {
        }
    }

    class TX3
    implements ProcessTask,
    Runnable {
        @Override
        public boolean isReady() {
            return true;
        }

        @Override
        public String getResults() {
            return "";
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public void run() {
            while (true) lbl-1000:
            // 6 sources

            {
                if ((ti = (NN_LoadedTargetId)StressTool2.access$1000(StressTool2.this).poll()) != null) {
                    try {
                        smsSet = StressTool2.access$300(StressTool2.this).getSmsSetForTargetId(new Date[]{new Date()}, ti);
                        if (smsSet == null) ** GOTO lbl-1000
                        ii = smsSet.getSmsCount();
                        i1 = 0;
                        while (true) {
                            if ((long)i1 >= ii) ** GOTO lbl-1000
                            sms = smsSet.getSms((long)i1);
                            StressTool2.access$300(StressTool2.this).deleteIdFromDests(sms);
                            ++i1;
                        }
                    }
                    catch (PersistenceException e) {
                        StressTool2.access$000().error((Object)("Exception in task X3: " + e.toString()), (Throwable)e);
                    }
                    continue;
                }
                try {
                    Thread.sleep(100L);
                    continue;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        }

        @Override
        public void terminate() {
        }
    }

    class TX2
    implements ProcessTask,
    Runnable {
        private int startNum;
        private int endNum;
        private int curNum;
        private boolean ready;

        public TX2(int startNum, int endNum) {
            this.startNum = startNum;
            this.endNum = endNum;
            this.curNum = startNum;
        }

        @Override
        public boolean isReady() {
            return this.ready;
        }

        @Override
        public String getResults() {
            return "";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long curDueSlot = StressTool2.this.dbOperations.calculateSlot(new Date());
            curDueSlot -= 1000L;
            try {
                block7: while (true) {
                    try {
                        int cnt = 1000;
                        List<NN_LoadedTargetId> lst = StressTool2.this.dbOperations.getTargetIdListForDueSlot(new Date[]{new Date()}, curDueSlot, curDueSlot + 2L, cnt);
                        if (lst.size() == 0) {
                            ++curDueSlot;
                        }
                        this.curNum += lst.size();
                        for (NN_LoadedTargetId ti : lst) {
                            StressTool2.this.queue.add(ti);
                        }
                    }
                    catch (PersistenceException e) {
                        logger.error((Object)("Exception in task X2: " + e.toString()), (Throwable)e);
                    }
                    if (this.curNum >= this.endNum) {
                        break;
                    }
                    while (true) {
                        if (StressTool2.this.queue.size() <= 10000) continue block7;
                        Thread.sleep(10L);
                    }
                    break;
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            finally {
                this.ready = true;
            }
        }

        @Override
        public void terminate() {
        }
    }

    class TX1
    implements ProcessTask,
    Runnable {
        private int startNum;
        private int endNum;
        private int curNum;
        private boolean ready;

        public TX1(int startNum, int endNum) {
            this.startNum = startNum;
            this.endNum = endNum;
            this.curNum = startNum;
        }

        @Override
        public boolean isReady() {
            return this.ready;
        }

        @Override
        public String getResults() {
            return "";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                do {
                    Integer ii1 = this.curNum;
                    String s1 = ii1.toString();
                    int messageId = 0;
                    try {
                        SmsSet smsSet = new SmsSet();
                        smsSet.setDestAddr(s1);
                        smsSet.setDestAddrNpi(1);
                        smsSet.setDestAddrTon(1);
                        ArrayList<byte[]> bb = new ArrayList<byte[]>();
                        byte[] bf1 = new byte[10];
                        byte[] bf2 = new byte[20];
                        byte[] bf3 = new byte[30];
                        bf1[0] = 10;
                        bf2[1] = 20;
                        bf3[3] = 30;
                        bb.add(bf1);
                        bb.add(bf2);
                        bb.add(bf3);
                        for (int i1 = 0; i1 < 3; ++i1) {
                            Sms sms = new Sms();
                            sms.setSmsSet(smsSet);
                            sms.setMessageId((long)this.curNum);
                            sms.setDbId(UUID.randomUUID());
                            sms.setShortMessage((byte[])bb.get(i1));
                            sms.setDataCoding(0);
                            sms.setEsmClass(20);
                            sms.setMessageId((long)(++messageId));
                            sms.setMoMessageRef(13);
                            sms.setOrigEsmeName("A1");
                            sms.setOrigSystemId("E1");
                            sms.setPriority(3);
                            sms.setProtocolId(14);
                            sms.setRegisteredDelivery(15);
                            if (i1 == 0) {
                                sms.setScheduleDeliveryTime(new Date());
                            }
                            Integer I2 = messageId + 20000;
                            sms.setSourceAddr(I2.toString());
                            sms.setSourceAddrNpi(4);
                            sms.setSourceAddrTon(1);
                            sms.setSubmitDate(new Date());
                            sms.setValidityPeriod(new Date(new Date().getTime() + 86400000L));
                            if (i1 == 0) {
                                Tlv tlv = new Tlv(0, bf3);
                                sms.getTlvSet().addOptionalParameter(tlv);
                            }
                            long dueSlot = StressTool2.this.dbOperations.calculateSlot(sms.getSubmitDate());
                            StressTool2.this.dbOperations.createRecord(dueSlot, sms);
                        }
                    }
                    catch (PersistenceException e) {
                        logger.error((Object)("Exception in task X1: " + e.toString()), (Throwable)e);
                    }
                    ++this.curNum;
                } while (this.curNum < this.endNum);
            }
            finally {
                this.ready = true;
            }
        }

        @Override
        public void terminate() {
        }
    }

    class TX
    implements ProcessTask,
    Runnable {
        private ArrayList<TX1> tx1 = new ArrayList();
        private TX2 tx2;
        private ArrayList<TX3> tx3 = new ArrayList();

        public TX() {
            if (StressTool2.this.threadCountW > 0) {
                int num = 1000000;
                int step = StressTool2.this.recordCount / StressTool2.this.threadCountW;
                for (int i1 = 0; i1 < StressTool2.this.threadCountW; ++i1) {
                    TX1 ta = new TX1(num, num + step);
                    num += step;
                    this.tx1.add(ta);
                    Thread t = new Thread(ta);
                    t.start();
                }
            }
            if (StressTool2.this.threadCountR > 0) {
                this.tx2 = new TX2(0, StressTool2.this.recordCount);
                Thread t = new Thread(this.tx2);
                t.start();
            }
            for (int i1 = 0; i1 < StressTool2.this.threadCountR; ++i1) {
                TX3 ta = new TX3();
                this.tx3.add(ta);
                Thread t = new Thread(ta);
                t.start();
            }
        }

        @Override
        public boolean isReady() {
            for (TX1 el : this.tx1) {
                if (el.isReady()) continue;
                return false;
            }
            return this.tx2 == null || this.tx2.isReady();
        }

        @Override
        public String getResults() {
            int i1 = 0;
            for (TX1 el : this.tx1) {
                i1 += el.curNum - el.startNum;
            }
            int i2 = StressTool2.this.recordCount;
            String s1 = "Processed TX1 " + i1 + " out of " + i2 + ", processed TX2 " + (this.tx2 != null ? Integer.valueOf(this.tx2.curNum) : "") + " out of " + (this.tx2 != null ? Integer.valueOf(this.tx2.endNum - this.tx2.startNum) : "") + ", queue=" + StressTool2.this.queue.size();
            return s1;
        }

        @Override
        public void run() {
        }

        @Override
        public void terminate() {
        }
    }

    class TA
    implements ProcessTask,
    Runnable {
        private ArrayList<TA> threads = new ArrayList();
        private int startNum;
        private int endNum;
        private int curNum;
        private boolean ready;
        private boolean isMaster = false;

        public TA() {
            this.isMaster = true;
            int num = 1000000;
            int step = StressTool2.this.recordCount / StressTool2.this.threadCountW;
            for (int i1 = 0; i1 < StressTool2.this.threadCountW; ++i1) {
                TA ta = new TA(num, num + step);
                num += step;
                this.threads.add(ta);
                Thread t = new Thread(ta);
                t.start();
            }
        }

        public TA(int startNum, int endNum) {
            this.startNum = startNum;
            this.endNum = endNum;
            this.curNum = startNum;
        }

        @Override
        public boolean isReady() {
            if (this.isMaster) {
                for (TA el : this.threads) {
                    if (el.isReady()) continue;
                    return false;
                }
                return true;
            }
            return this.ready;
        }

        @Override
        public String getResults() {
            int i1 = 0;
            for (TA el : this.threads) {
                i1 += el.curNum - el.startNum;
            }
            int i2 = StressTool2.this.recordCount;
            return "Processed " + i1 + " out of " + i2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                do {
                    SmsSet smsSet = new SmsSet();
                    Integer ii1 = this.curNum;
                    String s1 = ii1.toString();
                    smsSet.setDestAddr(s1);
                    smsSet.setDestAddrNpi(1);
                    smsSet.setDestAddrTon(1);
                    Sms sms = new Sms();
                    sms.setSmsSet(smsSet);
                    sms.setMessageId((long)this.curNum);
                    sms.setDbId(UUID.randomUUID());
                    sms.setShortMessage(new byte[10]);
                    try {
                        Date dt = new Date();
                        long dueSlot = StressTool2.this.dbOperations.calculateSlot(dt);
                        StressTool2.this.dbOperations.createRecord(dueSlot, sms);
                    }
                    catch (PersistenceException e) {
                        logger.error((Object)("Exception in task A: " + e.toString()), (Throwable)e);
                    }
                    ++this.curNum;
                } while (this.curNum < this.endNum);
            }
            finally {
                this.ready = true;
            }
        }

        @Override
        public void terminate() {
        }
    }

    static enum CTask {
        Live_Sms_Filling,
        Live_Sms_Deleting,
        Live_Sms_Cycle,
        Live_Sms_Special;

    }
}

