/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.smsc.slee.services.http.server.tx.data;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.mobicents.smsc.slee.services.http.server.tx.enums.RequestMessageBodyEncoding;
import org.mobicents.smsc.slee.services.http.server.tx.enums.ResponseFormat;
import org.mobicents.smsc.slee.services.http.server.tx.exceptions.HttpApiException;

public class HttpSendMessageIncomingData {
    private String userId;
    private String password;
    private String msg;
    private ResponseFormat format;
    private RequestMessageBodyEncoding encoding;
    private String senderId;
    private List<String> destAddresses = new ArrayList<String>();
    private String scheduleDeliveryTime;

    public HttpSendMessageIncomingData(String userId, String password, String msg, String formatParam, String encodingStr, String senderId, String[] to) throws HttpApiException {
        if (this.isEmptyOrNull(userId)) {
            throw new HttpApiException("userid parameter is not set properly or not valid in the Http Request.");
        }
        if (this.isEmptyOrNull(password)) {
            throw new HttpApiException("password parameter is not set properly or not valid in the Http Request.");
        }
        if (this.isEmptyOrNull(msg)) {
            throw new HttpApiException("msg parameter is not set properly or not valid in the Http Request.");
        }
        if (this.isEmptyOrNull(senderId)) {
            throw new HttpApiException("sender parameter is not set properly or not valid in the Http Request.");
        }
        if (to == null || to.length < 1) {
            throw new HttpApiException("to parameter is not set properly or not valid in the Http Request.");
        }
        if (encodingStr == null || !RequestMessageBodyEncoding.isValid(encodingStr)) {
            throw new HttpApiException("encoding parameter is not set properly or not valid in the Http Request.");
        }
        this.userId = userId;
        this.password = password;
        try {
            this.msg = URLDecoder.decode(msg, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new HttpApiException("Unsupported exception while decoding message.");
        }
        this.senderId = senderId;
        this.destAddresses.addAll(Arrays.asList(to));
        this.encoding = RequestMessageBodyEncoding.fromString(encodingStr);
        this.format = ResponseFormat.fromString(formatParam);
    }

    private boolean isEmptyOrNull(String toCheck) {
        if (toCheck == null) {
            return true;
        }
        return "".equals(toCheck);
    }

    public List<String> getDestAddresses() {
        return this.destAddresses;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getMsg() {
        return this.msg;
    }

    public ResponseFormat getFormat() {
        return this.format;
    }

    public RequestMessageBodyEncoding getEncoding() {
        return this.encoding;
    }

    public String getSenderId() {
        return this.senderId;
    }

    public int getDefaultMsgId() {
        return -1;
    }

    public String getScheduleDeliveryTime() {
        return this.scheduleDeliveryTime;
    }

    public byte[] getShortMessage() {
        return this.msg.getBytes();
    }

    public String toString() {
        return "HttpSendMessageIncomingData{userId='" + this.userId + '\'' + ", password='" + this.password + '\'' + ", msg='" + this.msg + '\'' + ", format='" + (Object)((Object)this.format) + '\'' + ", encoding=" + (Object)((Object)this.encoding) + ", senderId='" + this.senderId + '\'' + ", destAddresses=" + this.destAddresses + ", scheduleDeliveryTime='" + this.scheduleDeliveryTime + '\'' + '}';
    }

    public static ResponseFormat getFormat(HttpServletRequest request) {
        String param = request.getParameter("format");
        return ResponseFormat.fromString(param);
    }
}

