/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.smsc.slee.services.http.server.tx.utils;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.http.HttpServletResponse;
import javax.slee.facilities.Tracer;

public class HttpUtils {
    public static void sendOkResponseWithContent(Tracer tracer, HttpServletResponse response, String content) throws IOException {
        if (tracer.isFineEnabled()) {
            tracer.info("Sending 200 OK");
        }
        response.setStatus(200);
        if (content != null) {
            if (tracer.isFineEnabled()) {
                tracer.fine("Sending 200 OK: content:" + content);
            }
            response.setContentType("application/soap+xml; charset=UTF-8");
            PrintWriter writer = response.getWriter();
            writer.write(content);
            writer.flush();
        } else {
            tracer.severe("Content is empty");
        }
        response.flushBuffer();
    }

    public static void sendErrorResponse(Tracer tracer, HttpServletResponse response, int status, String message) throws IOException {
        if (tracer.isFineEnabled()) {
            tracer.fine("Sending sendError: status:" + status + " message:" + message);
        }
        response.sendError(status, message);
        response.flushBuffer();
    }

    public static void sendErrorResponseWithContent(Tracer tracer, HttpServletResponse response, int status, String message, String content) throws IOException {
        if (tracer.isFineEnabled()) {
            tracer.fine("Sending sendErrorWithContent: status: " + status + " message: " + message + " content: " + content);
        }
        response.setStatus(status);
        response.setContentType("application/soap+xml; charset=UTF-8");
        PrintWriter writer = response.getWriter();
        writer.write(content);
        writer.flush();
        response.flushBuffer();
    }
}

