/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.smsc.slee.services.http.server.tx;

import java.io.IOException;
import java.nio.charset.Charset;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.servlet.http.HttpServletRequest;
import javax.slee.ActivityContextInterface;
import javax.slee.ActivityEndEvent;
import javax.slee.CreateException;
import javax.slee.EventContext;
import javax.slee.InitialEventSelector;
import javax.slee.RolledBackContext;
import javax.slee.Sbb;
import javax.slee.SbbContext;
import javax.slee.ServiceID;
import javax.slee.facilities.Tracer;
import javax.slee.resource.ResourceAdaptorTypeID;
import javax.slee.serviceactivity.ServiceActivity;
import javax.slee.serviceactivity.ServiceStartedEvent;
import javolution.util.FastList;
import net.java.slee.resource.http.events.HttpServletRequestEvent;
import org.mobicents.slee.ChildRelationExt;
import org.mobicents.slee.SbbContextExt;
import org.mobicents.smsc.cassandra.PersistenceException;
import org.mobicents.smsc.domain.MProcManagement;
import org.mobicents.smsc.domain.MoChargingType;
import org.mobicents.smsc.domain.SmscPropertiesManagement;
import org.mobicents.smsc.domain.SmscStatAggregator;
import org.mobicents.smsc.domain.SmscStatProvider;
import org.mobicents.smsc.domain.StoreAndForwordMode;
import org.mobicents.smsc.library.MessageState;
import org.mobicents.smsc.library.MessageUtil;
import org.mobicents.smsc.library.OriginationType;
import org.mobicents.smsc.library.QuerySmResponse;
import org.mobicents.smsc.library.SbbStates;
import org.mobicents.smsc.library.Sms;
import org.mobicents.smsc.library.SmsSet;
import org.mobicents.smsc.library.SmsSetCache;
import org.mobicents.smsc.library.SmscProcessingException;
import org.mobicents.smsc.library.TargetAddress;
import org.mobicents.smsc.mproc.impl.MProcResult;
import org.mobicents.smsc.mproc.impl.PersistenseCommonInterface;
import org.mobicents.smsc.slee.resources.persistence.PersistenceRAInterface;
import org.mobicents.smsc.slee.resources.scheduler.SchedulerRaSbbInterface;
import org.mobicents.smsc.slee.services.charging.ChargingMedium;
import org.mobicents.smsc.slee.services.charging.ChargingSbbLocalObject;
import org.mobicents.smsc.slee.services.http.server.tx.SendMessageParseResult;
import org.mobicents.smsc.slee.services.http.server.tx.data.HttpGetMessageIdStatusIncomingData;
import org.mobicents.smsc.slee.services.http.server.tx.data.HttpGetMessageIdStatusOutgoingData;
import org.mobicents.smsc.slee.services.http.server.tx.data.HttpSendMessageIncomingData;
import org.mobicents.smsc.slee.services.http.server.tx.data.HttpSendMessageOutgoingData;
import org.mobicents.smsc.slee.services.http.server.tx.enums.ResponseFormat;
import org.mobicents.smsc.slee.services.http.server.tx.enums.Status;
import org.mobicents.smsc.slee.services.http.server.tx.exceptions.HttpApiException;
import org.mobicents.smsc.slee.services.http.server.tx.utils.HttpRequestUtils;
import org.mobicents.smsc.slee.services.http.server.tx.utils.HttpUtils;
import org.mobicents.smsc.slee.services.http.server.tx.utils.ResponseFormatter;

public abstract class TxHttpServerSbb
implements Sbb {
    protected static SmscPropertiesManagement smscPropertiesManagement = SmscPropertiesManagement.getInstance();
    private static final ResourceAdaptorTypeID PERSISTENCE_ID = new ResourceAdaptorTypeID("PersistenceResourceAdaptorType", "org.mobicents", "1.0");
    private static final String PERSISTENCE_LINK = "PersistenceResourceAdaptor";
    private static final ResourceAdaptorTypeID SCHEDULER_ID = new ResourceAdaptorTypeID("SchedulerResourceAdaptorType", "org.mobicents", "1.0");
    private static final String SCHEDULER_LINK = "SchedulerResourceAdaptor";
    protected Tracer logger;
    private SbbContextExt sbbContext;
    protected PersistenceRAInterface persistence = null;
    protected SchedulerRaSbbInterface scheduler = null;
    private SmscStatAggregator smscStatAggregator = SmscStatAggregator.getInstance();
    private static Charset utf8Charset = Charset.forName("UTF-8");
    private static Charset ucs2Charset = Charset.forName("UTF-16BE");
    private final String GET = "GET";
    private final String POST = "POST";
    private final String SEND_SMS = "sendSms";
    private final String MSG_QUERY = "msgQuery";

    public PersistenceRAInterface getStore() {
        return this.persistence;
    }

    public InitialEventSelector isInitialHttpRequestEvent(InitialEventSelector ies) {
        Object event;
        if (this.logger.isFinestEnabled()) {
            this.logger.finest("incomming http event: " + ies.getEvent());
        }
        if ((event = ies.getEvent()) instanceof HttpServletRequestEvent) {
            HttpServletRequest request = ((HttpServletRequestEvent)event).getRequest();
            String requestURL = request.getRequestURL().toString();
            if (request.getMethod().equals("GET")) {
                String[] tmp = requestURL.split("\\?");
                if (tmp[0].endsWith("sendSms") || tmp[0].endsWith("msgQuery")) {
                    ies.setInitialEvent(true);
                    return ies;
                }
            } else {
                if (request.getMethod().equals("POST") && (requestURL.endsWith("sendSms") || requestURL.endsWith("msgQuery"))) {
                    ies.setInitialEvent(true);
                    return ies;
                }
                if (this.logger.isFinestEnabled()) {
                    this.logger.finest(request.getMethod() + " this method is not supported!");
                }
            }
        }
        ies.setInitialEvent(false);
        if (this.logger.isFinestEnabled()) {
            this.logger.finest("this is not an initial event!");
        }
        return ies;
    }

    public void onHttpGet(HttpServletRequestEvent event, ActivityContextInterface aci) {
        block7: {
            this.logger.fine("onHttpGet");
            HttpServletRequest request = event.getRequest();
            try {
                if (this.checkCharging()) {
                    String message = "The operation is forbidden";
                    HttpUtils.sendErrorResponse(this.logger, event.getResponse(), 403, "The operation is forbidden");
                    break block7;
                }
                String requestURL = request.getRequestURL().toString();
                String[] tmp = requestURL.split("\\?");
                if (tmp[0].endsWith("sendSms")) {
                    this.processHttpSendMessageEvent(event, aci);
                    break block7;
                }
                if (tmp[0].endsWith("msgQuery")) {
                    this.processHttpGetMessageIdStatusEvent(event, aci);
                    break block7;
                }
                throw new HttpApiException("Unknown operation on the HTTP API");
            }
            catch (Exception e) {
                this.logger.severe("Error in onHttpGet", (Throwable)e);
                try {
                    HttpSendMessageOutgoingData outgoingData = new HttpSendMessageOutgoingData();
                    outgoingData.setStatus(Status.ERROR);
                    outgoingData.setMessage(e.getMessage());
                    ResponseFormat responseFormat = HttpSendMessageIncomingData.getFormat(request);
                    HttpUtils.sendErrorResponseWithContent(this.logger, event.getResponse(), 200, outgoingData.getMessage(), ResponseFormatter.format(outgoingData, responseFormat), responseFormat);
                }
                catch (IOException ex) {
                    this.logger.severe("Error while sending error response", (Throwable)ex);
                }
            }
        }
    }

    public void onHttpPost(HttpServletRequestEvent event, ActivityContextInterface aci) {
        block7: {
            this.logger.fine("onHttpPost");
            HttpServletRequest request = event.getRequest();
            try {
                if (this.checkCharging()) {
                    String message = "The operation is forbidden";
                    HttpUtils.sendErrorResponse(this.logger, event.getResponse(), 403, "The operation is forbidden");
                    break block7;
                }
                String requestURL = request.getRequestURL().toString();
                requestURL.endsWith("sendSms");
                if (requestURL.endsWith("sendSms")) {
                    this.processHttpSendMessageEvent(event, aci);
                    break block7;
                }
                if (requestURL.endsWith("msgQuery")) {
                    this.processHttpGetMessageIdStatusEvent(event, aci);
                    break block7;
                }
                throw new HttpApiException("Unknown operation on the HTTP API. Parameter set from the request does not match any of the HTTP API services.");
            }
            catch (Exception e) {
                this.logger.severe("Error in onHttpPost", (Throwable)e);
                try {
                    HttpSendMessageOutgoingData outgoingData = new HttpSendMessageOutgoingData();
                    outgoingData.setStatus(Status.ERROR);
                    outgoingData.setMessage(e.getMessage());
                    ResponseFormat responseFormat = HttpSendMessageIncomingData.getFormat(request);
                    HttpUtils.sendErrorResponseWithContent(this.logger, event.getResponse(), 200, outgoingData.getMessage(), ResponseFormatter.format(outgoingData, responseFormat), responseFormat);
                }
                catch (IOException ex) {
                    this.logger.severe("Error while sending error response", (Throwable)ex);
                }
            }
        }
    }

    private boolean checkCharging() {
        return smscPropertiesManagement.getTxHttpCharging() != MoChargingType.accept;
    }

    private void processHttpSendMessageEvent(HttpServletRequestEvent event, ActivityContextInterface aci) throws HttpApiException {
        this.logger.fine("processHttpSendMEssageEvent");
        HttpServletRequest request = event.getRequest();
        HttpSendMessageIncomingData incomingData = null;
        incomingData = this.createSendMessageIncomingData(request);
        this.sendMessage(event, incomingData, aci);
    }

    private void processHttpGetMessageIdStatusEvent(HttpServletRequestEvent event, ActivityContextInterface aci) throws HttpApiException {
        this.logger.fine("processHttpGetMessageIdStatusEvent");
        HttpServletRequest request = event.getRequest();
        HttpGetMessageIdStatusIncomingData incomingData = this.createGetMessageIdStatusIncomingData(request);
        this.getMessageIdStatus(event, incomingData, aci);
    }

    private HttpSendMessageIncomingData createSendMessageIncomingData(HttpServletRequest request) throws HttpApiException {
        this.logger.fine("createSendMessageIncomingData");
        if ("GET".equals(request.getMethod())) {
            String userId = request.getParameter("userid");
            String password = request.getParameter("password");
            String encodedMsg = request.getParameter("msg");
            String format = request.getParameter("format");
            String encoding = request.getParameter("encoding");
            String senderId = request.getParameter("sender");
            String destAddressParam = request.getParameter("to");
            String[] destAddresses = destAddressParam != null ? destAddressParam.split(",") : new String[]{};
            return new HttpSendMessageIncomingData(userId, password, encodedMsg, format, encoding, senderId, destAddresses);
        }
        if ("POST".equals(request.getMethod())) {
            String[] destAddresses;
            String userId = request.getParameter("userid");
            String password = request.getParameter("password");
            String encodedMsg = request.getParameter("msg");
            String format = request.getParameter("format");
            String encoding = request.getParameter("encoding");
            String senderId = request.getParameter("sender");
            String destAddressParam = request.getParameter("to");
            String[] stringArray = destAddresses = destAddressParam != null ? destAddressParam.split(",") : new String[]{};
            if (userId == null && password == null && encodedMsg == null && senderId == null && destAddresses == null) {
                String[] stringArray2;
                String[] stringArray3;
                String[] stringArray4;
                String[] stringArray5;
                String[] stringArray6;
                String[] stringArray7;
                String[] stringArray8;
                Map<String, String[]> map = HttpRequestUtils.extractParametersFromPost(this.logger, request);
                String[] tmp = map.get("userid");
                if (tmp == null) {
                    String[] stringArray9 = new String[1];
                    stringArray8 = stringArray9;
                    stringArray9[0] = "";
                } else {
                    stringArray8 = tmp;
                }
                userId = stringArray8[0];
                tmp = map.get("password");
                if (tmp == null) {
                    String[] stringArray10 = new String[1];
                    stringArray7 = stringArray10;
                    stringArray10[0] = "";
                } else {
                    stringArray7 = tmp;
                }
                password = stringArray7[0];
                tmp = map.get("msg");
                if (tmp == null) {
                    String[] stringArray11 = new String[1];
                    stringArray6 = stringArray11;
                    stringArray11[0] = "";
                } else {
                    stringArray6 = tmp;
                }
                encodedMsg = stringArray6[0];
                tmp = map.get("format");
                if (tmp == null) {
                    String[] stringArray12 = new String[1];
                    stringArray5 = stringArray12;
                    stringArray12[0] = "";
                } else {
                    stringArray5 = tmp;
                }
                format = stringArray5[0];
                tmp = map.get("encoding");
                if (tmp == null) {
                    String[] stringArray13 = new String[1];
                    stringArray4 = stringArray13;
                    stringArray13[0] = "";
                } else {
                    stringArray4 = tmp;
                }
                encoding = stringArray4[0];
                tmp = map.get("sender");
                if (tmp == null) {
                    String[] stringArray14 = new String[1];
                    stringArray3 = stringArray14;
                    stringArray14[0] = "";
                } else {
                    stringArray3 = tmp;
                }
                senderId = stringArray3[0];
                tmp = map.get("to");
                if (tmp == null) {
                    String[] stringArray15 = new String[1];
                    stringArray2 = stringArray15;
                    stringArray15[0] = "";
                } else {
                    stringArray2 = tmp;
                }
                destAddresses = stringArray2;
            }
            HttpSendMessageIncomingData incomingData = new HttpSendMessageIncomingData(userId, password, encodedMsg, format, encoding, senderId, destAddresses);
            return incomingData;
        }
        throw new HttpApiException("Unsupported method of the Http Request. Method is: " + request.getMethod());
    }

    private HttpGetMessageIdStatusIncomingData createGetMessageIdStatusIncomingData(HttpServletRequest request) throws HttpApiException {
        this.logger.fine("createGetMessageIdStatusIncomingData");
        String userId = request.getParameter("userid");
        String password = request.getParameter("password");
        String msgId = request.getParameter("msgid");
        String format = request.getParameter("format");
        if (userId == null && password == null && msgId == null) {
            String[] stringArray;
            String[] stringArray2;
            String[] stringArray3;
            String[] stringArray4;
            Map<String, String[]> map = HttpRequestUtils.extractParametersFromPost(this.logger, request);
            String[] tmp = map.get("userid");
            if (tmp == null) {
                String[] stringArray5 = new String[1];
                stringArray4 = stringArray5;
                stringArray5[0] = "";
            } else {
                stringArray4 = tmp;
            }
            userId = stringArray4[0];
            tmp = map.get("password");
            if (tmp == null) {
                String[] stringArray6 = new String[1];
                stringArray3 = stringArray6;
                stringArray6[0] = "";
            } else {
                stringArray3 = tmp;
            }
            password = stringArray3[0];
            tmp = map.get("msgid");
            if (tmp == null) {
                String[] stringArray7 = new String[1];
                stringArray2 = stringArray7;
                stringArray7[0] = "";
            } else {
                stringArray2 = tmp;
            }
            msgId = stringArray2[0];
            tmp = map.get("format");
            if (tmp == null) {
                String[] stringArray8 = new String[1];
                stringArray = stringArray8;
                stringArray8[0] = "";
            } else {
                stringArray = tmp;
            }
            format = stringArray[0];
        }
        HttpGetMessageIdStatusIncomingData incomingData = new HttpGetMessageIdStatusIncomingData(userId, password, msgId, format);
        return incomingData;
    }

    public void sendMessage(HttpServletRequestEvent event, HttpSendMessageIncomingData incomingData, ActivityContextInterface aci) {
        SendMessageParseResult parseResult;
        this.logger.fine("sendMessage");
        if (this.logger.isFineEnabled()) {
            this.logger.fine("\nReceived sendMessage = " + incomingData);
        }
        HttpSendMessageOutgoingData outgoingData = new HttpSendMessageOutgoingData();
        outgoingData.setStatus(Status.ERROR);
        PersistenceRAInterface store = this.getStore();
        try {
            parseResult = this.createSmsEventMultiDest(incomingData, store);
            for (Sms sms : parseResult.getParsedMessages()) {
                this.processSms(sms, store, incomingData);
            }
        }
        catch (SmscProcessingException e1) {
            if (!e1.isSkipErrorLogging()) {
                this.logger.severe(e1.getMessage(), (Throwable)e1);
                this.smscStatAggregator.updateMsgInFailedAll();
            }
            try {
                String message = "Error while trying to send send SMS message to multiple destinations.";
                outgoingData.setStatus(Status.ERROR);
                outgoingData.setMessage("Error while trying to send send SMS message to multiple destinations.");
                HttpUtils.sendErrorResponseWithContent(this.logger, event.getResponse(), 200, "Error while trying to send send SMS message to multiple destinations.", ResponseFormatter.format(outgoingData, incomingData.getFormat()), incomingData.getFormat());
            }
            catch (IOException e) {
                this.logger.severe("Error while trying to send HttpErrorResponse", (Throwable)e);
            }
            return;
        }
        catch (Throwable e1) {
            String s = "Exception when processing SubmitMulti message: " + e1.getMessage();
            this.logger.severe(s, e1);
            this.smscStatAggregator.updateMsgInFailedAll();
            try {
                String message = "Error while trying to send SubmitMultiResponse";
                outgoingData.setStatus(Status.ERROR);
                outgoingData.setMessage("Error while trying to send SubmitMultiResponse");
                HttpUtils.sendErrorResponseWithContent(this.logger, event.getResponse(), 200, "Error while trying to send SubmitMultiResponse", ResponseFormatter.format(outgoingData, incomingData.getFormat()), incomingData.getFormat());
            }
            catch (IOException e) {
                this.logger.severe("Error while trying to send SubmitMultiResponse=", (Throwable)e);
            }
            return;
        }
        for (Sms sms : parseResult.getParsedMessages()) {
            outgoingData.put(sms.getSmsSet().getDestAddr(), sms.getMessageId());
        }
        try {
            outgoingData.setStatus(Status.SUCCESS);
            HttpUtils.sendOkResponseWithContent(this.logger, event.getResponse(), ResponseFormatter.format(outgoingData, incomingData.getFormat()), incomingData.getFormat());
        }
        catch (Throwable e) {
            this.logger.severe("Error while trying to send SubmitMultiResponse=" + outgoingData, e);
        }
    }

    private void getMessageIdStatus(HttpServletRequestEvent event, HttpGetMessageIdStatusIncomingData incomingData, ActivityContextInterface aci) throws HttpApiException {
        if (this.logger.isFineEnabled()) {
            this.logger.fine("\nReceived getMessageIdStatus = " + incomingData);
        }
        PersistenceRAInterface store = this.getStore();
        Long messageId = incomingData.getMsgId();
        QuerySmResponse querySmResponse = null;
        MessageState messageState = null;
        try {
            long msgId = messageId;
            querySmResponse = store.c2_getQuerySmResponse(msgId);
            if (querySmResponse == null) {
                throw new HttpApiException("Cannot retrieve QuerySmResponse from database. Returned object is null.");
            }
            messageState = querySmResponse.getMessageState();
            HttpGetMessageIdStatusOutgoingData outgoingData = new HttpGetMessageIdStatusOutgoingData();
            outgoingData.setStatus(Status.SUCCESS);
            outgoingData.setStatusMessage(messageState.toString());
            HttpUtils.sendOkResponseWithContent(this.logger, event.getResponse(), ResponseFormatter.format(outgoingData, incomingData.getFormat()), incomingData.getFormat());
        }
        catch (PersistenceException e) {
            throw new HttpApiException("PersistenceException while obtaining message status from the database for the message with id: " + incomingData.getMsgId());
        }
        catch (IOException e) {
            throw new HttpApiException("IOException while trying to send response ok message with content");
        }
    }

    private TargetAddress createDestTargetAddress(String addr) throws SmscProcessingException {
        if (addr == null || "".equals(addr)) {
            throw new SmscProcessingException("DestAddress digits are absent", 0, 34, (Object)addr);
        }
        int destTon = smscPropertiesManagement.getHttpDefaultDestTon();
        int destNpi = smscPropertiesManagement.getHttpDefaultDestNpi();
        int networkId = smscPropertiesManagement.getHttpDefaultNetworkId();
        TargetAddress ta = new TargetAddress(destTon, destNpi, addr, networkId);
        return ta;
    }

    public void setSbbContext(SbbContext sbbContext) {
        this.sbbContext = (SbbContextExt)sbbContext;
        try {
            Context ctx = (Context)new InitialContext().lookup("java:comp/env");
            this.logger = this.sbbContext.getTracer(this.getClass().getSimpleName());
            this.persistence = (PersistenceRAInterface)this.sbbContext.getResourceAdaptorInterface(PERSISTENCE_ID, PERSISTENCE_LINK);
            this.scheduler = (SchedulerRaSbbInterface)this.sbbContext.getResourceAdaptorInterface(SCHEDULER_ID, SCHEDULER_LINK);
        }
        catch (Exception ne) {
            this.logger.severe("Could not set SBB context:", (Throwable)ne);
        }
    }

    public void onServiceStartedEvent(ServiceStartedEvent event, ActivityContextInterface aci, EventContext eventContext) {
        ServiceID serviceID = event.getService();
        this.logger.info("Rx: onServiceStartedEvent: event=" + event + ", serviceID=" + serviceID);
        SbbStates.setSmscTxHttpServerServiceState((boolean)true);
    }

    public void onActivityEndEvent(ActivityEndEvent event, ActivityContextInterface aci, EventContext eventContext) {
        boolean isServiceActivity = aci.getActivity() instanceof ServiceActivity;
        if (isServiceActivity) {
            this.logger.info("Rx: onActivityEndEvent: event=" + event + ", isServiceActivity=" + isServiceActivity);
            SbbStates.setSmscTxHttpServerServiceState((boolean)false);
        }
    }

    protected SendMessageParseResult createSmsEventMultiDest(HttpSendMessageIncomingData incomingData, PersistenceRAInterface store) throws SmscProcessingException {
        int dcs;
        List<String> addressList = incomingData.getDestAddresses();
        if (addressList == null || addressList.size() == 0) {
            throw new SmscProcessingException("For received SubmitMessage no DestAddresses found: ", 0, 34, null);
        }
        String msg = incomingData.getShortMessage();
        if (incomingData.getEncoding() == null) {
            dcs = smscPropertiesManagement.getHttpDefaultDataCoding();
        } else {
            switch (incomingData.getEncoding()) {
                case GSM7: {
                    dcs = 0;
                    break;
                }
                case UCS2: {
                    dcs = 8;
                    break;
                }
                default: {
                    dcs = smscPropertiesManagement.getHttpDefaultDataCoding();
                }
            }
        }
        String err = MessageUtil.checkDataCodingSchemeSupport((int)dcs);
        if (err != null) {
            throw new SmscProcessingException("TxHttp DataCoding scheme does not supported: " + dcs + " - " + err, 0, 34, null);
        }
        int nationalLanguageLockingShift = 0;
        int nationalLanguageSingleShift = 0;
        ArrayList<Sms> msgList = new ArrayList<Sms>(addressList.size());
        for (String address : addressList) {
            long messageId = store.c2_getNextMessageId();
            SmscStatProvider.getInstance().setCurrentMessageId(messageId);
            boolean succAddr = false;
            TargetAddress ta = null;
            try {
                ta = this.createDestTargetAddress(address);
                succAddr = true;
            }
            catch (SmscProcessingException e) {
                this.logger.severe("SmscProcessingException while processing message to destination: " + address);
            }
            if (!succAddr) continue;
            Sms sms = new Sms();
            sms.setDbId(UUID.randomUUID());
            sms.setOriginationType(OriginationType.HTTP);
            sms.setOrigNetworkId(ta.getNetworkId());
            sms.setSourceAddr(incomingData.getSenderId());
            sms.setSourceAddrNpi(smscPropertiesManagement.getHttpDefaultSourceNpi());
            sms.setSourceAddrTon(smscPropertiesManagement.getHttpDefaultSourceTon());
            sms.setDataCoding(dcs);
            sms.setEsmClass(smscPropertiesManagement.getHttpDefaultMessagingMode());
            int registeredDelivery = smscPropertiesManagement.getHttpDefaultRDDeliveryReceipt();
            if (smscPropertiesManagement.getHttpDefaultRDIntermediateNotification() != 0) {
                registeredDelivery |= 0x10;
            }
            sms.setRegisteredDelivery(registeredDelivery);
            sms.setNationalLanguageLockingShift(nationalLanguageLockingShift);
            sms.setNationalLanguageSingleShift(nationalLanguageSingleShift);
            sms.setSubmitDate((Date)new Timestamp(System.currentTimeMillis()));
            sms.setDefaultMsgId(incomingData.getDefaultMsgId());
            this.logger.finest("### Msg is: " + msg);
            sms.setShortMessageText(msg);
            MessageUtil.applyValidityPeriod((Sms)sms, null, (boolean)false, (int)smscPropertiesManagement.getMaxValidityPeriodHours(), (int)smscPropertiesManagement.getDefaultValidityPeriodHours());
            SmsSet smsSet = new SmsSet();
            smsSet.setDestAddr(ta.getAddr());
            smsSet.setDestAddrNpi(ta.getAddrNpi());
            smsSet.setDestAddrTon(ta.getAddrTon());
            smsSet.setNetworkId(ta.getNetworkId());
            smsSet.addSms(sms);
            sms.setSmsSet(smsSet);
            sms.setMessageId(messageId);
            msgList.add(sms);
        }
        return new SendMessageParseResult(msgList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processSms(Sms sms0, PersistenceRAInterface store, HttpSendMessageIncomingData eventSubmitMulti) throws SmscProcessingException {
        boolean withCharging;
        if (this.logger.isInfoEnabled()) {
            this.logger.info(String.format("\nReceived sms=%s", sms0.toString()));
        }
        if (smscPropertiesManagement.isSmscStopped()) {
            SmscProcessingException e = new SmscProcessingException("SMSC is stopped", 0, 0, null);
            e.setSkipErrorLogging(true);
            throw e;
        }
        if (smscPropertiesManagement.isDeliveryPause() && (!MessageUtil.isStoreAndForward((Sms)sms0) || smscPropertiesManagement.getStoreAndForwordMode() == StoreAndForwordMode.fast)) {
            SmscProcessingException e = new SmscProcessingException("SMSC is paused", 0, 0, null);
            e.setSkipErrorLogging(true);
            throw e;
        }
        if (!store.isDatabaseAvailable() && MessageUtil.isStoreAndForward((Sms)sms0)) {
            SmscProcessingException e = new SmscProcessingException("Database is unavailable", 0, 0, null);
            e.setSkipErrorLogging(true);
            throw e;
        }
        if (!MessageUtil.isStoreAndForward((Sms)sms0) || smscPropertiesManagement.getStoreAndForwordMode() == StoreAndForwordMode.fast) {
            int fetchMaxRows = (int)((double)smscPropertiesManagement.getMaxActivityCount() * 1.2);
            int activityCount = SmsSetCache.getInstance().getProcessingSmsSetSize();
            if (activityCount >= fetchMaxRows) {
                SmscProcessingException e = new SmscProcessingException("SMSC is overloaded", 0, 0, null);
                e.setSkipErrorLogging(true);
                throw e;
            }
        }
        if (withCharging = false) {
            ChargingSbbLocalObject chargingSbb = this.getChargingSbbObject();
            chargingSbb.setupChargingRequestInterface(ChargingMedium.TxSmppOrig, sms0);
        } else {
            MProcResult mProcResult = MProcManagement.getInstance().applyMProcArrival(sms0, (PersistenseCommonInterface)store);
            if (mProcResult.isMessageRejected()) {
                sms0.setMessageDeliveryResultResponse(null);
                SmscProcessingException e = new SmscProcessingException("Message is rejected by MProc rules", 0, 0, null);
                e.setSkipErrorLogging(true);
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("TxHttp: incoming message is rejected by mProc rules, message=[" + sms0 + "]");
                }
                throw e;
            }
            if (mProcResult.isMessageDropped()) {
                sms0.setMessageDeliveryResultResponse(null);
                this.smscStatAggregator.updateMsgInFailedAll();
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("TxHttp: incoming message is dropped by mProc rules, message=[" + sms0 + "]");
                }
                return;
            }
            this.smscStatAggregator.updateMsgInReceivedAll();
            FastList smss = mProcResult.getMessageList();
            FastList.Node n = smss.head();
            FastList.Node end = smss.tail();
            while ((n = n.getNext()) != end) {
                Sms sms = (Sms)n.getValue();
                TargetAddress ta = new TargetAddress(sms.getSmsSet());
                TargetAddress lock = store.obtainSynchroObject(ta);
                try {
                    TargetAddress targetAddress = lock;
                    synchronized (targetAddress) {
                        boolean storeAndForwMode = MessageUtil.isStoreAndForward((Sms)sms);
                        if (!storeAndForwMode) {
                            try {
                                this.scheduler.injectSmsOnFly(sms.getSmsSet(), true);
                            }
                            catch (Exception e) {
                                throw new SmscProcessingException("Exception when runnung injectSmsOnFly(): " + e.getMessage(), 0, 34, null, (Throwable)e);
                            }
                        }
                        if (smscPropertiesManagement.getStoreAndForwordMode() == StoreAndForwordMode.fast && sms.getScheduleDeliveryTime() == null) {
                            try {
                                sms.setStoringAfterFailure(true);
                                this.scheduler.injectSmsOnFly(sms.getSmsSet(), true);
                            }
                            catch (Exception e) {
                                throw new SmscProcessingException("Exception when runnung injectSmsOnFly(): " + e.getMessage(), 0, 34, null, (Throwable)e);
                            }
                        }
                        try {
                            sms.setStored(true);
                            this.scheduler.setDestCluster(sms.getSmsSet());
                            store.c2_scheduleMessage_ReschedDueSlot(sms, smscPropertiesManagement.getStoreAndForwordMode() == StoreAndForwordMode.fast, false);
                        }
                        catch (PersistenceException e) {
                            throw new SmscProcessingException("PersistenceException when storing LIVE_SMS : " + e.getMessage(), 0, 34, null, (Throwable)e);
                        }
                    }
                }
                finally {
                    store.releaseSynchroObject(lock);
                }
            }
        }
    }

    public abstract ChildRelationExt getChargingSbb();

    private ChargingSbbLocalObject getChargingSbbObject() {
        ChargingSbbLocalObject ret;
        block3: {
            ChildRelationExt relation = this.getChargingSbb();
            ret = (ChargingSbbLocalObject)relation.get("0");
            if (ret == null) {
                try {
                    ret = (ChargingSbbLocalObject)relation.create("0");
                }
                catch (Exception e) {
                    if (!this.logger.isSevereEnabled()) break block3;
                    this.logger.severe("Exception while trying to creat ChargingSbb child", (Throwable)e);
                }
            }
        }
        return ret;
    }

    public void sbbActivate() {
    }

    public void sbbCreate() throws CreateException {
    }

    public void sbbExceptionThrown(Exception arg0, Object arg1, ActivityContextInterface arg2) {
    }

    public void sbbLoad() {
    }

    public void sbbPassivate() {
    }

    public void sbbPostCreate() throws CreateException {
    }

    public void sbbRemove() {
    }

    public void sbbRolledBack(RolledBackContext arg0) {
    }

    public void sbbStore() {
    }

    public void unsetSbbContext() {
    }
}

