/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.smsc.slee.services.http.server.tx.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.slee.facilities.Tracer;
import org.mobicents.smsc.slee.services.http.server.tx.exceptions.HttpApiException;

public class HttpRequestUtils {
    private static final String P_MSG = "msg";
    private static final String P_SENDER = "sender";
    private static final String P_TO = "to";
    private static final String P_USERID = "userid";
    private static final String P_PASSWORD = "password";
    private static final String P_MSGID = "msgid";

    public static boolean isSendMessageRequest(Tracer logger, HttpServletRequest request) throws HttpApiException {
        Map params = request.getParameterMap();
        if (!request.getRequestURI().contains("restcomm")) {
            logger.finest("URI does not conatin 'restcomm'");
            return false;
        }
        if ("GET".equalsIgnoreCase(request.getMethod())) {
            logger.finest(params.toString());
            logger.finest(request.getRequestURL().toString());
            logger.finest(request.getParameter(P_USERID) + " contains key: " + params.containsKey(P_USERID));
            logger.finest(request.getParameter(P_PASSWORD) + " contains key: " + params.containsKey(P_PASSWORD));
            logger.finest(request.getParameter(P_SENDER) + " contains key: " + params.containsKey(P_SENDER));
            logger.finest(request.getParameter(P_MSG) + " contains key: " + params.containsKey(P_MSG));
            logger.finest(request.getParameter(P_TO) + " contains key: " + params.containsKey(P_TO));
            return params.containsKey(P_USERID) && params.containsKey(P_SENDER) && params.containsKey(P_PASSWORD) && params.containsKey(P_MSG) && params.containsKey(P_TO);
        }
        if ("POST".equalsIgnoreCase(request.getMethod())) {
            boolean checkParameter;
            logger.finest(params.toString());
            logger.finest(request.getRequestURL().toString());
            logger.finest(request.getParameter(P_USERID) + " contains key: " + params.containsKey(P_USERID));
            logger.finest(request.getParameter(P_PASSWORD) + " contains key: " + params.containsKey(P_PASSWORD));
            logger.finest(request.getParameter(P_SENDER) + " contains key: " + params.containsKey(P_SENDER));
            logger.finest(request.getParameter(P_MSG) + " contains key: " + params.containsKey(P_MSG));
            logger.finest(request.getParameter(P_TO) + " contains key: " + params.containsKey(P_TO));
            boolean bl = checkParameter = params.containsKey(P_USERID) && params.containsKey(P_SENDER) && params.containsKey(P_PASSWORD) && params.containsKey(P_MSG) && params.containsKey(P_TO);
            if (!checkParameter) {
                Map<String, String[]> map = HttpRequestUtils.extractParametersFromPost(logger, request);
                logger.finest(map.get(P_USERID) + " contains key: " + map.containsKey(P_USERID));
                logger.finest(map.get(P_PASSWORD) + " contains key: " + map.containsKey(P_PASSWORD));
                logger.finest(map.get(P_SENDER) + " contains key: " + map.containsKey(P_SENDER));
                logger.finest(map.get(P_MSG) + " contains key: " + map.containsKey(P_MSG));
                logger.finest(map.get(P_TO) + " contains key: " + map.containsKey(P_TO));
                return map.containsKey(P_USERID) && map.containsKey(P_SENDER) && map.containsKey(P_PASSWORD) && map.containsKey(P_MSG) && map.containsKey(P_TO);
            }
            return checkParameter;
        }
        logger.finest("Request method neither POST nor GET");
        return false;
    }

    public static boolean isGetMessageIdStatusService(Tracer logger, HttpServletRequest request) throws HttpApiException {
        Map params = request.getParameterMap();
        if (!request.getRequestURI().contains("restcomm")) {
            logger.finest("URI does not conatin 'restcomm'");
            return false;
        }
        if ("GET".equalsIgnoreCase(request.getMethod())) {
            logger.finest(params.toString());
            return params.containsKey(P_USERID) && params.containsKey(P_PASSWORD) && params.containsKey(P_MSGID);
        }
        if ("POST".equalsIgnoreCase(request.getMethod())) {
            boolean checkParameter;
            boolean bl = checkParameter = params.containsKey(P_USERID) && params.containsKey(P_PASSWORD) && params.containsKey(P_MSGID);
            if (!checkParameter) {
                Map<String, String[]> map = HttpRequestUtils.extractParametersFromPost(logger, request);
                logger.finest(map.get(P_USERID) + " contains key: " + map.containsKey(P_USERID));
                logger.finest(map.get(P_PASSWORD) + " contains key: " + map.containsKey(P_PASSWORD));
                logger.finest(map.get(P_MSGID) + " contains key: " + map.containsKey(P_MSG));
                return map.containsKey(P_USERID) && map.containsKey(P_PASSWORD) && map.containsKey(P_MSGID);
            }
            return checkParameter;
        }
        logger.finest("Request method neither POST nor GET");
        return false;
    }

    public static Map<String, String[]> extractParametersFromPost(Tracer logger, HttpServletRequest request) throws HttpApiException {
        try {
            String[] splitted;
            HashMap<String, String[]> map = new HashMap<String, String[]>();
            BufferedReader reader = request.getReader();
            if (reader == null) {
                return map;
            }
            logger.finest("### Reading lines from POST Request");
            String line = null;
            StringBuilder sb = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                logger.finest("### Line: " + line);
                sb.append(line);
            }
            String body = sb.toString();
            for (String item : splitted = body.split("\\&")) {
                String[] pair = item.split("=");
                if (pair.length != 2) {
                    logger.severe("#### Length is different than 2." + item + " will be omitted");
                    continue;
                }
                String first = pair[0];
                String second = pair[1];
                if (second.contains(",")) {
                    map.put(first, second.split(","));
                    continue;
                }
                map.put(first, new String[]{second});
            }
            return map;
        }
        catch (IOException e) {
            throw new HttpApiException("IOException while reading the body of the HttpServletRequest.");
        }
    }
}

