/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.smsc.slee.services.http.server.tx.data;

import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.slee.facilities.Tracer;
import org.mobicents.smsc.domain.HttpEncoding;
import org.mobicents.smsc.domain.SmscPropertiesManagement;
import org.mobicents.smsc.slee.services.http.server.tx.enums.MessageBodyEncoding;
import org.mobicents.smsc.slee.services.http.server.tx.enums.RequestParameter;
import org.mobicents.smsc.slee.services.http.server.tx.enums.ResponseFormat;
import org.mobicents.smsc.slee.services.http.server.tx.enums.SmscMessageEncoding;
import org.mobicents.smsc.slee.services.http.server.tx.exceptions.HttpApiException;
import org.mobicents.smsc.slee.services.http.server.tx.utils.HttpRequestUtils;

public class HttpSendMessageIncomingData {
    private String userId;
    private String password;
    private String msg;
    private ResponseFormat format;
    private SmscMessageEncoding smscEncoding;
    private MessageBodyEncoding messageBodyEncoding;
    private String senderId;
    private List<String> destAddresses = new ArrayList<String>();
    private HttpEncoding httpEncoding;

    public HttpSendMessageIncomingData(String userId, String password, String msg, String formatParam, String smscEncodingStr, String messageBodyEncodingStr, String senderId, String[] to, SmscPropertiesManagement smscPropertiesManagement) throws HttpApiException {
        this.format = ResponseFormat.fromString(formatParam);
        if (this.isEmptyOrNull(userId)) {
            throw new HttpApiException("'" + RequestParameter.USER_ID.getName() + "' parameter is not set properly or not valid in the Http Request.");
        }
        if (this.isEmptyOrNull(password)) {
            throw new HttpApiException("'" + RequestParameter.PASSWORD.getName() + "' parameter is not set properly or not valid in the Http Request.");
        }
        if (this.isEmptyOrNull(msg)) {
            throw new HttpApiException("'" + RequestParameter.MESSAGE_BODY.getName() + "' parameter is not set properly or not valid in the Http Request.");
        }
        if (this.isEmptyOrNull(senderId)) {
            throw new HttpApiException("'" + RequestParameter.SENDER.getName() + "' parameter is not set properly or not valid in the Http Request.");
        }
        try {
            Long.parseLong(senderId);
        }
        catch (NumberFormatException e) {
            throw new HttpApiException("'" + RequestParameter.SENDER.getName() + "' parameter is not valid in the Http Request. sender:" + senderId);
        }
        if (to == null || to.length < 1) {
            throw new HttpApiException("'" + RequestParameter.TO.getName() + "' parameter is not set in the Http Request.");
        }
        this.destAddresses = new ArrayList<String>(Arrays.asList(to));
        List<String> notValidNumbers = this.validateDestNumbersAndRemoveEmpty(this.destAddresses);
        if (!notValidNumbers.isEmpty()) {
            throw new HttpApiException("'" + RequestParameter.TO.getName() + "' parameter contains not valid value. Wrong format of numbers:" + Arrays.toString(notValidNumbers.toArray()));
        }
        if (smscEncodingStr != null && !SmscMessageEncoding.isValid(smscEncodingStr)) {
            throw new HttpApiException("'" + RequestParameter.SMSC_ENCODING.getName() + "' parameter is not set properly or not valid in the Http Request.");
        }
        if (messageBodyEncodingStr != null && !MessageBodyEncoding.isValid(messageBodyEncodingStr)) {
            throw new HttpApiException("'" + RequestParameter.MESSAGE_BODY_ENCODING.getName() + "' parameter is not set properly or not valid in the Http Request.");
        }
        if (smscEncodingStr != null) {
            this.smscEncoding = SmscMessageEncoding.fromString(smscEncodingStr);
        }
        if (messageBodyEncodingStr != null) {
            this.messageBodyEncoding = MessageBodyEncoding.fromString(messageBodyEncodingStr);
        } else {
            this.httpEncoding = SmscMessageEncoding.GSM7.equals((Object)this.getSmscEncoding()) ? smscPropertiesManagement.getHttpEncodingForGsm7() : smscPropertiesManagement.getHttpEncodingForUCS2();
            switch (this.httpEncoding) {
                case Utf8: {
                    this.messageBodyEncoding = MessageBodyEncoding.UTF8;
                    break;
                }
                case Unicode: {
                    this.messageBodyEncoding = MessageBodyEncoding.UTF16;
                    break;
                }
                default: {
                    this.messageBodyEncoding = MessageBodyEncoding.UTF8;
                }
            }
        }
        this.userId = userId;
        this.password = password;
        this.msg = this.decodeMessage(msg, this.getMessageBodyEncoding());
        this.senderId = senderId;
    }

    private String decodeMessage(String msgParameter, MessageBodyEncoding messageBodyEncoding) throws HttpApiException {
        String encoding;
        switch (messageBodyEncoding) {
            case UTF8: {
                encoding = "UTF-8";
                break;
            }
            case UTF16: {
                encoding = "UTF-16";
                break;
            }
            default: {
                encoding = "UTF-8";
            }
        }
        try {
            return new String(msgParameter.getBytes("iso-8859-1"), Charset.forName(encoding));
        }
        catch (UnsupportedEncodingException e) {
            throw new HttpApiException(e.getMessage(), e);
        }
    }

    private boolean isEmptyOrNull(String toCheck) {
        if (toCheck == null) {
            return true;
        }
        return "".equals(toCheck);
    }

    private List<String> validateDestNumbersAndRemoveEmpty(List<String> toCheck) {
        ArrayList<String> notValidDestinationNumbers = new ArrayList<String>();
        Iterator<String> iterator = toCheck.iterator();
        while (iterator.hasNext()) {
            String number = iterator.next().trim();
            if (number.isEmpty()) {
                iterator.remove();
                continue;
            }
            try {
                Long.parseLong(number);
            }
            catch (NumberFormatException e) {
                notValidDestinationNumbers.add(number);
            }
        }
        return notValidDestinationNumbers;
    }

    public List<String> getDestAddresses() {
        return this.destAddresses;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getMsg() {
        return this.msg;
    }

    public ResponseFormat getFormat() {
        return this.format;
    }

    public SmscMessageEncoding getSmscEncoding() {
        return this.smscEncoding;
    }

    public MessageBodyEncoding getMessageBodyEncoding() {
        return this.messageBodyEncoding;
    }

    public String getSenderId() {
        return this.senderId;
    }

    public int getDefaultMsgId() {
        return 0;
    }

    public String getShortMessage() {
        return this.msg;
    }

    public String toString() {
        return "HttpSendMessageIncomingData{userId='" + this.userId + '\'' + ", password='" + this.password + '\'' + ", msg='" + this.msg + '\'' + ", format='" + (Object)((Object)this.format) + '\'' + ", smscEncoding=" + (Object)((Object)this.smscEncoding) + ", messageBodyEncoding=" + (Object)((Object)this.messageBodyEncoding) + ", senderId='" + this.senderId + '\'' + ", destAddresses=" + this.destAddresses + '\'' + '}';
    }

    public static ResponseFormat getFormat(Tracer tracer, HttpServletRequest request) throws HttpApiException {
        String formatParameter = request.getParameter("format");
        if (formatParameter != null) {
            return ResponseFormat.fromString(formatParameter);
        }
        try {
            Map<String, String[]> stringMap = HttpRequestUtils.extractParametersFromPost(tracer, request);
            String[] format = stringMap.get("format");
            return ResponseFormat.fromString(format != null && format.length > 0 ? format[0] : null);
        }
        catch (Exception e) {
            return ResponseFormat.STRING;
        }
    }
}

