/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.smsc.slee.services.http.server.tx.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.slee.facilities.Tracer;
import org.mobicents.smsc.slee.services.http.server.tx.exceptions.HttpApiException;

public class HttpRequestUtils {
    public static final String P_MSG = "msg";
    public static final String P_SENDER = "sender";
    public static final String P_TO = "to";
    public static final String P_USERID = "userid";
    public static final String P_PASSWORD = "password";
    public static final String P_MSGID = "msgid";
    public static final String P_FORMAT = "format";
    public static final String P_SMSC_ENCODING = "smscEncoding";
    public static final String P_MESSAGE_BODY_ENCODING = "messageBodyEncoding";

    public static Map<String, String[]> extractParametersFromPost(Tracer logger, HttpServletRequest request) throws HttpApiException {
        try {
            String[] splitted;
            HashMap<String, String[]> map = new HashMap<String, String[]>();
            BufferedReader reader = request.getReader();
            if (reader == null) {
                return map;
            }
            logger.finest("### Reading lines from POST Request");
            String line = null;
            StringBuilder sb = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                logger.finest("### Line: " + line);
                sb.append(line);
            }
            String body = sb.toString();
            for (String item : splitted = body.split("\\&")) {
                String[] pair = item.split("=");
                if (pair.length != 2) {
                    logger.severe("#### Length is different than 2." + item + " will be omitted");
                    continue;
                }
                String first = pair[0];
                String second = pair[1];
                if (second.contains(",")) {
                    map.put(first, second.split(","));
                    continue;
                }
                map.put(first, new String[]{second});
            }
            return map;
        }
        catch (IOException e) {
            throw new HttpApiException("IOException while reading the body of the HttpServletRequest.");
        }
    }
}

