/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.smsc.slee.services.http.server.tx.data;

import javax.servlet.http.HttpServletRequest;
import org.mobicents.smsc.slee.services.http.server.tx.enums.RequestParameter;
import org.mobicents.smsc.slee.services.http.server.tx.enums.ResponseFormat;
import org.mobicents.smsc.slee.services.http.server.tx.exceptions.HttpApiException;

public class HttpGetMessageIdStatusIncomingData {
    private String userId;
    private String password;
    private Long msgId;
    private ResponseFormat format;

    public HttpGetMessageIdStatusIncomingData(String userId, String password, String msgId, String formatParam) throws HttpApiException {
        if (this.isEmptyOrNull(userId)) {
            throw new HttpApiException("'" + RequestParameter.USER_ID.getName() + "' parameter is not set properly or not valid in the Http Request.");
        }
        if (this.isEmptyOrNull(password)) {
            throw new HttpApiException("'" + RequestParameter.PASSWORD.getName() + "' parameter is not set properly or not valid in the Http Request.");
        }
        if (this.isEmptyOrNull(msgId)) {
            throw new HttpApiException("'" + RequestParameter.MESSAGE_ID.getName() + "' parameter is not set properly or not valid in the Http Request.");
        }
        this.userId = userId;
        this.password = password;
        this.format = formatParam == null ? ResponseFormat.STRING : ResponseFormat.fromString(formatParam);
        try {
            this.msgId = Long.parseLong(msgId);
        }
        catch (NumberFormatException e) {
            throw new HttpApiException("'" + RequestParameter.MESSAGE_ID.getName() + "' parameter in the Http Request is not valid long type");
        }
    }

    public String getUserId() {
        return this.userId;
    }

    public Long getMsgId() {
        return this.msgId;
    }

    private boolean isEmptyOrNull(String toCheck) {
        if (toCheck == null) {
            return true;
        }
        return "".equals(toCheck);
    }

    public String toString() {
        return "HttpSendMessageIncomingData{userId='" + this.userId + '\'' + ", password='" + this.password + '\'' + ", msgid='" + this.msgId + '\'' + '}';
    }

    public static ResponseFormat getFormat(HttpServletRequest request) {
        String param = request.getParameter("format");
        return ResponseFormat.fromString(param);
    }

    public ResponseFormat getFormat() {
        return this.format;
    }

    public void setMsgId(Long msgId) {
        this.msgId = msgId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }
}

