/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.smsc.slee.services.http.server.tx.data;

import org.mobicents.smsc.domain.HttpUsersManagement;
import org.mobicents.smsc.slee.services.http.server.tx.data.BaseIncomingData;
import org.mobicents.smsc.slee.services.http.server.tx.enums.RequestParameter;
import org.mobicents.smsc.slee.services.http.server.tx.exceptions.HttpApiException;
import org.mobicents.smsc.slee.services.http.server.tx.exceptions.UnauthorizedException;

public class HttpGetMessageIdStatusIncomingData
extends BaseIncomingData {
    private Long msgId;

    public HttpGetMessageIdStatusIncomingData(String userId, String password, String msgId, String formatParam, HttpUsersManagement httpUsersManagement) throws HttpApiException, UnauthorizedException {
        super(userId, password, formatParam, httpUsersManagement);
        if (this.isEmptyOrNull(msgId)) {
            throw new HttpApiException("'" + RequestParameter.MESSAGE_ID.getName() + "' parameter is not set properly or not valid in the Http Request.");
        }
        try {
            this.msgId = Long.parseLong(msgId);
        }
        catch (NumberFormatException e) {
            throw new HttpApiException("'" + RequestParameter.MESSAGE_ID.getName() + "' parameter in the Http Request is not valid long type");
        }
    }

    public Long getMsgId() {
        return this.msgId;
    }

    public String toString() {
        return "HttpSendMessageIncomingData{userId='" + this.userId + '\'' + ", password='" + this.password + '\'' + ", msgid='" + this.msgId + '\'' + '}';
    }

    public void setMsgId(Long msgId) {
        this.msgId = msgId;
    }
}

