/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.smsc.slee.services.http.server.tx.data;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.slee.facilities.Tracer;
import org.mobicents.smsc.domain.HttpUser;
import org.mobicents.smsc.domain.HttpUsersManagement;
import org.mobicents.smsc.slee.services.http.server.tx.enums.RequestParameter;
import org.mobicents.smsc.slee.services.http.server.tx.enums.ResponseFormat;
import org.mobicents.smsc.slee.services.http.server.tx.exceptions.HttpApiException;
import org.mobicents.smsc.slee.services.http.server.tx.exceptions.UnauthorizedException;
import org.mobicents.smsc.slee.services.http.server.tx.utils.HttpRequestUtils;

public abstract class BaseIncomingData {
    protected String userId;
    protected String password;
    protected ResponseFormat format;

    public BaseIncomingData(String userId, String password, String formatParam, HttpUsersManagement httpUsersManagement) throws UnauthorizedException {
        ResponseFormat responseFormat = this.format = formatParam == null ? ResponseFormat.STRING : ResponseFormat.fromString(formatParam);
        if (this.isEmptyOrNull(userId)) {
            throw new UnauthorizedException("Unauthorized: Access is denied due to invalid credentials - " + RequestParameter.USER_ID.getName() + " is null.", userId, password);
        }
        if (this.isEmptyOrNull(password)) {
            throw new UnauthorizedException("Unauthorized: Access is denied due to invalid credentials - " + RequestParameter.PASSWORD.getName() + " is null.", userId, password);
        }
        if (!this.checkUsernameAndPassword(userId, password, httpUsersManagement)) {
            throw new UnauthorizedException("Unauthorized: Access is denied due to invalid credentials - " + RequestParameter.USER_ID.getName() + " or " + RequestParameter.PASSWORD.getName() + " is incorrect.", userId, password);
        }
        this.userId = userId;
        this.password = password;
    }

    public boolean isEmptyOrNull(String toCheck) {
        if (toCheck == null) {
            return true;
        }
        return "".equals(toCheck);
    }

    public boolean checkUsernameAndPassword(String userId, String password, HttpUsersManagement httpUsersManagement) {
        HttpUser httpUser = httpUsersManagement.getHttpUserByName(userId);
        if (httpUser != null) {
            return password.equals(httpUser.getPassword());
        }
        return false;
    }

    public static ResponseFormat getFormat(Tracer tracer, HttpServletRequest request) throws HttpApiException {
        String formatParameter = request.getParameter("format");
        if (formatParameter != null) {
            return ResponseFormat.fromString(formatParameter);
        }
        try {
            Map<String, String[]> stringMap = HttpRequestUtils.extractParametersFromPost(tracer, request);
            String[] format = stringMap.get("format");
            return ResponseFormat.fromString(format != null && format.length > 0 ? format[0] : null);
        }
        catch (Exception e) {
            return ResponseFormat.STRING;
        }
    }

    public static ResponseFormat getFormat(HttpServletRequest request) {
        String param = request.getParameter("format");
        return ResponseFormat.fromString(param);
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getUserId() {
        return this.userId;
    }

    public ResponseFormat getFormat() {
        return this.format;
    }
}

