/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.smsc.slee.services.http.server.tx.data;

import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.mobicents.smsc.domain.HttpEncoding;
import org.mobicents.smsc.domain.HttpUsersManagement;
import org.mobicents.smsc.domain.SmscPropertiesManagement;
import org.mobicents.smsc.slee.services.http.server.tx.data.BaseIncomingData;
import org.mobicents.smsc.slee.services.http.server.tx.enums.MessageBodyEncoding;
import org.mobicents.smsc.slee.services.http.server.tx.enums.NPI;
import org.mobicents.smsc.slee.services.http.server.tx.enums.RequestParameter;
import org.mobicents.smsc.slee.services.http.server.tx.enums.SmscMessageEncoding;
import org.mobicents.smsc.slee.services.http.server.tx.enums.TON;
import org.mobicents.smsc.slee.services.http.server.tx.exceptions.HttpApiException;
import org.mobicents.smsc.slee.services.http.server.tx.exceptions.UnauthorizedException;

public class HttpSendMessageIncomingData
extends BaseIncomingData {
    private String msg;
    private SmscMessageEncoding smscEncoding;
    private MessageBodyEncoding messageBodyEncoding;
    private String sender;
    private List<String> destAddresses = new ArrayList<String>();
    private TON senderTon;
    private NPI senderNpi;
    private byte[] udh;
    private Pattern regExDigits = Pattern.compile("^[0-9]+$");
    private Pattern regExDigitsWithPlus = Pattern.compile("^\\+\\d+$");

    public HttpSendMessageIncomingData(String userId, String password, String msg, String formatParam, String smscEncodingStr, String messageBodyEncodingStr, String sender, String senderTon, String senderNpi, String[] to, SmscPropertiesManagement smscPropertiesManagement, HttpUsersManagement httpUsersManagement, String udhStr) throws HttpApiException, UnauthorizedException {
        super(userId, password, formatParam, httpUsersManagement);
        if (this.isEmptyOrNull(msg)) {
            throw new HttpApiException("'" + RequestParameter.MESSAGE_BODY.getName() + "' parameter is not set properly or not valid in the Http Request.");
        }
        if (this.isEmptyOrNull(sender)) {
            throw new HttpApiException("'" + RequestParameter.SENDER.getName() + "' parameter is not set properly or not valid in the Http Request.");
        }
        if (to == null || to.length < 1 || this.checkAllElements(to)) {
            throw new HttpApiException("'" + RequestParameter.TO.getName() + "' parameter is not set in the Http Request.");
        }
        this.destAddresses = new ArrayList<String>(Arrays.asList(to));
        List<String> notValidNumbers = this.validateDestNumbersAndRemoveEmpty(this.destAddresses);
        if (!notValidNumbers.isEmpty()) {
            throw new HttpApiException("'" + RequestParameter.TO.getName() + "' parameter contains not valid value. Wrong format of numbers:" + Arrays.toString(notValidNumbers.toArray()));
        }
        if (smscEncodingStr != null && !SmscMessageEncoding.isValid(smscEncodingStr)) {
            throw new HttpApiException("'" + RequestParameter.SMSC_ENCODING.getName() + "' parameter is not set properly or not valid in the Http Request.");
        }
        if (messageBodyEncodingStr != null && !MessageBodyEncoding.isValid(messageBodyEncodingStr)) {
            throw new HttpApiException("'" + RequestParameter.MESSAGE_BODY_ENCODING.getName() + "' parameter is not set properly or not valid in the Http Request.");
        }
        if (senderTon != null && TON.fromString(senderTon) == null) {
            throw new HttpApiException("'" + RequestParameter.SENDER_TON.getName() + "' parameter is not set properly or not valid in the Http Request.");
        }
        if (senderNpi != null && NPI.fromString(senderNpi) == null) {
            throw new HttpApiException("'" + RequestParameter.SENDER_NPI.getName() + "' parameter is not set properly or not valid in the Http Request.");
        }
        if (smscEncodingStr != null) {
            this.smscEncoding = SmscMessageEncoding.fromString(smscEncodingStr);
        }
        if (messageBodyEncodingStr != null) {
            this.messageBodyEncoding = MessageBodyEncoding.fromString(messageBodyEncodingStr);
        } else {
            HttpEncoding httpEncoding = SmscMessageEncoding.GSM7.equals((Object)this.getSmscEncoding()) ? smscPropertiesManagement.getHttpEncodingForGsm7() : smscPropertiesManagement.getHttpEncodingForUCS2();
            switch (httpEncoding) {
                case Utf8: {
                    this.messageBodyEncoding = MessageBodyEncoding.UTF8;
                    break;
                }
                case Unicode: {
                    this.messageBodyEncoding = MessageBodyEncoding.UTF16;
                    break;
                }
                default: {
                    this.messageBodyEncoding = MessageBodyEncoding.UTF8;
                }
            }
        }
        if (!this.isEmptyOrNull(udhStr)) {
            this.udh = this.udhToByte(udhStr);
        }
        this.sender = sender;
        this.msg = this.decodeMessage(msg, this.getMessageBodyEncoding());
        if (senderTon != null && senderNpi != null) {
            this.senderTon = TON.fromString(senderTon);
            this.senderNpi = NPI.fromString(senderNpi);
        } else {
            int defaultSourceTon = smscPropertiesManagement.getHttpDefaultSourceTon();
            int defaultSourceNpi = smscPropertiesManagement.getHttpDefaultSourceNpi();
            if (defaultSourceTon < 0 || defaultSourceNpi < 0) {
                if (defaultSourceTon == -1 || defaultSourceNpi == -1) {
                    Matcher m = this.regExDigitsWithPlus.matcher(this.sender);
                    if (m.matches()) {
                        this.senderTon = TON.INTERNATIONAL;
                        this.senderNpi = NPI.ISDN;
                        this.sender = this.sender.substring(1);
                    } else {
                        m = this.regExDigits.matcher(this.sender);
                        if (m.matches()) {
                            this.senderTon = TON.NATIONAL;
                            this.senderNpi = NPI.ISDN;
                        } else {
                            this.senderTon = TON.ALFANUMERIC;
                            this.senderNpi = NPI.UNKNOWN;
                        }
                    }
                } else {
                    Matcher m = this.regExDigits.matcher(this.sender);
                    if (m.matches()) {
                        this.senderTon = TON.INTERNATIONAL;
                        this.senderNpi = NPI.ISDN;
                    } else {
                        this.senderTon = TON.ALFANUMERIC;
                        this.senderNpi = NPI.UNKNOWN;
                    }
                }
            } else {
                this.senderTon = TON.fromInt(defaultSourceTon);
                this.senderNpi = NPI.fromInt(defaultSourceNpi);
            }
        }
    }

    private String decodeMessage(String msgParameter, MessageBodyEncoding messageBodyEncoding) throws HttpApiException {
        String encoding;
        switch (messageBodyEncoding) {
            case UTF8: {
                encoding = "UTF-8";
                break;
            }
            case UTF16: {
                encoding = "UTF-16";
                break;
            }
            default: {
                encoding = "UTF-8";
            }
        }
        try {
            return new String(msgParameter.getBytes("iso-8859-1"), Charset.forName(encoding));
        }
        catch (UnsupportedEncodingException e) {
            throw new HttpApiException(e.getMessage(), e);
        }
    }

    private boolean checkAllElements(String[] addresses) {
        for (String e : addresses) {
            if (e == null || e.trim().isEmpty()) continue;
            return false;
        }
        return true;
    }

    private List<String> validateDestNumbersAndRemoveEmpty(List<String> toCheck) {
        ArrayList<String> notValidDestinationNumbers = new ArrayList<String>();
        Iterator<String> iterator = toCheck.iterator();
        while (iterator.hasNext()) {
            String number = iterator.next().trim();
            if (number.isEmpty()) {
                iterator.remove();
                continue;
            }
            try {
                Long.parseLong(number);
            }
            catch (NumberFormatException e) {
                notValidDestinationNumbers.add(number);
            }
        }
        return notValidDestinationNumbers;
    }

    private byte[] udhToByte(String udhDecoded) throws HttpApiException {
        try {
            return udhDecoded.getBytes("iso-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            throw new HttpApiException(e.getMessage(), e);
        }
    }

    public List<String> getDestAddresses() {
        return this.destAddresses;
    }

    public String getMsg() {
        return this.msg;
    }

    public SmscMessageEncoding getSmscEncoding() {
        return this.smscEncoding;
    }

    public MessageBodyEncoding getMessageBodyEncoding() {
        return this.messageBodyEncoding;
    }

    public String getSender() {
        return this.sender;
    }

    public TON getSenderTon() {
        return this.senderTon;
    }

    public NPI getSenderNpi() {
        return this.senderNpi;
    }

    public int getDefaultMsgId() {
        return 0;
    }

    public String getShortMessage() {
        return this.msg;
    }

    public byte[] getUdh() {
        return this.udh;
    }

    public String udhToString(byte[] udhs) {
        if (udhs != null) {
            StringBuilder udhtoString = new StringBuilder();
            int length = udhs.length;
            for (int i = 0; i < length; ++i) {
                udhtoString.append(String.format("%02X ", udhs[i]));
            }
            return udhtoString.toString();
        }
        return "";
    }

    public String toString() {
        return "HttpSendMessageIncomingData{userId='" + this.userId + '\'' + ", password='" + this.password + '\'' + ", msg='" + this.msg + '\'' + ", format='" + (Object)((Object)this.format) + '\'' + ", smscEncoding=" + (Object)((Object)this.smscEncoding) + ", messageBodyEncoding=" + (Object)((Object)this.messageBodyEncoding) + ", sender='" + this.sender + '\'' + ", senderTon='" + (Object)((Object)this.senderTon) + '\'' + ", senderNpi='" + (Object)((Object)this.senderNpi) + '\'' + ", destAddresses=" + this.destAddresses + '\'' + ", udh=" + this.udhToString(this.udh) + '\'' + '}';
    }
}

