/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.smsc.slee.services.sip.server.tx;

import gov.nist.javax.sip.address.SipUri;
import gov.nist.javax.sip.header.SIPHeader;
import java.nio.charset.Charset;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.Date;
import java.util.UUID;
import javax.sip.RequestEvent;
import javax.sip.ResponseEvent;
import javax.sip.ServerTransaction;
import javax.sip.TimeoutEvent;
import javax.sip.header.FromHeader;
import javax.sip.header.Header;
import javax.sip.header.ToHeader;
import javax.sip.message.MessageFactory;
import javax.sip.message.Request;
import javax.sip.message.Response;
import javax.slee.ActivityContextInterface;
import javax.slee.ActivityEndEvent;
import javax.slee.CreateException;
import javax.slee.EventContext;
import javax.slee.RolledBackContext;
import javax.slee.Sbb;
import javax.slee.SbbContext;
import javax.slee.ServiceID;
import javax.slee.facilities.Tracer;
import javax.slee.resource.ResourceAdaptorTypeID;
import javax.slee.serviceactivity.ServiceActivity;
import javax.slee.serviceactivity.ServiceStartedEvent;
import javolution.util.FastList;
import net.java.slee.resource.sip.SleeSipProvider;
import org.mobicents.protocols.ss7.map.api.smstpdu.CharacterSet;
import org.mobicents.protocols.ss7.map.api.smstpdu.DataCodingGroup;
import org.mobicents.protocols.ss7.map.api.smstpdu.DataCodingScheme;
import org.mobicents.protocols.ss7.map.smstpdu.DataCodingSchemeImpl;
import org.mobicents.slee.ChildRelationExt;
import org.mobicents.slee.SbbContextExt;
import org.mobicents.smsc.cassandra.PersistenceException;
import org.mobicents.smsc.domain.MProcManagement;
import org.mobicents.smsc.domain.Sip;
import org.mobicents.smsc.domain.SipManagement;
import org.mobicents.smsc.domain.SmscCongestionControl;
import org.mobicents.smsc.domain.SmscPropertiesManagement;
import org.mobicents.smsc.domain.SmscStatAggregator;
import org.mobicents.smsc.domain.SmscStatProvider;
import org.mobicents.smsc.domain.StoreAndForwordMode;
import org.mobicents.smsc.library.MessageUtil;
import org.mobicents.smsc.library.OriginationType;
import org.mobicents.smsc.library.SbbStates;
import org.mobicents.smsc.library.Sms;
import org.mobicents.smsc.library.SmsSet;
import org.mobicents.smsc.library.SmsSetCache;
import org.mobicents.smsc.library.SmscProcessingException;
import org.mobicents.smsc.library.TargetAddress;
import org.mobicents.smsc.mproc.impl.MProcResult;
import org.mobicents.smsc.mproc.impl.PersistenseCommonInterface;
import org.mobicents.smsc.slee.resources.persistence.PersistenceRAInterface;
import org.mobicents.smsc.slee.resources.scheduler.SchedulerRaSbbInterface;
import org.mobicents.smsc.slee.services.charging.ChargingMedium;
import org.mobicents.smsc.slee.services.charging.ChargingSbbLocalObject;

public abstract class TxSipServerSbb
implements Sbb {
    protected static SmscPropertiesManagement smscPropertiesManagement = SmscPropertiesManagement.getInstance();
    private static final ResourceAdaptorTypeID PERSISTENCE_ID = new ResourceAdaptorTypeID("PersistenceResourceAdaptorType", "org.mobicents", "1.0");
    private static final String PERSISTENCE_LINK = "PersistenceResourceAdaptor";
    private static final ResourceAdaptorTypeID SCHEDULER_ID = new ResourceAdaptorTypeID("SchedulerResourceAdaptorType", "org.mobicents", "1.0");
    private static final String SCHEDULER_LINK = "SchedulerResourceAdaptor";
    private static final ResourceAdaptorTypeID SIP_RA_TYPE_ID = new ResourceAdaptorTypeID("JAIN SIP", "javax.sip", "1.2");
    private static final String SIP_RA_LINK = "SipRA";
    private SleeSipProvider sipRA;
    protected SchedulerRaSbbInterface scheduler = null;
    private MessageFactory messageFactory;
    protected Tracer logger;
    private SbbContextExt sbbContext;
    protected PersistenceRAInterface persistence = null;
    private SmscStatAggregator smscStatAggregator = SmscStatAggregator.getInstance();
    private SmscCongestionControl smscCongestionControl = SmscCongestionControl.getInstance();
    private static final SipManagement sipManagement = SipManagement.getInstance();
    private static Charset utf8 = Charset.forName("UTF-8");
    private static DataCodingSchemeImpl dcsGsm7 = new DataCodingSchemeImpl(DataCodingGroup.GeneralGroup, null, null, null, CharacterSet.GSM7, false);
    private static DataCodingSchemeImpl dcsUsc2 = new DataCodingSchemeImpl(DataCodingGroup.GeneralGroup, null, null, null, CharacterSet.UCS2, false);
    private static DataCodingSchemeImpl dcsGsm8 = new DataCodingSchemeImpl(DataCodingGroup.GeneralGroup, null, null, null, CharacterSet.GSM8, false);

    public void onMESSAGE(RequestEvent event, ActivityContextInterface aci) {
        if (this.logger.isFineEnabled()) {
            this.logger.fine("onMESSAGE " + event);
        }
        Sip sip = sipManagement.getSipByName("SIP");
        try {
            Request request = event.getRequest();
            byte[] message = request.getRawContent();
            ToHeader toHeader = (ToHeader)request.getHeader("To");
            String toUser = ((SipUri)toHeader.getAddress().getURI()).getUser();
            FromHeader fromHeader = (FromHeader)request.getHeader("From");
            String fromUser = ((SipUri)fromHeader.getAddress().getURI()).getUser();
            TargetAddress ta = this.createDestTargetAddress(toUser, sip.getNetworkId());
            PersistenceRAInterface store = this.getStore();
            byte[] udh = null;
            Header udhHeader = request.getHeader("X-SMS-UDH");
            if (udhHeader != null) {
                udh = this.hexStringToByteArray(((SIPHeader)udhHeader).getValue());
            }
            Header codingHeader = request.getHeader("X-SMS-CODING");
            DataCodingSchemeImpl codingSchme = dcsGsm7;
            if (codingHeader != null) {
                int dcs = Integer.parseInt(((SIPHeader)codingHeader).getValue());
                codingSchme = this.createDataCodingScheme(dcs);
            }
            Date validityPeriod = null;
            Header validityHeader = request.getHeader("X-SMS-VALIDITY");
            if (validityHeader != null) {
                try {
                    validityPeriod = MessageUtil.parseDate((String)((SIPHeader)validityHeader).getValue());
                }
                catch (ParseException e) {
                    this.logger.severe("ParseException when parsing ValidityPeriod field: " + e.getMessage(), (Throwable)e);
                    ServerTransaction serverTransaction = event.getServerTransaction();
                    try {
                        Response res = this.messageFactory.createResponse(500, serverTransaction.getRequest());
                        event.getServerTransaction().sendResponse(res);
                    }
                    catch (Exception e1) {
                        this.logger.severe("Exception while trying to send 500 response to sip", (Throwable)e1);
                    }
                    return;
                }
            }
            int regDeliveryInt = 0;
            Header regDeliveryHeader = request.getHeader("X-REG-DELIVERY");
            if (regDeliveryHeader != null) {
                regDeliveryInt = Integer.parseInt(((SIPHeader)regDeliveryHeader).getValue());
            }
            try {
                Sms sms = this.createSmsEvent(fromUser, message, ta, store, udh, codingSchme, validityPeriod, regDeliveryInt, sip.getNetworkId());
                this.processSms(sms, store);
            }
            catch (SmscProcessingException e1) {
                if (!e1.isSkipErrorLogging()) {
                    this.logger.severe("SmscProcessingException while processing a message from sip", (Throwable)e1);
                    this.smscStatAggregator.updateMsgInFailedAll();
                }
                ServerTransaction serverTransaction = event.getServerTransaction();
                try {
                    Response res = this.messageFactory.createResponse(500, serverTransaction.getRequest());
                    event.getServerTransaction().sendResponse(res);
                }
                catch (Exception e) {
                    this.logger.severe("Exception while trying to send Ok response to sip", (Throwable)e);
                }
                return;
            }
            catch (Throwable e1) {
                this.logger.severe("Exception while processing a message from sip", e1);
                this.smscStatAggregator.updateMsgInFailedAll();
                ServerTransaction serverTransaction = event.getServerTransaction();
                try {
                    Response res = this.messageFactory.createResponse(200, serverTransaction.getRequest());
                    event.getServerTransaction().sendResponse(res);
                }
                catch (Exception e) {
                    this.logger.severe("Exception while trying to send Ok response to sip", (Throwable)e);
                }
                return;
            }
            ServerTransaction serverTransaction = event.getServerTransaction();
            try {
                Response res = this.messageFactory.createResponse(200, serverTransaction.getRequest());
                event.getServerTransaction().sendResponse(res);
            }
            catch (Exception e) {
                this.logger.severe("Exception while trying to send Ok response to sip", (Throwable)e);
            }
        }
        catch (Exception e) {
            this.logger.severe("Error while trying to process received the SMS " + event, (Throwable)e);
        }
    }

    public void onCLIENT_ERROR(ResponseEvent event, ActivityContextInterface aci) {
        this.logger.severe("onCLIENT_ERROR " + event);
    }

    public void onSERVER_ERROR(ResponseEvent event, ActivityContextInterface aci) {
        this.logger.severe("onSERVER_ERROR " + event);
    }

    public void onSUCCESS(ResponseEvent event, ActivityContextInterface aci) {
        if (this.logger.isFineEnabled()) {
            this.logger.fine("onSUCCESS " + event);
        }
    }

    public void onTRYING(ResponseEvent event, ActivityContextInterface aci) {
        if (this.logger.isFineEnabled()) {
            this.logger.fine("onTRYING " + event);
        }
    }

    public void onPROVISIONAL(ResponseEvent event, ActivityContextInterface aci) {
        if (this.logger.isFineEnabled()) {
            this.logger.fine("onPROVISIONAL " + event);
        }
    }

    public void onREDIRECT(ResponseEvent event, ActivityContextInterface aci) {
        this.logger.info("onREDIRECT " + event);
    }

    public void onGLOBAL_FAILURE(ResponseEvent event, ActivityContextInterface aci) {
        this.logger.severe("onGLOBAL_FAILURE " + event);
    }

    public void onTRANSACTION(TimeoutEvent event, ActivityContextInterface aci) {
        this.logger.severe("onTRANSACTION " + event);
    }

    public PersistenceRAInterface getStore() {
        return this.persistence;
    }

    private TargetAddress createDestTargetAddress(String address, int networkId) {
        int destTon = smscPropertiesManagement.getDefaultTon();
        int destNpi = smscPropertiesManagement.getDefaultNpi();
        TargetAddress ta = new TargetAddress(destTon, destNpi, address, networkId);
        return ta;
    }

    public void sbbActivate() {
    }

    public void sbbCreate() throws CreateException {
    }

    public void sbbExceptionThrown(Exception arg0, Object arg1, ActivityContextInterface arg2) {
    }

    public void sbbLoad() {
    }

    public void sbbPassivate() {
    }

    public void sbbPostCreate() throws CreateException {
    }

    public void sbbRemove() {
    }

    public void sbbRolledBack(RolledBackContext arg0) {
    }

    public void sbbStore() {
    }

    public void setSbbContext(SbbContext sbbContext) {
        this.sbbContext = (SbbContextExt)sbbContext;
        try {
            this.logger = this.sbbContext.getTracer(this.getClass().getSimpleName());
            this.sipRA = (SleeSipProvider)this.sbbContext.getResourceAdaptorInterface(SIP_RA_TYPE_ID, SIP_RA_LINK);
            this.messageFactory = this.sipRA.getMessageFactory();
            this.persistence = (PersistenceRAInterface)this.sbbContext.getResourceAdaptorInterface(PERSISTENCE_ID, PERSISTENCE_LINK);
            this.scheduler = (SchedulerRaSbbInterface)this.sbbContext.getResourceAdaptorInterface(SCHEDULER_ID, SCHEDULER_LINK);
        }
        catch (Exception ne) {
            this.logger.severe("Could not set SBB context:", (Throwable)ne);
        }
    }

    public void unsetSbbContext() {
    }

    public void onServiceStartedEvent(ServiceStartedEvent event, ActivityContextInterface aci, EventContext eventContext) {
        ServiceID serviceID = event.getService();
        this.logger.info("Rx: onServiceStartedEvent: event=" + event + ", serviceID=" + serviceID);
        SbbStates.setSmscTxSipServerServiceState((boolean)true);
    }

    public void onActivityEndEvent(ActivityEndEvent event, ActivityContextInterface aci, EventContext eventContext) {
        boolean isServiceActivity = aci.getActivity() instanceof ServiceActivity;
        if (isServiceActivity) {
            this.logger.info("Rx: onActivityEndEvent: event=" + event + ", isServiceActivity=" + isServiceActivity);
            SbbStates.setSmscTxSipServerServiceState((boolean)false);
        }
    }

    protected Sms createSmsEvent(String fromUser, byte[] message, TargetAddress ta, PersistenceRAInterface store, byte[] udh, DataCodingSchemeImpl dataCodingScheme, Date validityPeriod, int regDeliveryInt, int networkId) throws SmscProcessingException {
        Sms sms = new Sms();
        sms.setDbId(UUID.randomUUID());
        sms.setOriginationType(OriginationType.SIP);
        sms.setRegisteredDelivery(regDeliveryInt);
        if (fromUser == null) {
            fromUser = "???";
        }
        boolean isDigital = true;
        for (char ch : fromUser.toCharArray()) {
            if (ch == '0' || ch == '1' || ch == '2' || ch == '3' || ch == '4' || ch == '5' || ch == '6' || ch == '7' || ch == '8' || ch == '9' || ch == '*' || ch == '#' || ch == 'a' || ch == 'b' || ch == 'c') continue;
            isDigital = false;
            break;
        }
        if (isDigital) {
            if (fromUser.length() > 20) {
                fromUser = fromUser.substring(0, 20);
            }
            sms.setSourceAddr(fromUser);
            sms.setSourceAddrTon(smscPropertiesManagement.getDefaultTon());
            sms.setSourceAddrNpi(smscPropertiesManagement.getDefaultNpi());
        } else {
            if (fromUser.length() > 11) {
                fromUser = fromUser.substring(0, 11);
            }
            sms.setSourceAddr(fromUser);
            sms.setSourceAddrTon(5);
            sms.setSourceAddrNpi(smscPropertiesManagement.getDefaultNpi());
        }
        int messageingMode = smscPropertiesManagement.getSipDefaultMessagingMode() & 3;
        sms.setEsmClass(messageingMode);
        sms.setOrigNetworkId(networkId);
        isDigital = true;
        for (char ch : ta.getAddr().toCharArray()) {
            if (ch == '0' || ch == '1' || ch == '2' || ch == '3' || ch == '4' || ch == '5' || ch == '6' || ch == '7' || ch == '8' || ch == '9' || ch == '*' || ch == '#' || ch == 'a' || ch == 'b' || ch == 'c') continue;
            isDigital = false;
            break;
        }
        if (!isDigital) {
            throw new SmscProcessingException("Destination address contains not only digits, *, #, a, b, or c characters: " + ta.getAddr(), 69, 34, null, null);
        }
        if (ta.getAddr().length() > 20) {
            throw new SmscProcessingException("Destination address has too long length: " + ta.getAddr(), 69, 34, null, null);
        }
        if (ta.getAddr().length() == 0) {
            throw new SmscProcessingException("Destination address has no digits", 69, 34, null, null);
        }
        if (message == null) {
            message = new byte[]{};
        }
        String msg = new String(message, utf8);
        sms.setShortMessageText(msg);
        if (udh != null) {
            sms.setShortMessageBin(udh);
            int esmClass = sms.getEsmClass();
            sms.setEsmClass(esmClass |= 0x40);
        }
        sms.setDataCoding(dataCodingScheme.getCode());
        int messageLen = MessageUtil.getMessageLengthInBytes((DataCodingScheme)dataCodingScheme, (String)msg, null);
        int lenSolid = MessageUtil.getMaxSolidMessageBytesLength();
        int lenSegmented = MessageUtil.getMaxSegmentedMessageBytesLength();
        if (messageLen > lenSegmented * 255) {
            throw new SmscProcessingException("Message length in bytes is too big for segmented message: " + messageLen + ">" + lenSegmented, 194, 34, null);
        }
        sms.setSubmitDate((Date)new Timestamp(System.currentTimeMillis()));
        sms.setPriority(0);
        MessageUtil.applyValidityPeriod((Sms)sms, (Date)validityPeriod, (boolean)false, (int)smscPropertiesManagement.getMaxValidityPeriodHours(), (int)smscPropertiesManagement.getDefaultValidityPeriodHours());
        SmsSet smsSet = new SmsSet();
        smsSet.setDestAddr(ta.getAddr());
        smsSet.setDestAddrNpi(ta.getAddrNpi());
        smsSet.setDestAddrTon(ta.getAddrTon());
        smsSet.setNetworkId(networkId);
        smsSet.addSms(sms);
        sms.setSmsSet(smsSet);
        long messageId = store.c2_getNextMessageId();
        SmscStatProvider.getInstance().setCurrentMessageId(messageId);
        sms.setMessageId(messageId);
        return sms;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processSms(Sms sms0, PersistenceRAInterface store) throws SmscProcessingException {
        if (smscPropertiesManagement.isSmscStopped()) {
            SmscProcessingException e = new SmscProcessingException("SMSC is stopped", 8, 0, null);
            e.setSkipErrorLogging(true);
            throw e;
        }
        if (smscPropertiesManagement.isDeliveryPause() && (!MessageUtil.isStoreAndForward((Sms)sms0) || smscPropertiesManagement.getStoreAndForwordMode() == StoreAndForwordMode.fast)) {
            SmscProcessingException e = new SmscProcessingException("SMSC is paused", 8, 0, null);
            e.setSkipErrorLogging(true);
            throw e;
        }
        if (!store.isDatabaseAvailable() && MessageUtil.isStoreAndForward((Sms)sms0)) {
            SmscProcessingException e = new SmscProcessingException("Database is unavailable", 8, 0, null);
            e.setSkipErrorLogging(true);
            throw e;
        }
        if (!MessageUtil.isStoreAndForward((Sms)sms0) || smscPropertiesManagement.getStoreAndForwordMode() == StoreAndForwordMode.fast) {
            int fetchMaxRows = (int)((double)smscPropertiesManagement.getMaxActivityCount() * 1.2);
            int activityCount = SmsSetCache.getInstance().getProcessingSmsSetSize();
            if (activityCount >= fetchMaxRows) {
                this.smscCongestionControl.registerMaxActivityCount1_2Threshold();
                SmscProcessingException e = new SmscProcessingException("SMSC is overloaded", 88, 0, null);
                e.setSkipErrorLogging(true);
                throw e;
            }
            this.smscCongestionControl.registerMaxActivityCount1_2BackToNormal();
        }
        boolean withCharging = false;
        switch (smscPropertiesManagement.getTxSipChargingType()) {
            case Selected: {
                break;
            }
            case All: {
                withCharging = true;
            }
        }
        if (withCharging) {
            ChargingSbbLocalObject chargingSbb = this.getChargingSbbObject();
            chargingSbb.setupChargingRequestInterface(ChargingMedium.TxSipOrig, sms0);
        } else {
            MProcResult mProcResult = MProcManagement.getInstance().applyMProcArrival(sms0, (PersistenseCommonInterface)this.persistence);
            FastList smss = mProcResult.getMessageList();
            FastList.Node n = smss.head();
            FastList.Node end = smss.tail();
            while ((n = n.getNext()) != end) {
                Sms sms = (Sms)n.getValue();
                TargetAddress ta = new TargetAddress(sms.getSmsSet());
                TargetAddress lock = store.obtainSynchroObject(ta);
                try {
                    TargetAddress targetAddress = lock;
                    synchronized (targetAddress) {
                        boolean storeAndForwMode = MessageUtil.isStoreAndForward((Sms)sms);
                        if (!storeAndForwMode) {
                            try {
                                this.scheduler.injectSmsOnFly(sms.getSmsSet(), true);
                            }
                            catch (Exception e) {
                                throw new SmscProcessingException("Exception when runnung injectSmsOnFly(): " + e.getMessage(), 8, 34, null, (Throwable)e);
                            }
                        }
                        if (smscPropertiesManagement.getStoreAndForwordMode() == StoreAndForwordMode.fast) {
                            try {
                                sms.setStoringAfterFailure(true);
                                this.scheduler.injectSmsOnFly(sms.getSmsSet(), true);
                            }
                            catch (Exception e) {
                                throw new SmscProcessingException("Exception when runnung injectSmsOnFly(): " + e.getMessage(), 8, 34, null, (Throwable)e);
                            }
                        }
                        try {
                            sms.setStored(true);
                            this.scheduler.setDestCluster(sms.getSmsSet());
                            store.c2_scheduleMessage_ReschedDueSlot(sms, smscPropertiesManagement.getStoreAndForwordMode() == StoreAndForwordMode.fast, false);
                        }
                        catch (PersistenceException e) {
                            throw new SmscProcessingException("PersistenceException when storing LIVE_SMS : " + e.getMessage(), 69, 34, null, (Throwable)e);
                        }
                    }
                }
                finally {
                    store.releaseSynchroObject(lock);
                }
            }
            if (mProcResult.isMessageRejected()) {
                SmscProcessingException e = new SmscProcessingException("Message is rejected by MProc rules", 69, 0, null);
                e.setSkipErrorLogging(true);
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("TxSmpp: incoming message is rejected by mProc rules, message=[" + sms0 + "]");
                }
                throw e;
            }
            if (mProcResult.isMessageDropped()) {
                this.smscStatAggregator.updateMsgInFailedAll();
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("TxSmpp: incoming message is dropped by mProc rules, message=[" + sms0 + "]");
                }
                return;
            }
            this.smscStatAggregator.updateMsgInReceivedAll();
            this.smscStatAggregator.updateMsgInReceivedSip();
        }
    }

    public abstract ChildRelationExt getChargingSbb();

    private ChargingSbbLocalObject getChargingSbbObject() {
        ChargingSbbLocalObject ret;
        block3: {
            ChildRelationExt relation = this.getChargingSbb();
            ret = (ChargingSbbLocalObject)relation.get("0");
            if (ret == null) {
                try {
                    ret = (ChargingSbbLocalObject)relation.create("0");
                }
                catch (Exception e) {
                    if (!this.logger.isSevereEnabled()) break block3;
                    this.logger.severe("Exception while trying to creat ChargingSbb child", (Throwable)e);
                }
            }
        }
        return ret;
    }

    private byte[] hexStringToByteArray(String s) {
        int len = s.length();
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(s.charAt(i), 16) << 4) + Character.digit(s.charAt(i + 1), 16));
        }
        return data;
    }

    private DataCodingSchemeImpl createDataCodingScheme(int dcs) {
        CharacterSet chs = CharacterSet.getInstance((int)dcs);
        return new DataCodingSchemeImpl(DataCodingGroup.GeneralGroup, null, null, null, chs, false);
    }
}

