/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.smsc.slee.services.smpp.server.tx;

import com.cloudhopper.smpp.pdu.BaseSm;
import com.cloudhopper.smpp.pdu.DataSm;
import com.cloudhopper.smpp.pdu.DataSmResp;
import com.cloudhopper.smpp.pdu.DeliverSm;
import com.cloudhopper.smpp.pdu.DeliverSmResp;
import com.cloudhopper.smpp.pdu.PduRequest;
import com.cloudhopper.smpp.pdu.PduResponse;
import com.cloudhopper.smpp.pdu.SubmitMulti;
import com.cloudhopper.smpp.pdu.SubmitMultiResp;
import com.cloudhopper.smpp.pdu.SubmitSm;
import com.cloudhopper.smpp.pdu.SubmitSmResp;
import com.cloudhopper.smpp.tlv.Tlv;
import com.cloudhopper.smpp.tlv.TlvConvertException;
import com.cloudhopper.smpp.type.Address;
import com.cloudhopper.smpp.type.RecoverablePduException;
import com.cloudhopper.smpp.type.SmppInvalidArgumentException;
import com.cloudhopper.smpp.type.UnsucessfulSME;
import com.cloudhopper.smpp.util.TlvUtil;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.slee.ActivityContextInterface;
import javax.slee.ActivityEndEvent;
import javax.slee.CreateException;
import javax.slee.EventContext;
import javax.slee.RolledBackContext;
import javax.slee.Sbb;
import javax.slee.SbbContext;
import javax.slee.ServiceID;
import javax.slee.facilities.Tracer;
import javax.slee.resource.ResourceAdaptorTypeID;
import javax.slee.serviceactivity.ServiceActivity;
import javax.slee.serviceactivity.ServiceStartedEvent;
import javolution.util.FastList;
import org.mobicents.protocols.ss7.map.api.smstpdu.CharacterSet;
import org.mobicents.protocols.ss7.map.api.smstpdu.DataCodingScheme;
import org.mobicents.protocols.ss7.map.api.smstpdu.UserDataHeader;
import org.mobicents.protocols.ss7.map.datacoding.GSMCharset;
import org.mobicents.protocols.ss7.map.datacoding.GSMCharsetDecoder;
import org.mobicents.protocols.ss7.map.datacoding.GSMCharsetDecodingData;
import org.mobicents.protocols.ss7.map.datacoding.Gsm7EncodingStyle;
import org.mobicents.protocols.ss7.map.smstpdu.DataCodingSchemeImpl;
import org.mobicents.protocols.ss7.map.smstpdu.UserDataHeaderImpl;
import org.mobicents.slee.ChildRelationExt;
import org.mobicents.slee.SbbContextExt;
import org.mobicents.smsc.cassandra.PersistenceException;
import org.mobicents.smsc.domain.MProcManagement;
import org.mobicents.smsc.domain.SmscPropertiesManagement;
import org.mobicents.smsc.domain.SmscStatAggregator;
import org.mobicents.smsc.domain.SmscStatProvider;
import org.mobicents.smsc.domain.StoreAndForwordMode;
import org.mobicents.smsc.library.MessageDeliveryResultResponseInterface;
import org.mobicents.smsc.library.MessageUtil;
import org.mobicents.smsc.library.OriginationType;
import org.mobicents.smsc.library.SbbStates;
import org.mobicents.smsc.library.Sms;
import org.mobicents.smsc.library.SmsSet;
import org.mobicents.smsc.library.SmsSetCache;
import org.mobicents.smsc.library.SmscProcessingException;
import org.mobicents.smsc.library.TargetAddress;
import org.mobicents.smsc.mproc.impl.MProcResult;
import org.mobicents.smsc.slee.resources.persistence.PersistenceRAInterface;
import org.mobicents.smsc.slee.resources.scheduler.SchedulerRaSbbInterface;
import org.mobicents.smsc.slee.resources.smpp.server.SmppSessions;
import org.mobicents.smsc.slee.resources.smpp.server.SmppTransaction;
import org.mobicents.smsc.slee.resources.smpp.server.SmppTransactionACIFactory;
import org.mobicents.smsc.slee.resources.smpp.server.events.PduRequestTimeout;
import org.mobicents.smsc.slee.services.charging.ChargingMedium;
import org.mobicents.smsc.slee.services.charging.ChargingSbbLocalObject;
import org.mobicents.smsc.slee.services.smpp.server.tx.MessageDeliveryResultResponseSmpp;
import org.mobicents.smsc.slee.services.smpp.server.tx.SubmitMultiParseResult;
import org.mobicents.smsc.smpp.CheckMessageLimitResult;
import org.mobicents.smsc.smpp.Esme;
import org.mobicents.smsc.smpp.SmppEncoding;

public abstract class TxSmppServerSbb
implements Sbb {
    protected static SmscPropertiesManagement smscPropertiesManagement = SmscPropertiesManagement.getInstance();
    private static final ResourceAdaptorTypeID PERSISTENCE_ID = new ResourceAdaptorTypeID("PersistenceResourceAdaptorType", "org.mobicents", "1.0");
    private static final String PERSISTENCE_LINK = "PersistenceResourceAdaptor";
    private static final ResourceAdaptorTypeID SCHEDULER_ID = new ResourceAdaptorTypeID("SchedulerResourceAdaptorType", "org.mobicents", "1.0");
    private static final String SCHEDULER_LINK = "SchedulerResourceAdaptor";
    protected Tracer logger;
    private SbbContextExt sbbContext;
    private SmppTransactionACIFactory smppServerTransactionACIFactory = null;
    protected SmppSessions smppServerSessions = null;
    protected PersistenceRAInterface persistence = null;
    protected SchedulerRaSbbInterface scheduler = null;
    private SmscStatAggregator smscStatAggregator = SmscStatAggregator.getInstance();
    private static Charset utf8Charset = Charset.forName("UTF-8");
    private static Charset ucs2Charset = Charset.forName("UTF-16BE");
    private static Charset isoCharset = Charset.forName("ISO-8859-1");
    private static Charset gsm7Charset = new GSMCharset("GSM", new String[0]);

    public PersistenceRAInterface getStore() {
        return this.persistence;
    }

    public void onSubmitSm(SubmitSm event, ActivityContextInterface aci) {
        Sms sms;
        CheckMessageLimitResult cres;
        Date dt0 = new Date();
        Date dt1 = new Date();
        SmppTransaction smppServerTransaction = (SmppTransaction)aci.getActivity();
        Esme esme = smppServerTransaction.getEsme();
        String esmeName = esme.getName();
        if (this.logger.isFineEnabled()) {
            this.logger.fine("\nReceived SUBMIT_SM = " + event + " from Esme name=" + esmeName);
        }
        if ((cres = esme.onMessageReceived(1)).getResult() != CheckMessageLimitResult.Result.ok) {
            if (cres.getResult() == CheckMessageLimitResult.Result.firstFault) {
                this.updateOverrateCounters(cres);
                this.logger.info(cres.getMessage());
            }
            SubmitSmResp response = event.createResponse();
            response.setCommandStatus(88);
            String s = cres.getMessage();
            if (s.length() > 255) {
                s = s.substring(0, 255);
            }
            try {
                Tlv tlv = TlvUtil.createNullTerminatedStringTlv((short)29, (String)s);
                response.addOptionalParameter(tlv);
            }
            catch (TlvConvertException e) {
                this.logger.severe("TlvConvertException while storing TAG_ADD_STATUS_INFO Tlv parameter", (Throwable)e);
            }
            try {
                this.smppServerSessions.sendResponsePdu(esme, (PduRequest)event, (PduResponse)response);
            }
            catch (Exception e) {
                this.logger.severe("Error while trying to send SubmitSmResponse=" + response, (Throwable)e);
            }
            return;
        }
        try {
            TargetAddress ta = this.createDestTargetAddress(event.getDestAddress(), esme.getNetworkId());
            PersistenceRAInterface store = this.getStore();
            sms = this.createSmsEvent((BaseSm)event, esme, ta, store);
            this.processSms(sms, store, esme, event, null, null, IncomingMessageType.submit_sm);
        }
        catch (SmscProcessingException e1) {
            if (!e1.isSkipErrorLogging()) {
                this.logger.severe(e1.getMessage(), (Throwable)e1);
                this.smscStatAggregator.updateMsgInFailedAll();
            }
            SubmitSmResp response = event.createResponse();
            response.setCommandStatus(e1.getSmppErrorCode());
            String s = e1.getMessage();
            if (s != null) {
                if (s.length() > 255) {
                    s = s.substring(0, 255);
                }
                try {
                    Tlv tlv = TlvUtil.createNullTerminatedStringTlv((short)29, (String)s);
                    response.addOptionalParameter(tlv);
                }
                catch (TlvConvertException e) {
                    this.logger.severe("TlvConvertException while storing TAG_ADD_STATUS_INFO Tlv parameter", (Throwable)e);
                }
            }
            try {
                this.smppServerSessions.sendResponsePdu(esme, (PduRequest)event, (PduResponse)response);
            }
            catch (Exception e) {
                this.logger.severe("Error while trying to send SubmitSmResponse=" + response, (Throwable)e);
            }
            return;
        }
        catch (Throwable e1) {
            String s = "Exception when processing SubmitSm message: " + e1.getMessage();
            this.logger.severe(s, e1);
            this.smscStatAggregator.updateMsgInFailedAll();
            SubmitSmResp response = event.createResponse();
            response.setCommandStatus(8);
            if (s.length() > 255) {
                s = s.substring(0, 255);
            }
            try {
                Tlv tlv = TlvUtil.createNullTerminatedStringTlv((short)29, (String)s);
                response.addOptionalParameter(tlv);
            }
            catch (TlvConvertException e) {
                this.logger.severe("TlvConvertException while storing TAG_ADD_STATUS_INFO Tlv parameter", (Throwable)e);
            }
            try {
                this.smppServerSessions.sendResponsePdu(esme, (PduRequest)event, (PduResponse)response);
            }
            catch (Exception e) {
                this.logger.severe("Error while trying to send SubmitSmResponse=" + response, (Throwable)e);
            }
            return;
        }
        SubmitSmResp response = event.createResponse();
        response.setMessageId(Long.valueOf(sms.getMessageId()).toString());
        try {
            if (sms.getMessageDeliveryResultResponse() == null) {
                this.smppServerSessions.sendResponsePdu(esme, (PduRequest)event, (PduResponse)response);
            }
        }
        catch (Throwable e) {
            this.logger.severe("Error while trying to send SubmitSmResponse=" + response, e);
        }
        Date dt3 = new Date();
        SmscStatProvider.getInstance().setParam1((int)(dt3.getTime() - dt0.getTime()));
        SmscStatProvider.getInstance().setParam2((int)(dt3.getTime() - dt1.getTime()));
    }

    private void updateOverrateCounters(CheckMessageLimitResult cres) {
        switch (cres.getDomain()) {
            case perSecond: {
                this.smscStatAggregator.updateSmppSecondRateOverlimitFail();
                break;
            }
            case perMinute: {
                this.smscStatAggregator.updateSmppMinuteRateOverlimitFail();
                break;
            }
            case perHour: {
                this.smscStatAggregator.updateSmppHourRateOverlimitFail();
                break;
            }
            case perDay: {
                this.smscStatAggregator.updateSmppDayRateOverlimitFail();
            }
        }
    }

    public void onDataSm(DataSm event, ActivityContextInterface aci) {
        Sms sms;
        CheckMessageLimitResult cres;
        SmppTransaction smppServerTransaction = (SmppTransaction)aci.getActivity();
        Esme esme = smppServerTransaction.getEsme();
        String esmeName = esme.getName();
        if (this.logger.isFineEnabled()) {
            this.logger.fine("Received DATA_SM = " + event + " from Esme name=" + esmeName);
        }
        if ((cres = esme.onMessageReceived(1)).getResult() != CheckMessageLimitResult.Result.ok) {
            if (cres.getResult() == CheckMessageLimitResult.Result.firstFault) {
                this.updateOverrateCounters(cres);
                this.logger.info(cres.getMessage());
            }
            DataSmResp response = event.createResponse();
            response.setCommandStatus(88);
            String s = cres.getMessage();
            if (s.length() > 255) {
                s = s.substring(0, 255);
            }
            try {
                Tlv tlv = TlvUtil.createNullTerminatedStringTlv((short)29, (String)s);
                response.addOptionalParameter(tlv);
            }
            catch (TlvConvertException e) {
                this.logger.severe("TlvConvertException while storing TAG_ADD_STATUS_INFO Tlv parameter", (Throwable)e);
            }
            try {
                this.smppServerSessions.sendResponsePdu(esme, (PduRequest)event, (PduResponse)response);
            }
            catch (Exception e) {
                this.logger.severe("Error while trying to send DataSmResponse=" + response, (Throwable)e);
            }
            return;
        }
        try {
            TargetAddress ta = this.createDestTargetAddress(event.getDestAddress(), esme.getNetworkId());
            PersistenceRAInterface store = this.getStore();
            sms = this.createSmsEvent((BaseSm)event, esme, ta, store);
            this.processSms(sms, store, esme, null, event, null, IncomingMessageType.data_sm);
        }
        catch (SmscProcessingException e1) {
            if (!e1.isSkipErrorLogging()) {
                this.logger.severe(e1.getMessage(), (Throwable)e1);
                this.smscStatAggregator.updateMsgInFailedAll();
            }
            DataSmResp response = event.createResponse();
            response.setCommandStatus(e1.getSmppErrorCode());
            String s = e1.getMessage();
            if (s != null) {
                if (s.length() > 255) {
                    s = s.substring(0, 255);
                }
                try {
                    Tlv tlv = TlvUtil.createNullTerminatedStringTlv((short)29, (String)s);
                    response.addOptionalParameter(tlv);
                }
                catch (TlvConvertException e) {
                    this.logger.severe("TlvConvertException while storing TAG_ADD_STATUS_INFO Tlv parameter", (Throwable)e);
                }
            }
            try {
                this.smppServerSessions.sendResponsePdu(esme, (PduRequest)event, (PduResponse)response);
            }
            catch (Exception e) {
                this.logger.severe("Error while trying to send DataSmResponse=" + response, (Throwable)e);
            }
            return;
        }
        catch (Throwable e1) {
            String s = "Exception when processing dataSm message: " + e1.getMessage();
            this.logger.severe(s, e1);
            this.smscStatAggregator.updateMsgInFailedAll();
            DataSmResp response = event.createResponse();
            response.setCommandStatus(8);
            if (s.length() > 255) {
                s = s.substring(0, 255);
            }
            try {
                Tlv tlv = TlvUtil.createNullTerminatedStringTlv((short)29, (String)s);
                response.addOptionalParameter(tlv);
            }
            catch (TlvConvertException e) {
                this.logger.severe("TlvConvertException while storing TAG_ADD_STATUS_INFO Tlv parameter", (Throwable)e);
            }
            try {
                this.smppServerSessions.sendResponsePdu(esme, (PduRequest)event, (PduResponse)response);
            }
            catch (Exception e) {
                this.logger.severe("Error while trying to send SubmitSmResponse=" + response, (Throwable)e);
            }
            return;
        }
        DataSmResp response = event.createResponse();
        response.setMessageId(Long.valueOf(sms.getMessageId()).toString());
        try {
            if (sms.getMessageDeliveryResultResponse() == null) {
                this.smppServerSessions.sendResponsePdu(esme, (PduRequest)event, (PduResponse)response);
            }
        }
        catch (Exception e) {
            this.logger.severe("Error while trying to send DataSmResponse=" + response, (Throwable)e);
        }
    }

    public void onSubmitMulti(SubmitMulti event, ActivityContextInterface aci) {
        Sms sms2;
        SubmitMultiParseResult parseResult;
        CheckMessageLimitResult cres;
        SmppTransaction smppServerTransaction = (SmppTransaction)aci.getActivity();
        Esme esme = smppServerTransaction.getEsme();
        String esmeName = esme.getName();
        if (this.logger.isFineEnabled()) {
            this.logger.fine("\nReceived SUBMIT_MULTI = " + event + " from Esme name=" + esmeName);
        }
        List addrList = event.getDestAddresses();
        int msgCnt = 0;
        if (addrList != null) {
            msgCnt = addrList.size();
        }
        if ((cres = esme.onMessageReceived(msgCnt)).getResult() != CheckMessageLimitResult.Result.ok) {
            if (cres.getResult() == CheckMessageLimitResult.Result.firstFault) {
                this.updateOverrateCounters(cres);
                this.logger.info(cres.getMessage());
            }
            SubmitMultiResp response = event.createResponse();
            response.setCommandStatus(88);
            String s = cres.getMessage();
            if (s.length() > 255) {
                s = s.substring(0, 255);
            }
            try {
                Tlv tlv = TlvUtil.createNullTerminatedStringTlv((short)29, (String)s);
                response.addOptionalParameter(tlv);
            }
            catch (TlvConvertException e) {
                this.logger.severe("TlvConvertException while storing TAG_ADD_STATUS_INFO Tlv parameter", (Throwable)e);
            }
            try {
                this.smppServerSessions.sendResponsePdu(esme, (PduRequest)event, (PduResponse)response);
            }
            catch (Exception e) {
                this.logger.severe("Error while trying to send SubmitMultiResponse=" + response, (Throwable)e);
            }
            return;
        }
        PersistenceRAInterface store = this.getStore();
        try {
            parseResult = this.createSmsEventMulti(event, esme, store, esme.getNetworkId());
            for (Sms sms2 : parseResult.getParsedMessages()) {
                this.processSms(sms2, store, esme, null, null, event, IncomingMessageType.submit_multi);
            }
        }
        catch (SmscProcessingException e1) {
            if (!e1.isSkipErrorLogging()) {
                this.logger.severe(e1.getMessage(), (Throwable)e1);
                this.smscStatAggregator.updateMsgInFailedAll();
            }
            SubmitMultiResp response = event.createResponse();
            response.setCommandStatus(e1.getSmppErrorCode());
            String s = e1.getMessage();
            if (s != null) {
                if (s.length() > 255) {
                    s = s.substring(0, 255);
                }
                try {
                    Tlv tlv = TlvUtil.createNullTerminatedStringTlv((short)29, (String)s);
                    response.addOptionalParameter(tlv);
                }
                catch (TlvConvertException e) {
                    this.logger.severe("TlvConvertException while storing TAG_ADD_STATUS_INFO Tlv parameter", (Throwable)e);
                }
            }
            try {
                this.smppServerSessions.sendResponsePdu(esme, (PduRequest)event, (PduResponse)response);
            }
            catch (Exception e) {
                this.logger.severe("Error while trying to send SubmitMultiResponse=" + response, (Throwable)e);
            }
            return;
        }
        catch (Throwable e1) {
            String s = "Exception when processing SubmitMulti message: " + e1.getMessage();
            this.logger.severe(s, e1);
            this.smscStatAggregator.updateMsgInFailedAll();
            SubmitMultiResp response = event.createResponse();
            response.setCommandStatus(8);
            if (s.length() > 255) {
                s = s.substring(0, 255);
            }
            try {
                Tlv tlv = TlvUtil.createNullTerminatedStringTlv((short)29, (String)s);
                response.addOptionalParameter(tlv);
            }
            catch (TlvConvertException e) {
                this.logger.severe("TlvConvertException while storing TAG_ADD_STATUS_INFO Tlv parameter", (Throwable)e);
            }
            try {
                this.smppServerSessions.sendResponsePdu(esme, (PduRequest)event, (PduResponse)response);
            }
            catch (Exception e) {
                this.logger.severe("Error while trying to send SubmitMultiResponse=" + response, (Throwable)e);
            }
            return;
        }
        SubmitMultiResp response = event.createResponse();
        sms2 = null;
        if (parseResult.getParsedMessages().size() > 0) {
            sms2 = parseResult.getParsedMessages().get(0);
        }
        if (sms2 != null) {
            response.setMessageId(Long.valueOf(sms2.getMessageId()).toString());
        }
        for (UnsucessfulSME usme : parseResult.getBadAddresses()) {
            try {
                response.addUnsucessfulSME(usme);
            }
            catch (SmppInvalidArgumentException e) {
                e.printStackTrace();
            }
        }
        try {
            if (sms2 == null || sms2.getMessageDeliveryResultResponse() == null) {
                this.smppServerSessions.sendResponsePdu(esme, (PduRequest)event, (PduResponse)response);
            }
        }
        catch (Throwable e) {
            this.logger.severe("Error while trying to send SubmitMultiResponse=" + response, e);
        }
    }

    private TargetAddress createDestTargetAddress(Address addr, int networkId) throws SmscProcessingException {
        int destNpi;
        int destTon;
        if (addr == null || addr.getAddress() == null || addr.getAddress().isEmpty()) {
            throw new SmscProcessingException("DestAddress digits are absent", 11, 34, (Object)addr);
        }
        switch (addr.getTon()) {
            case 0: {
                destTon = smscPropertiesManagement.getDefaultTon();
                break;
            }
            case 1: {
                destTon = addr.getTon();
                break;
            }
            case 2: {
                destTon = addr.getTon();
                break;
            }
            case 5: {
                destTon = addr.getTon();
                break;
            }
            default: {
                throw new SmscProcessingException("DestAddress TON not supported: " + addr.getTon(), 80, 34, (Object)addr);
            }
        }
        if (addr.getTon() == 5) {
            destNpi = addr.getNpi();
        } else {
            switch (addr.getNpi()) {
                case 0: {
                    destNpi = smscPropertiesManagement.getDefaultNpi();
                    break;
                }
                case 1: {
                    destNpi = addr.getNpi();
                    break;
                }
                default: {
                    throw new SmscProcessingException("DestAddress NPI not supported: " + addr.getNpi(), 81, 34, (Object)addr);
                }
            }
        }
        TargetAddress ta = new TargetAddress(destTon, destNpi, addr.getAddress(), networkId);
        return ta;
    }

    public void onDeliverSm(DeliverSm event, ActivityContextInterface aci) {
        Sms sms;
        CheckMessageLimitResult cres;
        SmppTransaction smppServerTransaction = (SmppTransaction)aci.getActivity();
        Esme esme = smppServerTransaction.getEsme();
        String esmeName = esme.getName();
        if (this.logger.isFineEnabled()) {
            this.logger.fine("\nReceived DELIVER_SM = " + event + " from Esme name=" + esmeName);
        }
        if ((cres = esme.onMessageReceived(1)).getResult() != CheckMessageLimitResult.Result.ok) {
            if (cres.getResult() == CheckMessageLimitResult.Result.firstFault) {
                this.updateOverrateCounters(cres);
                this.logger.info(cres.getMessage());
            }
            DeliverSmResp response = event.createResponse();
            response.setCommandStatus(88);
            String s = cres.getMessage();
            if (s.length() > 255) {
                s = s.substring(0, 255);
            }
            try {
                Tlv tlv = TlvUtil.createNullTerminatedStringTlv((short)29, (String)s);
                response.addOptionalParameter(tlv);
            }
            catch (TlvConvertException e) {
                this.logger.severe("TlvConvertException while storing TAG_ADD_STATUS_INFO Tlv parameter", (Throwable)e);
            }
            try {
                this.smppServerSessions.sendResponsePdu(esme, (PduRequest)event, (PduResponse)response);
            }
            catch (Exception e) {
                this.logger.severe("Error while trying to send DeliverSmResponse=" + response, (Throwable)e);
            }
            return;
        }
        try {
            TargetAddress ta = this.createDestTargetAddress(event.getDestAddress(), esme.getNetworkId());
            PersistenceRAInterface store = this.getStore();
            sms = this.createSmsEvent((BaseSm)event, esme, ta, store);
            this.processSms(sms, store, esme, null, null, null, IncomingMessageType.deliver_sm);
        }
        catch (SmscProcessingException e1) {
            if (!e1.isSkipErrorLogging()) {
                this.logger.severe(e1.getMessage(), (Throwable)e1);
                this.smscStatAggregator.updateMsgInFailedAll();
            }
            DeliverSmResp response = event.createResponse();
            response.setCommandStatus(e1.getSmppErrorCode());
            String s = e1.getMessage();
            if (s != null) {
                if (s.length() > 255) {
                    s = s.substring(0, 255);
                }
                try {
                    Tlv tlv = TlvUtil.createNullTerminatedStringTlv((short)29, (String)s);
                    response.addOptionalParameter(tlv);
                }
                catch (TlvConvertException e) {
                    this.logger.severe("TlvConvertException while storing TAG_ADD_STATUS_INFO Tlv parameter", (Throwable)e);
                }
            }
            try {
                this.smppServerSessions.sendResponsePdu(esme, (PduRequest)event, (PduResponse)response);
            }
            catch (Exception e) {
                this.logger.severe("Error while trying to send SubmitSmResponse=" + response, (Throwable)e);
            }
            return;
        }
        catch (Throwable e1) {
            String s = "Exception when processing SubmitSm message: " + e1.getMessage();
            this.logger.severe(s, e1);
            this.smscStatAggregator.updateMsgInFailedAll();
            DeliverSmResp response = event.createResponse();
            response.setCommandStatus(8);
            if (s.length() > 255) {
                s = s.substring(0, 255);
            }
            try {
                Tlv tlv = TlvUtil.createNullTerminatedStringTlv((short)29, (String)s);
                response.addOptionalParameter(tlv);
            }
            catch (TlvConvertException e) {
                this.logger.severe("TlvConvertException while storing TAG_ADD_STATUS_INFO Tlv parameter", (Throwable)e);
            }
            try {
                this.smppServerSessions.sendResponsePdu(esme, (PduRequest)event, (PduResponse)response);
            }
            catch (Exception e) {
                this.logger.severe("Error while trying to send SubmitSmResponse=" + response, (Throwable)e);
            }
            return;
        }
        DeliverSmResp response = event.createResponse();
        response.setMessageId(Long.valueOf(sms.getMessageId()).toString());
        try {
            this.smppServerSessions.sendResponsePdu(esme, (PduRequest)event, (PduResponse)response);
        }
        catch (Throwable e) {
            this.logger.severe("Error while trying to send SubmitSmResponse=" + response, e);
        }
    }

    public void onPduRequestTimeout(PduRequestTimeout event, ActivityContextInterface aci, EventContext eventContext) {
        this.logger.severe(String.format("\nonPduRequestTimeout : PduRequestTimeout=%s", event));
    }

    public void onRecoverablePduException(RecoverablePduException event, ActivityContextInterface aci, EventContext eventContext) {
        this.logger.severe(String.format("\nonRecoverablePduException : RecoverablePduException=%s", event));
    }

    public void sbbActivate() {
    }

    public void sbbCreate() throws CreateException {
    }

    public void sbbExceptionThrown(Exception arg0, Object arg1, ActivityContextInterface arg2) {
    }

    public void sbbLoad() {
    }

    public void sbbPassivate() {
    }

    public void sbbPostCreate() throws CreateException {
    }

    public void sbbRemove() {
    }

    public void sbbRolledBack(RolledBackContext arg0) {
    }

    public void sbbStore() {
    }

    public void setSbbContext(SbbContext sbbContext) {
        this.sbbContext = (SbbContextExt)sbbContext;
        try {
            Context ctx = (Context)new InitialContext().lookup("java:comp/env");
            this.smppServerTransactionACIFactory = (SmppTransactionACIFactory)ctx.lookup("slee/resources/smppp/server/1.0/acifactory");
            this.smppServerSessions = (SmppSessions)ctx.lookup("slee/resources/smpp/server/1.0/provider");
            this.logger = this.sbbContext.getTracer(this.getClass().getSimpleName());
            this.persistence = (PersistenceRAInterface)this.sbbContext.getResourceAdaptorInterface(PERSISTENCE_ID, PERSISTENCE_LINK);
            this.scheduler = (SchedulerRaSbbInterface)this.sbbContext.getResourceAdaptorInterface(SCHEDULER_ID, SCHEDULER_LINK);
        }
        catch (Exception ne) {
            this.logger.severe("Could not set SBB context:", (Throwable)ne);
        }
    }

    public void unsetSbbContext() {
    }

    public void onServiceStartedEvent(ServiceStartedEvent event, ActivityContextInterface aci, EventContext eventContext) {
        ServiceID serviceID = event.getService();
        this.logger.info("Rx: onServiceStartedEvent: event=" + event + ", serviceID=" + serviceID);
        SbbStates.setSmscTxSmppServerServiceState((boolean)true);
    }

    public void onActivityEndEvent(ActivityEndEvent event, ActivityContextInterface aci, EventContext eventContext) {
        boolean isServiceActivity = aci.getActivity() instanceof ServiceActivity;
        if (isServiceActivity) {
            this.logger.info("Rx: onActivityEndEvent: event=" + event + ", isServiceActivity=" + isServiceActivity);
            SbbStates.setSmscTxSmppServerServiceState((boolean)false);
        }
    }

    protected Sms createSmsEvent(BaseSm event, Esme origEsme, TargetAddress ta, PersistenceRAInterface store) throws SmscProcessingException {
        Date scheduleDeliveryTime;
        Date validityPeriod;
        Tlv tlvQosTimeToLive;
        String msg;
        int udhLen;
        Tlv messagePaylod;
        Tlv dest_addr_subunit;
        Sms sms = new Sms();
        sms.setDbId(UUID.randomUUID());
        sms.setOriginationType(OriginationType.SMPP);
        if (event.getSourceAddress() == null || event.getSourceAddress().getAddress() == null || event.getSourceAddress().getAddress().isEmpty()) {
            throw new SmscProcessingException("SourceAddress digits are absent", 10, 34, null);
        }
        sms.setSourceAddr(event.getSourceAddress().getAddress());
        switch (event.getSourceAddress().getTon()) {
            case 0: {
                sms.setSourceAddrTon(smscPropertiesManagement.getDefaultTon());
                break;
            }
            case 1: {
                sms.setSourceAddrTon((int)event.getSourceAddress().getTon());
                break;
            }
            case 2: {
                sms.setSourceAddrTon((int)event.getSourceAddress().getTon());
                break;
            }
            case 5: {
                sms.setSourceAddrTon((int)event.getSourceAddress().getTon());
                break;
            }
            default: {
                throw new SmscProcessingException("SourceAddress TON not supported: " + event.getSourceAddress().getTon(), 72, 34, null);
            }
        }
        if (event.getSourceAddress().getTon() != 5) {
            switch (event.getSourceAddress().getNpi()) {
                case 0: {
                    sms.setSourceAddrNpi(smscPropertiesManagement.getDefaultNpi());
                    break;
                }
                case 1: {
                    sms.setSourceAddrNpi((int)event.getSourceAddress().getNpi());
                    break;
                }
                default: {
                    throw new SmscProcessingException("SourceAddress NPI not supported: " + event.getSourceAddress().getNpi(), 73, 34, null);
                }
            }
        }
        sms.setOrigNetworkId(origEsme.getNetworkId());
        int dcs = event.getDataCoding();
        String err = MessageUtil.checkDataCodingSchemeSupport((int)dcs);
        if (err != null) {
            throw new SmscProcessingException("TxSmpp DataCoding scheme does not supported: " + dcs + " - " + err, 260, 34, null);
        }
        ArrayList optionalParameters = event.getOptionalParameters();
        if (optionalParameters != null && optionalParameters.size() > 0) {
            for (Tlv tlv : optionalParameters) {
                if (tlv.getTag() == 1060) continue;
                sms.getTlvSet().addOptionalParameter(tlv);
            }
        }
        if ((dest_addr_subunit = sms.getTlvSet().getOptionalParameter((short)5)) != null) {
            try {
                byte mclass = dest_addr_subunit.getValueAsByte();
                if (mclass >= 1 && mclass <= 4) {
                    dcs |= 16 + (mclass - 1);
                }
            }
            catch (TlvConvertException e) {
                e.printStackTrace();
            }
        }
        DataCodingSchemeImpl dataCodingScheme = new DataCodingSchemeImpl(dcs);
        sms.setDataCoding(dcs);
        sms.setOrigSystemId(origEsme.getSystemId());
        sms.setOrigEsmeName(origEsme.getName());
        sms.setSubmitDate((Date)new Timestamp(System.currentTimeMillis()));
        sms.setServiceType(event.getServiceType());
        sms.setEsmClass((int)event.getEsmClass());
        sms.setProtocolId((int)event.getProtocolId());
        sms.setPriority((int)event.getPriority());
        sms.setRegisteredDelivery((int)event.getRegisteredDelivery());
        sms.setReplaceIfPresent((int)event.getReplaceIfPresent());
        sms.setDefaultMsgId((int)event.getDefaultMsgId());
        boolean udhPresent = (event.getEsmClass() & 0x40) != 0;
        Tlv sarMsgRefNum = event.getOptionalParameter((short)524);
        Tlv sarTotalSegments = event.getOptionalParameter((short)526);
        Tlv sarSegmentSeqnum = event.getOptionalParameter((short)527);
        boolean segmentTlvFlag = sarMsgRefNum != null && sarTotalSegments != null && sarSegmentSeqnum != null;
        byte[] data = event.getShortMessage();
        if (event.getShortMessageLength() == 0 && (messagePaylod = event.getOptionalParameter((short)1060)) != null) {
            data = messagePaylod.getValue();
        }
        if (data == null) {
            data = new byte[]{};
        }
        byte[] udhData = null;
        byte[] textPart = data;
        if (udhPresent && data.length > 2 && (udhLen = (textPart[0] & 0xFF) + 1) <= textPart.length) {
            textPart = new byte[textPart.length - udhLen];
            udhData = new byte[udhLen];
            System.arraycopy(data, udhLen, textPart, 0, textPart.length);
            System.arraycopy(data, 0, udhData, 0, udhLen);
        }
        if (dataCodingScheme.getCharacterSet() == CharacterSet.GSM8) {
            msg = new String(textPart, isoCharset);
        } else {
            SmppEncoding enc = dataCodingScheme.getCharacterSet() == CharacterSet.GSM7 ? smscPropertiesManagement.getSmppEncodingForGsm7() : smscPropertiesManagement.getSmppEncodingForUCS2();
            switch (enc) {
                default: {
                    msg = new String(textPart, utf8Charset);
                    break;
                }
                case Unicode: {
                    msg = new String(textPart, ucs2Charset);
                    break;
                }
                case Gsm7: {
                    GSMCharsetDecoder decoder = (GSMCharsetDecoder)gsm7Charset.newDecoder();
                    decoder.setGSMCharsetDecodingData(new GSMCharsetDecodingData(Gsm7EncodingStyle.bit8_smpp_style, Integer.MAX_VALUE, 0));
                    ByteBuffer bb = ByteBuffer.wrap(textPart);
                    CharBuffer bf = null;
                    try {
                        bf = decoder.decode(bb);
                    }
                    catch (CharacterCodingException e) {
                        // empty catch block
                    }
                    msg = bf.toString();
                }
            }
        }
        sms.setShortMessageText(msg);
        sms.setShortMessageBin(udhData);
        if (origEsme.getMinMessageLength() >= 0 && msg.length() < origEsme.getMinMessageLength()) {
            SmscProcessingException e = new SmscProcessingException("Message length is less than a min length limit for ESME=" + origEsme.getName() + ", len=" + msg.length(), 1, 34, null);
            e.setSkipErrorLogging(true);
            throw e;
        }
        if (origEsme.getMaxMessageLength() >= 0 && msg.length() > origEsme.getMaxMessageLength()) {
            SmscProcessingException e = new SmscProcessingException("Message length is more than a max length limit for ESME=" + origEsme.getName() + ", len=" + msg.length(), 1, 34, null);
            e.setSkipErrorLogging(true);
            throw e;
        }
        if (udhPresent || segmentTlvFlag) {
            UserDataHeaderImpl udh = null;
            int lenSolid = MessageUtil.getMaxSolidMessageBytesLength();
            if (udhPresent) {
                udh = new UserDataHeaderImpl(udhData);
            } else {
                udh = this.createNationalLanguageUdh(origEsme, (DataCodingScheme)dataCodingScheme);
                if (udh != null && udh.getNationalLanguageLockingShift() != null) {
                    lenSolid -= 3;
                    sms.setNationalLanguageLockingShift(udh.getNationalLanguageLockingShift().getNationalLanguageIdentifier().getCode());
                }
                if (udh != null && udh.getNationalLanguageSingleShift() != null) {
                    lenSolid -= 3;
                    sms.setNationalLanguageSingleShift(udh.getNationalLanguageSingleShift().getNationalLanguageIdentifier().getCode());
                }
            }
            int messageLen = MessageUtil.getMessageLengthInBytes((DataCodingScheme)dataCodingScheme, (String)msg, (UserDataHeader)udh);
            if (udhData != null) {
                lenSolid -= udhData.length;
            }
            if (messageLen > lenSolid) {
                throw new SmscProcessingException("Message length in bytes is too big for solid message: " + messageLen + ">" + lenSolid, 194, 34, null);
            }
        } else {
            int lenSegmented = MessageUtil.getMaxSegmentedMessageBytesLength();
            UserDataHeader udh = this.createNationalLanguageUdh(origEsme, (DataCodingScheme)dataCodingScheme);
            if (msg.length() * 2 > (lenSegmented - 6) * 255) {
                int messageLen = MessageUtil.getMessageLengthInBytes((DataCodingScheme)dataCodingScheme, (String)msg, (UserDataHeader)udh);
                if (udh != null) {
                    if (udh.getNationalLanguageLockingShift() != null) {
                        lenSegmented -= 3;
                        sms.setNationalLanguageLockingShift(udh.getNationalLanguageLockingShift().getNationalLanguageIdentifier().getCode());
                    }
                    if (udh.getNationalLanguageSingleShift() != null) {
                        lenSegmented -= 3;
                        sms.setNationalLanguageSingleShift(udh.getNationalLanguageSingleShift().getNationalLanguageIdentifier().getCode());
                    }
                }
                if (messageLen > lenSegmented * 255) {
                    throw new SmscProcessingException("Message length in bytes is too big for segmented message: " + messageLen + ">" + lenSegmented, 194, 34, null);
                }
            } else if (udh != null) {
                if (udh.getNationalLanguageLockingShift() != null) {
                    sms.setNationalLanguageLockingShift(udh.getNationalLanguageLockingShift().getNationalLanguageIdentifier().getCode());
                }
                if (udh.getNationalLanguageSingleShift() != null) {
                    sms.setNationalLanguageSingleShift(udh.getNationalLanguageSingleShift().getNationalLanguageIdentifier().getCode());
                }
            }
        }
        if ((tlvQosTimeToLive = event.getOptionalParameter((short)23)) != null) {
            long valTime;
            try {
                valTime = new Date().getTime() + (long)tlvQosTimeToLive.getValueAsInt();
            }
            catch (TlvConvertException e) {
                throw new SmscProcessingException("TlvConvertException when getting TAG_QOS_TIME_TO_LIVE tlv field: " + e.getMessage(), 196, 34, null, (Throwable)e);
            }
            validityPeriod = new Date(valTime);
        } else {
            try {
                validityPeriod = MessageUtil.parseSmppDate((String)event.getValidityPeriod());
            }
            catch (ParseException e) {
                throw new SmscProcessingException("ParseException when parsing ValidityPeriod field: " + e.getMessage(), 98, 34, null, (Throwable)e);
            }
        }
        MessageUtil.applyValidityPeriod((Sms)sms, (Date)validityPeriod, (boolean)true, (int)smscPropertiesManagement.getMaxValidityPeriodHours(), (int)smscPropertiesManagement.getDefaultValidityPeriodHours());
        try {
            scheduleDeliveryTime = MessageUtil.parseSmppDate((String)event.getScheduleDeliveryTime());
        }
        catch (ParseException e) {
            throw new SmscProcessingException("ParseException when parsing ScheduleDeliveryTime field: " + e.getMessage(), 97, 34, null, (Throwable)e);
        }
        MessageUtil.applyScheduleDeliveryTime((Sms)sms, (Date)scheduleDeliveryTime);
        SmsSet smsSet = new SmsSet();
        smsSet.setDestAddr(ta.getAddr());
        smsSet.setDestAddrNpi(ta.getAddrNpi());
        smsSet.setDestAddrTon(ta.getAddrTon());
        smsSet.setNetworkId(origEsme.getNetworkId());
        smsSet.addSms(sms);
        sms.setSmsSet(smsSet);
        long messageId = store.c2_getNextMessageId();
        SmscStatProvider.getInstance().setCurrentMessageId(messageId);
        sms.setMessageId(messageId);
        return sms;
    }

    private UserDataHeader createNationalLanguageUdh(Esme origEsme, DataCodingScheme dataCodingScheme) {
        Object udh = null;
        int nationalLanguageSingleShift = 0;
        int nationalLanguageLockingShift = 0;
        if (dataCodingScheme.getCharacterSet() == CharacterSet.GSM7) {
            nationalLanguageSingleShift = origEsme.getNationalLanguageSingleShift();
            nationalLanguageLockingShift = origEsme.getNationalLanguageLockingShift();
            if (nationalLanguageSingleShift == -1) {
                nationalLanguageSingleShift = smscPropertiesManagement.getNationalLanguageSingleShift();
            }
            if (nationalLanguageLockingShift == -1) {
                nationalLanguageLockingShift = smscPropertiesManagement.getNationalLanguageLockingShift();
            }
        }
        return MessageUtil.getNationalLanguageIdentifierUdh((int)nationalLanguageLockingShift, (int)nationalLanguageSingleShift);
    }

    protected SubmitMultiParseResult createSmsEventMulti(SubmitMulti event, Esme origEsme, PersistenceRAInterface store, int networkId) throws SmscProcessingException {
        Date scheduleDeliveryTime;
        Date validityPeriod;
        Tlv tlvQosTimeToLive;
        String msg;
        int udhLen;
        Tlv messagePaylod;
        int sourceAddrTon;
        List addrList = event.getDestAddresses();
        if (addrList == null || addrList.size() == 0) {
            throw new SmscProcessingException("For received SubmitMulti no DestAddresses found: ", 52, 34, null);
        }
        if (event.getSourceAddress() == null || event.getSourceAddress().getAddress() == null || event.getSourceAddress().getAddress().isEmpty()) {
            throw new SmscProcessingException("SourceAddress digits are absent", 10, 34, null);
        }
        String sourceAddr = event.getSourceAddress().getAddress();
        int sourceAddrNpi = 0;
        switch (event.getSourceAddress().getTon()) {
            case 0: {
                sourceAddrTon = smscPropertiesManagement.getDefaultTon();
                break;
            }
            case 1: {
                sourceAddrTon = event.getSourceAddress().getTon();
                break;
            }
            case 2: {
                sourceAddrTon = event.getSourceAddress().getTon();
                break;
            }
            case 5: {
                sourceAddrTon = event.getSourceAddress().getTon();
                break;
            }
            default: {
                throw new SmscProcessingException("SourceAddress TON not supported: " + event.getSourceAddress().getTon(), 72, 34, null);
            }
        }
        if (event.getSourceAddress().getTon() != 5) {
            switch (event.getSourceAddress().getNpi()) {
                case 0: {
                    sourceAddrNpi = smscPropertiesManagement.getDefaultNpi();
                    break;
                }
                case 1: {
                    sourceAddrNpi = event.getSourceAddress().getNpi();
                    break;
                }
                default: {
                    throw new SmscProcessingException("SourceAddress NPI not supported: " + event.getSourceAddress().getNpi(), 73, 34, null);
                }
            }
        }
        int dcs = event.getDataCoding();
        String err = MessageUtil.checkDataCodingSchemeSupport((int)dcs);
        if (err != null) {
            throw new SmscProcessingException("TxSmpp DataCoding scheme does not supported: " + dcs + " - " + err, 260, 34, null);
        }
        ArrayList optionalParameters = event.getOptionalParameters();
        if (optionalParameters != null && optionalParameters.size() > 0) {
            for (Tlv tlv : optionalParameters) {
                if (tlv.getTag() != 5) continue;
                try {
                    byte mclass = tlv.getValueAsByte();
                    if (mclass < 1 || mclass > 4) break;
                    dcs |= 16 + (mclass - 1);
                }
                catch (TlvConvertException e) {
                    e.printStackTrace();
                }
                break;
            }
        }
        DataCodingSchemeImpl dataCodingScheme = new DataCodingSchemeImpl(dcs);
        boolean udhPresent = (event.getEsmClass() & 0x40) != 0;
        Tlv sarMsgRefNum = event.getOptionalParameter((short)524);
        Tlv sarTotalSegments = event.getOptionalParameter((short)526);
        Tlv sarSegmentSeqnum = event.getOptionalParameter((short)527);
        boolean segmentTlvFlag = sarMsgRefNum != null && sarTotalSegments != null && sarSegmentSeqnum != null;
        byte[] data = event.getShortMessage();
        if (event.getShortMessageLength() == 0 && (messagePaylod = event.getOptionalParameter((short)1060)) != null) {
            data = messagePaylod.getValue();
        }
        if (data == null) {
            data = new byte[]{};
        }
        byte[] udhData = null;
        byte[] textPart = data;
        if (udhPresent && data.length > 2 && (udhLen = (textPart[0] & 0xFF) + 1) <= textPart.length) {
            textPart = new byte[textPart.length - udhLen];
            udhData = new byte[udhLen];
            System.arraycopy(data, udhLen, textPart, 0, textPart.length);
            System.arraycopy(data, 0, udhData, 0, udhLen);
        }
        if (dataCodingScheme.getCharacterSet() == CharacterSet.GSM8) {
            msg = new String(textPart, isoCharset);
        } else {
            SmppEncoding enc = dataCodingScheme.getCharacterSet() == CharacterSet.GSM7 ? smscPropertiesManagement.getSmppEncodingForGsm7() : smscPropertiesManagement.getSmppEncodingForUCS2();
            switch (enc) {
                default: {
                    msg = new String(textPart, utf8Charset);
                    break;
                }
                case Unicode: {
                    msg = new String(textPart, ucs2Charset);
                    break;
                }
                case Gsm7: {
                    GSMCharsetDecoder decoder = (GSMCharsetDecoder)gsm7Charset.newDecoder();
                    decoder.setGSMCharsetDecodingData(new GSMCharsetDecodingData(Gsm7EncodingStyle.bit8_smpp_style, Integer.MAX_VALUE, 0));
                    ByteBuffer bb = ByteBuffer.wrap(textPart);
                    CharBuffer bf = null;
                    try {
                        bf = decoder.decode(bb);
                    }
                    catch (CharacterCodingException e) {
                        // empty catch block
                    }
                    msg = bf.toString();
                }
            }
        }
        int nationalLanguageLockingShift = 0;
        int nationalLanguageSingleShift = 0;
        if (udhPresent || segmentTlvFlag) {
            UserDataHeaderImpl udh = null;
            int lenSolid = MessageUtil.getMaxSolidMessageBytesLength();
            if (udhPresent) {
                udh = new UserDataHeaderImpl(udhData);
            } else {
                udh = this.createNationalLanguageUdh(origEsme, (DataCodingScheme)dataCodingScheme);
                if (udh.getNationalLanguageLockingShift() != null) {
                    lenSolid -= 3;
                    nationalLanguageLockingShift = udh.getNationalLanguageLockingShift().getNationalLanguageIdentifier().getCode();
                }
                if (udh.getNationalLanguageSingleShift() != null) {
                    lenSolid -= 3;
                    nationalLanguageSingleShift = udh.getNationalLanguageSingleShift().getNationalLanguageIdentifier().getCode();
                }
            }
            int messageLen = MessageUtil.getMessageLengthInBytes((DataCodingScheme)dataCodingScheme, (String)msg, (UserDataHeader)udh);
            if (udhData != null) {
                messageLen += udhData.length;
            }
            if (messageLen > lenSolid) {
                throw new SmscProcessingException("Message length in bytes is too big for solid message: " + messageLen + ">" + lenSolid, 194, 34, null);
            }
        } else {
            int lenSegmented = MessageUtil.getMaxSegmentedMessageBytesLength();
            if (msg.length() * 2 > (lenSegmented - 6) * 255) {
                UserDataHeader udh = this.createNationalLanguageUdh(origEsme, (DataCodingScheme)dataCodingScheme);
                int messageLen = MessageUtil.getMessageLengthInBytes((DataCodingScheme)dataCodingScheme, (String)msg, (UserDataHeader)udh);
                if (udh.getNationalLanguageLockingShift() != null) {
                    lenSegmented -= 3;
                    nationalLanguageLockingShift = udh.getNationalLanguageLockingShift().getNationalLanguageIdentifier().getCode();
                }
                if (udh.getNationalLanguageSingleShift() != null) {
                    lenSegmented -= 3;
                    nationalLanguageSingleShift = udh.getNationalLanguageSingleShift().getNationalLanguageIdentifier().getCode();
                }
                if (messageLen > lenSegmented * 255) {
                    throw new SmscProcessingException("Message length in bytes is too big for segmented message: " + messageLen + ">" + lenSegmented, 194, 34, null);
                }
            }
        }
        if ((tlvQosTimeToLive = event.getOptionalParameter((short)23)) != null) {
            long valTime;
            try {
                valTime = new Date().getTime() + (long)tlvQosTimeToLive.getValueAsInt();
            }
            catch (TlvConvertException e) {
                throw new SmscProcessingException("TlvConvertException when getting TAG_QOS_TIME_TO_LIVE tlv field: " + e.getMessage(), 196, 34, null, (Throwable)e);
            }
            validityPeriod = new Date(valTime);
        } else {
            try {
                validityPeriod = MessageUtil.parseSmppDate((String)event.getValidityPeriod());
            }
            catch (ParseException e) {
                throw new SmscProcessingException("ParseException when parsing ValidityPeriod field: " + e.getMessage(), 98, 34, null, (Throwable)e);
            }
        }
        try {
            scheduleDeliveryTime = MessageUtil.parseSmppDate((String)event.getScheduleDeliveryTime());
        }
        catch (ParseException e) {
            throw new SmscProcessingException("ParseException when parsing ScheduleDeliveryTime field: " + e.getMessage(), 97, 34, null, (Throwable)e);
        }
        long messageId = store.c2_getNextMessageId();
        SmscStatProvider.getInstance().setCurrentMessageId(messageId);
        ArrayList<Sms> msgList = new ArrayList<Sms>(addrList.size());
        ArrayList<UnsucessfulSME> badAddresses = new ArrayList<UnsucessfulSME>(addrList.size());
        for (Address address : addrList) {
            TargetAddress ta;
            boolean succAddr;
            block54: {
                succAddr = false;
                ta = null;
                try {
                    ta = this.createDestTargetAddress(address, networkId);
                    succAddr = true;
                }
                catch (SmscProcessingException e) {
                    Address addr = (Address)e.getExtraErrorData();
                    if (addr == null) break block54;
                    UnsucessfulSME asme = new UnsucessfulSME(e.getSmppErrorCode(), addr);
                    badAddresses.add(asme);
                }
            }
            if (!succAddr) continue;
            Sms sms = new Sms();
            sms.setDbId(UUID.randomUUID());
            sms.setOriginationType(OriginationType.SMPP);
            sms.setSourceAddr(sourceAddr);
            sms.setSourceAddrTon(sourceAddrTon);
            sms.setSourceAddrNpi(sourceAddrNpi);
            sms.setOrigNetworkId(networkId);
            sms.setDataCoding(dcs);
            sms.setNationalLanguageLockingShift(nationalLanguageLockingShift);
            sms.setNationalLanguageSingleShift(nationalLanguageSingleShift);
            sms.setOrigSystemId(origEsme.getSystemId());
            sms.setOrigEsmeName(origEsme.getName());
            sms.setSubmitDate((Date)new Timestamp(System.currentTimeMillis()));
            sms.setServiceType(event.getServiceType());
            sms.setEsmClass((int)event.getEsmClass());
            sms.setProtocolId((int)event.getProtocolId());
            sms.setPriority((int)event.getPriority());
            sms.setRegisteredDelivery((int)event.getRegisteredDelivery());
            sms.setReplaceIfPresent((int)event.getReplaceIfPresent());
            sms.setDefaultMsgId((int)event.getDefaultMsgId());
            sms.setShortMessageText(msg);
            sms.setShortMessageBin(udhData);
            MessageUtil.applyValidityPeriod((Sms)sms, (Date)validityPeriod, (boolean)true, (int)smscPropertiesManagement.getMaxValidityPeriodHours(), (int)smscPropertiesManagement.getDefaultValidityPeriodHours());
            MessageUtil.applyScheduleDeliveryTime((Sms)sms, (Date)scheduleDeliveryTime);
            if (optionalParameters != null && optionalParameters.size() > 0) {
                for (Tlv tlv : optionalParameters) {
                    if (tlv.getTag() == 1060) continue;
                    sms.getTlvSet().addOptionalParameter(tlv);
                }
            }
            SmsSet smsSet = new SmsSet();
            smsSet.setDestAddr(ta.getAddr());
            smsSet.setDestAddrNpi(ta.getAddrNpi());
            smsSet.setDestAddrTon(ta.getAddrTon());
            smsSet.setNetworkId(origEsme.getNetworkId());
            smsSet.addSms(sms);
            sms.setSmsSet(smsSet);
            sms.setMessageId(messageId);
            msgList.add(sms);
        }
        return new SubmitMultiParseResult(msgList, badAddresses);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processSms(Sms sms0, PersistenceRAInterface store, Esme esme, SubmitSm eventSubmit, DataSm eventData, SubmitMulti eventSubmitMulti, IncomingMessageType incomingMessageType) throws SmscProcessingException {
        boolean isTransactional;
        if (this.logger.isInfoEnabled()) {
            this.logger.info(String.format("\nReceived %s to ESME: %s, sms=%s", incomingMessageType.toString(), esme.getName(), sms0.toString()));
        }
        if (smscPropertiesManagement.isSmscStopped()) {
            SmscProcessingException e = new SmscProcessingException("SMSC is stopped", 8, 0, null);
            e.setSkipErrorLogging(true);
            throw e;
        }
        if (smscPropertiesManagement.isDeliveryPause() && (!MessageUtil.isStoreAndForward((Sms)sms0) || smscPropertiesManagement.getStoreAndForwordMode() == StoreAndForwordMode.fast)) {
            SmscProcessingException e = new SmscProcessingException("SMSC is paused", 8, 0, null);
            e.setSkipErrorLogging(true);
            throw e;
        }
        if (!store.isDatabaseAvailable() && MessageUtil.isStoreAndForward((Sms)sms0)) {
            SmscProcessingException e = new SmscProcessingException("Database is unavailable", 8, 0, null);
            e.setSkipErrorLogging(true);
            throw e;
        }
        if (!MessageUtil.isStoreAndForward((Sms)sms0) || smscPropertiesManagement.getStoreAndForwordMode() == StoreAndForwordMode.fast) {
            int fetchMaxRows = (int)((double)smscPropertiesManagement.getMaxActivityCount() * 1.2);
            int activityCount = SmsSetCache.getInstance().getProcessingSmsSetSize();
            if (activityCount >= fetchMaxRows) {
                SmscProcessingException e = new SmscProcessingException("SMSC is overloaded", 88, 0, null);
                e.setSkipErrorLogging(true);
                throw e;
            }
        }
        boolean withCharging = false;
        switch (smscPropertiesManagement.getTxSmppChargingType()) {
            case Selected: {
                withCharging = esme.isChargingEnabled();
                break;
            }
            case All: {
                withCharging = true;
            }
        }
        boolean bl = isTransactional = (eventSubmit != null || eventData != null) && MessageUtil.isTransactional((Sms)sms0);
        if (isTransactional || withCharging) {
            MessageDeliveryResultResponseSmpp messageDeliveryResultResponse = new MessageDeliveryResultResponseSmpp(!isTransactional, this.smppServerSessions, esme, eventSubmit, eventData, sms0.getMessageId());
            sms0.setMessageDeliveryResultResponse((MessageDeliveryResultResponseInterface)messageDeliveryResultResponse);
        }
        if (withCharging) {
            ChargingSbbLocalObject chargingSbb = this.getChargingSbbObject();
            chargingSbb.setupChargingRequestInterface(ChargingMedium.TxSmppOrig, sms0);
        } else {
            MProcResult mProcResult = MProcManagement.getInstance().applyMProcArrival(sms0);
            if (mProcResult.isMessageRejected()) {
                sms0.setMessageDeliveryResultResponse(null);
                SmscProcessingException e = new SmscProcessingException("Message is rejected by MProc rules", 69, 0, null);
                e.setSkipErrorLogging(true);
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("TxSmpp: incoming message is rejected by mProc rules, message=[" + sms0 + "]");
                }
                throw e;
            }
            if (mProcResult.isMessageDropped()) {
                sms0.setMessageDeliveryResultResponse(null);
                this.smscStatAggregator.updateMsgInFailedAll();
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("TxSmpp: incoming message is dropped by mProc rules, message=[" + sms0 + "]");
                }
                return;
            }
            this.smscStatAggregator.updateMsgInReceivedAll();
            this.smscStatAggregator.updateMsgInReceivedSmpp();
            FastList smss = mProcResult.getMessageList();
            FastList.Node n = smss.head();
            FastList.Node end = smss.tail();
            while ((n = n.getNext()) != end) {
                Sms sms = (Sms)n.getValue();
                TargetAddress ta = new TargetAddress(sms.getSmsSet());
                TargetAddress lock = store.obtainSynchroObject(ta);
                try {
                    TargetAddress targetAddress = lock;
                    synchronized (targetAddress) {
                        boolean storeAndForwMode = MessageUtil.isStoreAndForward((Sms)sms);
                        if (!storeAndForwMode) {
                            try {
                                this.scheduler.injectSmsOnFly(sms.getSmsSet(), true);
                            }
                            catch (Exception e) {
                                throw new SmscProcessingException("Exception when runnung injectSmsOnFly(): " + e.getMessage(), 8, 34, null, (Throwable)e);
                            }
                        }
                        if (smscPropertiesManagement.getStoreAndForwordMode() == StoreAndForwordMode.fast && sms.getScheduleDeliveryTime() == null) {
                            try {
                                sms.setStoringAfterFailure(true);
                                this.scheduler.injectSmsOnFly(sms.getSmsSet(), true);
                            }
                            catch (Exception e) {
                                throw new SmscProcessingException("Exception when runnung injectSmsOnFly(): " + e.getMessage(), 8, 34, null, (Throwable)e);
                            }
                        }
                        try {
                            sms.setStored(true);
                            this.scheduler.setDestCluster(sms.getSmsSet());
                            store.c2_scheduleMessage_ReschedDueSlot(sms, smscPropertiesManagement.getStoreAndForwordMode() == StoreAndForwordMode.fast, false);
                        }
                        catch (PersistenceException e) {
                            throw new SmscProcessingException("PersistenceException when storing LIVE_SMS : " + e.getMessage(), 69, 34, null, (Throwable)e);
                        }
                    }
                }
                finally {
                    store.releaseSynchroObject(lock);
                }
            }
        }
    }

    public abstract ChildRelationExt getChargingSbb();

    private ChargingSbbLocalObject getChargingSbbObject() {
        ChargingSbbLocalObject ret;
        block3: {
            ChildRelationExt relation = this.getChargingSbb();
            ret = (ChargingSbbLocalObject)relation.get("0");
            if (ret == null) {
                try {
                    ret = (ChargingSbbLocalObject)relation.create("0");
                }
                catch (Exception e) {
                    if (!this.logger.isSevereEnabled()) break block3;
                    this.logger.severe("Exception while trying to creat ChargingSbb child", (Throwable)e);
                }
            }
        }
        return ret;
    }

    public static enum IncomingMessageType {
        submit_sm,
        data_sm,
        deliver_sm,
        submit_multi;

    }
}

