/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.smsc.slee.services.smpp.server.tx;

import com.cloudhopper.smpp.pdu.DataSm;
import com.cloudhopper.smpp.pdu.DataSmResp;
import com.cloudhopper.smpp.pdu.PduRequest;
import com.cloudhopper.smpp.pdu.PduResponse;
import com.cloudhopper.smpp.pdu.SubmitSm;
import com.cloudhopper.smpp.pdu.SubmitSmResp;
import com.cloudhopper.smpp.tlv.Tlv;
import javax.slee.facilities.Tracer;
import org.mobicents.protocols.ss7.map.api.errors.MAPErrorMessage;
import org.mobicents.smsc.library.MessageDeliveryResultResponseInterface;
import org.restcomm.slee.resource.smpp.SmppSessions;
import org.restcomm.smpp.Esme;

public class MessageDeliveryResultResponseSmpp
implements MessageDeliveryResultResponseInterface {
    private boolean onlyChargingRequest;
    private SmppSessions smppSessions;
    private Esme esme;
    private SubmitSm eventSubmit;
    private DataSm eventData;
    private long messageId;
    private Tracer logger;

    public MessageDeliveryResultResponseSmpp(boolean onlyChargingRequest, SmppSessions smppSessions, Esme esme, SubmitSm eventSubmit, DataSm eventData, long messageId) {
        this.onlyChargingRequest = onlyChargingRequest;
        this.smppSessions = smppSessions;
        this.esme = esme;
        this.eventSubmit = eventSubmit;
        this.eventData = eventData;
        this.messageId = messageId;
    }

    public boolean isOnlyChargingRequest() {
        return this.onlyChargingRequest;
    }

    public void responseDeliverySuccess() {
        SubmitSmResp response = null;
        SubmitSm event = null;
        if (this.eventSubmit != null) {
            SubmitSmResp responseSubmit;
            event = this.eventSubmit;
            response = responseSubmit = this.eventSubmit.createResponse();
            responseSubmit.setMessageId(Long.valueOf(this.messageId).toString());
        }
        if (this.eventData != null) {
            event = this.eventData;
            DataSmResp responseData = this.eventData.createResponse();
            response = responseData;
            responseData.setMessageId(Long.valueOf(this.messageId).toString());
        }
        try {
            if (response != null) {
                this.smppSessions.sendResponsePdu(this.esme, (PduRequest)event, (PduResponse)response);
            }
        }
        catch (Throwable e) {
            this.logger.severe("Error while trying to send SubmitSmResponse=" + response, e);
        }
    }

    public void responseDeliveryFailure(MessageDeliveryResultResponseInterface.DeliveryFailureReason reason, MAPErrorMessage errMessage) {
        SubmitSmResp response = null;
        SubmitSm event = null;
        if (this.eventSubmit != null) {
            SubmitSmResp responseSubmit;
            event = this.eventSubmit;
            response = responseSubmit = this.eventSubmit.createResponse();
            responseSubmit.setMessageId(Long.valueOf(this.messageId).toString());
        }
        if (this.eventData != null) {
            event = this.eventData;
            DataSmResp responseData = this.eventData.createResponse();
            response = responseData;
            responseData.setMessageId(Long.valueOf(this.messageId).toString());
        }
        response.setCommandStatus(254);
        if (reason != null) {
            byte[] value = new byte[]{(byte)reason.getCode()};
            Tlv tlv = new Tlv(1061, value);
            response.addOptionalParameter(tlv);
        }
        try {
            if (response != null) {
                this.smppSessions.sendResponsePdu(this.esme, (PduRequest)event, (PduResponse)response);
            }
        }
        catch (Throwable e) {
            this.logger.severe("Error while trying to send SubmitSmResponse=" + response, e);
        }
    }
}

