/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.ussdgateway;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import javolution.text.TextBuilder;
import javolution.util.FastList;
import javolution.xml.XMLBinding;
import javolution.xml.XMLObjectReader;
import javolution.xml.XMLObjectWriter;
import javolution.xml.stream.XMLStreamException;
import org.apache.log4j.Logger;
import org.mobicents.ussdgateway.ShortCodeRoutingRuleManagementMBean;
import org.mobicents.ussdgateway.rules.ScRoutingRule;
import org.mobicents.ussdgateway.rules.ScRoutingRuleType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShortCodeRoutingRuleManagement
implements ShortCodeRoutingRuleManagementMBean {
    private static final Logger logger = Logger.getLogger(ShortCodeRoutingRuleManagement.class);
    private static final String SC_ROUTING_RULE_LIST = "scroutingrulelist";
    private static final String TAB_INDENT = "\t";
    private static final String CLASS_ATTRIBUTE = "type";
    private static final XMLBinding binding = new XMLBinding();
    private static final String PERSIST_FILE_NAME = "scroutingrule.xml";
    private String name;
    private String persistDir = null;
    protected FastList<ScRoutingRule> scRoutingRuleList = new FastList();
    private final TextBuilder persistFile = TextBuilder.newInstance();
    private static ShortCodeRoutingRuleManagement instance;

    private ShortCodeRoutingRuleManagement(String name) {
        this.name = name;
        binding.setClassAttribute(CLASS_ATTRIBUTE);
        binding.setAlias(ScRoutingRule.class, "scroutingrule");
    }

    protected static ShortCodeRoutingRuleManagement getInstance(String name) {
        if (instance == null) {
            instance = new ShortCodeRoutingRuleManagement(name);
        }
        return instance;
    }

    public static ShortCodeRoutingRuleManagement getInstance() {
        return instance;
    }

    public String getName() {
        return this.name;
    }

    public String getPersistDir() {
        return this.persistDir;
    }

    public void setPersistDir(String persistDir) {
        this.persistDir = persistDir;
    }

    @Override
    public List<ScRoutingRule> getScRoutingRuleList() {
        return this.scRoutingRuleList.unmodifiable();
    }

    @Override
    public ScRoutingRule getScRoutingRule(String shortCode, int networkId) {
        FastList.Node n = this.scRoutingRuleList.head();
        FastList.Node end = this.scRoutingRuleList.tail();
        while ((n = n.getNext()) != end) {
            ScRoutingRule rule = (ScRoutingRule)n.getValue();
            if (!(rule.isExactMatch() ? rule.getShortCode().equals(shortCode) && rule.getNetworkId() == networkId : shortCode.startsWith(rule.getShortCode()) && rule.getNetworkId() == networkId)) continue;
            return rule;
        }
        return null;
    }

    @Override
    public ScRoutingRule createScRoutingRule(String shortCode, ScRoutingRuleType routingRuleType, String urlOrsipProxy, boolean exactMatch, int networkId) throws Exception {
        if (shortCode == null || shortCode.equals("")) {
            throw new Exception("Invalid short code and networkid pair");
        }
        ScRoutingRule rule = this.getScRoutingRule(shortCode, networkId);
        if (rule != null) {
            throw new Exception("Creation of short code routing rule failed. Rule already exist");
        }
        if (routingRuleType == null) {
            throw new Exception("Rule type cannot be null");
        }
        if (urlOrsipProxy == null || urlOrsipProxy.equals("")) {
            throw new Exception("Invalid routing rule URL");
        }
        if (routingRuleType == ScRoutingRuleType.HTTP) {
            rule = new ScRoutingRule(shortCode);
            rule.setRuleType(routingRuleType);
            rule.setRuleUrl(urlOrsipProxy);
            rule.setExactMatch(exactMatch);
            rule.setNetworkId(networkId);
            this.scRoutingRuleList.add((Object)rule);
            this.store();
            return rule;
        }
        rule = new ScRoutingRule(shortCode);
        rule.setSipProxy(urlOrsipProxy);
        rule.setExactMatch(exactMatch);
        rule.setRuleType(routingRuleType);
        rule.setNetworkId(networkId);
        this.scRoutingRuleList.add((Object)rule);
        this.store();
        return rule;
    }

    @Override
    public ScRoutingRule modifyScRoutingRule(String shortCode, ScRoutingRuleType routingRuleType, String urlOrsipProxy, boolean exactMatch, int networkId) throws Exception {
        if (shortCode == null || shortCode.equals("")) {
            throw new Exception("Invalid short code and networkid pair");
        }
        ScRoutingRule rule = this.getScRoutingRule(shortCode, networkId);
        if (rule == null) {
            throw new Exception(String.format("No short code routing rule found for short code=%s network id=%d", shortCode, networkId));
        }
        if (routingRuleType == null) {
            throw new Exception("Rule type cannot be null");
        }
        if (urlOrsipProxy == null || urlOrsipProxy.equals("")) {
            throw new Exception("Invalid routing rule URL");
        }
        if (routingRuleType == ScRoutingRuleType.HTTP) {
            rule.setRuleType(routingRuleType);
            rule.setRuleUrl(urlOrsipProxy);
            rule.setExactMatch(exactMatch);
            this.store();
            return rule;
        }
        rule.setSipProxy(urlOrsipProxy);
        rule.setExactMatch(exactMatch);
        rule.setRuleType(routingRuleType);
        this.store();
        return rule;
    }

    @Override
    @Deprecated
    public ScRoutingRule createScRoutingRule(String shortCode, String url, boolean exactMatch) throws Exception {
        return this.createScRoutingRule(shortCode, ScRoutingRuleType.HTTP, url, exactMatch, 0);
    }

    @Override
    public ScRoutingRule deleteScRoutingRule(String shortCode, int networkId) throws Exception {
        if (shortCode == null || shortCode.equals("")) {
            throw new Exception("Invalid short code and networkid pair");
        }
        ScRoutingRule rule = this.getScRoutingRule(shortCode, networkId);
        if (rule == null) {
            throw new Exception(String.format("No short code routing rule found for short code=%s network id=%d", shortCode, networkId));
        }
        this.scRoutingRuleList.remove((Object)rule);
        this.store();
        return rule;
    }

    public void start() throws Exception {
        this.persistFile.clear();
        if (this.persistDir != null) {
            this.persistFile.append(this.persistDir).append(File.separator).append(this.name).append("_").append(PERSIST_FILE_NAME);
        } else {
            this.persistFile.append(System.getProperty("ussd.persist.dir", System.getProperty("user.dir"))).append(File.separator).append(this.name).append("_").append(PERSIST_FILE_NAME);
        }
        logger.info((Object)String.format("Loading short code routig rule configuration from %s", this.persistFile.toString()));
        try {
            this.load();
        }
        catch (FileNotFoundException e) {
            logger.warn((Object)String.format("Failed to load the short code routig rule configuration file. \n%s", e.getMessage()));
        }
    }

    public void stop() throws Exception {
        this.store();
    }

    public void removeAllResourses() throws Exception {
        this.scRoutingRuleList.clear();
        this.store();
    }

    public void store() {
        try {
            XMLObjectWriter writer = XMLObjectWriter.newInstance((OutputStream)new FileOutputStream(this.persistFile.toString()));
            writer.setBinding(binding);
            writer.setIndentation(TAB_INDENT);
            writer.write(this.scRoutingRuleList, SC_ROUTING_RULE_LIST, FastList.class);
            writer.close();
        }
        catch (Exception e) {
            logger.error((Object)"Error while persisting the Rule state in file", (Throwable)e);
        }
    }

    public void load() throws FileNotFoundException {
        XMLObjectReader reader = null;
        try {
            reader = XMLObjectReader.newInstance((InputStream)new FileInputStream(this.persistFile.toString()));
            reader.setBinding(binding);
            this.scRoutingRuleList = (FastList)reader.read(SC_ROUTING_RULE_LIST, FastList.class);
            reader.close();
        }
        catch (XMLStreamException xMLStreamException) {
            // empty catch block
        }
    }
}

