/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.ussdgateway;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import org.apache.log4j.Logger;
import org.jboss.mx.util.MBeanServerLocator;
import org.mobicents.ussdgateway.ShortCodeRoutingRuleManagement;
import org.mobicents.ussdgateway.ShortCodeRoutingRuleManagementMBean;
import org.mobicents.ussdgateway.UssdPropertiesManagement;
import org.mobicents.ussdgateway.UssdPropertiesManagementMBean;
import org.mobicents.ussdgateway.UssdStatAggregator;

public class UssdManagement {
    private static final Logger logger = Logger.getLogger(UssdManagement.class);
    public static final String JMX_DOMAIN = "org.mobicents.ussdgateway";
    protected static final String USSD_PERSIST_DIR_KEY = "ussd.persist.dir";
    protected static final String USER_DIR_KEY = "user.dir";
    private String persistDir = null;
    private final String name;
    private UssdPropertiesManagement ussdPropertiesManagement = null;
    private ShortCodeRoutingRuleManagement shortCodeRoutingRuleManagement = null;
    private MBeanServer mbeanServer = null;

    public UssdManagement(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getPersistDir() {
        return this.persistDir;
    }

    public void setPersistDir(String persistDir) {
        this.persistDir = persistDir;
    }

    public void start() throws Exception {
        UssdStatAggregator.getInstance().clearDialogsInProcess();
        this.ussdPropertiesManagement = UssdPropertiesManagement.getInstance(this.name);
        this.ussdPropertiesManagement.setPersistDir(this.persistDir);
        this.ussdPropertiesManagement.start();
        this.shortCodeRoutingRuleManagement = ShortCodeRoutingRuleManagement.getInstance(this.name);
        this.shortCodeRoutingRuleManagement.setPersistDir(this.persistDir);
        this.shortCodeRoutingRuleManagement.start();
        this.mbeanServer = MBeanServerLocator.locateJBoss();
        ObjectName ussdPropObjNname = new ObjectName("org.mobicents.ussdgateway:name=UssdPropertiesManagement");
        StandardMBean ussdPropMxBean = new StandardMBean(this.ussdPropertiesManagement, UssdPropertiesManagementMBean.class, true);
        this.mbeanServer.registerMBean(ussdPropMxBean, ussdPropObjNname);
        ObjectName ussdScRuleObjNname = new ObjectName("org.mobicents.ussdgateway:name=ShortCodeRoutingRuleManagement");
        StandardMBean ussdScRuleMxBean = new StandardMBean(this.shortCodeRoutingRuleManagement, ShortCodeRoutingRuleManagementMBean.class, true);
        this.mbeanServer.registerMBean(ussdScRuleMxBean, ussdScRuleObjNname);
        logger.info((Object)"Started UssdManagement");
    }

    public void stop() throws Exception {
        this.ussdPropertiesManagement.stop();
        if (this.mbeanServer != null) {
            ObjectName ussdPropObjNname = new ObjectName("org.mobicents.ussdgateway:name=UssdPropertiesManagement");
            this.mbeanServer.unregisterMBean(ussdPropObjNname);
            ObjectName ussdScRuleObjNname = new ObjectName("org.mobicents.ussdgateway:name=ShortCodeRoutingRuleManagement");
            this.mbeanServer.unregisterMBean(ussdScRuleObjNname);
        }
    }
}

