/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.ussdgateway.rules;

import javolution.xml.XMLFormat;
import javolution.xml.XMLSerializable;
import javolution.xml.stream.XMLStreamException;
import org.mobicents.ussdgateway.rules.ScRoutingRuleType;

public class ScRoutingRule
implements XMLSerializable {
    private static final String RULE_TYPE = "ruleType";
    private static final String SHORT_CODE = "shortcode";
    private static final String NETWORK_ID = "networkid";
    private static final String RULE_URL = "ruleurl";
    private static final String EXACT_MATCH = "exactmatch";
    private static final String SIP_PROXY = "sipProxy";
    private ScRoutingRuleType ruleType = ScRoutingRuleType.SIP;
    private String shortCode;
    private int networkId = 0;
    private String ruleUrl;
    private String sipProxy;
    private boolean exactMatch = true;
    protected static final XMLFormat<ScRoutingRule> ESME_XML = new XMLFormat<ScRoutingRule>(ScRoutingRule.class){

        public void read(XMLFormat.InputElement xml, ScRoutingRule esme) throws XMLStreamException {
            String ruleTypeStr = xml.getAttribute(ScRoutingRule.RULE_TYPE, null);
            if (ruleTypeStr == null) {
                esme.ruleType = ScRoutingRuleType.HTTP;
            } else {
                esme.ruleType = ScRoutingRuleType.valueOf(ruleTypeStr);
            }
            esme.shortCode = xml.getAttribute(ScRoutingRule.SHORT_CODE, null);
            esme.networkId = xml.getAttribute(ScRoutingRule.NETWORK_ID, 0);
            esme.ruleUrl = xml.getAttribute(ScRoutingRule.RULE_URL, null);
            esme.sipProxy = xml.getAttribute(ScRoutingRule.SIP_PROXY, null);
            esme.exactMatch = xml.getAttribute(ScRoutingRule.EXACT_MATCH, true);
        }

        public void write(ScRoutingRule esme, XMLFormat.OutputElement xml) throws XMLStreamException {
            xml.setAttribute(ScRoutingRule.RULE_TYPE, esme.ruleType.name());
            xml.setAttribute(ScRoutingRule.SHORT_CODE, esme.shortCode);
            xml.setAttribute(ScRoutingRule.NETWORK_ID, esme.networkId);
            xml.setAttribute(ScRoutingRule.RULE_URL, esme.ruleUrl);
            xml.setAttribute(ScRoutingRule.SIP_PROXY, esme.sipProxy);
            xml.setAttribute(ScRoutingRule.EXACT_MATCH, esme.exactMatch);
        }
    };

    public ScRoutingRule() {
    }

    public ScRoutingRuleType getRuleType() {
        return this.ruleType;
    }

    public void setRuleType(ScRoutingRuleType ruleType) {
        this.ruleType = ruleType;
    }

    public ScRoutingRule(String ussdString) {
        this.shortCode = ussdString;
    }

    public String getShortCode() {
        return this.shortCode;
    }

    public void setShortCode(String shortCode) {
        this.shortCode = shortCode;
    }

    public int getNetworkId() {
        return this.networkId;
    }

    public void setNetworkId(int networkId) {
        this.networkId = networkId;
    }

    public String getRuleUrl() {
        return this.ruleUrl;
    }

    public void setRuleUrl(String ruleUrl) {
        this.ruleUrl = ruleUrl;
    }

    public String getSipProxy() {
        return this.sipProxy;
    }

    public void setSipProxy(String sipProxy) {
        this.sipProxy = sipProxy;
    }

    public boolean isExactMatch() {
        return this.exactMatch;
    }

    public void setExactMatch(boolean exactMatch) {
        this.exactMatch = exactMatch;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        this.show(sb);
        return sb.toString();
    }

    public void show(StringBuffer sb) {
        sb.append("Short Code=").append(this.shortCode).append(" Network Id=").append(this.networkId).append(" Rule Type=").append((Object)this.ruleType).append(" URL=").append(this.ruleUrl).append(" To SIP Proxy=").append(this.sipProxy).append(" Exact Match=").append(this.isExactMatch());
        sb.append("\n");
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.networkId;
        result = 31 * result + (this.shortCode == null ? 0 : this.shortCode.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ScRoutingRule other = (ScRoutingRule)obj;
        if (this.networkId != other.networkId) {
            return false;
        }
        return !(this.shortCode == null ? other.shortCode != null : !this.shortCode.equals(other.shortCode));
    }
}

