/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.ussdgateway;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Map;
import javolution.text.TextBuilder;
import javolution.util.FastMap;
import javolution.xml.XMLBinding;
import javolution.xml.XMLObjectReader;
import javolution.xml.XMLObjectWriter;
import javolution.xml.stream.XMLStreamException;
import org.apache.log4j.Logger;
import org.mobicents.protocols.ss7.map.primitives.ArrayListSerializingBase;
import org.mobicents.ussdgateway.UssdGwGtNetworkIdElement;
import org.mobicents.ussdgateway.UssdPropertiesManagementMBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UssdPropertiesManagement
implements UssdPropertiesManagementMBean {
    private static final Logger logger = Logger.getLogger(UssdPropertiesManagement.class);
    protected static final String NO_ROUTING_RULE_CONFIGURED_ERROR_MESSAGE = "noroutingruleconfigerrmssg";
    protected static final String SERVER_ERROR_MESSAGE = "servererrmssg";
    protected static final String DIALOG_TIMEOUT_ERROR_MESSAGE = "dialogtimeouterrmssg";
    protected static final String DIALOG_TIMEOUT = "dialogtimeout";
    private static final String USSD_GT_LIST = "ussdgtlist";
    protected static final String USSD_GT = "ussdgt";
    protected static final String USSD_SSN = "ussdssn";
    protected static final String HLR_SSN = "hlrssn";
    protected static final String MSC_SSN = "mscssn";
    protected static final String MAX_MAP_VERSION = "maxmapv";
    protected static final String HR_HLR_GT = "hrhlrgt";
    protected static final String CDR_LOGGING_TO = "cdrloggingto";
    private static final String TAB_INDENT = "\t";
    private static final String CLASS_ATTRIBUTE = "type";
    private static final XMLBinding binding = new XMLBinding();
    private static final String PERSIST_FILE_NAME = "ussdproperties.xml";
    private static UssdPropertiesManagement instance;
    private final String name;
    private String persistDir = null;
    private final TextBuilder persistFile = TextBuilder.newInstance();
    private String noRoutingRuleConfiguredMessage = "Not valid short code. Please dial valid short code.";
    private String serverErrorMessage = "Server error, please try again after sometime";
    private String dialogTimeoutErrorMessage = "Request timeout please try again after sometime.";
    private String ussdGwGt = null;
    private FastMap<Integer, String> networkIdVsUssdGwGt = new FastMap();
    private int ussdGwSsn = -1;
    private int hlrSsn = -1;
    private int mscSsn = -1;
    private int maxMapVersion = 3;
    private long dialogTimeout = 25000L;
    private String hrHlrGt = null;
    private CdrLoggedType cdrLoggingTo = CdrLoggedType.Textfile;

    private UssdPropertiesManagement(String name) {
        this.name = name;
        binding.setClassAttribute(CLASS_ATTRIBUTE);
    }

    protected static UssdPropertiesManagement getInstance(String name) {
        if (instance == null) {
            instance = new UssdPropertiesManagement(name);
        }
        return instance;
    }

    public static UssdPropertiesManagement getInstance() {
        return instance;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public String getNoRoutingRuleConfiguredMessage() {
        return this.noRoutingRuleConfiguredMessage;
    }

    @Override
    public void setNoRoutingRuleConfiguredMessage(String noRoutingRuleConfiguredMessage) {
        this.noRoutingRuleConfiguredMessage = noRoutingRuleConfiguredMessage;
        this.store();
    }

    @Override
    public String getServerErrorMessage() {
        return this.serverErrorMessage;
    }

    @Override
    public void setServerErrorMessage(String serverErrorMessage) {
        this.serverErrorMessage = serverErrorMessage;
        this.store();
    }

    @Override
    public String getDialogTimeoutErrorMessage() {
        return this.dialogTimeoutErrorMessage;
    }

    @Override
    public void setDialogTimeoutErrorMessage(String dialogTimeoutErrorMessage) {
        this.dialogTimeoutErrorMessage = dialogTimeoutErrorMessage;
        this.store();
    }

    @Override
    public long getDialogTimeout() {
        return this.dialogTimeout;
    }

    @Override
    public void setDialogTimeout(long dialogTimeout) {
        this.dialogTimeout = dialogTimeout;
        this.store();
    }

    public String getPersistDir() {
        return this.persistDir;
    }

    public void setPersistDir(String persistDir) {
        this.persistDir = persistDir;
    }

    @Override
    public String getUssdGt() {
        return this.ussdGwGt;
    }

    @Override
    public void setUssdGt(String serviceCenterGt) {
        this.setUssdGt(0, serviceCenterGt);
    }

    @Override
    public String getUssdGt(int networkId) {
        String res = (String)this.networkIdVsUssdGwGt.get((Object)networkId);
        if (res != null) {
            return res;
        }
        return this.ussdGwGt;
    }

    @Override
    public Map<Integer, String> getNetworkIdVsUssdGwGt() {
        return this.networkIdVsUssdGwGt;
    }

    @Override
    public void setUssdGt(int networkId, String serviceCenterGt) {
        if (networkId == 0) {
            this.ussdGwGt = serviceCenterGt;
        } else if (serviceCenterGt == null || serviceCenterGt.equals("") || serviceCenterGt.equals("0")) {
            this.networkIdVsUssdGwGt.remove((Object)networkId);
        } else {
            this.networkIdVsUssdGwGt.put((Object)networkId, (Object)serviceCenterGt);
        }
        this.store();
    }

    @Override
    public int getUssdSsn() {
        return this.ussdGwSsn;
    }

    @Override
    public void setUssdSsn(int serviceCenterSsn) {
        this.ussdGwSsn = serviceCenterSsn;
        this.store();
    }

    @Override
    public int getHlrSsn() {
        return this.hlrSsn;
    }

    @Override
    public void setHlrSsn(int hlrSsn) {
        this.hlrSsn = hlrSsn;
        this.store();
    }

    @Override
    public int getMaxMapVersion() {
        return this.maxMapVersion;
    }

    @Override
    public void setMaxMapVersion(int maxMapVersion) {
        this.maxMapVersion = maxMapVersion;
        this.store();
    }

    @Override
    public String getHrHlrGt() {
        return this.hrHlrGt;
    }

    @Override
    public void setHrHlrGt(String hrHlrNumber) {
        this.hrHlrGt = hrHlrNumber;
        this.store();
    }

    @Override
    public int getMscSsn() {
        return this.mscSsn;
    }

    @Override
    public void setMscSsn(int mscSsn) {
        this.mscSsn = mscSsn;
        this.store();
    }

    @Override
    public CdrLoggedType getCdrLoggingTo() {
        return this.cdrLoggingTo;
    }

    @Override
    public void setCdrLoggingTo(CdrLoggedType cdrLoggingTo) {
        this.cdrLoggingTo = cdrLoggingTo;
        this.store();
    }

    public void start() throws Exception {
        this.persistFile.clear();
        if (this.persistDir != null) {
            this.persistFile.append(this.persistDir).append(File.separator).append(this.name).append("_").append(PERSIST_FILE_NAME);
        } else {
            this.persistFile.append(System.getProperty("ussd.persist.dir", System.getProperty("user.dir"))).append(File.separator).append(this.name).append("_").append(PERSIST_FILE_NAME);
        }
        logger.info((Object)String.format("Loading USSD Properties from %s", this.persistFile.toString()));
        try {
            this.load();
        }
        catch (FileNotFoundException e) {
            logger.warn((Object)String.format("Failed to load the USSD configuration file. \n%s", e.getMessage()));
        }
    }

    public void stop() throws Exception {
        this.store();
    }

    public void store() {
        try {
            XMLObjectWriter writer = XMLObjectWriter.newInstance((OutputStream)new FileOutputStream(this.persistFile.toString()));
            writer.setBinding(binding);
            writer.setIndentation(TAB_INDENT);
            if (this.networkIdVsUssdGwGt.size() > 0) {
                ArrayList<UssdGwGtNetworkIdElement> al = new ArrayList<UssdGwGtNetworkIdElement>();
                for (Map.Entry val : this.networkIdVsUssdGwGt.entrySet()) {
                    UssdGwGtNetworkIdElement el = new UssdGwGtNetworkIdElement();
                    el.networkId = (Integer)val.getKey();
                    el.ussdGwGt = (String)val.getValue();
                    al.add(el);
                }
                UssdPropertiesManagement_ussdGwGtNetworkId al2 = new UssdPropertiesManagement_ussdGwGtNetworkId(al);
                writer.write((Object)al2, USSD_GT_LIST, UssdPropertiesManagement_ussdGwGtNetworkId.class);
            }
            writer.write((Object)this.noRoutingRuleConfiguredMessage, NO_ROUTING_RULE_CONFIGURED_ERROR_MESSAGE, String.class);
            writer.write((Object)this.serverErrorMessage, SERVER_ERROR_MESSAGE, String.class);
            writer.write((Object)this.dialogTimeoutErrorMessage, DIALOG_TIMEOUT_ERROR_MESSAGE, String.class);
            writer.write((Object)this.dialogTimeout, DIALOG_TIMEOUT, Long.class);
            writer.write((Object)this.hrHlrGt, HR_HLR_GT, String.class);
            writer.write((Object)this.cdrLoggingTo.toString(), CDR_LOGGING_TO, String.class);
            writer.write((Object)this.ussdGwGt, USSD_GT, String.class);
            writer.write((Object)this.ussdGwSsn, USSD_SSN, Integer.class);
            writer.write((Object)this.hlrSsn, HLR_SSN, Integer.class);
            writer.write((Object)this.mscSsn, MSC_SSN, Integer.class);
            writer.write((Object)this.maxMapVersion, MAX_MAP_VERSION, Integer.class);
            writer.close();
        }
        catch (Exception e) {
            logger.error((Object)"Error while persisting the Rule state in file", (Throwable)e);
        }
    }

    public void load() throws FileNotFoundException {
        XMLObjectReader reader = null;
        try {
            String s1;
            reader = XMLObjectReader.newInstance((InputStream)new FileInputStream(this.persistFile.toString()));
            reader.setBinding(binding);
            UssdPropertiesManagement_ussdGwGtNetworkId al = (UssdPropertiesManagement_ussdGwGtNetworkId)((Object)reader.read(USSD_GT_LIST, UssdPropertiesManagement_ussdGwGtNetworkId.class));
            this.networkIdVsUssdGwGt.clear();
            if (al != null) {
                for (UssdGwGtNetworkIdElement elem : al.getData()) {
                    this.networkIdVsUssdGwGt.put((Object)elem.networkId, (Object)elem.ussdGwGt);
                }
            }
            if ((s1 = (String)reader.read(NO_ROUTING_RULE_CONFIGURED_ERROR_MESSAGE, String.class)) != null) {
                this.noRoutingRuleConfiguredMessage = s1;
            }
            if ((s1 = (String)reader.read(SERVER_ERROR_MESSAGE, String.class)) != null) {
                this.serverErrorMessage = s1;
            }
            if ((s1 = (String)reader.read(DIALOG_TIMEOUT_ERROR_MESSAGE, String.class)) != null) {
                this.dialogTimeoutErrorMessage = s1;
            }
            this.dialogTimeout = (Long)reader.read(DIALOG_TIMEOUT, Long.class);
            String vals = (String)reader.read(HR_HLR_GT, String.class);
            if (vals != null) {
                this.hrHlrGt = vals;
            }
            if ((vals = (String)reader.read("hrHlrGt", String.class)) != null) {
                this.hrHlrGt = vals;
            }
            if ((vals = (String)reader.read("hrhlrnumber", String.class)) != null) {
                this.hrHlrGt = vals;
            }
            if ((vals = (String)reader.read(CDR_LOGGING_TO, String.class)) != null) {
                this.cdrLoggingTo = Enum.valueOf(CdrLoggedType.class, vals);
            }
            if ((vals = (String)reader.read("cdrLoggingTo", String.class)) != null) {
                this.cdrLoggingTo = Enum.valueOf(CdrLoggedType.class, vals);
            }
            this.ussdGwGt = (String)reader.read(USSD_GT, String.class);
            this.ussdGwSsn = (Integer)reader.read(USSD_SSN, Integer.class);
            this.hlrSsn = (Integer)reader.read(HLR_SSN, Integer.class);
            this.mscSsn = (Integer)reader.read(MSC_SSN, Integer.class);
            this.maxMapVersion = (Integer)reader.read(MAX_MAP_VERSION, Integer.class);
            reader.close();
        }
        catch (XMLStreamException xMLStreamException) {
            // empty catch block
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class UssdPropertiesManagement_ussdGwGtNetworkId
    extends ArrayListSerializingBase<UssdGwGtNetworkIdElement> {
        public UssdPropertiesManagement_ussdGwGtNetworkId() {
            super(UssdPropertiesManagement.USSD_GT_LIST, UssdGwGtNetworkIdElement.class);
        }

        public UssdPropertiesManagement_ussdGwGtNetworkId(ArrayList<UssdGwGtNetworkIdElement> data) {
            super(UssdPropertiesManagement.USSD_GT_LIST, UssdGwGtNetworkIdElement.class, data);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CdrLoggedType {
        Database,
        Textfile;

    }
}

