/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.ussdgateway;

import java.util.Date;
import java.util.Map;
import javolution.util.FastMap;
import org.apache.log4j.Logger;
import org.mobicents.protocols.ss7.oam.common.jmx.MBeanHost;
import org.mobicents.protocols.ss7.oam.common.jmx.MBeanLayer;
import org.mobicents.protocols.ss7.oam.common.jmx.MBeanType;
import org.mobicents.protocols.ss7.oam.common.jmxss7.Ss7Layer;
import org.mobicents.protocols.ss7.oam.common.statistics.ComplexValueImpl;
import org.mobicents.protocols.ss7.oam.common.statistics.CounterDefImpl;
import org.mobicents.protocols.ss7.oam.common.statistics.CounterDefSetImpl;
import org.mobicents.protocols.ss7.oam.common.statistics.SourceValueCounterImpl;
import org.mobicents.protocols.ss7.oam.common.statistics.SourceValueObjectImpl;
import org.mobicents.protocols.ss7.oam.common.statistics.SourceValueSetImpl;
import org.mobicents.protocols.ss7.oam.common.statistics.api.ComplexValue;
import org.mobicents.protocols.ss7.oam.common.statistics.api.CounterDef;
import org.mobicents.protocols.ss7.oam.common.statistics.api.CounterDefSet;
import org.mobicents.protocols.ss7.oam.common.statistics.api.CounterMediator;
import org.mobicents.protocols.ss7.oam.common.statistics.api.CounterType;
import org.mobicents.protocols.ss7.oam.common.statistics.api.SourceValueCounter;
import org.mobicents.protocols.ss7.oam.common.statistics.api.SourceValueSet;
import org.mobicents.protocols.ss7.statistics.api.LongValue;
import org.mobicents.ussdgateway.UssdStatAggregator;
import org.mobicents.ussdgateway.UssdStatProviderJmxMBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UssdStatProviderJmx
implements UssdStatProviderJmxMBean,
CounterMediator {
    protected final Logger logger;
    private final MBeanHost ss7Management;
    private final UssdStatAggregator ussdStatAggregator = UssdStatAggregator.getInstance();
    private FastMap<String, CounterDefSet> lstCounters = new FastMap();

    public UssdStatProviderJmx(MBeanHost ss7Management) {
        this.ss7Management = ss7Management;
        this.logger = Logger.getLogger((String)(UssdStatProviderJmx.class.getCanonicalName() + "-" + this.getName()));
    }

    public void start() throws Exception {
        this.logger.info((Object)"Starting ...");
        this.setupCounterList();
        this.ss7Management.registerMBean((MBeanLayer)Ss7Layer.USSD_GW, (MBeanType)UssdManagementType.MANAGEMENT, this.getName(), (Object)this);
        this.logger.info((Object)"Started ...");
    }

    public void stop() {
        this.logger.info((Object)"Stopping ...");
        this.logger.info((Object)"Stopped ...");
    }

    public String getName() {
        return "USSD";
    }

    private void setupCounterList() {
        FastMap lst = new FastMap();
        CounterDefSetImpl cds = new CounterDefSetImpl(this.getCounterMediatorName() + "-Main");
        lst.put((Object)cds.getName(), (Object)cds);
        CounterDefImpl cd = new CounterDefImpl(CounterType.Minimal, "MinDialogsInProcess", "A min count of dialogs that are in progress during a period");
        cds.addCounterDef((CounterDef)cd);
        cd = new CounterDefImpl(CounterType.Maximal, "MaxDialogsInProcess", "A max count of dialogs that are in progress during a period");
        cds.addCounterDef((CounterDef)cd);
        cd = new CounterDefImpl(CounterType.Summary, "DialogsAllEstablished", "Dialogs successfully established all");
        cds.addCounterDef((CounterDef)cd);
        cd = new CounterDefImpl(CounterType.Summary, "DialogsAllFailed", "Dialogs failed at establishing or established phases all");
        cds.addCounterDef((CounterDef)cd);
        cd = new CounterDefImpl(CounterType.Summary, "DialogsPullEstablished", "Dialogs successfully established - pull case");
        cds.addCounterDef((CounterDef)cd);
        cd = new CounterDefImpl(CounterType.Summary, "DialogsPullFailed", "Dialogs failed at establishing or established phases - pull case");
        cds.addCounterDef((CounterDef)cd);
        cd = new CounterDefImpl(CounterType.Summary, "DialogsPushEstablished", "Dialogs successfully established - push case");
        cds.addCounterDef((CounterDef)cd);
        cd = new CounterDefImpl(CounterType.Summary, "DialogsPushFailed", "Dialogs failed at establishing or established phases - push case");
        cds.addCounterDef((CounterDef)cd);
        cd = new CounterDefImpl(CounterType.Summary, "DialogsHttpEstablished", "Dialogs successfully established - Http case");
        cds.addCounterDef((CounterDef)cd);
        cd = new CounterDefImpl(CounterType.Summary, "DialogsHttpFailed", "Dialogs failed at establishing or established phases - Http case");
        cds.addCounterDef((CounterDef)cd);
        cd = new CounterDefImpl(CounterType.Summary, "DialogsSipEstablished", "Dialogs successfully established - Sip case");
        cds.addCounterDef((CounterDef)cd);
        cd = new CounterDefImpl(CounterType.Summary, "DialogsSipFailed", "Dialogs failed at establishing or established phases - Sip case");
        cds.addCounterDef((CounterDef)cd);
        cd = new CounterDefImpl(CounterType.Summary_Cumulative, "DialogsAllEstablishedCumulative", "Dialogs successfully established all cumulative");
        cds.addCounterDef((CounterDef)cd);
        cd = new CounterDefImpl(CounterType.Summary_Cumulative, "DialogsAllFailedCumulative", "Dialogs failed at establishing or established phases all cumulative");
        cds.addCounterDef((CounterDef)cd);
        cd = new CounterDefImpl(CounterType.Average, "DialogsAllEstablishedPerSec", "Dialogs successfully established all per second");
        cds.addCounterDef((CounterDef)cd);
        cd = new CounterDefImpl(CounterType.Average, "DialogsAllFailedPerSec", "Dialogs failed at establishing or established phases all per second");
        cds.addCounterDef((CounterDef)cd);
        cd = new CounterDefImpl(CounterType.Summary, "ProcessUssdRequestOperations", "ProcessUssdRequest operations count");
        cds.addCounterDef((CounterDef)cd);
        cd = new CounterDefImpl(CounterType.Summary_Cumulative, "ProcessUssdRequestOperationsCumulative", "ProcessUssdRequest operations count cumulative");
        cds.addCounterDef((CounterDef)cd);
        cd = new CounterDefImpl(CounterType.Summary, "UssdRequestOperations", "UssdRequest operations count");
        cds.addCounterDef((CounterDef)cd);
        cd = new CounterDefImpl(CounterType.Summary_Cumulative, "UssdRequestOperationsCumulative", "UssdRequest operations count cumulative");
        cds.addCounterDef((CounterDef)cd);
        cd = new CounterDefImpl(CounterType.Summary, "UssdNotifyOperations", "UssdNotify operations count");
        cds.addCounterDef((CounterDef)cd);
        cd = new CounterDefImpl(CounterType.Summary_Cumulative, "UssdNotifyOperationsCumulative", "UssdNotify operations count cumulative");
        cds.addCounterDef((CounterDef)cd);
        cd = new CounterDefImpl(CounterType.Summary, "UssdPullNoRoutingRule", "Ussd pull requests with no configured routing rule count");
        cds.addCounterDef((CounterDef)cd);
        cd = new CounterDefImpl(CounterType.Summary_Cumulative, "UssdPullNoRoutingRuleCumulative", "Ussd pull requests with no configured routing rule count cumulative");
        cds.addCounterDef((CounterDef)cd);
        cds.addCounterDef((CounterDef)cd);
        cd = new CounterDefImpl(CounterType.Summary, "MapErrorAbsentSubscribers", "AbsentSubscribers MAP errors count");
        cds.addCounterDef((CounterDef)cd);
        cd = new CounterDefImpl(CounterType.Summary_Cumulative, "MapErrorAbsentSubscribersCumulative", "AbsentSubscribers MAP errors count cumulative");
        cds.addCounterDef((CounterDef)cd);
        cd = new CounterDefImpl(CounterType.Summary, "MapErrorCallBarred", "CallBarred MAP errors count");
        cds.addCounterDef((CounterDef)cd);
        cd = new CounterDefImpl(CounterType.Summary_Cumulative, "MapErrorCallBarredCumulative", "CallBarred MAP errors count cumulative");
        cds.addCounterDef((CounterDef)cd);
        cd = new CounterDefImpl(CounterType.Summary, "MapErrorTeleserviceNotProvisioned", "TeleserviceNotProvisioned MAP errors count");
        cds.addCounterDef((CounterDef)cd);
        cd = new CounterDefImpl(CounterType.Summary_Cumulative, "MapErrorTeleserviceNotProvisionedCumulative", "TeleserviceNotProvisioned MAP errors count cumulative");
        cds.addCounterDef((CounterDef)cd);
        cd = new CounterDefImpl(CounterType.Summary, "MapErrorUnknownSubscriber", "UnknownSubscriber MAP errors count");
        cds.addCounterDef((CounterDef)cd);
        cd = new CounterDefImpl(CounterType.Summary_Cumulative, "MapErrorUnknownSubscriberCumulative", "UnknownSubscriber MAP errors count cumulative");
        cds.addCounterDef((CounterDef)cd);
        cd = new CounterDefImpl(CounterType.Summary, "MapErrorUssdBusy", "UssdBusy MAP errors count");
        cds.addCounterDef((CounterDef)cd);
        cd = new CounterDefImpl(CounterType.Summary_Cumulative, "MapErrorUssdBusyCumulative", "UssdBusy MAP errors count cumulative");
        cds.addCounterDef((CounterDef)cd);
        cd = new CounterDefImpl(CounterType.Summary, "MapErrorComponentOther", "ComponentOther MAP errors count");
        cds.addCounterDef((CounterDef)cd);
        cd = new CounterDefImpl(CounterType.Summary_Cumulative, "MapErrorComponentOtherCumulative", "ComponentOther MAP errors count cumulative");
        cds.addCounterDef((CounterDef)cd);
        cd = new CounterDefImpl(CounterType.Summary, "MapDialogTimeouts", "MAP DialogTimeouts count");
        cds.addCounterDef((CounterDef)cd);
        cd = new CounterDefImpl(CounterType.Summary_Cumulative, "MapDialogTimeoutsCumulative", "MAP DialogTimeouts count cumulative");
        cds.addCounterDef((CounterDef)cd);
        cd = new CounterDefImpl(CounterType.Summary, "MapInvokeTimeouts", "MAP InvokeTimeouts count");
        cds.addCounterDef((CounterDef)cd);
        cd = new CounterDefImpl(CounterType.Summary_Cumulative, "MapInvokeTimeoutsCumulative", "MAP InvokeTimeouts count cumulative");
        cds.addCounterDef((CounterDef)cd);
        cd = new CounterDefImpl(CounterType.Summary, "AppTimeouts", "Application Timeouts count");
        cds.addCounterDef((CounterDef)cd);
        cd = new CounterDefImpl(CounterType.Summary_Cumulative, "AppTimeoutsCumulative", "Application Timeouts count cumulative");
        cds.addCounterDef((CounterDef)cd);
        cd = new CounterDefImpl(CounterType.ComplexValue, "RequestsPerUssdCode", "USSD PULL requests count per USSD code");
        cds.addCounterDef((CounterDef)cd);
        this.lstCounters = lst;
    }

    public CounterDefSet getCounterDefSet(String counterDefSetName) {
        return (CounterDefSet)this.lstCounters.get((Object)counterDefSetName);
    }

    public String[] getCounterDefSetList() {
        String[] res = new String[this.lstCounters.size()];
        this.lstCounters.keySet().toArray(res);
        return res;
    }

    public String getCounterMediatorName() {
        return "USSD GW-" + this.getName();
    }

    public SourceValueSet getSourceValueSet(String counterDefSetName, String campaignName, int durationInSeconds) {
        SourceValueSetImpl svs;
        if (durationInSeconds >= 60) {
            this.logger.info((Object)("getSourceValueSet() - starting - campaignName=" + campaignName));
        } else {
            this.logger.debug((Object)("getSourceValueSet() - starting - campaignName=" + campaignName));
        }
        long curTimeSeconds = new Date().getTime() / 1000L;
        try {
            String[] csl = this.getCounterDefSetList();
            if (!csl[0].equals(counterDefSetName)) {
                return null;
            }
            svs = new SourceValueSetImpl(this.ussdStatAggregator.getSessionId());
            CounterDefSet cds = this.getCounterDefSet(counterDefSetName);
            for (CounterDef cd : cds.getCounterDefs()) {
                SourceValueCounterImpl scs = new SourceValueCounterImpl(cd);
                SourceValueObjectImpl svo = null;
                if (cd.getCounterName().equals("MinDialogsInProcess")) {
                    Long res = this.ussdStatAggregator.getMinDialogsInProcess(campaignName);
                    if (res != null) {
                        svo = new SourceValueObjectImpl(this.getName(), res.longValue());
                    }
                } else if (cd.getCounterName().equals("MaxDialogsInProcess")) {
                    Long res = this.ussdStatAggregator.getMaxDialogsInProcess(campaignName);
                    if (res != null) {
                        svo = new SourceValueObjectImpl(this.getName(), res.longValue());
                    }
                } else if (cd.getCounterName().equals("DialogsAllEstablished")) {
                    svo = new SourceValueObjectImpl(this.getName(), this.ussdStatAggregator.getDialogsAllEstablished());
                } else if (cd.getCounterName().equals("DialogsAllFailed")) {
                    svo = new SourceValueObjectImpl(this.getName(), this.ussdStatAggregator.getDialogsAllFailed());
                } else if (cd.getCounterName().equals("DialogsPullEstablished")) {
                    svo = new SourceValueObjectImpl(this.getName(), this.ussdStatAggregator.getDialogsPullEstablished());
                } else if (cd.getCounterName().equals("DialogsPullFailed")) {
                    svo = new SourceValueObjectImpl(this.getName(), this.ussdStatAggregator.getDialogsPullFailed());
                } else if (cd.getCounterName().equals("DialogsPushEstablished")) {
                    svo = new SourceValueObjectImpl(this.getName(), this.ussdStatAggregator.getDialogsPushEstablished());
                } else if (cd.getCounterName().equals("DialogsPushFailed")) {
                    svo = new SourceValueObjectImpl(this.getName(), this.ussdStatAggregator.getDialogsPushFailed());
                } else if (cd.getCounterName().equals("DialogsHttpEstablished")) {
                    svo = new SourceValueObjectImpl(this.getName(), this.ussdStatAggregator.getDialogsHttpEstablished());
                } else if (cd.getCounterName().equals("DialogsHttpFailed")) {
                    svo = new SourceValueObjectImpl(this.getName(), this.ussdStatAggregator.getDialogsHttpFailed());
                } else if (cd.getCounterName().equals("DialogsSipEstablished")) {
                    svo = new SourceValueObjectImpl(this.getName(), this.ussdStatAggregator.getDialogsSipEstablished());
                } else if (cd.getCounterName().equals("DialogsSipFailed")) {
                    svo = new SourceValueObjectImpl(this.getName(), this.ussdStatAggregator.getDialogsSipFailed());
                } else if (cd.getCounterName().equals("DialogsAllEstablishedCumulative")) {
                    svo = new SourceValueObjectImpl(this.getName(), this.ussdStatAggregator.getDialogsAllEstablishedCumulative());
                } else if (cd.getCounterName().equals("DialogsAllFailedCumulative")) {
                    svo = new SourceValueObjectImpl(this.getName(), this.ussdStatAggregator.getDialogsAllFailedCumulative());
                } else if (cd.getCounterName().equals("DialogsAllEstablishedPerSec")) {
                    long cnt = this.ussdStatAggregator.getDialogsAllEstablished();
                    svo = new SourceValueObjectImpl(this.getName(), 0L);
                    svo.setValueA((double)cnt);
                    svo.setValueB((double)curTimeSeconds);
                } else if (cd.getCounterName().equals("DialogsAllFailedPerSec")) {
                    long cnt = this.ussdStatAggregator.getDialogsAllFailed();
                    svo = new SourceValueObjectImpl(this.getName(), 0L);
                    svo.setValueA((double)cnt);
                    svo.setValueB((double)curTimeSeconds);
                } else if (cd.getCounterName().equals("ProcessUssdRequestOperations")) {
                    svo = new SourceValueObjectImpl(this.getName(), this.ussdStatAggregator.getProcessUssdRequestOperations());
                } else if (cd.getCounterName().equals("ProcessUssdRequestOperationsCumulative")) {
                    svo = new SourceValueObjectImpl(this.getName(), this.ussdStatAggregator.getProcessUssdRequestOperations());
                } else if (cd.getCounterName().equals("UssdRequestOperations")) {
                    svo = new SourceValueObjectImpl(this.getName(), this.ussdStatAggregator.getUssdRequestOperations());
                } else if (cd.getCounterName().equals("UssdRequestOperationsCumulative")) {
                    svo = new SourceValueObjectImpl(this.getName(), this.ussdStatAggregator.getUssdRequestOperations());
                } else if (cd.getCounterName().equals("UssdNotifyOperations")) {
                    svo = new SourceValueObjectImpl(this.getName(), this.ussdStatAggregator.getUssdNotifyOperations());
                } else if (cd.getCounterName().equals("UssdNotifyOperationsCumulative")) {
                    svo = new SourceValueObjectImpl(this.getName(), this.ussdStatAggregator.getUssdNotifyOperations());
                } else if (cd.getCounterName().equals("UssdPullNoRoutingRule")) {
                    svo = new SourceValueObjectImpl(this.getName(), this.ussdStatAggregator.getUssdPullNoRoutingRule());
                } else if (cd.getCounterName().equals("UssdPullNoRoutingRuleCumulative")) {
                    svo = new SourceValueObjectImpl(this.getName(), this.ussdStatAggregator.getUssdPullNoRoutingRule());
                } else if (cd.getCounterName().equals("MapErrorAbsentSubscribers")) {
                    svo = new SourceValueObjectImpl(this.getName(), this.ussdStatAggregator.getMapErrorAbsentSubscribers());
                } else if (cd.getCounterName().equals("MapErrorAbsentSubscribersCumulative")) {
                    svo = new SourceValueObjectImpl(this.getName(), this.ussdStatAggregator.getMapErrorAbsentSubscribers());
                } else if (cd.getCounterName().equals("MapErrorCallBarred")) {
                    svo = new SourceValueObjectImpl(this.getName(), this.ussdStatAggregator.getMapErrorCallBarred());
                } else if (cd.getCounterName().equals("MapErrorCallBarredCumulative")) {
                    svo = new SourceValueObjectImpl(this.getName(), this.ussdStatAggregator.getMapErrorCallBarred());
                } else if (cd.getCounterName().equals("MapErrorTeleserviceNotProvisioned")) {
                    svo = new SourceValueObjectImpl(this.getName(), this.ussdStatAggregator.getMapErrorTeleserviceNotProvisioned());
                } else if (cd.getCounterName().equals("MapErrorTeleserviceNotProvisionedCumulative")) {
                    svo = new SourceValueObjectImpl(this.getName(), this.ussdStatAggregator.getMapErrorTeleserviceNotProvisioned());
                } else if (cd.getCounterName().equals("MapErrorUnknownSubscriber")) {
                    svo = new SourceValueObjectImpl(this.getName(), this.ussdStatAggregator.getMapErrorUnknownSubscriber());
                } else if (cd.getCounterName().equals("MapErrorUnknownSubscriberCumulative")) {
                    svo = new SourceValueObjectImpl(this.getName(), this.ussdStatAggregator.getMapErrorUnknownSubscriber());
                } else if (cd.getCounterName().equals("MapErrorUssdBusy")) {
                    svo = new SourceValueObjectImpl(this.getName(), this.ussdStatAggregator.getMapErrorUssdBusy());
                } else if (cd.getCounterName().equals("MapErrorUssdBusyCumulative")) {
                    svo = new SourceValueObjectImpl(this.getName(), this.ussdStatAggregator.getMapErrorUssdBusy());
                } else if (cd.getCounterName().equals("MapErrorComponentOther")) {
                    svo = new SourceValueObjectImpl(this.getName(), this.ussdStatAggregator.getMapErrorComponentOther());
                } else if (cd.getCounterName().equals("MapErrorComponentOtherCumulative")) {
                    svo = new SourceValueObjectImpl(this.getName(), this.ussdStatAggregator.getMapErrorComponentOther());
                } else if (cd.getCounterName().equals("MapDialogTimeouts")) {
                    svo = new SourceValueObjectImpl(this.getName(), this.ussdStatAggregator.getMapDialogTimeouts());
                } else if (cd.getCounterName().equals("MapDialogTimeoutsCumulative")) {
                    svo = new SourceValueObjectImpl(this.getName(), this.ussdStatAggregator.getMapDialogTimeouts());
                } else if (cd.getCounterName().equals("MapInvokeTimeouts")) {
                    svo = new SourceValueObjectImpl(this.getName(), this.ussdStatAggregator.getMapInvokeTimeouts());
                } else if (cd.getCounterName().equals("MapInvokeTimeoutsCumulative")) {
                    svo = new SourceValueObjectImpl(this.getName(), this.ussdStatAggregator.getMapInvokeTimeouts());
                } else if (cd.getCounterName().equals("AppTimeouts")) {
                    svo = new SourceValueObjectImpl(this.getName(), this.ussdStatAggregator.getAppTimeouts());
                } else if (cd.getCounterName().equals("AppTimeoutsCumulative")) {
                    svo = new SourceValueObjectImpl(this.getName(), this.ussdStatAggregator.getAppTimeouts());
                } else if (cd.getCounterName().equals("RequestsPerUssdCode")) {
                    svo = this.createComplexValue(this.ussdStatAggregator.getRequestsPerUssdCode(campaignName));
                }
                if (svo != null) {
                    scs.addObject(svo);
                }
                svs.addCounter((SourceValueCounter)scs);
            }
        }
        catch (Throwable e) {
            this.logger.info((Object)("Exception when getSourceValueSet() - campaignName=" + campaignName + " - " + e.getMessage()), e);
            return null;
        }
        if (durationInSeconds >= 60) {
            this.logger.info((Object)("getSourceValueSet() - return value - campaignName=" + campaignName));
        } else {
            this.logger.debug((Object)("getSourceValueSet() - return value - campaignName=" + campaignName));
        }
        return svs;
    }

    private SourceValueObjectImpl createComplexValue(Map<String, LongValue> vv) {
        SourceValueObjectImpl svo = null;
        if (vv != null) {
            svo = new SourceValueObjectImpl(this.getName(), 0L);
            ComplexValue[] vvv = new ComplexValue[vv.size()];
            int i1 = 0;
            for (String s : vv.keySet()) {
                LongValue lv = vv.get(s);
                vvv[i1++] = new ComplexValueImpl(s, lv.getValue());
            }
            svo.setComplexValue(vvv);
        }
        return svo;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum UssdManagementType implements MBeanType
    {
        MANAGEMENT("Management");

        private final String name;
        public static final String NAME_MANAGEMENT = "Management";

        private UssdManagementType(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public static UssdManagementType getInstance(String name) {
            if (NAME_MANAGEMENT.equals(name)) {
                return MANAGEMENT;
            }
            return null;
        }
    }
}

