/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.applications.ussd.bootstrap;

import java.io.InputStream;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;

public final class Version {
    public static final Version instance = new Version();
    private Properties props = this.loadProperties();

    private Version() {
    }

    public Map getProperties() {
        return Collections.unmodifiableMap(this.props);
    }

    public String getProperty(String name) {
        return this.props.getProperty(name);
    }

    public String getProjectName() {
        String version = instance.getProperty("name");
        if (version != null) {
            return version;
        }
        return "???";
    }

    public String getProjectType() {
        String version = instance.getProperty("project.type");
        if (version != null) {
            return version;
        }
        return "???";
    }

    public String getProjectVersion() {
        String version = instance.getProperty("version");
        if (version != null) {
            return version;
        }
        return "???";
    }

    public String getStatisticsServer() {
        String version = instance.getProperty("statistics.server");
        if (version != null) {
            return version;
        }
        return "https://statistics.restcomm.com/rest/";
    }

    public String getShortName() {
        String version = instance.getProperty("short.name");
        if (version != null) {
            return version;
        }
        return "???";
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Mobicents USSD Gateway Server: ");
        boolean first = true;
        for (Object key : this.props.keySet()) {
            if (first) {
                first = false;
            } else {
                sb.append(",");
            }
            sb.append(key).append('=').append(this.props.get(key));
        }
        return sb.toString();
    }

    private Properties loadProperties() {
        this.props = new Properties();
        try {
            InputStream in = Version.class.getResourceAsStream("version.properties");
            this.props.load(in);
            in.close();
        }
        catch (Exception e) {
            throw new Error("Missing version.properties");
        }
        return this.props;
    }
}

