/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.ussdgateway;

import com.codahale.metrics.Counter;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import org.mobicents.protocols.ss7.statistics.StatDataCollectionImpl;
import org.mobicents.protocols.ss7.statistics.api.LongValue;
import org.mobicents.protocols.ss7.statistics.api.StatDataCollection;
import org.mobicents.protocols.ss7.statistics.api.StatDataCollectorType;
import org.mobicents.protocols.ss7.statistics.api.StatResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UssdStatAggregator {
    private static String MIN_DIALOGS_IN_PROCESS = "MinDialogsInProcess";
    private static String MAX_DIALOGS_IN_PROCESS = "MaxDialogsInProcess";
    private static String REQUESTS_PER_USSD_CODE = "RequestsPerUssdCode";
    private static final UssdStatAggregator instance = new UssdStatAggregator();
    private StatCollector statCollector = new StatCollector();
    private UUID sessionId = UUID.randomUUID();
    private Counter counterDialogs;
    private Counter counterMessages;

    public static UssdStatAggregator getInstance() {
        return instance;
    }

    public void setCounterDialogs(Counter counterDialogs) {
        this.counterDialogs = counterDialogs;
    }

    public void setCounterMessages(Counter counterMessages) {
        this.counterMessages = counterMessages;
    }

    public void reset() {
        this.statCollector = new StatCollector();
        this.sessionId = UUID.randomUUID();
    }

    public UUID getSessionId() {
        return this.sessionId;
    }

    public void addDialogsInProcess() {
        long newVal = this.statCollector.dialogsCnt.addAndGet(1L);
        this.updateMinDialogsInProcess(newVal);
        this.updateMaxDialogsInProcess(newVal);
    }

    public void removeDialogsInProcess() {
        long newVal = this.statCollector.dialogsCnt.addAndGet(-1L);
        this.updateMinDialogsInProcess(newVal);
        this.updateMaxDialogsInProcess(newVal);
    }

    public void clearDialogsInProcess() {
        this.statCollector.dialogsCnt.set(0L);
        this.updateMinDialogsInProcess(0L);
        this.updateMaxDialogsInProcess(0L);
    }

    public Long getMinDialogsInProcess(String compainName) {
        StatResult res = this.statCollector.statDataCollection.restartAndGet(MIN_DIALOGS_IN_PROCESS, compainName);
        this.statCollector.statDataCollection.updateData(MIN_DIALOGS_IN_PROCESS, this.statCollector.dialogsCnt.get());
        if (res != null) {
            return res.getLongValue();
        }
        return null;
    }

    private void updateMinDialogsInProcess(long newVal) {
        this.statCollector.statDataCollection.updateData(MIN_DIALOGS_IN_PROCESS, newVal);
    }

    public Long getMaxDialogsInProcess(String compainName) {
        StatResult res = this.statCollector.statDataCollection.restartAndGet(MAX_DIALOGS_IN_PROCESS, compainName);
        this.statCollector.statDataCollection.updateData(MAX_DIALOGS_IN_PROCESS, this.statCollector.dialogsCnt.get());
        if (res != null) {
            return res.getLongValue();
        }
        return null;
    }

    private void updateMaxDialogsInProcess(long newVal) {
        this.statCollector.statDataCollection.updateData(MAX_DIALOGS_IN_PROCESS, newVal);
    }

    public Long getCurrentDialogsInProcess(String compainName) {
        return this.statCollector.dialogsCnt.get();
    }

    public long getDialogsAllEstablished() {
        return this.statCollector.dialogsAllEstablished.get();
    }

    public void updateDialogsAllEstablished() {
        this.statCollector.dialogsAllEstablished.addAndGet(1L);
        if (this.counterDialogs != null) {
            this.counterDialogs.inc();
        }
    }

    public long getDialogsAllFailed() {
        return this.statCollector.dialogsAllFailed.get();
    }

    public void updateDialogsAllFailed() {
        this.statCollector.dialogsAllFailed.addAndGet(1L);
    }

    public long getDialogsPullEstablished() {
        return this.statCollector.dialogsPullEstablished.get();
    }

    public void updateDialogsPullEstablished() {
        this.statCollector.dialogsPullEstablished.addAndGet(1L);
    }

    public long getDialogsPullFailed() {
        return this.statCollector.dialogsPullFailed.get();
    }

    public void updateDialogsPullFailed() {
        this.statCollector.dialogsPullFailed.addAndGet(1L);
    }

    public long getDialogsPushEstablished() {
        return this.statCollector.dialogsPushEstablished.get();
    }

    public void updateDialogsPushEstablished() {
        this.statCollector.dialogsPushEstablished.addAndGet(1L);
    }

    public long getDialogsPushFailed() {
        return this.statCollector.dialogsPushFailed.get();
    }

    public void updateDialogsPushFailed() {
        this.statCollector.dialogsPushFailed.addAndGet(1L);
    }

    public long getDialogsHttpEstablished() {
        return this.statCollector.dialogsHttpEstablished.get();
    }

    public void updateDialogsHttpEstablished() {
        this.statCollector.dialogsHttpEstablished.addAndGet(1L);
    }

    public long getDialogsHttpFailed() {
        return this.statCollector.dialogsHttpFailed.get();
    }

    public void updateDialogsHttpFailed() {
        this.statCollector.dialogsHttpFailed.addAndGet(1L);
    }

    public long getDialogsSipEstablished() {
        return this.statCollector.dialogsSipEstablished.get();
    }

    public void updateDialogsSipEstablished() {
        this.statCollector.dialogsSipEstablished.addAndGet(1L);
    }

    public long getDialogsSipFailed() {
        return this.statCollector.dialogsSipFailed.get();
    }

    public void updateDialogsSipFailed() {
        this.statCollector.dialogsSipFailed.addAndGet(1L);
    }

    public long getMessagesRecieved() {
        return this.statCollector.messagesRecieved.get();
    }

    public void updateMessagesRecieved() {
        this.statCollector.messagesRecieved.addAndGet(1L);
    }

    public long getMessagesSent() {
        return this.statCollector.messagesSent.get();
    }

    public void updateMessagesSent() {
        this.statCollector.messagesSent.addAndGet(1L);
    }

    public long getMessagesAll() {
        return this.statCollector.messagesAll.get();
    }

    public long getMessagesAllCumulative() {
        return this.statCollector.messagesAll.get();
    }

    public void updateMessagesAll() {
        this.statCollector.messagesAll.addAndGet(1L);
        if (this.counterMessages != null) {
            this.counterMessages.inc();
        }
    }

    public long getDialogsAllEstablishedCumulative() {
        return this.statCollector.dialogsAllEstablished.get();
    }

    public long getDialogsAllFailedCumulative() {
        return this.statCollector.dialogsAllFailed.get();
    }

    public long getProcessUssdRequestOperations() {
        return this.statCollector.processUssdRequestOperations.get();
    }

    public void updateProcessUssdRequestOperations() {
        this.statCollector.processUssdRequestOperations.addAndGet(1L);
    }

    public long getUssdRequestOperations() {
        return this.statCollector.ussdRequestOperations.get();
    }

    public void updateUssdRequestOperations() {
        this.statCollector.ussdRequestOperations.addAndGet(1L);
    }

    public long getUssdNotifyOperations() {
        return this.statCollector.ussdNotifyOperations.get();
    }

    public void updateUssdNotifyOperations() {
        this.statCollector.ussdNotifyOperations.addAndGet(1L);
    }

    public long getUssdPullNoRoutingRule() {
        return this.statCollector.ussdPullNoRoutingRule.get();
    }

    public void updateUssdPullNoRoutingRule() {
        this.statCollector.ussdPullNoRoutingRule.addAndGet(1L);
    }

    public long getMapErrorAbsentSubscribers() {
        return this.statCollector.mapErrorAbsentSubscribers.get();
    }

    public void updateMapErrorAbsentSubscribers() {
        this.statCollector.mapErrorAbsentSubscribers.addAndGet(1L);
    }

    public long getMapErrorCallBarred() {
        return this.statCollector.mapErrorCallBarred.get();
    }

    public void updateMapErrorCallBarred() {
        this.statCollector.mapErrorCallBarred.addAndGet(1L);
    }

    public long getMapErrorTeleserviceNotProvisioned() {
        return this.statCollector.mapErrorTeleserviceNotProvisioned.get();
    }

    public void updateMapErrorTeleserviceNotProvisioned() {
        this.statCollector.mapErrorTeleserviceNotProvisioned.addAndGet(1L);
    }

    public long getMapErrorUnknownSubscriber() {
        return this.statCollector.mapErrorUnknownSubscriber.get();
    }

    public void updateMapErrorUnknownSubscriber() {
        this.statCollector.mapErrorUnknownSubscriber.addAndGet(1L);
    }

    public long getMapErrorUssdBusy() {
        return this.statCollector.mapErrorUssdBusy.get();
    }

    public void updateMapErrorUssdBusy() {
        this.statCollector.mapErrorUssdBusy.addAndGet(1L);
    }

    public long getMapErrorComponentOther() {
        return this.statCollector.mapErrorComponentOther.get();
    }

    public void updateMapErrorComponentOther() {
        this.statCollector.mapErrorComponentOther.addAndGet(1L);
    }

    public long getMapDialogTimeouts() {
        return this.statCollector.mapDialogTimeouts.get();
    }

    public void updateMapDialogTimeouts() {
        this.statCollector.mapDialogTimeouts.addAndGet(1L);
    }

    public long getMapInvokeTimeouts() {
        return this.statCollector.mapInvokeTimeouts.get();
    }

    public void updateMapInvokeTimeouts() {
        this.statCollector.mapInvokeTimeouts.addAndGet(1L);
    }

    public long getAppTimeouts() {
        return this.statCollector.appTimeouts.get();
    }

    public void updateAppTimeouts() {
        this.statCollector.appTimeouts.addAndGet(1L);
    }

    public Map<String, LongValue> getRequestsPerUssdCode(String compainName) {
        StatResult res = this.statCollector.statDataCollection.restartAndGet(REQUESTS_PER_USSD_CODE, compainName);
        if (res != null) {
            return res.getStringLongValue();
        }
        return null;
    }

    public void updateRequestsPerUssdCode(String name) {
        this.statCollector.statDataCollection.updateData(REQUESTS_PER_USSD_CODE, name);
    }

    private class StatCollector {
        private StatDataCollection statDataCollection = new StatDataCollectionImpl();
        private AtomicLong dialogsCnt = new AtomicLong();
        private AtomicLong dialogsAllEstablished = new AtomicLong();
        private AtomicLong dialogsAllFailed = new AtomicLong();
        private AtomicLong dialogsPullEstablished = new AtomicLong();
        private AtomicLong dialogsPullFailed = new AtomicLong();
        private AtomicLong dialogsPushEstablished = new AtomicLong();
        private AtomicLong dialogsPushFailed = new AtomicLong();
        private AtomicLong dialogsHttpEstablished = new AtomicLong();
        private AtomicLong dialogsHttpFailed = new AtomicLong();
        private AtomicLong dialogsSipEstablished = new AtomicLong();
        private AtomicLong dialogsSipFailed = new AtomicLong();
        private AtomicLong messagesRecieved = new AtomicLong();
        private AtomicLong messagesSent = new AtomicLong();
        private AtomicLong messagesAll = new AtomicLong();
        private AtomicLong processUssdRequestOperations = new AtomicLong();
        private AtomicLong ussdRequestOperations = new AtomicLong();
        private AtomicLong ussdNotifyOperations = new AtomicLong();
        private AtomicLong ussdPullNoRoutingRule = new AtomicLong();
        private AtomicLong mapErrorAbsentSubscribers = new AtomicLong();
        private AtomicLong mapErrorCallBarred = new AtomicLong();
        private AtomicLong mapErrorTeleserviceNotProvisioned = new AtomicLong();
        private AtomicLong mapErrorUnknownSubscriber = new AtomicLong();
        private AtomicLong mapErrorUssdBusy = new AtomicLong();
        private AtomicLong mapErrorComponentOther = new AtomicLong();
        private AtomicLong mapDialogTimeouts = new AtomicLong();
        private AtomicLong mapInvokeTimeouts = new AtomicLong();
        private AtomicLong appTimeouts = new AtomicLong();

        public StatCollector() {
            this.statDataCollection.registerStatCounterCollector(MIN_DIALOGS_IN_PROCESS, StatDataCollectorType.MIN);
            this.statDataCollection.registerStatCounterCollector(MAX_DIALOGS_IN_PROCESS, StatDataCollectorType.MAX);
            this.statDataCollection.registerStatCounterCollector(REQUESTS_PER_USSD_CODE, StatDataCollectorType.StringLongMap);
        }
    }
}

