/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.ussdgateway;

import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Logger;
import org.mobicents.ss7.management.console.ShellExecutor;
import org.mobicents.ussdgateway.ShortCodeRoutingRuleManagement;
import org.mobicents.ussdgateway.UssdManagement;
import org.mobicents.ussdgateway.UssdPropertiesManagement;
import org.mobicents.ussdgateway.rules.ScRoutingRule;
import org.mobicents.ussdgateway.rules.ScRoutingRuleType;

public class UssdShellExecutor
implements ShellExecutor {
    private static final Logger logger = Logger.getLogger(UssdShellExecutor.class);
    private UssdManagement ussdManagement;
    private UssdPropertiesManagement ussdPropertiesManagement = UssdPropertiesManagement.getInstance();
    private ShortCodeRoutingRuleManagement shortCodeRoutingRuleManagement = ShortCodeRoutingRuleManagement.getInstance();

    public UssdManagement getUssdManagement() {
        return this.ussdManagement;
    }

    public void setUssdManagement(UssdManagement ussdManagement) {
        this.ussdManagement = ussdManagement;
    }

    public String execute(String[] commands) {
        try {
            if (commands.length < 2) {
                return "Invalid Command";
            }
            String command = commands[1];
            if (command.equals("scrule")) {
                return this.manageScRule(commands);
            }
            if (command.equals("set")) {
                return this.manageSet(commands);
            }
            if (command.equals("get")) {
                return this.manageGet(commands);
            }
            return "Invalid Command";
        }
        catch (Exception e) {
            logger.error((Object)String.format("Error while executing comand %s", Arrays.toString(commands)), (Throwable)e);
            return e.getMessage();
        }
    }

    public boolean handles(String command) {
        return "ussd".equals(command);
    }

    private String manageScRule(String[] commands) throws Exception {
        String command = commands[2];
        if (command.equals("create")) {
            return this.createScRule(commands);
        }
        if (command.equals("modify")) {
            return this.modifyScRule(commands);
        }
        if (command.equals("delete")) {
            return this.deleteScRule(commands);
        }
        if (command.equals("show")) {
            return this.showScRule(commands);
        }
        return "Invalid Command";
    }

    private String createScRule(String[] commands) throws Exception {
        if (commands.length < 5 || commands.length > 8) {
            return "Invalid Command";
        }
        String shortCode = commands[3];
        String url = commands[4];
        ScRoutingRuleType ruleType = ScRoutingRuleType.HTTP;
        boolean exactmatch = true;
        int networkId = 0;
        if (commands.length > 5) {
            String args6 = commands[5];
            if (args6.equals("true") || args6.equals("false")) {
                exactmatch = Boolean.parseBoolean(args6);
            } else if (args6.equals("HTTP") || args6.equals("SIP")) {
                ruleType = ScRoutingRuleType.valueOf(args6);
            } else {
                networkId = Integer.parseInt(args6);
            }
        }
        if (commands.length > 6) {
            String args7 = commands[6];
            if (args7.equals("true") || args7.equals("false")) {
                exactmatch = Boolean.parseBoolean(args7);
            } else if (args7.equals("HTTP") || args7.equals("SIP")) {
                ruleType = ScRoutingRuleType.valueOf(args7);
            } else {
                networkId = Integer.parseInt(args7);
            }
        }
        if (commands.length > 7) {
            String args8 = commands[7];
            if (args8.equals("true") || args8.equals("false")) {
                exactmatch = Boolean.parseBoolean(args8);
            } else if (args8.equals("HTTP") || args8.equals("SIP")) {
                ruleType = ScRoutingRuleType.valueOf(args8);
            } else {
                networkId = Integer.parseInt(args8);
            }
        }
        if (ruleType == null) {
            return "Invalid Command";
        }
        this.shortCodeRoutingRuleManagement.createScRoutingRule(shortCode, ruleType, url, exactmatch, networkId);
        return String.format("Successfully created routing rule for short code=%s network id=%d", shortCode, networkId);
    }

    private String modifyScRule(String[] commands) throws Exception {
        if (commands.length < 5 || commands.length > 8) {
            return "Invalid Command";
        }
        String shortCode = commands[3];
        String url = commands[4];
        ScRoutingRuleType ruleType = ScRoutingRuleType.HTTP;
        boolean exactmatch = true;
        int networkId = 0;
        if (commands.length > 5) {
            String args6 = commands[5];
            if (args6.equals("true") || args6.equals("false")) {
                exactmatch = Boolean.parseBoolean(args6);
            } else if (args6.equals("HTTP") || args6.equals("SIP")) {
                ruleType = ScRoutingRuleType.valueOf(args6);
            } else {
                networkId = Integer.parseInt(args6);
            }
        }
        if (commands.length > 6) {
            String args7 = commands[6];
            if (args7.equals("true") || args7.equals("false")) {
                exactmatch = Boolean.parseBoolean(args7);
            } else if (args7.equals("HTTP") || args7.equals("SIP")) {
                ruleType = ScRoutingRuleType.valueOf(args7);
            } else {
                networkId = Integer.parseInt(args7);
            }
        }
        if (commands.length > 7) {
            String args8 = commands[7];
            if (args8.equals("true") || args8.equals("false")) {
                exactmatch = Boolean.parseBoolean(args8);
            } else if (args8.equals("HTTP") || args8.equals("SIP")) {
                ruleType = ScRoutingRuleType.valueOf(args8);
            } else {
                networkId = Integer.parseInt(args8);
            }
        }
        if (ruleType == null) {
            return "Invalid Command";
        }
        this.shortCodeRoutingRuleManagement.modifyScRoutingRule(shortCode, ruleType, url, exactmatch, networkId);
        return String.format("Successfully modified routing rule for short code=%s network id=%d", shortCode, networkId);
    }

    private String deleteScRule(String[] commands) throws Exception {
        if (commands.length < 4 || commands.length > 5) {
            return "Invalid Command";
        }
        String shortCode = commands[3];
        int networkId = 0;
        if (commands.length > 4) {
            String args6 = commands[4];
            networkId = Integer.parseInt(args6);
        }
        this.shortCodeRoutingRuleManagement.deleteScRoutingRule(shortCode, networkId);
        return String.format("Successfully deleted routing rule for short code=%s network id=%d", shortCode, networkId);
    }

    private String showScRule(String[] commands) {
        List<ScRoutingRule> rules = this.shortCodeRoutingRuleManagement.getScRoutingRuleList();
        if (rules.size() == 0) {
            return "No short code routing rule defined yet";
        }
        StringBuffer sb = new StringBuffer();
        if (commands.length >= 4) {
            ScRoutingRule scRule;
            String shortCode = commands[3];
            int networkId = 0;
            if (commands.length > 4) {
                String args6 = commands[4];
                networkId = Integer.parseInt(args6);
            }
            if ((scRule = this.shortCodeRoutingRuleManagement.getScRoutingRule(shortCode, networkId)) == null) {
                return "Invalid short code and networkid pair";
            }
            sb.append("\n");
            scRule.show(sb);
        } else {
            for (ScRoutingRule scRule : rules) {
                sb.append("\n");
                scRule.show(sb);
            }
        }
        return sb.toString();
    }

    private String manageSet(String[] options) throws Exception {
        if (options.length < 4) {
            return "Invalid Command";
        }
        String parName = options[2].toLowerCase();
        if (parName.equals("noroutingruleconfigerrmssg")) {
            this.ussdPropertiesManagement.setNoRoutingRuleConfiguredMessage(this.formFullMessage(options, 3));
        } else if (parName.equals("dialogtimeouterrmssg")) {
            this.ussdPropertiesManagement.setDialogTimeoutErrorMessage(this.formFullMessage(options, 3));
        } else if (parName.equals("serveroverloadedmsg")) {
            this.ussdPropertiesManagement.setServerOverloadedMessage(this.formFullMessage(options, 3));
        } else if (parName.equals("servererrmssg")) {
            this.ussdPropertiesManagement.setServerErrorMessage(this.formFullMessage(options, 3));
        } else if (parName.equals("dialogtimeout")) {
            this.ussdPropertiesManagement.setDialogTimeout(Long.parseLong(options[3]));
        } else if (parName.equals("ussdgt")) {
            String gt = options[3];
            if (options.length >= 6 && options[4].equals("networkid")) {
                int val = Integer.parseInt(options[5]);
                this.ussdPropertiesManagement.setUssdGt(val, gt);
            } else {
                this.ussdPropertiesManagement.setUssdGt(gt);
            }
        } else if (parName.equals("maxactivitycount")) {
            this.ussdPropertiesManagement.setMaxActivityCount(Integer.parseInt(options[3]));
        } else if (parName.equals("ussdssn")) {
            this.ussdPropertiesManagement.setUssdSsn(Integer.parseInt(options[3]));
        } else if (parName.equals("hlrssn")) {
            this.ussdPropertiesManagement.setHlrSsn(Integer.parseInt(options[3]));
        } else if (parName.equals("mscssn")) {
            this.ussdPropertiesManagement.setMscSsn(Integer.parseInt(options[3]));
        } else if (parName.equals("maxmapv")) {
            this.ussdPropertiesManagement.setMaxMapVersion(Integer.parseInt(options[3]));
        } else if (parName.equals("hrhlrgt")) {
            if (options[3].equals("null")) {
                System.err.println("setting null");
                this.ussdPropertiesManagement.setHrHlrGt(null);
            } else {
                System.err.println("its not null");
                this.ussdPropertiesManagement.setHrHlrGt(options[3]);
            }
        } else if (parName.equals("cdrloggingto")) {
            UssdPropertiesManagement.CdrLoggedType cdrLoggedType = Enum.valueOf(UssdPropertiesManagement.CdrLoggedType.class, options[3]);
            this.ussdPropertiesManagement.setCdrLoggingTo(cdrLoggedType);
        } else {
            return "Invalid Command";
        }
        return "Parameter has been successfully set";
    }

    private String formFullMessage(String[] options, int fromIndex) {
        StringBuffer sb = new StringBuffer();
        for (int count = fromIndex; count < options.length; ++count) {
            sb.append(options[count]);
            if (count == options.length - 1) continue;
            sb.append(" ");
        }
        return sb.toString();
    }

    private String manageGet(String[] options) throws Exception {
        if (options.length == 3) {
            String parName = options[2].toLowerCase();
            StringBuilder sb = new StringBuilder();
            sb.append(options[2]);
            sb.append(" = ");
            if (parName.equals("noroutingruleconfigerrmssg")) {
                sb.append(this.ussdPropertiesManagement.getNoRoutingRuleConfiguredMessage());
            } else if (parName.equals("dialogtimeouterrmssg")) {
                sb.append(this.ussdPropertiesManagement.getDialogTimeoutErrorMessage());
            } else if (parName.equals("serveroverloadedmsg")) {
                sb.append(this.ussdPropertiesManagement.getServerOverloadedMessage());
            } else if (parName.equals("servererrmssg")) {
                sb.append(this.ussdPropertiesManagement.getServerErrorMessage());
            } else if (parName.equals("dialogtimeout")) {
                sb.append(this.ussdPropertiesManagement.getDialogTimeout());
            } else if (parName.equals("ussdgt")) {
                sb.append("networkId=0 - GT=");
                sb.append(this.ussdPropertiesManagement.getUssdGt());
                for (Integer key : this.ussdPropertiesManagement.getNetworkIdVsUssdGwGt().keySet()) {
                    sb.append("\nnetworkId=");
                    sb.append(key);
                    sb.append(" - GT=");
                    sb.append(this.ussdPropertiesManagement.getNetworkIdVsUssdGwGt().get(key));
                }
            } else if (parName.equals("maxactivitycount")) {
                sb.append(this.ussdPropertiesManagement.getMaxActivityCount());
            } else if (parName.equals("ussdssn")) {
                sb.append(this.ussdPropertiesManagement.getUssdSsn());
            } else if (parName.equals("hlrssn")) {
                sb.append(this.ussdPropertiesManagement.getHlrSsn());
            } else if (parName.equals("mscssn")) {
                sb.append(this.ussdPropertiesManagement.getMscSsn());
            } else if (parName.equals("maxmapv")) {
                sb.append(this.ussdPropertiesManagement.getMaxMapVersion());
            } else if (parName.equals("hrhlrgt")) {
                sb.append(this.ussdPropertiesManagement.getHrHlrGt());
            } else if (parName.equals("cdrloggingto")) {
                sb.append((Object)this.ussdPropertiesManagement.getCdrLoggingTo());
            } else {
                return "Invalid Command";
            }
            return sb.toString();
        }
        StringBuilder sb = new StringBuilder();
        sb.append("noroutingruleconfigerrmssg = ");
        sb.append(this.ussdPropertiesManagement.getNoRoutingRuleConfiguredMessage());
        sb.append("\n");
        sb.append("dialogtimeouterrmssg = ");
        sb.append(this.ussdPropertiesManagement.getDialogTimeoutErrorMessage());
        sb.append("\n");
        sb.append("serveroverloadedmsg = ");
        sb.append(this.ussdPropertiesManagement.getServerOverloadedMessage());
        sb.append("\n");
        sb.append("dialogtimeout = ");
        sb.append(this.ussdPropertiesManagement.getDialogTimeout());
        sb.append("\n");
        sb.append("servererrmssg = ");
        sb.append(this.ussdPropertiesManagement.getServerErrorMessage());
        sb.append("\n");
        sb.append("networkId=0 - GT=");
        sb.append(this.ussdPropertiesManagement.getUssdGt());
        for (Integer key : this.ussdPropertiesManagement.getNetworkIdVsUssdGwGt().keySet()) {
            sb.append("\nnetworkId=");
            sb.append(key);
            sb.append(" - GT=");
            sb.append(this.ussdPropertiesManagement.getNetworkIdVsUssdGwGt().get(key));
        }
        sb.append("\n");
        sb.append("maxactivitycount = ");
        sb.append(this.ussdPropertiesManagement.getMaxActivityCount());
        sb.append("\n");
        sb.append("ussdssn = ");
        sb.append(this.ussdPropertiesManagement.getUssdSsn());
        sb.append("\n");
        sb.append("hlrssn = ");
        sb.append(this.ussdPropertiesManagement.getHlrSsn());
        sb.append("\n");
        sb.append("mscssn = ");
        sb.append(this.ussdPropertiesManagement.getMscSsn());
        sb.append("\n");
        sb.append("maxmapv = ");
        sb.append(this.ussdPropertiesManagement.getMaxMapVersion());
        sb.append("\n");
        sb.append("hrhlrgt = ");
        sb.append(this.ussdPropertiesManagement.getHrHlrGt());
        sb.append("\n");
        sb.append("cdrloggingto = ");
        sb.append((Object)this.ussdPropertiesManagement.getCdrLoggingTo());
        sb.append("\n");
        return sb.toString();
    }
}

