/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.applications.ussd.examples.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Arrays;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javolution.util.FastList;
import javolution.xml.stream.XMLStreamException;
import org.apache.log4j.Logger;
import org.mobicents.applications.ussd.examples.http.TestServlet;
import org.mobicents.protocols.ss7.indicator.RoutingIndicator;
import org.mobicents.protocols.ss7.map.api.MAPApplicationContext;
import org.mobicents.protocols.ss7.map.api.MAPApplicationContextName;
import org.mobicents.protocols.ss7.map.api.MAPApplicationContextVersion;
import org.mobicents.protocols.ss7.map.api.MAPException;
import org.mobicents.protocols.ss7.map.api.MAPMessage;
import org.mobicents.protocols.ss7.map.api.MAPMessageType;
import org.mobicents.protocols.ss7.map.api.datacoding.CBSDataCodingScheme;
import org.mobicents.protocols.ss7.map.api.primitives.AddressNature;
import org.mobicents.protocols.ss7.map.api.primitives.AddressString;
import org.mobicents.protocols.ss7.map.api.primitives.AlertingCategory;
import org.mobicents.protocols.ss7.map.api.primitives.AlertingPattern;
import org.mobicents.protocols.ss7.map.api.primitives.ISDNAddressString;
import org.mobicents.protocols.ss7.map.api.primitives.NumberingPlan;
import org.mobicents.protocols.ss7.map.api.primitives.USSDString;
import org.mobicents.protocols.ss7.map.api.service.supplementary.ProcessUnstructuredSSRequest;
import org.mobicents.protocols.ss7.map.datacoding.CBSDataCodingSchemeImpl;
import org.mobicents.protocols.ss7.map.primitives.AddressStringImpl;
import org.mobicents.protocols.ss7.map.primitives.AlertingPatternImpl;
import org.mobicents.protocols.ss7.map.primitives.ISDNAddressStringImpl;
import org.mobicents.protocols.ss7.map.primitives.USSDStringImpl;
import org.mobicents.protocols.ss7.map.service.supplementary.ProcessUnstructuredSSRequestImpl;
import org.mobicents.protocols.ss7.map.service.supplementary.ProcessUnstructuredSSResponseImpl;
import org.mobicents.protocols.ss7.map.service.supplementary.UnstructuredSSRequestImpl;
import org.mobicents.protocols.ss7.map.service.supplementary.UnstructuredSSResponseImpl;
import org.mobicents.protocols.ss7.sccp.impl.parameter.SccpAddressImpl;
import org.mobicents.protocols.ss7.sccp.parameter.SccpAddress;
import org.mobicents.protocols.ss7.tcap.api.MessageType;
import org.mobicents.ussdgateway.EventsSerializeFactory;
import org.mobicents.ussdgateway.XmlMAPDialog;

public class TestServlet
extends HttpServlet {
    private static final Logger logger = Logger.getLogger(TestServlet.class);
    private EventsSerializeFactory factory = null;

    public void init() {
        this.factory = new EventsSerializeFactory();
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        PrintWriter out = response.getWriter();
        out.println("<html>");
        out.println("<body>");
        out.println("<h1>Hello USSD Demo Get</h1>");
        CBSDataCodingSchemeImpl cbsDataCodingScheme = new CBSDataCodingSchemeImpl(15);
        USSDStringImpl ussdStr = new USSDStringImpl("USSD String : Hello World\n 1. Balance\n 2. Texts Remaining".getBytes(), (CBSDataCodingScheme)cbsDataCodingScheme);
        UnstructuredSSRequestImpl unstructuredSSRequestIndication = new UnstructuredSSRequestImpl((CBSDataCodingScheme)cbsDataCodingScheme, (USSDString)ussdStr, null, null);
        SccpAddressImpl orgAddress = new SccpAddressImpl(RoutingIndicator.ROUTING_BASED_ON_DPC_AND_SSN, null, 1, 8);
        SccpAddressImpl dstAddress = new SccpAddressImpl(RoutingIndicator.ROUTING_BASED_ON_DPC_AND_SSN, null, 2, 8);
        AddressStringImpl destReference = new AddressStringImpl(AddressNature.international_number, NumberingPlan.land_mobile, "204208300008002");
        AddressStringImpl origReference = new AddressStringImpl(AddressNature.international_number, NumberingPlan.ISDN, "31628968300");
        ISDNAddressStringImpl isdnAddress = new ISDNAddressStringImpl(AddressNature.international_number, NumberingPlan.ISDN, "79273605819");
        AlertingPatternImpl alertingPattern = new AlertingPatternImpl(AlertingCategory.Category3);
        ProcessUnstructuredSSRequestImpl processUnstructuredSSRequestIndication = new ProcessUnstructuredSSRequestImpl((CBSDataCodingScheme)cbsDataCodingScheme, (USSDString)ussdStr, (AlertingPattern)alertingPattern, (ISDNAddressString)isdnAddress);
        MAPApplicationContext appCtx = MAPApplicationContext.getInstance((MAPApplicationContextName)MAPApplicationContextName.networkUnstructuredSsContext, (MAPApplicationContextVersion)MAPApplicationContextVersion.version2);
        XmlMAPDialog copy = new XmlMAPDialog(appCtx, (SccpAddress)orgAddress, (SccpAddress)dstAddress, Long.valueOf(12L), Long.valueOf(13L), (AddressString)destReference, (AddressString)origReference);
        copy.addMAPMessage((MAPMessage)unstructuredSSRequestIndication);
        try {
            byte[] data = this.factory.serialize(copy);
            System.out.println(Arrays.toString(data));
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
        }
        out.println("</body>");
        out.println("</html>");
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        ServletInputStream is = request.getInputStream();
        try {
            XmlMAPDialog original = this.factory.deserialize((InputStream)is);
            HttpSession session = request.getSession(true);
            if (logger.isInfoEnabled()) {
                logger.info((Object)("doPost. HttpSession=" + session.getId() + " Dialog = " + original));
            }
            USSDStringImpl ussdStr = null;
            byte[] data = null;
            FastList capMessages = original.getMAPMessages();
            MessageType messageType = original.getTCAPMessageType();
            FastList.Node n = capMessages.head();
            FastList.Node end = capMessages.tail();
            while ((n = n.getNext()) != end) {
                MAPMessage rawMessage = (MAPMessage)n.getValue();
                MAPMessageType type = rawMessage.getMessageType();
                block3 : switch (1.$SwitchMap$org$mobicents$protocols$ss7$tcap$api$MessageType[messageType.ordinal()]) {
                    case 1: {
                        CBSDataCodingScheme cbsDataCodingScheme;
                        switch (1.$SwitchMap$org$mobicents$protocols$ss7$map$api$MAPMessageType[type.ordinal()]) {
                            case 1: {
                                ProcessUnstructuredSSRequest processUnstructuredSSRequest = (ProcessUnstructuredSSRequest)rawMessage;
                                cbsDataCodingScheme = processUnstructuredSSRequest.getDataCodingScheme();
                                if (logger.isInfoEnabled()) {
                                    logger.info((Object)("Received ProcessUnstructuredSSRequestIndication USSD String=" + processUnstructuredSSRequest.getUSSDString().getString(null)));
                                }
                                session.setAttribute("ProcessUnstructuredSSRequest_InvokeId", (Object)processUnstructuredSSRequest.getInvokeId());
                                ussdStr = new USSDStringImpl("USSD String : Hello World\n 1. Balance\n 2. Texts Remaining", cbsDataCodingScheme, null);
                                UnstructuredSSRequestImpl unstructuredSSRequestIndication = new UnstructuredSSRequestImpl(cbsDataCodingScheme, (USSDString)ussdStr, null, null);
                                original.reset();
                                original.setUserObject((Object)("Session Id : " + session.getId()));
                                original.setTCAPMessageType(MessageType.Continue);
                                original.setCustomInvokeTimeOut(Integer.valueOf(25000));
                                original.addMAPMessage((MAPMessage)unstructuredSSRequestIndication);
                                data = this.factory.serialize(original);
                                response.getOutputStream().write(data);
                                response.flushBuffer();
                                break block3;
                            }
                        }
                        logger.error((Object)("Received Dialog BEGIN but message is not ProcessUnstructuredSSRequestIndication. Message=" + rawMessage));
                        break;
                    }
                    case 2: {
                        CBSDataCodingScheme cbsDataCodingScheme;
                        switch (1.$SwitchMap$org$mobicents$protocols$ss7$map$api$MAPMessageType[type.ordinal()]) {
                            case 2: {
                                UnstructuredSSResponseImpl unstructuredSSResponse = (UnstructuredSSResponseImpl)rawMessage;
                                cbsDataCodingScheme = unstructuredSSResponse.getDataCodingScheme();
                                long invokeId = (Long)session.getAttribute("ProcessUnstructuredSSRequest_InvokeId");
                                USSDString ussdStringObj = unstructuredSSResponse.getUSSDString();
                                String ussdString = null;
                                if (ussdStringObj != null) {
                                    ussdString = ussdStringObj.getString(null);
                                }
                                logger.info((Object)("Received UnstructuredSSResponse USSD String=" + ussdString + " HttpSession=" + session.getId() + " invokeId=" + invokeId));
                                cbsDataCodingScheme = new CBSDataCodingSchemeImpl(15);
                                ussdStr = new USSDStringImpl("Thank You!", null, null);
                                ProcessUnstructuredSSResponseImpl processUnstructuredSSResponse = new ProcessUnstructuredSSResponseImpl(cbsDataCodingScheme, (USSDString)ussdStr);
                                processUnstructuredSSResponse.setInvokeId(invokeId);
                                original.reset();
                                original.setTCAPMessageType(MessageType.End);
                                original.addMAPMessage((MAPMessage)processUnstructuredSSResponse);
                                original.close(false);
                                data = this.factory.serialize(original);
                                response.getOutputStream().write(data);
                                response.flushBuffer();
                                try {
                                    session.invalidate();
                                }
                                catch (Exception e) {
                                    session.invalidate();
                                    logger.error((Object)("Error while invalidating HttpSession=" + session.getId()));
                                }
                                break block3;
                            }
                        }
                        logger.error((Object)("Received Dialog CONTINUE but message is not UnstructuredSSResponseIndication. Message=" + rawMessage));
                        break;
                    }
                    case 3: {
                        try {
                            session.invalidate();
                            break;
                        }
                        catch (Exception e) {
                            session.invalidate();
                            logger.error((Object)("Error while invalidating HttpSession=" + session.getId()));
                        }
                    }
                }
            }
        }
        catch (XMLStreamException e) {
            logger.error((Object)"Error while processing received XML", (Throwable)e);
        }
        catch (MAPException e) {
            e.printStackTrace();
        }
    }
}

