/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.applications.ussd.examples.http.push;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Date;
import javolution.util.FastList;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.CookieStore;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.params.HttpParams;
import org.apache.http.params.SyncBasicHttpParams;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;
import org.mobicents.applications.ussd.examples.http.push.HTTPPushMBean;
import org.mobicents.protocols.ss7.map.api.MAPApplicationContext;
import org.mobicents.protocols.ss7.map.api.MAPApplicationContextName;
import org.mobicents.protocols.ss7.map.api.MAPApplicationContextVersion;
import org.mobicents.protocols.ss7.map.api.MAPException;
import org.mobicents.protocols.ss7.map.api.MAPMessage;
import org.mobicents.protocols.ss7.map.api.MAPMessageType;
import org.mobicents.protocols.ss7.map.api.datacoding.CBSDataCodingScheme;
import org.mobicents.protocols.ss7.map.api.dialog.MAPUserAbortChoice;
import org.mobicents.protocols.ss7.map.api.primitives.AddressNature;
import org.mobicents.protocols.ss7.map.api.primitives.AlertingLevel;
import org.mobicents.protocols.ss7.map.api.primitives.AlertingPattern;
import org.mobicents.protocols.ss7.map.api.primitives.ISDNAddressString;
import org.mobicents.protocols.ss7.map.api.primitives.NumberingPlan;
import org.mobicents.protocols.ss7.map.api.primitives.USSDString;
import org.mobicents.protocols.ss7.map.api.service.supplementary.UnstructuredSSResponse;
import org.mobicents.protocols.ss7.map.datacoding.CBSDataCodingSchemeImpl;
import org.mobicents.protocols.ss7.map.dialog.MAPUserAbortChoiceImpl;
import org.mobicents.protocols.ss7.map.primitives.AlertingPatternImpl;
import org.mobicents.protocols.ss7.map.primitives.ISDNAddressStringImpl;
import org.mobicents.protocols.ss7.map.primitives.USSDStringImpl;
import org.mobicents.protocols.ss7.map.service.supplementary.UnstructuredSSNotifyRequestImpl;
import org.mobicents.protocols.ss7.map.service.supplementary.UnstructuredSSRequestImpl;
import org.mobicents.protocols.ss7.tcap.api.MessageType;
import org.mobicents.ussdgateway.EventsSerializeFactory;
import org.mobicents.ussdgateway.XmlMAPDialog;

public class HTTPPush
implements HTTPPushMBean {
    private static final Logger logger = Logger.getLogger(HTTPPush.class);
    private String targetURI = "http://localhost:8080/mobicents";
    private String isdn = "1111";
    private EventsSerializeFactory serializer = new EventsSerializeFactory();
    private StringBuilder status = new StringBuilder();
    private static long ID = 0L;
    private static final CBSDataCodingScheme CBS_CODDING_SCHEME = new CBSDataCodingSchemeImpl(15);
    private static final AlertingPattern ALERTING_PATTERN = new AlertingPatternImpl(AlertingLevel.Level1);
    private static final String ANSWER_NTFY = "2";
    private XmlMAPDialog dialog;
    private HttpContext context;
    private HttpClient httpClient;
    private CookieStore cookieStore = null;
    private final MAPApplicationContext appCtx = MAPApplicationContext.getInstance((MAPApplicationContextName)MAPApplicationContextName.networkUnstructuredSsContext, (MAPApplicationContextVersion)MAPApplicationContextVersion.version2);

    public HTTPPush() {
        SyncBasicHttpParams params = new SyncBasicHttpParams();
        SchemeRegistry schemeRegistry = new SchemeRegistry();
        schemeRegistry.register(new Scheme("http", 80, (SchemeSocketFactory)PlainSocketFactory.getSocketFactory()));
        schemeRegistry.register(new Scheme("https", 443, (SchemeSocketFactory)SSLSocketFactory.getSocketFactory()));
        ThreadSafeClientConnManager threadSafeClientConnManager = new ThreadSafeClientConnManager(schemeRegistry);
        threadSafeClientConnManager.setMaxTotal(1000);
        this.httpClient = new DefaultHttpClient((ClientConnectionManager)threadSafeClientConnManager, (HttpParams)params);
    }

    public void setTargetUri(String uri) {
        this.targetURI = uri;
    }

    public String getTargetUri() {
        return this.targetURI;
    }

    public String getIsdn() {
        return this.isdn;
    }

    public void setIsdn(String isdn) {
        this.isdn = isdn;
    }

    public void reset() {
        this.dialog = null;
        this.status = new StringBuilder();
        this.context = null;
    }

    public void sendRequest(String ussdRequest, boolean emptyDialogHandshake, int invokeTimeout, String userData) throws Exception {
        ISDNAddressString isdnAddressString = this.getISDNAddressString();
        USSDString ussdStr = this.getUSSDString(ussdRequest);
        UnstructuredSSRequestImpl unstructuredSSRequestIndication = new UnstructuredSSRequestImpl(CBS_CODDING_SCHEME, ussdStr, ALERTING_PATTERN, isdnAddressString);
        if (this.dialog == null) {
            this.establishSession();
            this.dialog = new XmlMAPDialog(this.appCtx, null, null, Long.valueOf(0L), Long.valueOf(0L), null, null);
            this.dialog.setCustomInvokeTimeOut(Integer.valueOf(invokeTimeout));
            this.dialog.setEmptyDialogHandshake(Boolean.valueOf(emptyDialogHandshake));
            this.dialog.setTCAPMessageType(MessageType.Begin);
            this.addStatusEntry("Created dialog: '" + this.dialog);
        } else {
            this.dialog.reset();
            this.dialog.setTCAPMessageType(MessageType.Continue);
            this.addStatusEntry("Sending on existing dialog: '" + this.dialog);
        }
        if (userData != null) {
            this.dialog.setUserObject((Object)userData);
        }
        this.dialog.addMAPMessage((MAPMessage)unstructuredSSRequestIndication);
        byte[] serialized = this.serializer.serialize(this.dialog);
        this.addStatusEntry("Sending UnstructuredSSRequest");
        HttpResponse response = this.send(serialized);
        this.handleResponse(response);
    }

    public void sendNotify(String ussdRequest, boolean emptyDialogHandshake, int invokeTimeout, String userData) throws Exception {
        ISDNAddressString isdnAddressString = this.getISDNAddressString();
        USSDString ussdStr = this.getUSSDString(ussdRequest);
        UnstructuredSSNotifyRequestImpl unstructuredSSNotifyRequest = new UnstructuredSSNotifyRequestImpl(CBS_CODDING_SCHEME, ussdStr, ALERTING_PATTERN, isdnAddressString);
        if (this.dialog == null) {
            this.establishSession();
            this.dialog = new XmlMAPDialog(this.appCtx, null, null, Long.valueOf(0L), Long.valueOf(0L), null, null);
            this.dialog.setEmptyDialogHandshake(Boolean.valueOf(emptyDialogHandshake));
            this.dialog.setCustomInvokeTimeOut(Integer.valueOf(invokeTimeout));
            this.dialog.setTCAPMessageType(MessageType.Begin);
            this.addStatusEntry("Created dialog: '" + this.dialog);
        } else {
            this.dialog.reset();
            this.dialog.setTCAPMessageType(MessageType.Continue);
            this.addStatusEntry("Sending on existing dialog: '" + this.dialog);
        }
        if (userData != null) {
            this.dialog.setUserObject((Object)userData);
        }
        this.dialog.addMAPMessage((MAPMessage)unstructuredSSNotifyRequest);
        byte[] serialized = this.serializer.serialize(this.dialog);
        this.addStatusEntry("Sending UnstructuredSSNotifyRequest");
        HttpResponse response = this.send(serialized);
        this.handleResponse(response);
    }

    public String getStatus() {
        return this.status.toString();
    }

    public void abort() throws Exception {
        if (this.dialog == null) {
            throw new Exception("There is no Dialog established yet");
        }
        MAPUserAbortChoiceImpl abort = new MAPUserAbortChoiceImpl();
        abort.setUserSpecificReason();
        this.dialog.reset();
        this.dialog.setTCAPMessageType(MessageType.Abort);
        this.dialog.abort((MAPUserAbortChoice)abort);
        this.addStatusEntry("Aborting existing dialog: '" + this.dialog);
        byte[] serialized = this.serializer.serialize(this.dialog);
        HttpResponse response = this.send(serialized);
        this.handleResponse(response);
    }

    public void close() throws Exception {
        if (this.dialog == null) {
            throw new Exception("There is no Dialog established yet");
        }
        this.dialog.reset();
        this.dialog.setTCAPMessageType(MessageType.End);
        this.dialog.close(false);
        this.addStatusEntry("Closing existing dialog: '" + this.dialog);
        byte[] serialized = this.serializer.serialize(this.dialog);
        HttpResponse response = this.send(serialized);
        this.handleResponse(response);
    }

    protected synchronized long getNewID() {
        return ID++;
    }

    protected USSDString getUSSDString(String msg) throws MAPException {
        return new USSDStringImpl(msg, CBS_CODDING_SCHEME, null);
    }

    protected ISDNAddressString getISDNAddressString() {
        return new ISDNAddressStringImpl(AddressNature.international_number, NumberingPlan.ISDN, this.isdn);
    }

    protected void addStatusEntry(String entry) {
        Date d = new Date();
        d.setTime(System.currentTimeMillis());
        StringBuilder sb = new StringBuilder();
        sb.append(d.toString()).append(">").append(entry);
        sb.append("\n");
        sb.append("---------------------------------");
        logger.info((Object)sb.toString());
        this.status.append(sb.toString().replaceAll("<", "-").replaceAll(">", "-"));
    }

    protected void establishSession() {
        this.context = new BasicHttpContext();
        BasicCookieStore cookieStore = new BasicCookieStore();
        this.context.setAttribute("http.cookie-store", (Object)cookieStore);
    }

    protected HttpResponse send(byte[] serialized) throws Exception {
        HttpPost post = new HttpPost(this.targetURI);
        if (!(post instanceof HttpEntityEnclosingRequestBase)) {
            throw new IOException();
        }
        this.addStatusEntry("Sending:\n" + new String(serialized));
        ByteArrayEntity entity = new ByteArrayEntity(serialized);
        entity.setContentType("text/xml");
        entity.setContentEncoding(Charset.defaultCharset().toString());
        ((HttpEntityEnclosingRequestBase)post).setEntity((HttpEntity)entity);
        return this.httpClient.execute((HttpUriRequest)post, this.context);
    }

    protected void handleResponse(HttpResponse response) throws Exception {
        XmlMAPDialog deserialized;
        Header[] headers;
        if (response.getStatusLine().getStatusCode() != 200) {
            logger.error((Object)("Received bad answer: " + response.getStatusLine().getStatusCode() + " <> " + response.getStatusLine().getReasonPhrase()));
            return;
        }
        for (Header h : headers = response.getAllHeaders()) {
            this.addStatusEntry(h.getName() + " - " + h.getValue());
        }
        String content = EntityUtils.toString((HttpEntity)response.getEntity());
        this.addStatusEntry("Received response: \n" + content);
        if (content == null || content.trim().equals("")) {
            return;
        }
        this.dialog = deserialized = this.serializer.deserialize(content.getBytes());
        if (this.dialog.getTCAPMessageType() == MessageType.End || this.dialog.getTCAPMessageType() == MessageType.Abort) {
            this.addStatusEntry("Dialog " + this.dialog.getTCAPMessageType().name());
            this.reset();
            return;
        }
        Boolean prearrangedEnd = this.dialog.getPrearrangedEnd();
        FastList capMessages = this.dialog.getMAPMessages();
        FastList.Node n = capMessages.head();
        FastList.Node end = capMessages.tail();
        while ((n = n.getNext()) != end) {
            MAPMessage message = (MAPMessage)n.getValue();
            MAPMessageType type = message.getMessageType();
            switch (type) {
                case unstructuredSSRequest_Response: {
                    UnstructuredSSResponse unstructuredSSResponse = (UnstructuredSSResponse)message;
                    USSDString x = unstructuredSSResponse.getUSSDString();
                    String s = x.getString(Charset.defaultCharset());
                    this.addStatusEntry("Received response: " + s);
                    if (!s.equals(ANSWER_NTFY)) break;
                    this.sendNotify("Bye bye", false, 20000, null);
                    break;
                }
                case unstructuredSSNotify_Response: {
                    this.addStatusEntry("Received NTFY response.");
                    break;
                }
            }
        }
    }
}

