/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.applications.ussd.examples.sip;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import javax.sip.ClientTransaction;
import javax.sip.Dialog;
import javax.sip.DialogState;
import javax.sip.DialogTerminatedEvent;
import javax.sip.IOExceptionEvent;
import javax.sip.InvalidArgumentException;
import javax.sip.ListeningPoint;
import javax.sip.PeerUnavailableException;
import javax.sip.RequestEvent;
import javax.sip.ResponseEvent;
import javax.sip.ServerTransaction;
import javax.sip.SipException;
import javax.sip.SipFactory;
import javax.sip.SipListener;
import javax.sip.SipProvider;
import javax.sip.SipStack;
import javax.sip.TimeoutEvent;
import javax.sip.TransactionTerminatedEvent;
import javax.sip.address.Address;
import javax.sip.address.AddressFactory;
import javax.sip.address.SipURI;
import javax.sip.address.URI;
import javax.sip.header.CSeqHeader;
import javax.sip.header.CallIdHeader;
import javax.sip.header.ContactHeader;
import javax.sip.header.ContentLengthHeader;
import javax.sip.header.ContentTypeHeader;
import javax.sip.header.FromHeader;
import javax.sip.header.Header;
import javax.sip.header.HeaderFactory;
import javax.sip.header.MaxForwardsHeader;
import javax.sip.header.ToHeader;
import javax.sip.header.ViaHeader;
import javax.sip.message.MessageFactory;
import javax.sip.message.Request;
import javax.sip.message.Response;
import org.mobicents.protocols.ss7.map.api.MAPMessageType;
import org.mobicents.ussdgateway.AnyExt;
import org.mobicents.ussdgateway.EventsSerializeFactory;
import org.mobicents.ussdgateway.SipUssdMessage;

public class SipServerTest
implements SipListener {
    private static final String CONTENT_TYPE = "application";
    private static final String CONTENT_SUB_TYPE = "vnd.3gpp.ussd+xml";
    private String transport = "udp";
    private String peerHostPort = "127.0.0.1:5060";
    private String fromName = "BigGuy";
    private String fromSipAddress = "here.com";
    private String fromDisplayName = "The Master Blaster";
    private String toSipAddress = "there.com";
    private String toUser = "919960639901";
    private String toDisplayName = "919960639901";
    private static SipProvider sipProvider;
    private static AddressFactory addressFactory;
    private static MessageFactory messageFactory;
    private static HeaderFactory headerFactory;
    private static SipStack sipStack;
    private ContactHeader contactHeader;
    private ListeningPoint udpListeningPoint;
    private ClientTransaction inviteTid;
    private Dialog dialog;
    private boolean byeTaskRunning;
    private EventsSerializeFactory eventsSerializeFactory;
    private Request ackRequest;

    public static void main(String[] args) {
        new SipServerTest().init();
    }

    public void processRequest(RequestEvent requestReceivedEvent) {
        Request request = requestReceivedEvent.getRequest();
        ServerTransaction serverTransactionId = requestReceivedEvent.getServerTransaction();
        System.out.println("\n\nRequest " + request.getMethod() + " received at " + sipStack.getStackName() + " with server transaction id " + serverTransactionId);
        if (request.getMethod().equals("BYE")) {
            this.processBye(request, serverTransactionId);
        } else if (request.getMethod().equals("INFO")) {
            this.processInfo(requestReceivedEvent, serverTransactionId);
        } else {
            try {
                serverTransactionId.sendResponse(messageFactory.createResponse(202, request));
            }
            catch (SipException e) {
                e.printStackTrace();
            }
            catch (InvalidArgumentException e) {
                e.printStackTrace();
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
    }

    private void sendUnstructuredSSNotify(RequestEvent requestEvent) throws Exception {
        SipUssdMessage simMsg = new SipUssdMessage("Thank you your balance is XX", "en");
        simMsg.setAnyExt(new AnyExt(MAPMessageType.unstructuredSSNotify_Request));
        byte[] rawContent = this.eventsSerializeFactory.serializeSipUssdMessage(simMsg);
        String content = new String(rawContent);
        SipProvider provider = (SipProvider)requestEvent.getSource();
        Request infoRequest = this.dialog.createRequest("INFO");
        ContentTypeHeader contentTypeHeader = headerFactory.createContentTypeHeader(CONTENT_TYPE, CONTENT_SUB_TYPE);
        infoRequest.setContent((Object)content, contentTypeHeader);
        ContentLengthHeader contentLengthHeader = headerFactory.createContentLengthHeader(content.length());
        infoRequest.setContentLength(contentLengthHeader);
        ClientTransaction ct = provider.getNewClientTransaction(infoRequest);
        this.dialog.sendRequest(ct);
    }

    public void processInfo(RequestEvent requestEvent, ServerTransaction serverTransactionId) {
        SipProvider sipProvider = (SipProvider)requestEvent.getSource();
        Request request = requestEvent.getRequest();
        try {
            MAPMessageType mapMessageType;
            System.out.println("SipServerTest: got an INFO sending INFO again");
            ContentTypeHeader contentTypeHeader = (ContentTypeHeader)request.getHeader("Content-Type");
            System.out.println("ContentTypeHeader " + contentTypeHeader);
            if (contentTypeHeader == null) {
                // empty if block
            }
            String contentType = contentTypeHeader.getContentType();
            String contentSubType = contentTypeHeader.getContentSubType();
            if (contentType == null || !contentType.equals(CONTENT_TYPE) || contentSubType == null || contentSubType.equals(CONTENT_SUB_TYPE)) {
                // empty if block
            }
            byte[] content = request.getRawContent();
            System.out.println("Content " + new String(content));
            SipUssdMessage originalMessage = this.eventsSerializeFactory.deserializeSipUssdMessage(content);
            System.out.println("Deserialized SipUssdMessage : " + originalMessage);
            Response response = messageFactory.createResponse(200, request);
            ServerTransaction st = requestEvent.getServerTransaction();
            if (st == null) {
                st = sipProvider.getNewServerTransaction(request);
            }
            this.dialog = st.getDialog();
            st.sendResponse(response);
            AnyExt anyExt = originalMessage.getAnyExt();
            if (anyExt != null && (mapMessageType = anyExt.getMapMessageType()) == MAPMessageType.unstructuredSSNotify_Response) {
                return;
            }
            this.sendUnstructuredSSNotify(requestEvent);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(0);
        }
    }

    public void processBye(Request request, ServerTransaction serverTransactionId) {
        try {
            System.out.println("shootist:  got a bye .");
            if (serverTransactionId == null) {
                System.out.println("shootist:  null TID.");
                return;
            }
            Dialog dialog = serverTransactionId.getDialog();
            System.out.println("Dialog State = " + dialog.getState());
            Response response = messageFactory.createResponse(200, request);
            serverTransactionId.sendResponse(response);
            System.out.println("shootist:  Sending OK.");
            System.out.println("Dialog State = " + dialog.getState());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(0);
        }
    }

    public void processResponse(ResponseEvent responseReceivedEvent) {
        System.out.println("Got a response");
        Response response = responseReceivedEvent.getResponse();
        ClientTransaction tid = responseReceivedEvent.getClientTransaction();
        CSeqHeader cseq = (CSeqHeader)response.getHeader("CSeq");
        System.out.println("Response received : Status Code = " + response.getStatusCode() + " " + cseq);
        if (tid == null) {
            if (this.ackRequest != null && this.dialog != null) {
                System.out.println("re-sending ACK");
                try {
                    this.dialog.sendAck(this.ackRequest);
                }
                catch (SipException se) {
                    se.printStackTrace();
                }
            }
            return;
        }
        if (!this.byeTaskRunning) {
            this.byeTaskRunning = true;
            new Timer().schedule((TimerTask)new ByeTask(this.dialog), 4000L);
        }
        System.out.println("transaction state is " + tid.getState());
        System.out.println("Dialog = " + tid.getDialog());
        System.out.println("Dialog State is " + tid.getDialog().getState());
        try {
            if (response.getStatusCode() == 200) {
                if (cseq.getMethod().equals("INVITE")) {
                    System.out.println("Dialog after 200 OK  " + this.dialog);
                    System.out.println("Dialog State after 200 OK  " + this.dialog.getState());
                    this.ackRequest = this.dialog.createAck(((CSeqHeader)response.getHeader("CSeq")).getSeqNumber());
                    System.out.println("Sending ACK");
                    this.dialog.sendAck(this.ackRequest);
                } else if (cseq.getMethod().equals("CANCEL") && this.dialog.getState() == DialogState.CONFIRMED) {
                    System.out.println("Sending BYE -- cancel went in too late !!");
                    Request byeRequest = this.dialog.createRequest("BYE");
                    ClientTransaction ct = sipProvider.getNewClientTransaction(byeRequest);
                    this.dialog.sendRequest(ct);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(0);
        }
    }

    public void processTimeout(TimeoutEvent timeoutEvent) {
        System.out.println("Transaction Time out");
    }

    public void sendCancel() {
        try {
            System.out.println("Sending cancel");
            Request cancelRequest = this.inviteTid.createCancel();
            ClientTransaction cancelTid = sipProvider.getNewClientTransaction(cancelRequest);
            cancelTid.sendRequest();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void init() {
        this.eventsSerializeFactory = new EventsSerializeFactory();
        SipFactory sipFactory = null;
        sipStack = null;
        sipFactory = SipFactory.getInstance();
        sipFactory.setPathName("gov.nist");
        Properties properties = new Properties();
        properties.setProperty("javax.sip.OUTBOUND_PROXY", this.peerHostPort + "/" + this.transport);
        properties.setProperty("javax.sip.STACK_NAME", "shootist");
        properties.setProperty("gov.nist.javax.sip.DEBUG_LOG", "shootistdebug.txt");
        properties.setProperty("gov.nist.javax.sip.SERVER_LOG", "shootistlog.txt");
        properties.setProperty("gov.nist.javax.sip.CACHE_CLIENT_CONNECTIONS", "false");
        properties.setProperty("gov.nist.javax.sip.TRACE_LEVEL", "DEBUG");
        try {
            sipStack = sipFactory.createSipStack(properties);
            System.out.println("createSipStack " + sipStack);
        }
        catch (PeerUnavailableException e) {
            e.printStackTrace();
            System.err.println(e.getMessage());
            System.exit(0);
        }
        try {
            headerFactory = sipFactory.createHeaderFactory();
            addressFactory = sipFactory.createAddressFactory();
            messageFactory = sipFactory.createMessageFactory();
            this.udpListeningPoint = sipStack.createListeningPoint("127.0.0.1", 5070, this.transport);
            System.out.println("listeningPoint = " + this.udpListeningPoint);
            sipProvider = sipStack.createSipProvider(this.udpListeningPoint);
            System.out.println("SipProvider = " + sipProvider);
            SipServerTest listener = this;
            sipProvider.addSipListener((SipListener)listener);
            SipURI fromAddress = addressFactory.createSipURI(this.fromName, this.fromSipAddress);
            Address fromNameAddress = addressFactory.createAddress((URI)fromAddress);
            fromNameAddress.setDisplayName(this.fromDisplayName);
            FromHeader fromHeader = headerFactory.createFromHeader(fromNameAddress, "12345");
            SipURI toAddress = addressFactory.createSipURI(this.toUser, this.toSipAddress);
            Address toNameAddress = addressFactory.createAddress((URI)toAddress);
            toNameAddress.setDisplayName(this.toDisplayName);
            ToHeader toHeader = headerFactory.createToHeader(toNameAddress, null);
            SipURI requestURI = addressFactory.createSipURI(this.toUser, this.peerHostPort);
            ArrayList<ViaHeader> viaHeaders = new ArrayList<ViaHeader>();
            String ipAddress = this.udpListeningPoint.getIPAddress();
            ViaHeader viaHeader = headerFactory.createViaHeader(ipAddress, sipProvider.getListeningPoint(this.transport).getPort(), this.transport, null);
            viaHeaders.add(viaHeader);
            ContentTypeHeader contentTypeHeader = headerFactory.createContentTypeHeader(CONTENT_TYPE, CONTENT_SUB_TYPE);
            CallIdHeader callIdHeader = sipProvider.getNewCallId();
            CSeqHeader cSeqHeader = headerFactory.createCSeqHeader(1L, "INVITE");
            MaxForwardsHeader maxForwards = headerFactory.createMaxForwardsHeader(70);
            Request request = messageFactory.createRequest((URI)requestURI, "INVITE", callIdHeader, cSeqHeader, fromHeader, toHeader, viaHeaders, maxForwards);
            String host = "127.0.0.1";
            SipURI contactUrl = addressFactory.createSipURI(this.fromName, host);
            contactUrl.setPort(this.udpListeningPoint.getPort());
            contactUrl.setLrParam();
            SipURI contactURI = addressFactory.createSipURI(this.fromName, host);
            contactURI.setPort(sipProvider.getListeningPoint(this.transport).getPort());
            Address contactAddress = addressFactory.createAddress((URI)contactURI);
            contactAddress.setDisplayName(this.fromName);
            this.contactHeader = headerFactory.createContactHeader(contactAddress);
            request.addHeader((Header)this.contactHeader);
            SipUssdMessage simMsg = new SipUssdMessage("Press 1 for SMS and 2 for Call", "en");
            byte[] data = this.eventsSerializeFactory.serializeSipUssdMessage(simMsg);
            String content = new String(data);
            byte[] contents = content.getBytes();
            request.setContent((Object)contents, contentTypeHeader);
            Header callInfoHeader = headerFactory.createHeader("Call-Info", "<http://www.antd.nist.gov>");
            request.addHeader(callInfoHeader);
            this.inviteTid = sipProvider.getNewClientTransaction(request);
            System.out.println("inviteTid = " + this.inviteTid);
            this.inviteTid.sendRequest();
            this.dialog = this.inviteTid.getDialog();
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
            ex.printStackTrace();
        }
    }

    public void processIOException(IOExceptionEvent exceptionEvent) {
        System.out.println("IOException happened for " + exceptionEvent.getHost() + " port = " + exceptionEvent.getPort());
    }

    public void processTransactionTerminated(TransactionTerminatedEvent transactionTerminatedEvent) {
        System.out.println("Transaction terminated event recieved");
    }

    public void processDialogTerminated(DialogTerminatedEvent dialogTerminatedEvent) {
        System.out.println("dialogTerminatedEvent");
    }

    class ByeTask
    extends TimerTask {
        Dialog dialog;

        public ByeTask(Dialog dialog) {
            this.dialog = dialog;
        }

        public void run() {
            try {
                Request byeRequest = this.dialog.createRequest("BYE");
                ClientTransaction ct = sipProvider.getNewClientTransaction(byeRequest);
                this.dialog.sendRequest(ct);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                System.exit(0);
            }
        }
    }
}

