/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.applications.ussd.examples.sip;

import java.text.ParseException;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import javax.sip.ClientTransaction;
import javax.sip.Dialog;
import javax.sip.DialogState;
import javax.sip.DialogTerminatedEvent;
import javax.sip.IOExceptionEvent;
import javax.sip.InvalidArgumentException;
import javax.sip.ListeningPoint;
import javax.sip.PeerUnavailableException;
import javax.sip.RequestEvent;
import javax.sip.ResponseEvent;
import javax.sip.ServerTransaction;
import javax.sip.SipException;
import javax.sip.SipFactory;
import javax.sip.SipListener;
import javax.sip.SipProvider;
import javax.sip.SipStack;
import javax.sip.TimeoutEvent;
import javax.sip.TransactionState;
import javax.sip.TransactionTerminatedEvent;
import javax.sip.address.Address;
import javax.sip.address.AddressFactory;
import javax.sip.header.ContactHeader;
import javax.sip.header.ContentLengthHeader;
import javax.sip.header.ContentTypeHeader;
import javax.sip.header.Header;
import javax.sip.header.HeaderFactory;
import javax.sip.header.ToHeader;
import javax.sip.message.MessageFactory;
import javax.sip.message.Request;
import javax.sip.message.Response;
import org.apache.log4j.Logger;
import org.mobicents.ussdgateway.EventsSerializeFactory;
import org.mobicents.ussdgateway.SipUssdMessage;

public class SipClientTest
implements SipListener {
    private final Logger logger = Logger.getLogger((String)SipClientTest.class.getName());
    private static final String CONTENT_TYPE = "application";
    private static final String CONTENT_SUB_TYPE = "vnd.3gpp.ussd+xml";
    private static AddressFactory addressFactory;
    private static MessageFactory messageFactory;
    private static HeaderFactory headerFactory;
    private static SipStack sipStack;
    private static final String myAddress = "127.0.0.1";
    private static final int myPort = 5065;
    protected ServerTransaction inviteTid;
    private Response okResponse;
    private Request inviteRequest;
    private Dialog dialog;
    public static final boolean callerSendsBye = true;
    private volatile int requestSentCout = 0;
    private EventsSerializeFactory eventsSerializeFactory;
    protected static final String usageString = "java examples.shootist.Shootist \n>>>> is your class path set to the root?";

    private static void usage() {
        System.out.println(usageString);
        System.exit(0);
    }

    public void processRequest(RequestEvent requestEvent) {
        Request request = requestEvent.getRequest();
        ServerTransaction serverTransactionId = requestEvent.getServerTransaction();
        System.out.println("\n\nRequest " + request.getMethod() + " received at " + sipStack.getStackName() + " with server transaction id " + serverTransactionId);
        if (request.getMethod().equals("INVITE")) {
            this.processInvite(requestEvent, serverTransactionId);
        } else if (request.getMethod().equals("ACK")) {
            this.processAck(requestEvent, serverTransactionId);
        } else if (request.getMethod().equals("INFO")) {
            this.processInfo(requestEvent, serverTransactionId);
        } else if (request.getMethod().equals("BYE")) {
            this.processBye(requestEvent, serverTransactionId);
        } else if (request.getMethod().equals("CANCEL")) {
            this.processCancel(requestEvent, serverTransactionId);
        } else {
            try {
                serverTransactionId.sendResponse(messageFactory.createResponse(202, request));
                SipProvider prov = (SipProvider)requestEvent.getSource();
                Request refer = requestEvent.getDialog().createRequest("REFER");
                requestEvent.getDialog().sendRequest(prov.getNewClientTransaction(refer));
            }
            catch (SipException e) {
                e.printStackTrace();
            }
            catch (InvalidArgumentException e) {
                e.printStackTrace();
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
    }

    public void processResponse(ResponseEvent responseEvent) {
    }

    public void processAck(RequestEvent requestEvent, ServerTransaction serverTransaction) {
        try {
            System.out.println("shootme: got an ACK! ");
            System.out.println("Dialog State = " + this.dialog.getState());
            SipProvider provider = (SipProvider)requestEvent.getSource();
            if (this.requestSentCout == 0) {
                this.sendUnstructuredSSRequest(requestEvent);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void sendUnstructuredSSRequest(RequestEvent requestEvent) throws Exception {
        ++this.requestSentCout;
        SipUssdMessage simMsg = new SipUssdMessage("Press 1 to know your airtime and 2 to know your SMS balance", "en");
        byte[] rawContent = this.eventsSerializeFactory.serializeSipUssdMessage(simMsg);
        String content = new String(rawContent);
        SipProvider provider = (SipProvider)requestEvent.getSource();
        Request infoRequest = this.dialog.createRequest("INFO");
        ContentTypeHeader contentTypeHeader = headerFactory.createContentTypeHeader(CONTENT_TYPE, CONTENT_SUB_TYPE);
        infoRequest.setContent((Object)content, contentTypeHeader);
        ContentLengthHeader contentLengthHeader = headerFactory.createContentLengthHeader(content.length());
        infoRequest.setContentLength(contentLengthHeader);
        ClientTransaction ct = provider.getNewClientTransaction(infoRequest);
        this.dialog.sendRequest(ct);
    }

    public void processInfo(RequestEvent requestEvent, ServerTransaction serverTransaction) {
        SipProvider sipProvider = (SipProvider)requestEvent.getSource();
        Request request = requestEvent.getRequest();
        this.requestSentCout = 0;
        try {
            System.out.println("shootme: got an INFO Send BYE");
            ServerTransaction serverTransactionId = requestEvent.getServerTransaction();
            Response response = messageFactory.createResponse(200, request);
            serverTransactionId.sendResponse(response);
            ContentTypeHeader contentTypeHeader = (ContentTypeHeader)request.getHeader("Content-Type");
            System.out.println("ContentTypeHeader " + contentTypeHeader);
            if (contentTypeHeader == null) {
                // empty if block
            }
            String contentType = contentTypeHeader.getContentType();
            String contentSubType = contentTypeHeader.getContentSubType();
            if (contentType == null || !contentType.equals(CONTENT_TYPE) || contentSubType == null || contentSubType.equals(CONTENT_SUB_TYPE)) {
                // empty if block
            }
            byte[] rawContent = request.getRawContent();
            System.out.println("Content " + new String(rawContent));
            SipUssdMessage originalMessage = this.eventsSerializeFactory.deserializeSipUssdMessage(rawContent);
            System.out.println("Deserialized SipUssdMessage : " + originalMessage);
            SipUssdMessage simMsg = new SipUssdMessage("Thank You!", "en");
            rawContent = this.eventsSerializeFactory.serializeSipUssdMessage(simMsg);
            String content = new String(rawContent);
            Request byeRequest = this.dialog.createRequest("BYE");
            contentTypeHeader = headerFactory.createContentTypeHeader(CONTENT_TYPE, CONTENT_SUB_TYPE);
            byeRequest.setContent((Object)content, contentTypeHeader);
            ContentLengthHeader contentLengthHeader = headerFactory.createContentLengthHeader(content.length());
            byeRequest.setContentLength(contentLengthHeader);
            ClientTransaction ct = sipProvider.getNewClientTransaction(byeRequest);
            this.dialog.sendRequest(ct);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(0);
        }
    }

    public void processInvite(RequestEvent requestEvent, ServerTransaction serverTransaction) {
        this.requestSentCout = 0;
        SipProvider sipProvider = (SipProvider)requestEvent.getSource();
        Request request = requestEvent.getRequest();
        try {
            System.out.println("shootme: got an Invite sending Trying");
            ContentTypeHeader contentTypeHeader = (ContentTypeHeader)request.getHeader("Content-Type");
            System.out.println("ContentTypeHeader " + contentTypeHeader);
            if (contentTypeHeader == null) {
                // empty if block
            }
            String contentType = contentTypeHeader.getContentType();
            String contentSubType = contentTypeHeader.getContentSubType();
            if (contentType == null || !contentType.equals(CONTENT_TYPE) || contentSubType == null || contentSubType.equals(CONTENT_SUB_TYPE)) {
                // empty if block
            }
            byte[] content = request.getRawContent();
            System.out.println("Content " + new String(content));
            SipUssdMessage originalMessage = this.eventsSerializeFactory.deserializeSipUssdMessage(content);
            System.out.println("Deserialized SipUssdMessage : " + originalMessage);
            Response response = messageFactory.createResponse(180, request);
            ServerTransaction st = requestEvent.getServerTransaction();
            if (st == null) {
                st = sipProvider.getNewServerTransaction(request);
            }
            this.dialog = st.getDialog();
            st.sendResponse(response);
            this.okResponse = messageFactory.createResponse(200, request);
            Address address = addressFactory.createAddress("Shootme <sip:127.0.0.1:5065>");
            ContactHeader contactHeader = headerFactory.createContactHeader(address);
            response.addHeader((Header)contactHeader);
            ToHeader toHeader = (ToHeader)this.okResponse.getHeader("To");
            toHeader.setTag("4321");
            this.okResponse.addHeader((Header)contactHeader);
            this.inviteTid = st;
            this.inviteRequest = request;
            new Timer().schedule((TimerTask)new MyTimerTask(this), 1000L);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(0);
        }
    }

    private void sendInviteOK() {
        try {
            if (this.inviteTid.getState() != TransactionState.COMPLETED) {
                System.out.println("shootme: Dialog state before 200: " + this.inviteTid.getDialog().getState());
                this.inviteTid.sendResponse(this.okResponse);
                System.out.println("shootme: Dialog state after 200: " + this.inviteTid.getDialog().getState());
            }
        }
        catch (SipException ex) {
            ex.printStackTrace();
        }
        catch (InvalidArgumentException ex) {
            ex.printStackTrace();
        }
    }

    public void processBye(RequestEvent requestEvent, ServerTransaction serverTransactionId) {
        this.requestSentCout = 0;
        SipProvider sipProvider = (SipProvider)requestEvent.getSource();
        Request request = requestEvent.getRequest();
        Dialog dialog = requestEvent.getDialog();
        System.out.println("local party = " + dialog.getLocalParty());
        try {
            System.out.println("shootme:  got a bye sending OK.");
            Response response = messageFactory.createResponse(200, request);
            serverTransactionId.sendResponse(response);
            System.out.println("Dialog State is " + serverTransactionId.getDialog().getState());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(0);
        }
    }

    public void processCancel(RequestEvent requestEvent, ServerTransaction serverTransactionId) {
        SipProvider sipProvider = (SipProvider)requestEvent.getSource();
        Request request = requestEvent.getRequest();
        try {
            System.out.println("shootme:  got a cancel.");
            if (serverTransactionId == null) {
                System.out.println("shootme:  null tid.");
                return;
            }
            Response response = messageFactory.createResponse(200, request);
            serverTransactionId.sendResponse(response);
            if (this.dialog.getState() != DialogState.CONFIRMED) {
                response = messageFactory.createResponse(487, this.inviteRequest);
                this.inviteTid.sendResponse(response);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(0);
        }
    }

    public void processTimeout(TimeoutEvent timeoutEvent) {
        Object transaction = timeoutEvent.isServerTransaction() ? timeoutEvent.getServerTransaction() : timeoutEvent.getClientTransaction();
        System.out.println("state = " + transaction.getState());
        System.out.println("dialog = " + transaction.getDialog());
        System.out.println("dialogState = " + transaction.getDialog().getState());
        System.out.println("Transaction Time out");
    }

    public void init() {
        this.eventsSerializeFactory = new EventsSerializeFactory();
        SipFactory sipFactory = null;
        sipStack = null;
        sipFactory = SipFactory.getInstance();
        sipFactory.setPathName("gov.nist");
        Properties properties = new Properties();
        properties.setProperty("javax.sip.STACK_NAME", "shootme");
        properties.setProperty("gov.nist.javax.sip.TRACE_LEVEL", "LOG4J");
        properties.setProperty("gov.nist.javax.sip.DEBUG_LOG", "shootmedebug.txt");
        properties.setProperty("gov.nist.javax.sip.SERVER_LOG", "shootmelog.txt");
        try {
            sipStack = sipFactory.createSipStack(properties);
            System.out.println("sipStack = " + sipStack);
        }
        catch (PeerUnavailableException e) {
            e.printStackTrace();
            System.err.println(e.getMessage());
            if (e.getCause() != null) {
                e.getCause().printStackTrace();
            }
            System.exit(0);
        }
        try {
            headerFactory = sipFactory.createHeaderFactory();
            addressFactory = sipFactory.createAddressFactory();
            messageFactory = sipFactory.createMessageFactory();
            ListeningPoint lp = sipStack.createListeningPoint(myAddress, 5065, "udp");
            SipClientTest listener = this;
            SipProvider sipProvider = sipStack.createSipProvider(lp);
            System.out.println("udp provider " + sipProvider);
            sipProvider.addSipListener((SipListener)listener);
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
            ex.printStackTrace();
            SipClientTest.usage();
        }
    }

    public static void main(String[] args) {
        new SipClientTest().init();
    }

    public void processIOException(IOExceptionEvent exceptionEvent) {
        System.out.println("IOException");
    }

    public void processTransactionTerminated(TransactionTerminatedEvent transactionTerminatedEvent) {
        if (transactionTerminatedEvent.isServerTransaction()) {
            System.out.println("Transaction terminated event recieved" + transactionTerminatedEvent.getServerTransaction());
        } else {
            System.out.println("Transaction terminated " + transactionTerminatedEvent.getClientTransaction());
        }
    }

    public void processDialogTerminated(DialogTerminatedEvent dialogTerminatedEvent) {
        System.out.println("Dialog terminated event recieved");
        Dialog d = dialogTerminatedEvent.getDialog();
        System.out.println("Local Party = " + d.getLocalParty());
    }

    class MyTimerTask
    extends TimerTask {
        SipClientTest shootme;

        public MyTimerTask(SipClientTest shootme) {
            this.shootme = shootme;
        }

        public void run() {
            this.shootme.sendInviteOK();
        }
    }
}

