/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.ussd.server.bootstrap;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.log4j.Logger;

public class Configuration {
    private static final String HEADER = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n <deployment xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"urn:jboss:bean-deployer:2.0 bean-deployer_2_0.xsd\" xmlns=\"urn:jboss:bean-deployer:2.0\">\n";
    private static final String FOOTER = "</deployment>";
    private File file;
    private File directory;
    private boolean isDirectory;
    private long lastModified;
    private Logger logger = Logger.getLogger(Configuration.class);

    public Configuration(String s, File directory) {
        this.directory = directory;
    }

    public String getBeans() throws IOException {
        File[] files;
        String config = "";
        for (File file : files = this.directory.listFiles()) {
            if (!file.isDirectory()) {
                this.logger.info((Object)("Configuring " + file));
                String description = this.read(file);
                int p1 = description.indexOf("<xml");
                int p2 = description.indexOf(62, p1);
                description = description.substring(p2 + 1);
                p1 = description.indexOf("<deployment");
                p2 = description.indexOf(62, p1);
                description = description.substring(p2 + 1);
                description = description.replaceFirst(FOOTER, "");
                config = config + "\n" + description;
                continue;
            }
            this.logger.info((Object)("Reading directory " + file));
            Configuration conf = new Configuration("", file);
            config = config + conf.getBeans();
        }
        return config;
    }

    public URL getConfig() throws IOException {
        String s = HEADER + this.getBeans() + FOOTER;
        File tempDir = new File(this.directory.getParent() + File.separator + "temp");
        tempDir.mkdir();
        String temp = tempDir.getPath() + File.separator + "deployment-beans.xml";
        FileOutputStream fout = new FileOutputStream(temp, false);
        fout.write(s.getBytes());
        fout.flush();
        fout.close();
        File deployment = new File(temp);
        return deployment.toURI().toURL();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String read(File file) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        FileInputStream fin = null;
        try {
            fin = new FileInputStream(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        try {
            int b = -1;
            while ((b = fin.read()) != -1) {
                bout.write(b);
            }
        }
        finally {
            fin.close();
        }
        return new String(bout.toByteArray());
    }

    public Configuration(File file) {
        this.file = file;
        this.isDirectory = file.isDirectory();
        this.lastModified = file.lastModified();
    }

    public boolean isDirectory() {
        return this.isDirectory;
    }

    public URL getURL() {
        try {
            return this.file.toURI().toURL();
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public long lastModified() {
        return this.lastModified;
    }

    public void update(long lastModified) {
        this.lastModified = lastModified;
    }
}

