/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.ussd.server.bootstrap;

import java.io.File;
import java.io.FileFilter;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileFilterImpl
implements FileFilter {
    private static Set<String> fileSuffixes = new CopyOnWriteArraySet<String>();

    public FileFilterImpl() {
    }

    public FileFilterImpl(Set<String> suffixes) {
        if (suffixes == null) {
            throw new IllegalArgumentException("Null suffixes");
        }
        fileSuffixes.clear();
        fileSuffixes.addAll(suffixes);
    }

    @Override
    public boolean accept(File pathname) {
        for (String suffix : fileSuffixes) {
            String filePathName = pathname.getName();
            if (!filePathName.endsWith(suffix)) continue;
            return true;
        }
        return false;
    }

    public Set<String> getSuffixes() {
        return fileSuffixes;
    }

    public static boolean addFileSuffix(String suffix) {
        if (suffix == null) {
            throw new IllegalArgumentException("Null suffix");
        }
        return fileSuffixes.add(suffix);
    }

    public static boolean removeFileSuffix(String suffix) {
        if (suffix == null) {
            throw new IllegalArgumentException("Null suffix");
        }
        return fileSuffixes.remove(suffix);
    }

    static {
        fileSuffixes.add("-beans.xml");
        fileSuffixes.add("-conf.xml");
    }
}

