/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.ussd.ihub;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.log4j.Logger;
import org.mobicents.protocols.ss7.map.api.MAPDialog;
import org.mobicents.protocols.ss7.map.api.MAPDialogListener;
import org.mobicents.protocols.ss7.map.api.MAPException;
import org.mobicents.protocols.ss7.map.api.MAPMessage;
import org.mobicents.protocols.ss7.map.api.datacoding.CBSDataCodingScheme;
import org.mobicents.protocols.ss7.map.api.dialog.MAPAbortProviderReason;
import org.mobicents.protocols.ss7.map.api.dialog.MAPAbortSource;
import org.mobicents.protocols.ss7.map.api.dialog.MAPNoticeProblemDiagnostic;
import org.mobicents.protocols.ss7.map.api.dialog.MAPRefuseReason;
import org.mobicents.protocols.ss7.map.api.dialog.MAPUserAbortChoice;
import org.mobicents.protocols.ss7.map.api.errors.AbsentSubscriberDiagnosticSM;
import org.mobicents.protocols.ss7.map.api.errors.MAPErrorMessage;
import org.mobicents.protocols.ss7.map.api.errors.MAPErrorMessageAbsentSubscriberSM;
import org.mobicents.protocols.ss7.map.api.errors.MAPErrorMessageFactory;
import org.mobicents.protocols.ss7.map.api.primitives.AddressNature;
import org.mobicents.protocols.ss7.map.api.primitives.AddressString;
import org.mobicents.protocols.ss7.map.api.primitives.IMSI;
import org.mobicents.protocols.ss7.map.api.primitives.ISDNAddressString;
import org.mobicents.protocols.ss7.map.api.primitives.MAPExtensionContainer;
import org.mobicents.protocols.ss7.map.api.primitives.NumberingPlan;
import org.mobicents.protocols.ss7.map.api.primitives.USSDString;
import org.mobicents.protocols.ss7.map.api.service.sms.AlertServiceCentreRequest;
import org.mobicents.protocols.ss7.map.api.service.sms.AlertServiceCentreResponse;
import org.mobicents.protocols.ss7.map.api.service.sms.ForwardShortMessageRequest;
import org.mobicents.protocols.ss7.map.api.service.sms.ForwardShortMessageResponse;
import org.mobicents.protocols.ss7.map.api.service.sms.InformServiceCentreRequest;
import org.mobicents.protocols.ss7.map.api.service.sms.LocationInfoWithLMSI;
import org.mobicents.protocols.ss7.map.api.service.sms.MAPDialogSms;
import org.mobicents.protocols.ss7.map.api.service.sms.MAPServiceSmsListener;
import org.mobicents.protocols.ss7.map.api.service.sms.MoForwardShortMessageRequest;
import org.mobicents.protocols.ss7.map.api.service.sms.MoForwardShortMessageResponse;
import org.mobicents.protocols.ss7.map.api.service.sms.MtForwardShortMessageRequest;
import org.mobicents.protocols.ss7.map.api.service.sms.MtForwardShortMessageResponse;
import org.mobicents.protocols.ss7.map.api.service.sms.NoteSubscriberPresentRequest;
import org.mobicents.protocols.ss7.map.api.service.sms.ReadyForSMRequest;
import org.mobicents.protocols.ss7.map.api.service.sms.ReadyForSMResponse;
import org.mobicents.protocols.ss7.map.api.service.sms.ReportSMDeliveryStatusRequest;
import org.mobicents.protocols.ss7.map.api.service.sms.ReportSMDeliveryStatusResponse;
import org.mobicents.protocols.ss7.map.api.service.sms.SendRoutingInfoForSMRequest;
import org.mobicents.protocols.ss7.map.api.service.sms.SendRoutingInfoForSMResponse;
import org.mobicents.protocols.ss7.map.api.service.sms.SmsSignalInfo;
import org.mobicents.protocols.ss7.map.api.service.supplementary.ActivateSSRequest;
import org.mobicents.protocols.ss7.map.api.service.supplementary.ActivateSSResponse;
import org.mobicents.protocols.ss7.map.api.service.supplementary.DeactivateSSRequest;
import org.mobicents.protocols.ss7.map.api.service.supplementary.DeactivateSSResponse;
import org.mobicents.protocols.ss7.map.api.service.supplementary.EraseSSRequest;
import org.mobicents.protocols.ss7.map.api.service.supplementary.EraseSSResponse;
import org.mobicents.protocols.ss7.map.api.service.supplementary.GetPasswordRequest;
import org.mobicents.protocols.ss7.map.api.service.supplementary.GetPasswordResponse;
import org.mobicents.protocols.ss7.map.api.service.supplementary.InterrogateSSRequest;
import org.mobicents.protocols.ss7.map.api.service.supplementary.InterrogateSSResponse;
import org.mobicents.protocols.ss7.map.api.service.supplementary.MAPDialogSupplementary;
import org.mobicents.protocols.ss7.map.api.service.supplementary.MAPServiceSupplementaryListener;
import org.mobicents.protocols.ss7.map.api.service.supplementary.ProcessUnstructuredSSRequest;
import org.mobicents.protocols.ss7.map.api.service.supplementary.ProcessUnstructuredSSResponse;
import org.mobicents.protocols.ss7.map.api.service.supplementary.RegisterPasswordRequest;
import org.mobicents.protocols.ss7.map.api.service.supplementary.RegisterPasswordResponse;
import org.mobicents.protocols.ss7.map.api.service.supplementary.RegisterSSRequest;
import org.mobicents.protocols.ss7.map.api.service.supplementary.RegisterSSResponse;
import org.mobicents.protocols.ss7.map.api.service.supplementary.UnstructuredSSNotifyRequest;
import org.mobicents.protocols.ss7.map.api.service.supplementary.UnstructuredSSNotifyResponse;
import org.mobicents.protocols.ss7.map.api.service.supplementary.UnstructuredSSRequest;
import org.mobicents.protocols.ss7.map.api.service.supplementary.UnstructuredSSResponse;
import org.mobicents.protocols.ss7.map.api.smstpdu.AddressField;
import org.mobicents.protocols.ss7.map.api.smstpdu.SmsSubmitTpdu;
import org.mobicents.protocols.ss7.map.api.smstpdu.SmsTpdu;
import org.mobicents.protocols.ss7.map.api.smstpdu.SmsTpduType;
import org.mobicents.protocols.ss7.map.datacoding.CBSDataCodingSchemeImpl;
import org.mobicents.protocols.ss7.map.primitives.IMSIImpl;
import org.mobicents.protocols.ss7.map.primitives.ISDNAddressStringImpl;
import org.mobicents.protocols.ss7.map.primitives.USSDStringImpl;
import org.mobicents.protocols.ss7.map.service.sms.LocationInfoWithLMSIImpl;
import org.mobicents.protocols.ss7.map.service.supplementary.UnstructuredSSRequestImpl;
import org.mobicents.protocols.ss7.tcap.asn.ApplicationContextName;
import org.mobicents.protocols.ss7.tcap.asn.comp.Problem;
import org.mobicents.ussd.ihub.MAPSimulator;

public class MAPListener
implements MAPDialogListener,
MAPServiceSmsListener,
MAPServiceSupplementaryListener {
    private static final Logger logger = Logger.getLogger(MAPListener.class);
    private MAPSimulator iHubManagement = null;
    private final AtomicLong mapMessagesReceivedCounter = new AtomicLong(0L);
    private long currentMapMessageCount = 0L;
    private final MAPErrorMessageFactory mAPErrorMessageFactory;
    private long processUnstSSReqInvokeId = 0L;

    protected MAPListener(MAPSimulator iHubManagement) {
        this.iHubManagement = iHubManagement;
        this.mAPErrorMessageFactory = this.iHubManagement.getMapProvider().getMAPErrorMessageFactory();
    }

    public void onDialogAccept(MAPDialog arg0, MAPExtensionContainer arg1) {
        logger.info((Object)("onDialogAccept " + arg0));
    }

    public void onDialogClose(MAPDialog arg0) {
        logger.info((Object)("onDialogClose " + arg0));
    }

    public void onDialogDelimiter(MAPDialog arg0) {
        logger.info((Object)("onDialogDelimiter " + arg0));
    }

    public void onDialogNotice(MAPDialog arg0, MAPNoticeProblemDiagnostic arg1) {
        logger.warn((Object)("onDialogNotice " + arg0));
    }

    public void onDialogProviderAbort(MAPDialog arg0, MAPAbortProviderReason arg1, MAPAbortSource arg2, MAPExtensionContainer arg3) {
        logger.error((Object)("onDialogProviderAbort " + arg0));
    }

    public void onDialogReject(MAPDialog mapDialog, MAPRefuseReason refuseReason, ApplicationContextName alternativeApplicationContext, MAPExtensionContainer extensionContainer) {
        logger.error((Object)("onDialogReject " + mapDialog));
    }

    public void onDialogRelease(MAPDialog arg0) {
        logger.info((Object)("onDialogRelease " + arg0));
    }

    public void onDialogRequest(MAPDialog arg0, AddressString arg1, AddressString arg2, MAPExtensionContainer arg3) {
        logger.info((Object)("onDialogRequest " + arg0));
        this.currentMapMessageCount = this.mapMessagesReceivedCounter.incrementAndGet();
    }

    public void onDialogRequestEricsson(MAPDialog arg0, AddressString arg1, AddressString arg2, AddressString arg3, AddressString arg4) {
        logger.info((Object)("onDialogRequestEricsson " + arg0));
    }

    public void onDialogTimeout(MAPDialog arg0) {
        logger.error((Object)("onDialogTimeout " + arg0));
    }

    public void onDialogUserAbort(MAPDialog arg0, MAPUserAbortChoice arg1, MAPExtensionContainer arg2) {
        logger.error((Object)("onDialogUserAbort " + arg0));
    }

    public void onErrorComponent(MAPDialog arg0, Long arg1, MAPErrorMessage arg2) {
        logger.error((Object)("onErrorComponent " + arg0));
    }

    public void onInvokeTimeout(MAPDialog arg0, Long arg1) {
        logger.error((Object)("onInvokeTimeout " + arg0));
    }

    public void onMAPMessage(MAPMessage arg0) {
    }

    public void onRejectComponent(MAPDialog arg0, Long arg1, Problem arg2, boolean isLocalOriginated) {
        logger.error((Object)("onRejectComponent " + arg0));
    }

    public void onAlertServiceCentreRequest(AlertServiceCentreRequest arg0) {
        logger.info((Object)("onAlertServiceCentreRequest " + arg0));
    }

    public void onAlertServiceCentreResponse(AlertServiceCentreResponse arg0) {
        logger.info((Object)("onAlertServiceCentreResponse " + arg0));
    }

    public void onForwardShortMessageRequest(ForwardShortMessageRequest event) {
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Rx : onForwardShortMessageRequest=" + event));
        }
        MAPDialogSms mapDialogSms = event.getMAPDialog();
        if (this.currentMapMessageCount % 7L == 0L) {
            try {
                MAPErrorMessageAbsentSubscriberSM mapErrorMessage = this.mAPErrorMessageFactory.createMAPErrorMessageAbsentSubscriberSM(AbsentSubscriberDiagnosticSM.IMSIDetached, null, null);
                mapDialogSms.sendErrorComponent(Long.valueOf(event.getInvokeId()), (MAPErrorMessage)mapErrorMessage);
                mapDialogSms.close(false);
            }
            catch (MAPException e) {
                logger.error((Object)"Error while sending MAPErrorMessageAbsentSubscriberSM ", (Throwable)e);
            }
        } else {
            try {
                mapDialogSms.addForwardShortMessageResponse(event.getInvokeId());
                mapDialogSms.close(false);
            }
            catch (MAPException e) {
                e.printStackTrace();
            }
        }
    }

    public void onForwardShortMessageResponse(ForwardShortMessageResponse arg0) {
        logger.info((Object)("onForwardShortMessageResponse " + arg0));
    }

    public void onInformServiceCentreRequest(InformServiceCentreRequest arg0) {
        logger.info((Object)("onInformServiceCentreRequest " + arg0));
    }

    public void onMoForwardShortMessageRequest(MoForwardShortMessageRequest request) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Rx : MoForwardShortMessageRequestIndication=" + request));
        }
        MAPDialogSms dialog = request.getMAPDialog();
        try {
            dialog.addMoForwardShortMessageResponse(request.getInvokeId(), null, null);
            dialog.close(false);
        }
        catch (MAPException e) {
            logger.error((Object)"Error while sending MoForwardShortMessageResponse ", (Throwable)e);
        }
        try {
            SmsSignalInfo smsSignalInfo = request.getSM_RP_UI();
            SmsTpdu smsTpdu = smsSignalInfo.decodeTpdu(true);
            if (smsTpdu.getSmsTpduType() != SmsTpduType.SMS_SUBMIT) {
                logger.error((Object)("Rx : MoForwardShortMessageRequestIndication, but SmsTpduType is not SMS_SUBMIT. SmsTpdu=" + smsTpdu));
                return;
            }
            SmsSubmitTpdu smsSubmitTpdu = (SmsSubmitTpdu)smsTpdu;
            AddressField destinationAddress = smsSubmitTpdu.getDestinationAddress();
        }
        catch (MAPException e1) {
            logger.error((Object)"Error while decoding SmsSignalInfo ", (Throwable)e1);
        }
    }

    public void onMoForwardShortMessageResponse(MoForwardShortMessageResponse arg0) {
        logger.info((Object)("onMoForwardShortMessageResponse " + arg0));
    }

    public void onMtForwardShortMessageRequest(MtForwardShortMessageRequest event) {
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Rx : onMtForwardShortMessageIndication=" + event));
        }
        MAPDialogSms mapDialogSms = event.getMAPDialog();
        if (this.currentMapMessageCount % 7L == 0L) {
            try {
                MAPErrorMessageAbsentSubscriberSM mapErrorMessage = this.mAPErrorMessageFactory.createMAPErrorMessageAbsentSubscriberSM(AbsentSubscriberDiagnosticSM.IMSIDetached, null, null);
                mapDialogSms.sendErrorComponent(Long.valueOf(event.getInvokeId()), (MAPErrorMessage)mapErrorMessage);
                mapDialogSms.close(false);
            }
            catch (MAPException e) {
                logger.error((Object)"Error while sending MAPErrorMessageAbsentSubscriberSM ", (Throwable)e);
            }
        } else {
            try {
                mapDialogSms.addMtForwardShortMessageResponse(event.getInvokeId(), null, null);
                mapDialogSms.close(false);
            }
            catch (MAPException e) {
                e.printStackTrace();
            }
        }
    }

    public void onMtForwardShortMessageResponse(MtForwardShortMessageResponse arg0) {
        logger.info((Object)("onMtForwardShortMessageResponse " + arg0));
    }

    public void onReportSMDeliveryStatusRequest(ReportSMDeliveryStatusRequest arg0) {
        logger.info((Object)("onReportSMDeliveryStatusRequest " + arg0));
    }

    public void onReportSMDeliveryStatusResponse(ReportSMDeliveryStatusResponse arg0) {
        logger.info((Object)("onReportSMDeliveryStatusResponse " + arg0));
    }

    public void onSendRoutingInfoForSMRequest(SendRoutingInfoForSMRequest event) {
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Rx : SendRoutingInfoForSMRequestIndication=" + event));
        }
        MAPDialogSms mapDialogSms = event.getMAPDialog();
        IMSIImpl imsi = new IMSIImpl("410035001692061");
        ISDNAddressStringImpl nnn = new ISDNAddressStringImpl(AddressNature.international_number, NumberingPlan.ISDN, "923330052001");
        LocationInfoWithLMSIImpl li = new LocationInfoWithLMSIImpl((ISDNAddressString)nnn, null, null, false, null);
        try {
            mapDialogSms.addSendRoutingInfoForSMResponse(event.getInvokeId(), (IMSI)imsi, (LocationInfoWithLMSI)li, null, null);
            mapDialogSms.close(false);
        }
        catch (MAPException e) {
            e.printStackTrace();
        }
    }

    public void onSendRoutingInfoForSMResponse(SendRoutingInfoForSMResponse arg0) {
        logger.info((Object)("onSendRoutingInfoForSMResponse " + arg0));
    }

    public void onProcessUnstructuredSSRequest(ProcessUnstructuredSSRequest req) {
        logger.info((Object)("onProcessUnstructuredSSRequest " + req));
        this.processUnstSSReqInvokeId = req.getInvokeId();
        CBSDataCodingSchemeImpl cbsDataCodingScheme = new CBSDataCodingSchemeImpl(15);
        USSDStringImpl ussdStr = new USSDStringImpl("USSD String : Hello World\n 1. Balance\n 2. Texts Remaining".getBytes(), (CBSDataCodingScheme)cbsDataCodingScheme);
        UnstructuredSSRequestImpl unstructuredSSRequestIndication = new UnstructuredSSRequestImpl((CBSDataCodingScheme)cbsDataCodingScheme, (USSDString)ussdStr, null, null);
        MAPDialogSupplementary mapDialog = req.getMAPDialog();
        try {
            mapDialog.addUnstructuredSSRequest((CBSDataCodingScheme)cbsDataCodingScheme, (USSDString)ussdStr, null, null);
            mapDialog.send();
        }
        catch (MAPException e) {
            logger.error((Object)"Error while trying to send UnstructuredSSRequest to remote", (Throwable)e);
        }
    }

    public void onProcessUnstructuredSSResponse(ProcessUnstructuredSSResponse arg0) {
        logger.info((Object)("onProcessUnstructuredSSResponse " + arg0));
    }

    public void onUnstructuredSSNotifyRequest(UnstructuredSSNotifyRequest event) {
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Rx : onUnstructuredSSNotifyRequest=" + event));
        }
        MAPDialogSupplementary mapDialogSupplementary = event.getMAPDialog();
        try {
            mapDialogSupplementary.addUnstructuredSSNotifyResponse(event.getInvokeId());
            mapDialogSupplementary.send();
        }
        catch (MAPException e) {
            logger.error((Object)("Error while trying to send the UnstructuredSSNotifyResponse for Dialog" + mapDialogSupplementary), (Throwable)e);
        }
    }

    public void onUnstructuredSSNotifyResponse(UnstructuredSSNotifyResponse event) {
        logger.info((Object)("onUnstructuredSSNotifyResponse " + event));
    }

    public void onUnstructuredSSRequest(UnstructuredSSRequest event) {
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Rx : onUnstructuredSSRequest=" + event));
        }
        MAPDialogSupplementary mapDialogSupplementary = event.getMAPDialog();
        try {
            USSDStringImpl ussdStr = new USSDStringImpl("1", event.getDataCodingScheme(), null);
            mapDialogSupplementary.addUnstructuredSSResponse(event.getInvokeId(), event.getDataCodingScheme(), (USSDString)ussdStr);
            mapDialogSupplementary.send();
        }
        catch (MAPException e) {
            logger.error((Object)"Error while trying to send UnstructuredSSResponse", (Throwable)e);
        }
    }

    public void onUnstructuredSSResponse(UnstructuredSSResponse evt) {
        logger.info((Object)("onUnstructuredSSResponse " + evt));
        try {
            USSDStringImpl ussdStr = new USSDStringImpl("Thank You!", evt.getDataCodingScheme(), null);
            MAPDialogSupplementary mapDialogSupplementary = evt.getMAPDialog();
            mapDialogSupplementary.addProcessUnstructuredSSResponse(this.processUnstSSReqInvokeId, evt.getDataCodingScheme(), (USSDString)ussdStr);
            mapDialogSupplementary.close(false);
        }
        catch (MAPException e) {
            logger.error((Object)"Error while trying to send ProcessUnstructuredSSResponse", (Throwable)e);
        }
    }

    public void onRegisterSSRequest(RegisterSSRequest request) {
    }

    public void onRegisterSSResponse(RegisterSSResponse response) {
    }

    public void onEraseSSRequest(EraseSSRequest request) {
    }

    public void onEraseSSResponse(EraseSSResponse response) {
    }

    public void onActivateSSRequest(ActivateSSRequest request) {
    }

    public void onActivateSSResponse(ActivateSSResponse response) {
    }

    public void onDeactivateSSRequest(DeactivateSSRequest request) {
    }

    public void onDeactivateSSResponse(DeactivateSSResponse response) {
    }

    public void onInterrogateSSRequest(InterrogateSSRequest request) {
    }

    public void onInterrogateSSResponse(InterrogateSSResponse response) {
    }

    public void onGetPasswordRequest(GetPasswordRequest request) {
    }

    public void onGetPasswordResponse(GetPasswordResponse response) {
    }

    public void onRegisterPasswordRequest(RegisterPasswordRequest request) {
    }

    public void onRegisterPasswordResponse(RegisterPasswordResponse response) {
    }

    public void onReadyForSMRequest(ReadyForSMRequest request) {
    }

    public void onReadyForSMResponse(ReadyForSMResponse response) {
    }

    public void onNoteSubscriberPresentRequest(NoteSubscriberPresentRequest request) {
    }
}

